/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.app;

import com.neeve.aep.AepEngine;
import com.neeve.config.Config;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.server.app.ESrvAppException;
import com.neeve.server.app.ISrvAppServerStopper;
import com.neeve.server.app.ISrvAppWatcher;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.SrvAppObject;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonListCommandsResponse;
import com.neeve.server.mon.cnc.SrvMonReturnType;
import com.neeve.server.thread.SrvThreadManager;
import com.neeve.sma.MessageBusBinding;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlGc;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class SrvAppManager
extends SrvAppObject {
    private final SrvConfigDescriptor configDescriptor;
    private final SrvThreadManager threadManager;
    private final ISrvAppWatcher appWatcher;
    private final ISrvAppServerStopper serverStopper;
    private final Map<String, SrvAppLoader> apps;
    private final ReentrantLock appsLock;
    private final IEmxUserEvent appLoadEvent;
    private final AppLoadEventHandler appLoadEventHandler;
    private final IEmxUserEvent appUnloadEvent;
    private final AppUnloadEventHandler appUnloadEventHandler;
    private final IEmxUserEvent appReloadEvent;
    private final AppReloadEventHandler appReloadEventHandler;
    private final IEmxUserEvent appUserEvent;
    private final AppUserEventHandler appUserEventHandler;
    private final boolean stopServerOnLastApp;
    private volatile State state;

    private SrvAppManager(SrvConfigDescriptor configDescriptor, SrvThreadManager threadManager, ISrvAppWatcher appWatcher, ISrvAppServerStopper serverStopper) {
        this.configDescriptor = configDescriptor;
        this.threadManager = threadManager;
        this.appWatcher = appWatcher;
        this.serverStopper = serverStopper;
        this.apps = new LinkedHashMap<String, SrvAppLoader>();
        this.appsLock = new ReentrantLock(true);
        this.appLoadEventHandler = new AppLoadEventHandler();
        this.appLoadEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.appLoadEventHandler);
        this.appUnloadEventHandler = new AppUnloadEventHandler();
        this.appUnloadEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.appUnloadEventHandler);
        this.appReloadEventHandler = new AppReloadEventHandler();
        this.appReloadEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.appReloadEventHandler);
        this.appUserEventHandler = new AppUserEventHandler();
        this.appUserEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.appUserEventHandler);
        this.stopServerOnLastApp = configDescriptor.isAutoStopOnLastAppStop();
        this.state = State.Init;
    }

    public static final SrvAppManager create(SrvConfigDescriptor configDescriptor, SrvThreadManager threadManager, ISrvAppWatcher appWatcher, ISrvAppServerStopper serverStopper) {
        return new SrvAppManager(configDescriptor, threadManager, appWatcher, serverStopper);
    }

    private static final boolean anyJarsInDir(File dir) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public final boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        }).length > 0;
    }

    private static final Properties loadAppVersionInfo(File dir) throws Exception {
        File verinfoFile = new File(dir + "/.verinfo");
        Properties props = new Properties();
        if (verinfoFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(verinfoFile);
                try {
                    props.load(fis);
                }
                catch (IOException e) {
                    throw new Exception("I/O exception encountered while loading .verinfo property file '" + verinfoFile + "' [" + e.toString() + "]");
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return props;
    }

    private static final void saveAppVersionInfo(Properties props, File dir) throws Exception {
        File verinfoFile = new File(dir + "/.verinfo");
        try {
            FileOutputStream fos = new FileOutputStream(verinfoFile);
            try {
                props.store(fos, null);
            }
            catch (IOException e) {
                throw new Exception("I/O exception encountered while saving .verinfo property file '" + verinfoFile + "' [" + e.toString() + "]");
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (FileNotFoundException e) {
            throw new Exception("I/O exception encountered while saving .verinfo property file '" + verinfoFile + "' [" + e.toString() + "]");
        }
    }

    private final List<String> listAppsUnprotected() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        for (String app : this.apps.keySet()) {
            ret.add(app);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void installAppUnprotected(String serverName, String name, File artifactDir) throws Exception {
        FilenameFilter jarFilter = new FilenameFilter(){

            @Override
            public final boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        if (!SrvConfigAppDescriptor.exists(serverName, name)) throw new Exception("unknown application '" + name + "'");
        if (!artifactDir.exists()) throw new Exception("directory '" + artifactDir + "' does not exist");
        if (!artifactDir.isDirectory()) throw new Exception("'" + artifactDir + "' is not a directory");
        if (!SrvAppManager.anyJarsInDir(artifactDir)) throw new Exception("no jars in directory '" + artifactDir + "'");
        File installDir = new File(Config.getJavaLibDirectory() + "/apps/" + name);
        if (!installDir.exists()) {
            installDir.mkdirs();
        }
        Properties verinfo = SrvAppManager.loadAppVersionInfo(installDir);
        String currentVerStr = verinfo.getProperty("current");
        String latestVerStr = verinfo.getProperty("latest");
        if (latestVerStr == null) {
            if (SrvAppManager.anyJarsInDir(installDir)) {
                currentVerStr = "1";
                UtlFile.copyDirectory((File)installDir, (File)new File(installDir + "/" + currentVerStr), (FilenameFilter)jarFilter);
                latestVerStr = "2";
            } else {
                latestVerStr = "1";
                currentVerStr = "1";
            }
        } else {
            currentVerStr = currentVerStr == null ? latestVerStr : currentVerStr;
            latestVerStr = String.valueOf(Integer.valueOf(latestVerStr) + 1);
        }
        UtlFile.copyDirectory((File)artifactDir, (File)new File(installDir + "/" + latestVerStr), (FilenameFilter)jarFilter);
        verinfo.setProperty("current", currentVerStr);
        verinfo.setProperty("latest", latestVerStr);
        SrvAppManager.saveAppVersionInfo(verinfo, installDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void setAppVersionUnprotected(String serverName, String name, int version) throws Exception {
        if (!SrvConfigAppDescriptor.exists(serverName, name)) throw new Exception("unknown application '" + name + "'");
        if (version < 0) throw new Exception("new version must be >= 0 (0 implies latest)");
        File dir = new File(Config.getJavaLibDirectory() + "/apps/" + name);
        if (!dir.exists()) throw new Exception("application is not versioned (install the application to automatically version it)");
        Properties verinfo = SrvAppManager.loadAppVersionInfo(dir);
        String currentVerStr = verinfo.getProperty("current");
        String latestVerStr = verinfo.getProperty("latest");
        if (latestVerStr == null) throw new Exception("application is not versioned (install the application to automatically version it)");
        if (version == 0) {
            currentVerStr = latestVerStr;
        } else {
            if (version > Integer.valueOf(latestVerStr)) throw new Exception("invalid version (> latest version)");
            currentVerStr = String.valueOf(version);
        }
        verinfo.setProperty("current", currentVerStr);
        SrvAppManager.saveAppVersionInfo(verinfo, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadAppUnprotected(String name) throws Exception {
        SrvAppLoader appLoader = this.apps.get(name);
        if (appLoader == null) {
            appLoader = new SrvAppLoader(name, this.configDescriptor, this, this.appWatcher);
            boolean loaded = false;
            this.apps.put(name, appLoader);
            try {
                appLoader.open();
                loaded = true;
            }
            finally {
                if (!loaded) {
                    this.apps.remove(name);
                }
            }
        }
    }

    private final void startAppUnprotected(String name, boolean async) throws Exception {
        SrvAppLoader appLoader = this.apps.get(name);
        if (appLoader == null) {
            throw new Exception("app '" + name + "' is not loaded");
        }
        appLoader.start(async);
    }

    private final void stopAppUnprotected(String name) throws Exception {
        SrvAppLoader appLoader = this.apps.get(name);
        if (appLoader == null) {
            throw new Exception("app '" + name + "' is not loaded");
        }
        appLoader.stop();
    }

    private final Object issueAppCommandUnprotected(String name, String command, String[] args) throws Exception {
        SrvAppLoader appLoader = this.apps.get(name);
        if (appLoader != null) {
            return appLoader.issueAppCommand(command, args);
        }
        throw new Exception("application '" + name + "' is not running");
    }

    private final SrvMonListCommandsResponse issueGetCommandsUnprotected(SrvMonListCommandsRequest request) throws Exception {
        String appName = request.getEntity();
        if (appName != null) {
            SrvAppLoader appLoader = this.apps.get(request.getEntity());
            if (appLoader != null) {
                return appLoader.getAppCommands(request);
            }
            throw new Exception("application '" + appName + "' is not running");
        }
        throw new Exception("application name must be specified");
    }

    private final void unloadAppUnprotected(String name) {
        SrvAppLoader appLoader = this.apps.get(name);
        if (appLoader != null) {
            try {
                appLoader.close();
            }
            finally {
                this.apps.remove(name);
            }
        }
    }

    private final void reloadAppUnprotected(String name) throws Exception {
        this.unloadAppUnprotected(name);
        this.loadAppUnprotected(name);
    }

    private final void dispatchEventToAppUnprotected(String name, Object event) throws Exception {
        SrvAppLoader appLoader = this.apps.get(name);
        if (appLoader != null) {
            appLoader.dispatchEvent(event);
        }
    }

    private final void stopUnprotected() {
        Iterator<SrvAppLoader> iterator = this.apps.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    final void acquireAppsTableLock() {
        if (this.threaded) {
            this.appsLock.lock();
        }
    }

    final void releaseAppsTableLock() {
        if (this.threaded) {
            this.appsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppStopped(SrvAppLoader stoppedAppLoader) {
        this.tracer.log("Application '" + stoppedAppLoader.getAppName() + "' has stopped.", Tracer.Level.INFO);
        if (!stoppedAppLoader.isAdminApp() && this.serverStopper != null) {
            boolean shutdownServer = true;
            this.acquireAppsTableLock();
            try {
                for (SrvAppLoader loader : this.apps.values()) {
                    shutdownServer &= loader.isAdminApp() || loader.getAppEngine().getState() == AepEngine.State.Stopped;
                }
            }
            finally {
                this.releaseAppsTableLock();
            }
            if (shutdownServer) {
                if (this.stopServerOnLastApp) {
                    this.tracer.log("All applications have stopped. Stopping server...", Tracer.Level.INFO);
                    this.serverStopper.stop(false);
                } else {
                    this.tracer.log("All applications have stopped. Configured to not stop server on last app.", Tracer.Level.INFO);
                }
            }
        }
    }

    final ISrvAppServerStopper getServerStopper() {
        return this.serverStopper;
    }

    private final MessageBusBinding getAppDirectBusBindingUnprotected(String appName) {
        SrvAppLoader appLoader = this.apps.get(appName);
        return appLoader != null ? appLoader.getAppEngine().getDirectBusBinding() : null;
    }

    public final void start() throws ESrvAppException {
        if (this.state == State.Init) {
            Set<String> appSet = this.configDescriptor.getAppNames();
            if (appSet.size() > 0) {
                Iterator<String> iterator = appSet.iterator();
                while (iterator.hasNext()) {
                    try {
                        this.loadAppUnprotected(iterator.next().trim());
                    }
                    catch (Exception e) {
                        if (this.configDescriptor.isAutoStopOnAppStartFail()) {
                            if (e instanceof ESrvAppException) {
                                throw (ESrvAppException)((Object)e);
                            }
                            throw new ESrvAppException(e);
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append("Application load failed\n").append(UtlThrowable.prepareStackTrace((Throwable)e)).append("Ignoring (not configured to stop on app start fail)...");
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
            } else {
                this.tracer.log("No applications configured.", Tracer.Level.INFO);
            }
            this.state = State.Started;
            for (SrvAppLoader appLoader : this.apps.values()) {
                try {
                    if (!appLoader.getAppDescriptor().getAutoStart()) continue;
                    appLoader.start(false);
                }
                catch (Exception e) {
                    if (this.configDescriptor.isAutoStopOnAppStartFail()) {
                        if (e instanceof ESrvAppException) {
                            throw (ESrvAppException)((Object)e);
                        }
                        throw new ESrvAppException(e);
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("Application start failed\n").append(UtlThrowable.prepareStackTrace((Throwable)e)).append("Ignoring (not configured to stop on app start fail)...");
                    this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                }
            }
        } else {
            throw new IllegalStateException("application manager already started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final List<String> listApps() throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                List<String> list = this.listAppsUnprotected();
                return list;
            }
            finally {
                this.releaseAppsTableLock();
            }
        }
        throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
    }

    public final void installApp(String name, File dir) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                SrvAppManager.installAppUnprotected(this.configDescriptor.getName(), name, dir);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void setAppVersion(String name, int version) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                SrvAppManager.setAppVersionUnprotected(this.configDescriptor.getName(), name, version);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void loadApp(String name) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                this.loadAppUnprotected(name);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final SrvAppLoader getAppLoader(String name) {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                SrvAppLoader srvAppLoader = this.apps.get(name);
                return srvAppLoader;
            }
            finally {
                this.releaseAppsTableLock();
            }
        }
        throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
    }

    public final boolean isStarted() {
        return this.state == State.Started;
    }

    public final boolean isAppLoaded(String name) {
        if (this.state == State.Started) {
            return this.getAppLoader(name) != null;
        }
        throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String issueAppCommand(String name, String command, String[] args) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                String string = (String)UtlDataTypes.convert(String.class, (Object)this.issueAppCommandUnprotected(name, command, args));
                return string;
            }
            finally {
                this.releaseAppsTableLock();
            }
        }
        throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void issueAppCommand(String name, String command, String[] args, SrvMonInvokeCommandResponse response) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                Object ret = this.issueAppCommandUnprotected(name, command, args);
                SrvAppManager.returnValueToTypedResponse(ret, response);
            }
            catch (Throwable thrown) {
                response.setErrorMessage(thrown.getMessage());
                response.setStackTrace(UtlThrowable.prepareStackTrace((Throwable)thrown));
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void issueAppCommandUnsafe(String name, String command, String[] args, SrvMonInvokeCommandResponse response) throws Exception {
        if (this.state != State.Started) throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        SrvAppLoader appLoader = this.getAppLoader(name);
        if (appLoader == null) throw new Exception("application '" + name + "' is not running");
        Object ret = appLoader.issueAppCommand(command, args);
        try {
            SrvAppManager.returnValueToTypedResponse(ret, response);
            return;
        }
        catch (Throwable thrown) {
            response.setErrorMessage(thrown.getMessage());
            response.setStackTrace(UtlThrowable.prepareStackTrace((Throwable)thrown));
        }
    }

    private static void returnValueToTypedResponse(Object ret, SrvMonInvokeCommandResponse response) {
        if (ret == null) {
            response.setReturnType(SrvMonReturnType.VOID);
        } else if (ret instanceof Boolean) {
            response.setReturnType(SrvMonReturnType.BOOLEAN);
            response.setBooleanReturnValue((Boolean)ret);
        } else if (ret instanceof Byte) {
            response.setReturnType(SrvMonReturnType.BYTE);
            response.setByteReturnValue((Byte)ret);
        } else if (ret instanceof Character) {
            response.setReturnType(SrvMonReturnType.CHAR);
            response.setCharReturnValue(((Character)ret).charValue());
        } else if (ret instanceof Short) {
            response.setReturnType(SrvMonReturnType.SHORT);
            response.setShortReturnValue((Short)ret);
        } else if (ret instanceof Integer) {
            response.setReturnType(SrvMonReturnType.INT);
            response.setIntReturnValue((Integer)ret);
        } else if (ret instanceof Long) {
            response.setReturnType(SrvMonReturnType.LONG);
            response.setLongReturnValue((Long)ret);
        } else if (ret instanceof Float) {
            response.setReturnType(SrvMonReturnType.FLOAT);
            response.setFloatReturnValue(((Float)ret).floatValue());
        } else if (ret instanceof String) {
            response.setReturnType(SrvMonReturnType.STRING);
            String result = (String)ret;
            if (result.startsWith("NOK ")) {
                if (result.length() == 4) {
                    response.setErrorMessage("NOK");
                } else {
                    response.setErrorMessage(result.substring(4));
                }
            } else if (result.startsWith("OK ")) {
                if (result.length() == 3) {
                    response.setStringReturnValue("");
                } else {
                    response.setStringReturnValue(result.substring(3));
                }
            } else {
                response.setStringReturnValue(result);
            }
        } else if (ret instanceof Date) {
            response.setReturnType(SrvMonReturnType.DATE);
            response.setDateReturnValue((Date)ret);
        } else {
            String converted = (String)UtlDataTypes.convert(String.class, (Object)ret);
            response.setReturnType(SrvMonReturnType.STRING);
            response.setStringReturnValue(converted);
        }
    }

    public final SrvMonListCommandsResponse issueGetCommands(SrvMonListCommandsRequest request) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                SrvMonListCommandsResponse srvMonListCommandsResponse = this.issueGetCommandsUnprotected(request);
                return srvMonListCommandsResponse;
            }
            finally {
                this.releaseAppsTableLock();
            }
        }
        throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
    }

    public final void startApp(String name, boolean async) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                this.startAppUnprotected(name, async);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void stopApp(String name) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                this.stopAppUnprotected(name);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void unloadApp(String name) {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                this.unloadAppUnprotected(name);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
        UtlGc.runGc();
    }

    public final void reloadApp(String name) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                this.reloadAppUnprotected(name);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void dispatchEventToApp(String name, Object event) throws Exception {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                this.dispatchEventToAppUnprotected(name, event);
            }
            finally {
                this.releaseAppsTableLock();
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void scheduleAppUnload(String name) throws ESrvAppException {
        if (this.state == State.Started) {
            if (this.tracer.debug) {
                this.tracer.log("Received request to schedule a unload for application '" + name + "'.", Tracer.Level.DEBUG);
            }
            if (this.isAppLoaded(name)) {
                if (this.tracer.debug) {
                    this.tracer.log("Application is loaded. Scheduling the unload...", Tracer.Level.DEBUG);
                }
                try {
                    this.appUnloadEvent.setAttachment((Object)name);
                    this.threadManager.getThreadPool().getMainThread().getDispatcher().schedUserEv(this.appUnloadEvent);
                }
                catch (Exception e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Failed to schedule application unload [" + e.toString() + "].", Tracer.Level.DEBUG);
                    }
                    throw new ESrvAppException(e);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Application is not loaded. Nothing to be done.", Tracer.Level.DEBUG);
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    public final void scheduleAppReload(String name) throws ESrvAppException {
        if (this.state == State.Started) {
            if (this.tracer.debug) {
                this.tracer.log("Received request to schedule a reload for application '" + name + "'.", Tracer.Level.DEBUG);
            }
            if (this.isAppLoaded(name)) {
                if (this.tracer.debug) {
                    this.tracer.log("Application is loaded. Scheduling application reload...", Tracer.Level.DEBUG);
                }
                try {
                    this.appReloadEvent.setAttachment((Object)name);
                    this.threadManager.getThreadPool().getMainThread().getDispatcher().schedUserEv(this.appReloadEvent);
                }
                catch (Exception e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Failed to schedule application reload [" + e.toString() + "].", Tracer.Level.DEBUG);
                    }
                    throw new ESrvAppException(e);
                }
            } else {
                if (this.tracer.debug) {
                    this.tracer.log("Application is not loaded. Scheduling application load...", Tracer.Level.DEBUG);
                }
                try {
                    this.appLoadEvent.setAttachment((Object)name);
                    this.threadManager.getThreadPool().getMainThread().getDispatcher().schedUserEv(this.appLoadEvent);
                }
                catch (Exception e) {
                    if (this.tracer.debug) {
                        this.tracer.log("Failed to schedule application load [" + e.toString() + "].", Tracer.Level.DEBUG);
                    }
                    throw new ESrvAppException(e);
                }
            }
        } else {
            throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void scheduleAppEvent(String name, Object event) throws ESrvAppException {
        if (this.state != State.Started) throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
        if (this.tracer.debug) {
            this.tracer.log("Received request to schedule an event to application '" + name + "'.", Tracer.Level.DEBUG);
        }
        if (!this.isAppLoaded(name)) throw new IllegalArgumentException("application '" + name + "' is not loaded");
        if (this.tracer.debug) {
            this.tracer.log("Application is loaded. Scheduling the event...", Tracer.Level.DEBUG);
        }
        try {
            this.appUserEvent.setAttachment((Object)new UserEventContext(name, event));
            this.threadManager.getThreadPool().getMainThread().getDispatcher().schedUserEv(this.appUserEvent);
            return;
        }
        catch (Exception e) {
            if (!this.tracer.debug) throw new ESrvAppException(e);
            this.tracer.log("Failed to schedule application event [" + e.toString() + "].", Tracer.Level.DEBUG);
            throw new ESrvAppException(e);
        }
    }

    public final MessageBusBinding getAppDirectBusBinding(String appName) {
        if (this.state == State.Started) {
            this.acquireAppsTableLock();
            try {
                MessageBusBinding messageBusBinding = this.getAppDirectBusBindingUnprotected(appName);
                return messageBusBinding;
            }
            finally {
                this.releaseAppsTableLock();
            }
        }
        throw new IllegalStateException("application manager not started (state '" + (Object)((Object)this.state) + "')");
    }

    public final void stop() {
        if (this.state == State.Started) {
            try {
                this.acquireAppsTableLock();
                try {
                    this.stopUnprotected();
                }
                finally {
                    this.releaseAppsTableLock();
                }
            }
            finally {
                this.state = State.Stopped;
            }
        }
    }

    private final class AppUserEventHandler
    implements IEmxEventHandler {
        private AppUserEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            UserEventContext context = (UserEventContext)event.getAttachment();
            if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                SrvAppManager.this.tracer.log("Received event to dispatch to application '" + context.appName + "'.", Tracer.Level.DEBUG);
            }
            try {
                SrvAppManager.this.dispatchEventToApp(context.appName, context.event);
                if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                    SrvAppManager.this.tracer.log("Dispatched event to application successfully.", Tracer.Level.DEBUG);
                }
            }
            catch (Exception e) {
                SrvAppManager.this.tracer.log("...Application event handling encoutered a fault [" + e.toString() + "]", Tracer.Level.WARNING);
            }
            return false;
        }
    }

    private final class UserEventContext {
        final String appName;
        final Object event;

        UserEventContext(String appName, Object event) {
            this.appName = appName;
            this.event = event;
        }
    }

    private final class AppReloadEventHandler
    implements IEmxEventHandler {
        private AppReloadEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            block4: {
                String appName = (String)event.getAttachment();
                if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                    SrvAppManager.this.tracer.log("Received event to reload application '" + appName + "'.", Tracer.Level.DEBUG);
                }
                try {
                    SrvAppManager.this.reloadApp(appName);
                    if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                        SrvAppManager.this.tracer.log("Application reloaded successfully.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    if (!((SrvAppManager)SrvAppManager.this).tracer.debug) break block4;
                    SrvAppManager.this.tracer.log("...Failed to reload application [" + e.toString() + "]", Tracer.Level.DEBUG);
                }
            }
            return false;
        }
    }

    private final class AppUnloadEventHandler
    implements IEmxEventHandler {
        private AppUnloadEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            block4: {
                String appName = (String)event.getAttachment();
                if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                    SrvAppManager.this.tracer.log("Received event to unload application '" + appName + "'.", Tracer.Level.DEBUG);
                }
                try {
                    SrvAppManager.this.unloadApp(appName);
                    if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                        SrvAppManager.this.tracer.log("Application unloaded successfully.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    if (!((SrvAppManager)SrvAppManager.this).tracer.debug) break block4;
                    SrvAppManager.this.tracer.log("...Failed to unload application [" + e.toString() + "]", Tracer.Level.DEBUG);
                }
            }
            return false;
        }
    }

    private final class AppLoadEventHandler
    implements IEmxEventHandler {
        private AppLoadEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            block4: {
                String appName = (String)event.getAttachment();
                if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                    SrvAppManager.this.tracer.log("Received event to load application '" + appName + "'.", Tracer.Level.DEBUG);
                }
                try {
                    SrvAppManager.this.loadApp(appName);
                    if (((SrvAppManager)SrvAppManager.this).tracer.debug) {
                        SrvAppManager.this.tracer.log("Application loaded successfully.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    if (!((SrvAppManager)SrvAppManager.this).tracer.debug) break block4;
                    SrvAppManager.this.tracer.log("...Failed to load application [" + e.toString() + "]", Tracer.Level.DEBUG);
                }
            }
            return false;
        }
    }

    private static enum State {
        Init,
        Started,
        Stopped;

    }
}

