/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UtlUnit {
    private static final LinkedHashMap<String, ByteUnit> bytesLookup = new LinkedHashMap();
    private static final LinkedHashMap<String, TimeUnit> durationLookup = new LinkedHashMap();
    private static final LinkedHashMap<String, TimeUnit> caseSensitiveDurationLookup = new LinkedHashMap();
    private static final Pattern byteStringPattern;
    private static final Pattern durationStringPattern;

    public static String readableBytesSize(long size) {
        if (size == 0L) {
            return "0B";
        }
        int digitGroups = Math.min((int)(Math.log10(size) / Math.log10(1024.0)), ByteUnit.maxUnit().power);
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + "" + (Object)((Object)ByteUnit.fromPower(digitGroups));
    }

    public static double parseBytes(String size, ByteUnit targetUnit) {
        return UtlUnit.parseBytes(size, ByteUnit.Bytes, targetUnit);
    }

    public static double parseBytes(String size, ByteUnit defaultUnit, ByteUnit targetUnit) {
        ByteUnit unit;
        Matcher matcher = byteStringPattern.matcher(size);
        String signStr = null;
        String number = null;
        String unitStr = defaultUnit.shortName;
        if (matcher.find()) {
            signStr = matcher.group(1);
            number = matcher.group(2);
            unitStr = matcher.group(3);
            if (unitStr == null) {
                unitStr = defaultUnit.shortName;
            }
        } else {
            number = size;
        }
        int sign = 1;
        if (signStr != null && "-".equals(signStr)) {
            sign = -1;
        }
        if ((unit = ByteUnit.get(unitStr = unitStr.trim())) == null) {
            throw new IllegalArgumentException("'" + unitStr + "' is not a recognized byte unit ... expected one of " + bytesLookup.keySet() + " (case insensitive)");
        }
        if (number == null || number.trim().length() == 0) {
            throw new IllegalArgumentException("'" + size + "' is not a valid number of bytes expected #,###.# [" + bytesLookup.keySet() + "]");
        }
        BigDecimal bytes = new BigDecimal(number.replace(",", ""));
        return bytes.multiply(unit.multiplier).divide(targetUnit.multiplier).doubleValue() * (double)sign;
    }

    public static double convertBytes(double size, ByteUnit sourceUnit, ByteUnit targetUnit) {
        BigDecimal bytes = new BigDecimal("" + size);
        int sign = 1;
        if (size < 0.0) {
            size *= -1.0;
            sign = -1;
        }
        return bytes.multiply(sourceUnit.multiplier).divide(targetUnit.multiplier).doubleValue() * (double)sign;
    }

    public static long toNumBytes(String size) {
        return (long)UtlUnit.parseBytes(size, ByteUnit.Bytes);
    }

    public static final double parseDuration(String duration, TimeUnit defaultUnit, TimeUnit targetUnit) {
        if (duration == null) {
            throw new IllegalArgumentException("duration cannot be null");
        }
        if (targetUnit == null) {
            throw new IllegalArgumentException("Target unit cannot be null");
        }
        Matcher matcher = durationStringPattern.matcher(duration);
        String number = null;
        TimeUnit durationUnit = defaultUnit;
        if (matcher.find()) {
            number = matcher.group(1);
            String unitStr = matcher.group(2);
            if (unitStr != null && (unitStr = unitStr.trim()).length() > 0) {
                durationUnit = caseSensitiveDurationLookup.get(unitStr);
                if (durationUnit == null) {
                    durationUnit = durationLookup.get(unitStr.toLowerCase());
                }
                if (durationUnit == null) {
                    throw new IllegalArgumentException("'" + unitStr + "' is not a valid duration unit. Expected one of " + caseSensitiveDurationLookup.keySet() + " (case sensitive) or " + durationLookup.keySet() + " (case insensitive)");
                }
            }
        } else {
            number = duration;
        }
        if (durationUnit == null) {
            throw new IllegalArgumentException("'" + duration + "' does not specify a time unit and no default time unit supplied. Expected duration to end with one of " + caseSensitiveDurationLookup.keySet() + " (case sensitive) or " + durationLookup.keySet() + " (case insensitive)");
        }
        if (number == null || number.trim().length() == 0) {
            throw new IllegalArgumentException("'" + duration + "' is not a valid duration string. Expected #,###.# [" + caseSensitiveDurationLookup.keySet() + " (case sensitive) or " + durationLookup.keySet() + " (case insensitive)");
        }
        return UtlUnit.convertDuration(new BigDecimal(number.replace(",", "")).doubleValue(), durationUnit, targetUnit);
    }

    public static final double convertDuration(double duration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit) {
        switch (sourceTimeUnit) {
            case DAYS: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration;
                    }
                    case HOURS: {
                        return duration * (double)TimeUnit.DAYS.toHours(1L);
                    }
                    case MINUTES: {
                        return duration * (double)TimeUnit.DAYS.toMinutes(1L);
                    }
                    case SECONDS: {
                        return duration * (double)TimeUnit.DAYS.toSeconds(1L);
                    }
                    case MILLISECONDS: {
                        return duration * (double)TimeUnit.DAYS.toMillis(1L);
                    }
                    case MICROSECONDS: {
                        return duration * (double)TimeUnit.DAYS.toMicros(1L);
                    }
                    case NANOSECONDS: {
                        return duration * (double)TimeUnit.DAYS.toNanos(1L);
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
            case HOURS: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration / (double)TimeUnit.DAYS.toHours(1L);
                    }
                    case HOURS: {
                        return duration;
                    }
                    case MINUTES: {
                        return duration * (double)TimeUnit.HOURS.toMinutes(1L);
                    }
                    case SECONDS: {
                        return duration * (double)TimeUnit.HOURS.toSeconds(1L);
                    }
                    case MILLISECONDS: {
                        return duration * (double)TimeUnit.HOURS.toMillis(1L);
                    }
                    case MICROSECONDS: {
                        return duration * (double)TimeUnit.HOURS.toMicros(1L);
                    }
                    case NANOSECONDS: {
                        return duration * (double)TimeUnit.HOURS.toNanos(1L);
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
            case MINUTES: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration / (double)TimeUnit.DAYS.toMinutes(1L);
                    }
                    case HOURS: {
                        return duration / (double)TimeUnit.HOURS.toMinutes(1L);
                    }
                    case MINUTES: {
                        return duration;
                    }
                    case SECONDS: {
                        return duration * (double)TimeUnit.MINUTES.toSeconds(1L);
                    }
                    case MILLISECONDS: {
                        return duration * (double)TimeUnit.MINUTES.toMillis(1L);
                    }
                    case MICROSECONDS: {
                        return duration * (double)TimeUnit.MINUTES.toMicros(1L);
                    }
                    case NANOSECONDS: {
                        return duration * (double)TimeUnit.MINUTES.toNanos(1L);
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
            case SECONDS: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration / (double)TimeUnit.DAYS.toSeconds(1L);
                    }
                    case HOURS: {
                        return duration / (double)TimeUnit.HOURS.toSeconds(1L);
                    }
                    case MINUTES: {
                        return duration / (double)TimeUnit.MINUTES.toSeconds(1L);
                    }
                    case SECONDS: {
                        return duration;
                    }
                    case MILLISECONDS: {
                        return duration * (double)TimeUnit.SECONDS.toMillis(1L);
                    }
                    case MICROSECONDS: {
                        return duration * (double)TimeUnit.SECONDS.toMicros(1L);
                    }
                    case NANOSECONDS: {
                        return duration * (double)TimeUnit.SECONDS.toNanos(1L);
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
            case MILLISECONDS: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration / (double)TimeUnit.DAYS.toMillis(1L);
                    }
                    case HOURS: {
                        return duration / (double)TimeUnit.HOURS.toMillis(1L);
                    }
                    case MINUTES: {
                        return duration / (double)TimeUnit.MINUTES.toMillis(1L);
                    }
                    case SECONDS: {
                        return duration / (double)TimeUnit.SECONDS.toMillis(1L);
                    }
                    case MILLISECONDS: {
                        return duration;
                    }
                    case MICROSECONDS: {
                        return duration * (double)TimeUnit.MILLISECONDS.toMicros(1L);
                    }
                    case NANOSECONDS: {
                        return duration * (double)TimeUnit.MILLISECONDS.toNanos(1L);
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
            case MICROSECONDS: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration / (double)TimeUnit.DAYS.toMicros(1L);
                    }
                    case HOURS: {
                        return duration / (double)TimeUnit.HOURS.toMicros(1L);
                    }
                    case MINUTES: {
                        return duration / (double)TimeUnit.MINUTES.toMicros(1L);
                    }
                    case SECONDS: {
                        return duration / (double)TimeUnit.SECONDS.toMicros(1L);
                    }
                    case MILLISECONDS: {
                        return duration / (double)TimeUnit.MILLISECONDS.toMicros(1L);
                    }
                    case MICROSECONDS: {
                        return duration;
                    }
                    case NANOSECONDS: {
                        return duration * (double)TimeUnit.MICROSECONDS.toNanos(1L);
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
            case NANOSECONDS: {
                switch (targetTimeUnit) {
                    case DAYS: {
                        return duration / (double)TimeUnit.DAYS.toNanos(1L);
                    }
                    case HOURS: {
                        return duration / (double)TimeUnit.HOURS.toNanos(1L);
                    }
                    case MINUTES: {
                        return duration / (double)TimeUnit.MINUTES.toNanos(1L);
                    }
                    case SECONDS: {
                        return duration / (double)TimeUnit.SECONDS.toNanos(1L);
                    }
                    case MILLISECONDS: {
                        return duration / (double)TimeUnit.MILLISECONDS.toNanos(1L);
                    }
                    case MICROSECONDS: {
                        return duration / (double)TimeUnit.MICROSECONDS.toNanos(1L);
                    }
                    case NANOSECONDS: {
                        return duration;
                    }
                }
                throw new RuntimeException("Illegal target unit: " + (Object)((Object)targetTimeUnit));
            }
        }
        throw new RuntimeException("Illegal source unit: " + (Object)((Object)sourceTimeUnit));
    }

    public static final String formatDuration(double duration, TimeUnit unit) {
        return UtlUnit.formatDuration(duration, unit, 1);
    }

    public static final String formatDuration(double duration, TimeUnit unit, int decimalPoints) {
        double days = 0.0;
        double hours = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        double millis = 0.0;
        double micros = 0.0;
        double nanos = 0.0;
        switch (unit) {
            case DAYS: {
                days = duration;
                break;
            }
            case HOURS: {
                days = TimeUnit.HOURS.toDays((long)duration);
                hours = duration -= (double)TimeUnit.DAYS.toHours((long)days);
                break;
            }
            case MINUTES: {
                days = TimeUnit.MINUTES.toDays((long)duration);
                hours = TimeUnit.MINUTES.toHours((long)(duration -= (double)TimeUnit.DAYS.toMinutes((long)days)));
                minutes = duration -= (double)TimeUnit.HOURS.toMinutes((long)hours);
                break;
            }
            case SECONDS: {
                days = TimeUnit.SECONDS.toDays((long)duration);
                hours = TimeUnit.SECONDS.toHours((long)(duration -= (double)TimeUnit.DAYS.toSeconds((long)days)));
                minutes = TimeUnit.SECONDS.toMinutes((long)(duration -= (double)TimeUnit.HOURS.toSeconds((long)hours)));
                seconds = duration -= (double)TimeUnit.MINUTES.toSeconds((long)minutes);
                break;
            }
            case MILLISECONDS: {
                days = TimeUnit.MILLISECONDS.toDays((long)duration);
                hours = TimeUnit.MILLISECONDS.toHours((long)(duration -= (double)TimeUnit.DAYS.toMillis((long)days)));
                minutes = TimeUnit.MILLISECONDS.toMinutes((long)(duration -= (double)TimeUnit.HOURS.toMillis((long)hours)));
                seconds = TimeUnit.MILLISECONDS.toSeconds((long)(duration -= (double)TimeUnit.MINUTES.toMillis((long)minutes)));
                millis = duration -= (double)TimeUnit.SECONDS.toMillis((long)seconds);
                break;
            }
            case MICROSECONDS: {
                days = TimeUnit.MICROSECONDS.toDays((long)duration);
                hours = TimeUnit.MICROSECONDS.toHours((long)(duration -= (double)TimeUnit.DAYS.toMicros((long)days)));
                minutes = TimeUnit.MICROSECONDS.toMinutes((long)(duration -= (double)TimeUnit.HOURS.toMicros((long)hours)));
                seconds = TimeUnit.MICROSECONDS.toSeconds((long)(duration -= (double)TimeUnit.MINUTES.toMicros((long)minutes)));
                millis = TimeUnit.MICROSECONDS.toMillis((long)(duration -= (double)TimeUnit.SECONDS.toMicros((long)seconds)));
                micros = duration -= (double)TimeUnit.MILLISECONDS.toMicros((long)millis);
                break;
            }
            case NANOSECONDS: {
                days = TimeUnit.NANOSECONDS.toDays((long)duration);
                hours = TimeUnit.NANOSECONDS.toHours((long)(duration -= (double)TimeUnit.DAYS.toNanos((long)days)));
                minutes = TimeUnit.NANOSECONDS.toMinutes((long)(duration -= (double)TimeUnit.HOURS.toNanos((long)hours)));
                seconds = TimeUnit.NANOSECONDS.toSeconds((long)(duration -= (double)TimeUnit.MINUTES.toNanos((long)minutes)));
                millis = TimeUnit.NANOSECONDS.toMillis((long)(duration -= (double)TimeUnit.SECONDS.toNanos((long)seconds)));
                micros = TimeUnit.NANOSECONDS.toMicros((long)(duration -= (double)TimeUnit.MILLISECONDS.toNanos((long)millis)));
                nanos = duration -= (double)TimeUnit.MICROSECONDS.toNanos((long)micros);
            }
        }
        if (days > 0.0) {
            double elapsed = days + hours / 24.0;
            return String.format("%." + decimalPoints + "fd", elapsed);
        }
        if (hours > 0.0) {
            double elapsed = hours + minutes / 60.0;
            return String.format("%." + decimalPoints + "fh", elapsed);
        }
        if (minutes > 0.0) {
            double elapsed = minutes + seconds / 60.0;
            return String.format("%." + decimalPoints + "fm", elapsed);
        }
        if (seconds > 0.0) {
            double elapsed = seconds + millis / 1000.0;
            return String.format("%." + decimalPoints + "fs", elapsed);
        }
        if (millis > 0.0) {
            double elapsed = millis + micros / 1000.0;
            return String.format("%." + decimalPoints + "fms", elapsed);
        }
        if (micros > 0.0) {
            double elapsed = micros + nanos / 1000.0;
            return String.format("%." + decimalPoints + "fus", elapsed);
        }
        if (nanos > 0.0) {
            return String.format("%." + decimalPoints + "fns", nanos);
        }
        return String.format("%." + decimalPoints + "fs", 0.0);
    }

    static {
        bytesLookup.put("b", ByteUnit.Bytes);
        bytesLookup.put("byte", ByteUnit.Bytes);
        bytesLookup.put("bytes", ByteUnit.Bytes);
        bytesLookup.put("k", ByteUnit.Kilobytes);
        bytesLookup.put("kb", ByteUnit.Kilobytes);
        bytesLookup.put("kilobyte", ByteUnit.Kilobytes);
        bytesLookup.put("kilobytes", ByteUnit.Kilobytes);
        bytesLookup.put("m", ByteUnit.Megabytes);
        bytesLookup.put("mb", ByteUnit.Megabytes);
        bytesLookup.put("megabyte", ByteUnit.Megabytes);
        bytesLookup.put("megabytes", ByteUnit.Megabytes);
        bytesLookup.put("g", ByteUnit.Gigabytes);
        bytesLookup.put("gb", ByteUnit.Gigabytes);
        bytesLookup.put("gigabyte", ByteUnit.Gigabytes);
        bytesLookup.put("gigabytes", ByteUnit.Gigabytes);
        bytesLookup.put("t", ByteUnit.Terabytes);
        bytesLookup.put("tb", ByteUnit.Terabytes);
        bytesLookup.put("terabyte", ByteUnit.Terabytes);
        bytesLookup.put("terabytes", ByteUnit.Terabytes);
        bytesLookup.put("p", ByteUnit.Petabytes);
        bytesLookup.put("pb", ByteUnit.Petabytes);
        bytesLookup.put("petabyte", ByteUnit.Petabytes);
        bytesLookup.put("petabytes", ByteUnit.Petabytes);
        caseSensitiveDurationLookup.put("d", TimeUnit.DAYS);
        caseSensitiveDurationLookup.put("h", TimeUnit.HOURS);
        caseSensitiveDurationLookup.put("m", TimeUnit.MINUTES);
        caseSensitiveDurationLookup.put("s", TimeUnit.SECONDS);
        durationLookup.put("day", TimeUnit.DAYS);
        durationLookup.put("days", TimeUnit.DAYS);
        durationLookup.put("hour", TimeUnit.HOURS);
        durationLookup.put("hours", TimeUnit.HOURS);
        durationLookup.put("minute", TimeUnit.MINUTES);
        durationLookup.put("minutes", TimeUnit.MINUTES);
        durationLookup.put("second", TimeUnit.SECONDS);
        durationLookup.put("seconds", TimeUnit.SECONDS);
        durationLookup.put("ms", TimeUnit.MILLISECONDS);
        durationLookup.put("millisecond", TimeUnit.MILLISECONDS);
        durationLookup.put("milliseconds", TimeUnit.MILLISECONDS);
        durationLookup.put("microsecond", TimeUnit.MICROSECONDS);
        durationLookup.put("microseconds", TimeUnit.MICROSECONDS);
        durationLookup.put("nanosecond", TimeUnit.NANOSECONDS);
        durationLookup.put("nanoseconds", TimeUnit.NANOSECONDS);
        byteStringPattern = Pattern.compile("([+-]*)([\\d,.]+)([\\sa-zA-Z]+)", 2);
        durationStringPattern = Pattern.compile("([\\d,.]+)([\\sa-zA-Z]+)", 2);
    }

    public static enum ByteUnit {
        Bytes(0, "B"),
        Kilobytes(1, "KB"),
        Megabytes(2, "MB"),
        Gigabytes(3, "GB"),
        Terabytes(4, "TB"),
        Petabytes(5, "PB");

        final int power;
        final String shortName;
        final BigDecimal multiplier;

        private ByteUnit(int power, String shortName) {
            this.power = power;
            this.shortName = shortName;
            this.multiplier = BigDecimal.valueOf(1024L).pow(power);
        }

        static ByteUnit fromPower(int power) {
            switch (power) {
                case 0: {
                    return Bytes;
                }
                case 1: {
                    return Kilobytes;
                }
                case 2: {
                    return Megabytes;
                }
                case 3: {
                    return Gigabytes;
                }
                case 4: {
                    return Terabytes;
                }
                case 5: {
                    return Petabytes;
                }
            }
            return null;
        }

        static ByteUnit get(String suffix) {
            return (ByteUnit)((Object)bytesLookup.get(suffix.toLowerCase()));
        }

        static ByteUnit maxUnit() {
            return ByteUnit.values()[ByteUnit.values().length - 1];
        }

        public String toString() {
            return this.shortName;
        }
    }

    public static enum Unit {
        Bytes,
        Time,
        None;

    }
}

