/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import vanilla.java.affinity.IAffinity;

public enum NativeAffinity implements IAffinity
{
    INSTANCE;

    public static final boolean LOADED;
    private static final Logger LOGGER;

    private static native long getAffinity0();

    private static native void setAffinity0(long var0);

    @Override
    public long getAffinity() {
        return NativeAffinity.getAffinity0();
    }

    @Override
    public void setAffinity(long affinity) {
        NativeAffinity.setAffinity0(affinity);
    }

    private static boolean initialize() {
        return NativeAffinity.loadAffinityNativeLibrary();
    }

    private static String md5sum(InputStream input) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            String string = md5out.toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm is not available: " + e);
        }
        finally {
            in.close();
        }
    }

    private static boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        String prefix = "javaaffinity-" + NativeAffinity.getVersion() + "-";
        String extractedLibFileName = prefix + libraryFileName;
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        try {
            if (extractedLibFile.exists()) {
                String md5sum2;
                String md5sum1 = NativeAffinity.md5sum(NativeAffinity.class.getResourceAsStream(nativeLibraryFilePath));
                if (md5sum1.equals(md5sum2 = NativeAffinity.md5sum(new FileInputStream(extractedLibFile)))) {
                    return NativeAffinity.loadNativeLibrary(targetFolder, extractedLibFileName);
                }
                boolean deletionSucceeded = extractedLibFile.delete();
                if (!deletionSucceeded) {
                    throw new IOException("failed to remove existing native library file: " + extractedLibFile.getAbsolutePath());
                }
            }
            InputStream reader = NativeAffinity.class.getResourceAsStream(nativeLibraryFilePath);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.close();
            reader.close();
            if (!System.getProperty("os.name").contains("Windows")) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", extractedLibFile.getAbsolutePath()}).waitFor();
                }
                catch (Throwable e) {}
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Unable to extract libaffinity in " + targetFolder);
            }
            return false;
        }
        return NativeAffinity.loadNativeLibrary(targetFolder, extractedLibFileName);
    }

    private static synchronized boolean loadNativeLibrary(String path, String name) {
        File libPath = new File(path, name);
        if (libPath.exists()) {
            String absolutePath = libPath.getAbsolutePath();
            try {
                System.load(absolutePath);
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to find " + absolutePath + " in " + path + " " + e.getMessage());
                }
                return false;
            }
        }
        return false;
    }

    private static boolean loadAffinityNativeLibrary() {
        if (LOADED) {
            return LOADED;
        }
        String affinityNativeLibraryName = System.mapLibraryName("affinity");
        String affinityNativeLibraryPath = "/vanilla/java/affinity/native/" + NativeAffinity.getNativeLibFolderPathForCurrentOS();
        if (NativeAffinity.class.getResource(affinityNativeLibraryPath + File.separator + affinityNativeLibraryName) == null) {
            return false;
        }
        String tempFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        return NativeAffinity.extractAndLoadLibraryFile(affinityNativeLibraryPath, affinityNativeLibraryName, tempFolder);
    }

    private static String getVersion() {
        String version;
        block3: {
            InputStream versionFile = NativeAffinity.class.getResourceAsStream("/META-INF/maven/vanilla.java/affinity/pom.properties");
            version = "unknown";
            try {
                if (versionFile != null) {
                    Properties versionData = new Properties();
                    versionData.load(versionFile);
                    version = versionData.getProperty("version", version);
                    version = version.trim().replaceAll("[^0-9\\.]", "");
                }
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block3;
                LOGGER.info("Unable to find libaffinity version from maven metadata");
            }
        }
        return version;
    }

    private static String getNativeLibFolderPathForCurrentOS() {
        return NativeAffinity.getOSName() + "/" + NativeAffinity.getArchName();
    }

    private static String getOSName() {
        return NativeAffinity.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    private static String getArchName() {
        return NativeAffinity.translateArchNameToFolderName(System.getProperty("os.arch"));
    }

    private static String translateOSNameToFolderName(String osName) {
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        return osName.replaceAll("\\W", "");
    }

    private static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }

    static {
        LOGGER = Logger.getLogger(NativeAffinity.class.getName());
        LOADED = NativeAffinity.loadAffinityNativeLibrary();
    }
}

