/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmDocumentedType;
import com.neeve.adm.AdmModel;

public abstract class AdmType
extends AdmDocumentedType {
    private final String name;
    private AdmModel model;

    protected AdmType(AdmModel model, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.model = model;
        this.name = name;
    }

    public String getTemplatedJavaTypeName() {
        if (this.model != null) {
            return "%{" + this.model.getNamespace() + "." + this.name + "}";
        }
        throw new IllegalStateException("This method must provide namespace or be overridden in subclasses (" + this.name + ").");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getName();
    }

    public String getQualifiedName(AdmModel model) {
        if (this.model != null && !model.getNamespace().equals(this.model.getNamespace())) {
            return this.model.getNamespace() + "." + this.name;
        }
        return this.name;
    }

    public void setModel(AdmModel model) {
        this.model = model;
    }

    public AdmModel getModel() {
        return this.model;
    }

    public String getJavaTypeName() {
        return this.getName();
    }

    public String getPrimitiveTypeName() {
        return this.getJavaTypeName();
    }

    public String getTemplatedPrimitiveTypeName() {
        return this.getTemplatedJavaTypeName();
    }

    public boolean isArray() {
        return false;
    }
}

