/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmDocumentedType;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.EAdmException;
import com.neeve.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public final class AdmEnumeration
extends AdmScopedType {
    private final CodeType codeType;
    private final LinkedList<ConstEntry> consts;
    private boolean valIsDiffFromDerived;
    private static boolean useLongProtoConstNames = Config.getValue((String)"nv.adm.uselongprotoconstnames", (boolean)true);

    public AdmEnumeration(AdmModel model, String namespace, String name, CodeType codeType) {
        super(model, namespace, name);
        this.codeType = codeType;
        this.consts = new LinkedList();
    }

    public AdmEnumeration(AdmModel model, String namespace, String name) {
        this(model, namespace, name, CodeType.INTEGER);
    }

    private final void validateCodeParameter(Object code) throws EAdmException {
        switch (this.codeType) {
            case INTEGER: {
                if (code == null) break;
                throw new EAdmException("code can only be supplied for character and string coded enums", this.getCodeSource());
            }
            case CHARACTER: {
                if (code == null) {
                    throw new EAdmException("code value for a character coded enum cannot be null", this.getCodeSource());
                }
                if (code instanceof Character) break;
                throw new EAdmException("code value for a character coded enum must be of Character type", this.getCodeSource());
            }
            case STRING: {
                if (code == null) {
                    throw new EAdmException("code value for a string coded enum cannot be null", this.getCodeSource());
                }
                if (code instanceof String) break;
                throw new EAdmException("code value for a string coded enum must be of String type", this.getCodeSource());
            }
            default: {
                throw new EAdmException("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'", this.getCodeSource());
            }
        }
    }

    private final AdmEnumeration addConstCore(String name, int value, Object code) throws EAdmException {
        if (this.hasValue(0) && value == Integer.MAX_VALUE || this.hasValue(Integer.MAX_VALUE) && value == 0) {
            throw new EAdmException("an enumeration cannot have both value of 0 and 2147483647", this.getCodeSource());
        }
        ConstEntry entry = new ConstEntry(name, value, code);
        this.consts.remove(entry);
        this.consts.add(entry);
        return this;
    }

    public final void setUseLongProtoConstNames(boolean val) {
        useLongProtoConstNames = val;
    }

    public final AdmEnumeration addConst(String name, int value, Object code) throws EAdmException {
        this.validateCodeParameter(code);
        switch (this.codeType) {
            case CHARACTER: {
                this.valIsDiffFromDerived |= value != ((Character)code).charValue();
                break;
            }
            case STRING: {
                this.valIsDiffFromDerived |= value != ((String)code).hashCode();
                break;
            }
        }
        return this.addConstCore(name, value, code);
    }

    public final AdmEnumeration addConst(String name, Object code) throws EAdmException {
        switch (this.codeType) {
            case INTEGER: {
                if (code == null) {
                    throw new IllegalArgumentException("code value cannot be null");
                }
                if (!(code instanceof Integer)) {
                    throw new EAdmException("code value for a integer coded enum must be of Integer type", this.getCodeSource());
                }
                return this.addConstCore(name, (Integer)code, null);
            }
            case CHARACTER: {
                this.validateCodeParameter(code);
                return this.addConstCore(name, ((Character)code).charValue(), code);
            }
            case STRING: {
                this.validateCodeParameter(code);
                return this.addConstCore(name, ((String)code).hashCode(), code);
            }
        }
        throw new EAdmException("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'", this.getCodeSource());
    }

    public final AdmEnumeration addConst(String name, int value) throws EAdmException {
        return this.addConst(name, value, null);
    }

    public final ConstEntry getConst(String name) {
        if (name == null) {
            throw new IllegalArgumentException("const name cannot be null");
        }
        Iterator<ConstEntry> iterator = this.constIterator();
        while (iterator.hasNext()) {
            ConstEntry entry = iterator.next();
            if (!entry.name.equals(name)) continue;
            return entry;
        }
        return null;
    }

    public final Collection<ConstEntry> getConsts() {
        return this.consts;
    }

    public final boolean hasValue(int value) {
        Iterator<ConstEntry> iterator = this.constIterator();
        while (iterator.hasNext()) {
            if (iterator.next().value != value) continue;
            return true;
        }
        return false;
    }

    public final Iterator<ConstEntry> constIterator() {
        return this.consts.iterator();
    }

    public final CodeType getCodeType() {
        return this.codeType;
    }

    public final void generateProtobufIDL(PrintWriter writer) throws EAdmException {
        writer.println("enum " + this.getName() + " {");
        writer.println("   option (com.neeve.adm.types.protobuf.enum_type) = \"" + CodeType.toIDLEnumType(this.codeType) + "\";");
        Collections.sort(this.consts);
        Iterator<ConstEntry> iterator = this.constIterator();
        block5: while (iterator.hasNext()) {
            ConstEntry entry = iterator.next();
            switch (this.codeType) {
                case INTEGER: {
                    writer.println("   " + entry.protoIDLConstName() + " = " + entry.value + ";");
                    continue block5;
                }
                case CHARACTER: {
                    writer.println("   " + entry.protoIDLConstName() + " = " + entry.value + " [(com.neeve.adm.types.protobuf.stringvalue) = \"" + ((Character)entry.code).toString() + "\"];");
                    continue block5;
                }
                case STRING: {
                    writer.println("   " + entry.protoIDLConstName() + " = " + entry.value + " [(com.neeve.adm.types.protobuf.stringvalue) = \"" + (String)entry.code + "\"];");
                    continue block5;
                }
            }
            throw new EAdmException("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'", this.getCodeSource());
        }
        writer.println("}");
    }

    public final void generateClass(AdmSourceCodeBuilder codeBuilder) throws Exception {
        ConstEntry entry;
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(this.getNamespace());
        codeBuilder.last().appendln("");
        AdmGenerator.writeJavadocTypeComment("", this, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(((Object)((Object)this)).getClass(), null, this.getModel(), codeBuilder);
        codeBuilder.last().appendln("public enum " + this.getName() + " {");
        Collections.sort(this.consts);
        Iterator<ConstEntry> iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            AdmGenerator.writeJavadocTypeComment("   ", entry, codeBuilder);
            codeBuilder.last().append("   " + entry.name + " (" + entry.value + ")");
            if (iterator.hasNext()) {
                codeBuilder.last().appendln(",");
                continue;
            }
            codeBuilder.last().appendln(";");
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   final private static class EnumIndex {");
        codeBuilder.last().appendln("       final private EnumIndex _children[] = new EnumIndex[256];");
        codeBuilder.last().appendln("       private boolean _isLeaf;");
        codeBuilder.last().appendln("       private " + this.getName() + " _value;");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("       final private void insert(final " + this.getName() + " value, final int pos) {");
        codeBuilder.last().appendln("           final String key = value.name();");
        codeBuilder.last().appendln("           if (pos == key.length()) {");
        codeBuilder.last().appendln("               _isLeaf = true;");
        codeBuilder.last().appendln("               _value = value;");
        codeBuilder.last().appendln("           }");
        codeBuilder.last().appendln("           else {");
        codeBuilder.last().appendln("               final int idx = Character.toLowerCase(key.charAt(pos));");
        codeBuilder.last().appendln("               if (_children[idx] == null) {");
        codeBuilder.last().appendln("                   _children[idx] = new EnumIndex();");
        codeBuilder.last().appendln("               }");
        codeBuilder.last().appendln("               _children[idx].insert(value, pos+1);");
        codeBuilder.last().appendln("           }");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("       final void insert(final " + this.getName() + " value) {");
        codeBuilder.last().appendln("           insert(value, 0);");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("       final EnumIndex next(final char c) {");
        codeBuilder.last().appendln("           return _children[Character.toLowerCase(c)];");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("       final " + this.getName() + " value() {");
        codeBuilder.last().appendln("           return _value;");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /*");
        codeBuilder.last().appendln("    * The enum values stored in serialized form");
        codeBuilder.last().appendln("    */");
        iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            codeBuilder.last().appendln("   final private static int " + entry.name + "_ASCII_BufferLen;");
            codeBuilder.last().appendln("   final private static long " + entry.name + "_ASCII_Buffer;");
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /*");
        codeBuilder.last().appendln("    * The enum search index");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final private static EnumIndex _index = new EnumIndex();");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * A zero garbage alternative to {@link " + this.getName() + "#values()}.");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static %{java.util.List}<" + this.getName() + "> VALUES = %{java.util.Collections}.unmodifiableList(%{java.util.Arrays}.asList(" + this.getName() + ".values()));");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * A preallocated empty array used to avoid garbage when returning empty arrays.");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static " + this.getName() + "[] EMPTY_ARRAY = new " + this.getName() + "[0];");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * The ordinal value");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public int val;");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * The static constructor");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   static {");
        codeBuilder.last().appendln("       byte[] bytes;");
        iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("       bytes = " + this.getName() + "." + entry.name + ".name().getBytes(%{java.nio.charset.Charset}.forName(\"US-ASCII\"));");
            codeBuilder.last().appendln("       " + entry.name + "_ASCII_BufferLen = bytes.length;");
            codeBuilder.last().appendln("       " + entry.name + "_ASCII_Buffer = %{com.neeve.io.IOBuffer}.allocateMemoryBlock(bytes.length);");
            codeBuilder.last().appendln("       %{com.neeve.io.IOBuffer}.putFrom(" + entry.name + "_ASCII_Buffer, 0, bytes, 0, bytes.length);");
            codeBuilder.last().appendln("       _index.insert(" + this.getName() + "." + entry.name + ");");
        }
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   " + this.getName() + "(final int val) {");
        codeBuilder.last().appendln("      this.val = val;");
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Tests if the passed in value represents a 'constant' in this enumeration.");
        codeBuilder.last().appendln("    * ");
        codeBuilder.last().appendln("    * @param val The value to test for.");
        codeBuilder.last().appendln("    * @return true If this enumeration has the given 'constant' value.");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static boolean hasValue(final int val) {");
        codeBuilder.last().appendln("      switch (val) {");
        iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            codeBuilder.last().appendln("         case " + entry.value + ":");
            codeBuilder.last().appendln("             return true;");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("         default:");
        codeBuilder.last().appendln("            return false;");
        codeBuilder.last().appendln("      }");
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Get an enum's name's length serialized using ASCII encoding");
        codeBuilder.last().appendln("    *");
        codeBuilder.last().appendln("    * @param val The enum whose name to serialize.");
        codeBuilder.last().appendln("    * @return The serialized length");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static int nameASCIILen(final " + this.getName() + " val) {");
        codeBuilder.last().appendln("      switch (val) {");
        iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            codeBuilder.last().appendln("         case " + entry.name + ":");
            codeBuilder.last().appendln("              return " + entry.name + "_ASCII_BufferLen;");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("         default:");
        codeBuilder.last().appendln("            throw new IllegalArgumentException(\"invalid const: '\" + val + \"'\");");
        codeBuilder.last().appendln("      }");
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Serialize an enum's name to a native memory region");
        codeBuilder.last().appendln("    *");
        codeBuilder.last().appendln("    * @param val The enum whose name to serialize.");
        codeBuilder.last().appendln("    * @param addr The native address to serialize to");
        codeBuilder.last().appendln("    * @param offset The offset relative to the native address to serialize to");
        codeBuilder.last().appendln("    * @return The serialized length");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static int nameTo(final " + this.getName() + " val, final long addr, final int offset) {");
        codeBuilder.last().appendln("      switch (val) {");
        iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            codeBuilder.last().appendln("         case " + entry.name + ":");
            codeBuilder.last().appendln("              %{com.neeve.io.IOBuffer}.copy(" + entry.name + "_ASCII_Buffer, 0, addr, offset, " + entry.name + "_ASCII_BufferLen);");
            codeBuilder.last().appendln("              return " + entry.name + "_ASCII_BufferLen;");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("         default:");
        codeBuilder.last().appendln("            throw new IllegalArgumentException(\"invalid const: '\" + val + \"'\");");
        codeBuilder.last().appendln("      }");
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Gets an enum from its serialized name value");
        codeBuilder.last().appendln("    *");
        codeBuilder.last().appendln("    * @param val The value whose name to serialize.");
        codeBuilder.last().appendln("    * @param addr The native address where the enum's name is serialized");
        codeBuilder.last().appendln("    * @param offset The offset relative to the native address where the name is serialized");
        codeBuilder.last().appendln("    * @param limit The limit into the buffer to parse");
        codeBuilder.last().appendln("    * @param delim The terminating character of the serialized name");
        codeBuilder.last().appendln("    * @param parsedCount Contains the number of characters parsed");
        codeBuilder.last().appendln("    * @return The deserialized enum");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static " + this.getName() + " fromName(final long addr, final int offset, final int limit, final char delim, final %{com.neeve.io.IOBuffer}.ParsedCount parsedCount) {");
        codeBuilder.last().appendln("       EnumIndex index = _index;");
        codeBuilder.last().appendln("       " + this.getName() + " ret = null;");
        codeBuilder.last().appendln("       boolean successfulParse = false;");
        codeBuilder.last().appendln("       parsedCount.value = 0;");
        codeBuilder.last().appendln("       while ((offset + parsedCount.value) < limit) {");
        codeBuilder.last().appendln("           final char c = %{com.neeve.io.IOBuffer}.getASCIIChar(addr, offset + parsedCount.value++);");
        codeBuilder.last().appendln("           if (c == delim) {");
        codeBuilder.last().appendln("               ret = index != null ? index.value() : null;");
        codeBuilder.last().appendln("               break;");
        codeBuilder.last().appendln("           }");
        codeBuilder.last().appendln("           else {");
        codeBuilder.last().appendln("               index = index != null ? index.next(c) : null;");
        codeBuilder.last().appendln("           }");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("       if (ret == null) {");
        codeBuilder.last().appendln("           throw new IllegalArgumentException(\"invalid serialized enum name\");");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("       return ret;");
        codeBuilder.last().appendln("   }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Get an enum from its value.");
        codeBuilder.last().appendln("    * ");
        codeBuilder.last().appendln("    * @param val The value to look up.");
        codeBuilder.last().appendln("    * @return The value corresponding to the constant value");
        codeBuilder.last().appendln("    * @throws IllegalArgumentException if the provided code is not a valid code for this enum");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static " + this.getName() + " fromValue(final int val) {");
        codeBuilder.last().appendln("      switch (val) {");
        iterator = this.constIterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            codeBuilder.last().appendln("         case " + entry.value + ":");
            codeBuilder.last().appendln("             return " + entry.name + ";");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("         default:");
        codeBuilder.last().appendln("            throw new IllegalArgumentException(\"invalid value: '\" + val + \"'\");");
        codeBuilder.last().appendln("      }");
        codeBuilder.last().appendln("   }");
        switch (this.codeType) {
            case INTEGER: {
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("   /**");
                codeBuilder.last().appendln("    * Get an enum from its 'code' value.");
                codeBuilder.last().appendln("    * ");
                codeBuilder.last().appendln("    * @param code The 'code' value to look up.");
                codeBuilder.last().appendln("    * @return The enumeration value corresponding to the 'code' value");
                codeBuilder.last().appendln("    * @throws IllegalArgumentException if the provided code is not a valid code for this enum");
                codeBuilder.last().appendln("    */");
                codeBuilder.last().appendln("   final public static " + this.getName() + " fromCode(final int code) {");
                codeBuilder.last().appendln("      return fromValue(code);");
                codeBuilder.last().appendln("   }");
                break;
            }
            case CHARACTER: {
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("   /**");
                codeBuilder.last().appendln("    * Get an enum from its 'code' value.");
                codeBuilder.last().appendln("    * ");
                codeBuilder.last().appendln("    * @param code The 'code' value to look up.");
                codeBuilder.last().appendln("    * @return The enumeration value corresponding to the 'code' value");
                codeBuilder.last().appendln("    * @throws IllegalArgumentException if the provided code is not a valid code for this enum");
                codeBuilder.last().appendln("    */");
                codeBuilder.last().appendln("   final public static " + this.getName() + " fromCode(final Character code) {");
                codeBuilder.last().appendln("      switch (code) {");
                iterator = this.constIterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    codeBuilder.last().appendln("         case '" + Character.toString(((Character)entry.code).charValue()) + "':");
                    codeBuilder.last().appendln("             return " + entry.name + ";");
                    codeBuilder.last().appendln("");
                }
                codeBuilder.last().appendln("         default:");
                codeBuilder.last().appendln("            throw new IllegalArgumentException(\"invalid code '\" + code + \"'\");");
                codeBuilder.last().appendln("      }");
                codeBuilder.last().appendln("   }");
                break;
            }
            case STRING: {
                codeBuilder.last().appendln("   /**");
                codeBuilder.last().appendln("    * Get an enum from its 'code' value.");
                codeBuilder.last().appendln("    * ");
                codeBuilder.last().appendln("    * @param code The 'code' value to look up.");
                codeBuilder.last().appendln("    * @return The enumeration value corresponding to the 'code' value");
                codeBuilder.last().appendln("    * @throws IllegalArgumentException if the provided code is not a valid code for this enum");
                codeBuilder.last().appendln("    */");
                if (this.valIsDiffFromDerived) {
                    codeBuilder.last().appendln("   final public static " + this.getName() + " fromCode(final String code) {");
                    iterator = this.constIterator();
                    boolean first = true;
                    while (iterator.hasNext()) {
                        ConstEntry entry2 = iterator.next();
                        if (first) {
                            codeBuilder.last().appendln("      if (code.equals(\"" + (String)entry2.code + "\")) {");
                            first = false;
                        } else {
                            codeBuilder.last().appendln("      else if (code.equals(\"" + (String)entry2.code + "\")) {");
                        }
                        codeBuilder.last().appendln("          return " + entry2.name + ";");
                        codeBuilder.last().appendln("      }");
                    }
                    codeBuilder.last().appendln("      throw new IllegalArgumentException(\"invalid code '\" + code + \"'\");");
                    codeBuilder.last().appendln("   }");
                    break;
                }
                codeBuilder.last().appendln("   final public static " + this.getName() + " fromCode(final String code) {");
                codeBuilder.last().appendln("      return fromValue(code.hashCode());");
                codeBuilder.last().appendln("   }");
                break;
            }
            default: {
                throw new InternalError("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'");
            }
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Get an enum from its 'code' value in string form.");
        codeBuilder.last().appendln("    * ");
        codeBuilder.last().appendln("    * @param value The 'code' value to look up.");
        codeBuilder.last().appendln("    * @return The enumeration value corresponding to the 'code' value");
        codeBuilder.last().appendln("    * @throws IllegalArgumentException if the provided code is not a valid code for this enum");
        codeBuilder.last().appendln("    */");
        switch (this.codeType) {
            case INTEGER: {
                codeBuilder.last().appendln("   final public static " + this.getName() + " fromCodeString(final String value) {");
                codeBuilder.last().appendln("      return fromCode(Integer.parseInt(value));");
                codeBuilder.last().appendln("   }");
                break;
            }
            case CHARACTER: {
                codeBuilder.last().appendln("   final public static " + this.getName() + " fromCodeString(final String value) {");
                codeBuilder.last().appendln("      return fromCode(value.charAt(0));");
                codeBuilder.last().appendln("   }");
                break;
            }
            case STRING: {
                codeBuilder.last().appendln("   final public static " + this.getName() + " fromCodeString(final String value) {");
                codeBuilder.last().appendln("      return fromCode(value);");
                codeBuilder.last().appendln("   }");
                break;
            }
            default: {
                throw new InternalError("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'");
            }
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Gets the code type with which this enumeration was generated.");
        codeBuilder.last().appendln("    * ");
        codeBuilder.last().appendln("    * @return The code type (Character.class, Integer.class, or String.class)");
        codeBuilder.last().appendln("    */");
        switch (this.codeType) {
            case INTEGER: {
                codeBuilder.last().appendln("   final public static Class<?> getCodeType() {");
                codeBuilder.last().appendln("      return Integer.class;");
                codeBuilder.last().appendln("   }");
                break;
            }
            case CHARACTER: {
                codeBuilder.last().appendln("   final public static Class<?> getCodeType() {");
                codeBuilder.last().appendln("      return Character.class;");
                codeBuilder.last().appendln("   }");
                break;
            }
            case STRING: {
                codeBuilder.last().appendln("   final public static Class<?> getCodeType() {");
                codeBuilder.last().appendln("      return String.class;");
                codeBuilder.last().appendln("   }");
                break;
            }
            default: {
                throw new InternalError("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'");
            }
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * Gets the code value for this enumeration as a String.");
        codeBuilder.last().appendln("    * ");
        codeBuilder.last().appendln("    * @return the code value for this enumeration as a String.");
        codeBuilder.last().appendln("    */");
        switch (this.codeType) {
            case INTEGER: {
                codeBuilder.last().appendln("   final public String getCodeString() {");
                codeBuilder.last().appendln("      return String.valueOf(this.val);");
                codeBuilder.last().appendln("   }");
                break;
            }
            case CHARACTER: {
                codeBuilder.last().appendln("   final public String getCodeString() {");
                codeBuilder.last().appendln("      return Character.toString((char)this.val);");
                codeBuilder.last().appendln("   }");
                break;
            }
            case STRING: {
                codeBuilder.last().appendln("   final public String getCodeString() {");
                codeBuilder.last().appendln("      switch (this.val) {");
                iterator = this.constIterator();
                while (iterator.hasNext()) {
                    ConstEntry entry3 = iterator.next();
                    codeBuilder.last().appendln("         case " + entry3.value + ":");
                    codeBuilder.last().appendln("             return \"" + (String)entry3.code + "\";");
                    codeBuilder.last().appendln("");
                }
                codeBuilder.last().appendln("      }");
                codeBuilder.last().appendln("      return null;");
                codeBuilder.last().appendln("   }");
                break;
            }
            default: {
                throw new InternalError("unknown enumeration code type '" + (Object)((Object)this.codeType) + "'");
            }
        }
        codeBuilder.last().appendln("}");
    }

    public final void generateClass(File baseOutDir, boolean absolute) throws Exception {
        File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), this.getName());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder(this.getModel());
            this.generateClass(codeBuilder);
            codeBuilder.write(file);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create enumeration class file '" + file.getPath() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    public final class ConstEntry
    extends AdmDocumentedType
    implements Comparable<ConstEntry> {
        public final String name;
        public final int value;
        public final Object code;

        ConstEntry(String name, int value, Object code) {
            if (name == null) {
                throw new IllegalArgumentException("const name cannot be null");
            }
            this.name = name;
            this.value = value;
            this.code = code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        final String protoIDLConstName() {
            return useLongProtoConstNames ? AdmEnumeration.this.getName() + "_" + this.name : this.name;
        }

        @Override
        public final int compareTo(ConstEntry entry) {
            return this.value - entry.value;
        }

        public final boolean equals(Object o) {
            ConstEntry entry = (ConstEntry)o;
            return this.name.equals(entry.name);
        }

        public final int hashCode() {
            return this.name.hashCode();
        }
    }

    public static enum CodeType {
        INTEGER,
        CHARACTER,
        STRING;


        public static String toIDLEnumType(CodeType codeType) {
            switch (codeType) {
                case INTEGER: {
                    return "int";
                }
                case CHARACTER: {
                    return "char";
                }
                case STRING: {
                    return "string";
                }
            }
            throw new InternalError("unknown enumeration code type '" + (Object)((Object)codeType) + "'");
        }
    }
}

