/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jcsmp;

import com.neeve.root.RootConfig;
import com.neeve.sma.SmaException;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.ISolSession;
import com.neeve.solxf.SolConfig;
import com.neeve.solxf.impl.jcsmp.SolJcsmpQueue;
import com.neeve.solxf.impl.jcsmp.SolJcsmpSession;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SolJcsmpFactory {
    private static final SolJcsmpFactory _instance = new SolJcsmpFactory();

    private SolJcsmpFactory() {
    }

    public static final SolJcsmpFactory onlyInstance() {
        return _instance;
    }

    public final ISolSession createSession(String host, String userName, Properties props, Properties solxfProperties) throws SmaException {
        return new SolJcsmpSession(host, userName, props, solxfProperties);
    }

    public final ISolQueue createQueue(SolJcsmpSession session, String name) {
        return new SolJcsmpQueue(session, name);
    }

    static {
        Level logLevel = Level.INFO;
        switch (RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)SolConfig.getConfig()).getLevel()) {
            case SEVERE: {
                logLevel = Level.SEVERE;
                break;
            }
            case WARNING: {
                logLevel = Level.WARNING;
                break;
            }
            case INFO: {
                logLevel = Level.INFO;
                break;
            }
            case CONFIG: {
                logLevel = Level.CONFIG;
                break;
            }
            case FINE: {
                logLevel = Level.FINE;
                break;
            }
            case FINER: {
                logLevel = Level.FINER;
                break;
            }
            case DIAGNOSE: 
            case VERBOSE: 
            case FINEST: {
                logLevel = Level.FINEST;
                break;
            }
            case DEBUG: 
            case ALL: {
                logLevel = Level.ALL;
                break;
            }
            case OFF: {
                logLevel = Level.OFF;
            }
        }
        Logger.getLogger("com.solacesystems.jcsmp").setLevel(logLevel);
    }
}

