/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solace;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.solace.SolaceBindingProperties;
import com.neeve.solace.SolaceMessageBusBinding;
import com.neeve.solace.SolaceMessageChannel;
import com.neeve.solace.SolaceOrphanSubscriptionFoundSmaException;
import com.neeve.solxf.ESolException;
import com.neeve.solxf.ISolContext;
import com.neeve.solxf.ISolFlowReceiver;
import com.neeve.solxf.ISolMessageConsumer;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.solxf.ISolMessageProducer;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.ISolSession;
import com.neeve.solxf.SolFactory;
import com.neeve.solxf.semp.reply.QueueType;
import com.neeve.solxf.semp.reply.RpcReply;
import com.neeve.solxf.semp.request.KeywordType;
import com.neeve.solxf.semp.request.Rpc;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlConcurrentRingBuffer;
import com.neeve.util.UtlDisruptor;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.neeve.util.UtlUnit;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class SolaceSession
extends SmaObject {
    final Thread.UncaughtExceptionHandler sendThreadExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable th) {
            if (((SolaceSession)SolaceSession.this).tracer.debug) {
                SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Thread [" + t.getName() + "] has Exception [" + th.getMessage() + "]...", Tracer.Level.DEBUG);
            }
            if (((SolaceSession)SolaceSession.this).tracer.debug) {
                SolaceSession.this.tracer.log(".... Calling binding.onSessionFail()", Tracer.Level.DEBUG);
            }
            SolaceSession.this.binding.onSessionFail((Exception)((Object)new SmaException(th)));
            if (((SolaceSession)SolaceSession.this).tracer.debug) {
                SolaceSession.this.tracer.log(".... Done Calling binding.onSessionFail(), everything should be down now", Tracer.Level.DEBUG);
            }
        }
    };
    private static final ThreadLocal<String> sessionDispatchThreadNames = new ThreadLocal();
    private final SolaceEventHandler handler = new SolaceEventHandler();
    private final SolaceMessageBusBinding binding;
    private final boolean isProducer;
    private final boolean isConsumer;
    private final String userName;
    private final MessageBusDescriptor descriptor;
    private final Properties providerProps;
    private final String type;
    private final Disruptor<CarrierEvent> disruptor;
    private final RingBuffer<CarrierEvent> ringBuffer;
    private final UtlConcurrentRingBuffer<OutstandingSendContext> sendContexts;
    private final MessageLatencyManager latencyManager;
    private final int sessionOpenRetryLimit;
    private final int sessionOpenRetryInterval;
    private final String tracePrefix;
    private final Properties solxfProperties;
    private Thread senderThread;
    private ISolSession session;
    private ISolQueue queue;
    private ISolMessageProducer producer;
    private ISolMessageConsumer consumer;
    private ISolFlowReceiver flowReceiver;
    private long sno;
    private long stableSno;
    private boolean useJNI = false;
    private boolean treatNonXInboundMessagesAsFault;
    private Set<String> guaranteedSubscriptions = new LinkedHashSet<String>();
    private boolean consumerThreadInitialized = false;
    private boolean producerThreadInitialized = false;
    private boolean started = false;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Exception failure = null;

    public SolaceSession(SolaceMessageBusBinding binding, boolean isProducer, boolean isConsumer, String userName, MessageBusDescriptor descriptor, Properties providerProps, boolean useJNI, boolean treatNonXInboundMessagesAsFault) throws SmaException {
        super(null);
        this.type = "[" + (isProducer ? "P" : "") + (isConsumer ? "C" : "") + "]";
        this.tracePrefix = "[SolaceSession," + descriptor.getName() + "," + this.type + "] ";
        if (this.tracer.debug) {
            this.tracer.log("[SolaceSession," + descriptor.getName() + "," + this.type + "] Creating session [user name=" + userName + "]...", Tracer.Level.DEBUG);
        }
        this.binding = binding;
        this.isProducer = isProducer;
        this.isConsumer = isConsumer;
        this.userName = userName;
        this.descriptor = descriptor;
        this.providerProps = (Properties)providerProps.clone();
        this.useJNI = useJNI;
        this.treatNonXInboundMessagesAsFault = treatNonXInboundMessagesAsFault;
        this.sessionOpenRetryLimit = binding.getSessionOpenRetryCount();
        this.sessionOpenRetryInterval = binding.getSessionOpenRetryInterval();
        this.solxfProperties = new Properties();
        this.solxfProperties.put("write_payload_in_xml_content", String.valueOf(binding.isWritePayloadInXmlContent()));
        this.solxfProperties.put("read_payload_from_xml_content", String.valueOf(binding.isReadPayloadFromXmlContent()));
        if (isProducer && binding.detachedSends()) {
            this.disruptor = UtlDisruptor.createSingleConsumerDisruptor((EventFactory)new CarrierEventFactory(), (int)binding.getDetachedSendsQueueDepth(), (ThreadFactory)new SenderThreadFactory(), (ProducerType)ProducerType.SINGLE, (WaitStrategy)binding.getDetachedSendsQueueWaitStrategy(), (EventHandler)new CarrierEventProcessor());
            this.ringBuffer = this.disruptor.getRingBuffer();
        } else {
            this.disruptor = null;
            this.ringBuffer = null;
        }
        this.sendContexts = UtlConcurrentRingBuffer.create((int)256, (UtlConcurrentRingBuffer.ItemFactory)new OutstandingSendContextFactory());
        this.latencyManager = binding.getLatencyManager();
        try {
            if (isConsumer && binding.enableSempRequests()) {
                long ts = System.currentTimeMillis();
                this.marshaller = JAXBContext.newInstance((Class[])new Class[]{Rpc.class}).createMarshaller();
                this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{RpcReply.class}).createUnmarshaller();
                this.tracer.log(this.tracePrefix + "Created SEMP request/reply marshaller/unmarshaller in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts), (TimeUnit)TimeUnit.MILLISECONDS), Tracer.Level.INFO);
            } else {
                this.marshaller = null;
                this.unmarshaller = null;
            }
        }
        catch (Exception e) {
            throw new SmaException((Throwable)e);
        }
    }

    private final String getClientName(boolean isConsumer) {
        return this.binding.clientName() + (this.binding.isSingleSession() ? "" : (isConsumer ? "-IN" : "-OUT"));
    }

    private final Properties getSessionProperties(Properties providerProps) {
        if (!this.useJNI) {
            if (!providerProps.containsKey("jcsmp.PUB_MULTI_THREAD")) {
                providerProps.setProperty("jcsmp.PUB_MULTI_THREAD", "false");
            }
            if (!providerProps.containsKey("jcsmp.SUB_ACK_WINDOW_SIZE")) {
                providerProps.setProperty("jcsmp.SUB_ACK_WINDOW_SIZE", "255");
            }
            if (!providerProps.containsKey("jcsmp.MESSAGE_ACK_MODE")) {
                providerProps.setProperty("jcsmp.MESSAGE_ACK_MODE", "client_ack");
            }
            providerProps.setProperty("jcsmp.client_name", this.getClientName(this.isConsumer));
        } else {
            providerProps.setProperty("SESSION_CLIENT_NAME", this.getClientName(this.isConsumer));
        }
        if (this.tracer.debug) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Preparing session properties from " + providerProps + "...", Tracer.Level.DEBUG);
        }
        return providerProps;
    }

    private final Properties getFlowProperties(Properties props) throws SmaException {
        String val;
        String key;
        Enumeration<?> enumeration;
        Properties flowProps = new Properties();
        if (this.useJNI) {
            if (!props.containsKey("FLOW_FORWARDING_MODE")) {
                props.setProperty("FLOW_FORWARDING_MODE", "1");
            }
            enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                val = props.getProperty(key);
                if (!key.startsWith("FLOW_")) continue;
                flowProps.setProperty(key, val);
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Flow properties...", Tracer.Level.DEBUG);
            enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                val = props.getProperty(key);
                this.tracer.log("..." + key + "=" + val, Tracer.Level.DEBUG);
            }
        }
        return flowProps;
    }

    private final void onAckNack(long key, Exception status) {
        String err = null;
        if (key > this.stableSno && key <= this.sno) {
            if (key == this.stableSno + 1L) {
                long slot = this.sendContexts.nextRead();
                OutstandingSendContext context = (OutstandingSendContext)this.sendContexts.get(slot);
                if (context != null && context.id == key) {
                    if (status != null) {
                        XString messageKey = context.view != null ? context.view.getMessageKeyAsRaw() : null;
                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Received send completion (msg=" + context.view + ", key=" + (messageKey != null ? messageKey.toDiagnosticString() : "null") + ", status=" + status + ")", Tracer.Level.WARNING);
                    } else if (this.tracer.debug) {
                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Received send completion (msg=" + context.view + ", status=" + status + ")", Tracer.Level.DEBUG);
                    }
                    ++this.stableSno;
                    SolaceMessageChannel sender = context.sender;
                    MessageView view = context.view;
                    this.sendContexts.read(slot);
                    sender.onAckNack(view, status);
                } else {
                    err = context == null ? "missing context [key=" + key + "]" : "invalid context sno [exp=" + key + ", actual=" + context.id + "]";
                }
            } else {
                err = "out of sequence send completion [exp=" + (this.stableSno + 1L) + ", actual=" + key + "]";
            }
        } else {
            err = "invalid stable sno [sno=" + key + ", last=" + this.sno + ", stable=" + this.stableSno + "]";
        }
        if (err != null) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] **** " + err + " ****", Tracer.Level.SEVERE);
            if (this.failure == null) {
                this.failure = new Exception(err, status);
            }
        }
    }

    private final void enqueForDetachedSend(SolaceMessageChannel sender, MessageView view, IOBuffer serializedMessage, int serializedMessageOffset, int serializedMessageLength, IOBuffer serializedMetadata, int serializedMetadataOffset, int serializedMetadataLength, XString topic, MessageChannel.Qos qos, int flags) {
        long sequence = this.ringBuffer.next();
        CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
        carrierEvent.sender = sender;
        carrierEvent.view = view;
        carrierEvent.view.acquire();
        carrierEvent.serializedMessage = IOBuffer.ensureCapacity((IOBuffer)carrierEvent.serializedMessage, (int)serializedMessageLength, (boolean)false);
        IOBuffer.copy((long)serializedMessage.getNativeAddress(), (int)serializedMessageOffset, (long)carrierEvent.serializedMessage.getNativeAddress(), (int)0, (int)serializedMessageLength);
        carrierEvent.serializedMessageOffset = serializedMessageOffset;
        carrierEvent.serializedMessageLength = serializedMessageLength;
        if (serializedMetadata != null) {
            carrierEvent.serializedMetadata = IOBuffer.ensureCapacity((IOBuffer)carrierEvent.serializedMetadata, (int)serializedMetadataLength, (boolean)false);
            IOBuffer.copy((long)serializedMetadata.getNativeAddress(), (int)serializedMetadataOffset, (long)carrierEvent.serializedMetadata.getNativeAddress(), (int)0, (int)serializedMetadataLength);
        }
        carrierEvent.serializedMetadataOffset = serializedMetadataOffset;
        carrierEvent.serializedMetadataLength = serializedMetadataLength;
        carrierEvent.topic.setValue(topic);
        carrierEvent.qos = qos;
        carrierEvent.flags = flags;
        this.ringBuffer.publish(sequence);
    }

    private final MessageTransportHeaders.Header getUserDataTransportHeader(MessageView view) {
        MessageTransportHeaders.Header ret = null;
        MessageTransportHeaders headers = view.getMessageTransportHeaders();
        if (headers != null) {
            for (MessageTransportHeaders.Header header : headers) {
                if (!header.getNameUnsafe().equals((Object)SolaceBindingProperties.TRANSPORT_PROPNAME_USERDATA)) continue;
                ret = header;
                break;
            }
        }
        return ret;
    }

    private final OutstandingSendContext allocateOutstandingSendContext(SolaceMessageChannel sender, MessageView view) {
        long slot = this.sendContexts.nextWrite();
        OutstandingSendContext sendContext = (OutstandingSendContext)this.sendContexts.get(slot);
        sendContext.init(++this.sno, sender, view);
        this.sendContexts.write(slot);
        return sendContext;
    }

    private final void sendCore(SolaceMessageChannel sender, MessageView view, IOBuffer serializedMessage, int serializedMessageOffset, int serializedMessageLength, IOBuffer serializedMetadata, int serializedMetadataOffset, int serializedMetadataLength, XString topic, MessageChannel.Qos qos, int flags) throws SmaException {
        if (this.failure != null) {
            this.binding.onSessionFail(this.failure);
            return;
        }
        MessageTransportHeaders.Header userdataHeader = this.getUserDataTransportHeader(view);
        long preWireTs = this.producer.send(serializedMessage, serializedMessageOffset, serializedMessageLength, serializedMetadata, serializedMetadataOffset, serializedMetadataLength, userdataHeader != null ? userdataHeader.getEncodedValueBackingBuffer() : null, userdataHeader != null ? userdataHeader.getEncodedValueOffset() : 0, userdataHeader != null ? userdataHeader.getEncodedValueLength() : 0, topic, view.getOriginTs(), qos == MessageChannel.Qos.Guaranteed ? this.allocateOutstandingSendContext((SolaceMessageChannel)sender, (MessageView)view).id : 0L);
        view.setPostWireSendTs(UtlTime.now());
        view.setPreWireTs(preWireTs);
        if (MessageLatencyManager.captureMsgLatencyStats && this.latencyManager != null) {
            this.latencyManager.update(view, MessageLatencyManager.MessagingDirection.Outbound);
        }
    }

    private final void validateMaxBindCount() throws SmaException {
        if (this.binding.enforceMaxBindCount() <= 0L) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Skipping max bind count check (not enabled): " + this.binding.enforceMaxBindCount(), Tracer.Level.DEBUG);
            }
            return;
        }
        if (!this.isConsumer) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Skipping max bind count check (not a consumer session)", Tracer.Level.DEBUG);
            }
            return;
        }
        String queueName = this.binding.queueName();
        if (queueName == null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Skipping max bind count check (no queue for session)", Tracer.Level.DEBUG);
            }
            return;
        }
        if (!this.supportsRequests()) {
            throw new SmaPermanentException(this.tracePrefix + "Max bind count check requested, but session doesn't support SEMP requests");
        }
        Rpc.Show showRequest = new Rpc.Show();
        Rpc.Show.Queue queueQuery = new Rpc.Show.Queue();
        queueQuery.setName(queueName);
        if (this.binding.vpnName() != null) {
            queueQuery.setVpnName(this.binding.vpnName());
        }
        showRequest.setQueue(queueQuery);
        RpcReply reply = this.sempShowRequest(showRequest, false);
        RpcReply.Rpc.Show.Queue queueResponse = reply.getRpc().getShow().getQueue();
        if (queueResponse != null && !queueResponse.getQueues().getQueue().isEmpty()) {
            long maxBindCountProvisioned = queueResponse.getQueues().getQueue().get(0).getInfo().getMaxBindCount();
            if (maxBindCountProvisioned != this.binding.enforceMaxBindCount()) {
                throw new SmaPermanentException(this.tracePrefix + "Provisioned max bind count of " + maxBindCountProvisioned + " for '" + queueName + "' does not match " + this.binding.enforceMaxBindCount());
            }
        } else {
            throw new SmaException(this.tracePrefix + "Max bind count check requested failed to retrieve queue details for '" + queueName + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateSubscription() throws SmaException {
        Set<String> guaranteedSubscriptionsFromAppliance = null;
        boolean guaranteedSubscriptionsQueriedFromAppliance = false;
        boolean checkApplianceSubscriptions = false;
        switch (this.binding.orphanSubscriptionCheckPolicy()) {
            case None: {
                break;
            }
            case Ignore: 
            case LogExceptionAndContinue: 
            case NoOrphan: 
            case Unsubscribe: {
                checkApplianceSubscriptions = true;
                break;
            }
            default: {
                throw new InternalError("unknown orphan check policy '" + (Object)((Object)this.binding.orphanSubscriptionCheckPolicy()) + "'");
            }
        }
        if (checkApplianceSubscriptions) {
            if (this.supportsRequests()) {
                this.tracer.log(this.tracePrefix + "Performing orphan subscription check (policy=" + (Object)((Object)this.binding.orphanSubscriptionCheckPolicy()) + ")", Tracer.Level.INFO);
                long ts = System.currentTimeMillis();
                try {
                    long ts1 = System.currentTimeMillis();
                    guaranteedSubscriptionsFromAppliance = this.getGuaranteedSubscriptions(this);
                    guaranteedSubscriptionsQueriedFromAppliance = true;
                    if (this.tracer.getLevel().val <= Tracer.Level.VERBOSE.val) {
                        this.tracer.log(this.tracePrefix + "Fetched " + guaranteedSubscriptionsFromAppliance.size() + " queue subscriptions in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts1), (TimeUnit)TimeUnit.MILLISECONDS) + ". Subscriptions: " + guaranteedSubscriptionsFromAppliance, Tracer.Level.INFO);
                    } else {
                        this.tracer.log(this.tracePrefix + "Fetched " + guaranteedSubscriptionsFromAppliance.size() + " queue subscriptions in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts1), (TimeUnit)TimeUnit.MILLISECONDS) + ".", Tracer.Level.INFO);
                    }
                }
                catch (SmaException e) {
                    throw new SmaException("Error fetching queue subscriptions: [" + e.getMessage() + "]", (Throwable)e);
                }
                if (guaranteedSubscriptionsQueriedFromAppliance) {
                    long ts2 = System.currentTimeMillis();
                    HashSet<String> orphanSubscriptions = new HashSet<String>();
                    orphanSubscriptions.addAll(guaranteedSubscriptionsFromAppliance);
                    for (String guaranteeedSubscription : this.guaranteedSubscriptions) {
                        orphanSubscriptions.remove(guaranteeedSubscription);
                    }
                    long orphanSubscriptionIdentifyTime = System.currentTimeMillis() - ts2;
                    long ts3 = System.currentTimeMillis();
                    if (!orphanSubscriptions.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.tracePrefix).append("Found ").append(orphanSubscriptions.size());
                        sb.append(" orphaned subscription").append(orphanSubscriptions.size() > 1 ? "s {" : " {");
                        int i = 1;
                        for (String orphan : orphanSubscriptions) {
                            sb.append("\n  Orphan Subscription #").append(i++).append(" :").append(orphan);
                        }
                        sb.append("\n}");
                        switch (this.binding.orphanSubscriptionCheckPolicy()) {
                            case None: {
                                this.tracer.log(sb.toString(), Tracer.Level.INFO);
                                break;
                            }
                            case Ignore: {
                                this.tracer.log(sb.toString(), Tracer.Level.INFO);
                                break;
                            }
                            case LogExceptionAndContinue: {
                                this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)((Object)new SolaceOrphanSubscriptionFoundSmaException(sb.toString()))) + "\n...logged exception and continuing", Tracer.Level.WARNING);
                                break;
                            }
                            case NoOrphan: {
                                this.tracer.log(sb.toString(), Tracer.Level.INFO);
                                throw new SolaceOrphanSubscriptionFoundSmaException(sb.toString());
                            }
                            case Unsubscribe: {
                                this.tracer.log(sb.toString(), Tracer.Level.INFO);
                                this.tracer.log(this.tracePrefix + "Unsubscribing the " + orphanSubscriptions.size() + " orphan subscriptions...", Tracer.Level.INFO);
                                XString topic = XString.create();
                                try {
                                    for (String subscription : orphanSubscriptions) {
                                        topic.setValue(subscription);
                                        this.session.removeSubscription(this.queue, topic);
                                    }
                                    this.tracer.log(this.tracePrefix + "Successfully completed the unsubscribe.", Tracer.Level.INFO);
                                    break;
                                }
                                finally {
                                    topic.clear(true);
                                }
                            }
                            default: {
                                throw new InternalError("unknown orphan check policy '" + (Object)((Object)this.binding.orphanSubscriptionCheckPolicy()) + "'");
                            }
                        }
                    } else {
                        this.tracer.log(this.tracePrefix + "No orphan subscriptions.", Tracer.Level.INFO);
                    }
                    long orphanSubscriptionActTime = System.currentTimeMillis() - ts3;
                    this.tracer.log(this.tracePrefix + "Performed orphan check on fetched subscriptions in " + UtlUnit.formatDuration((double)(orphanSubscriptionIdentifyTime + orphanSubscriptionActTime), (TimeUnit)TimeUnit.MILLISECONDS) + " (ident=" + UtlUnit.formatDuration((double)orphanSubscriptionIdentifyTime, (TimeUnit)TimeUnit.MILLISECONDS) + ", act=" + UtlUnit.formatDuration((double)orphanSubscriptionActTime, (TimeUnit)TimeUnit.MILLISECONDS) + ")", Tracer.Level.INFO);
                }
                this.tracer.log(this.tracePrefix + "Orphan subscription check completed in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts), (TimeUnit)TimeUnit.MILLISECONDS), Tracer.Level.INFO);
            } else {
                this.tracer.log(this.tracePrefix + "Orphan subscription check set to '" + (Object)((Object)this.binding.orphanSubscriptionCheckPolicy()) + " but semp requests are not supported", Tracer.Level.SEVERE);
            }
        }
        ISolContext context = this.binding.getSolaceContext();
        context.setGuaranteedSubscription(this.guaranteedSubscriptions);
        context.setGuaranteedSubscriptionsQueriedFromAppliance(guaranteedSubscriptionsQueriedFromAppliance);
        context.setGuaranteedSubscriptionsOnAppliance(guaranteedSubscriptionsFromAppliance);
        this.binding.getSubscriptionValidationHandler().validate(context);
    }

    private final Set<String> getGuaranteedSubscriptions(SolaceSession session) throws SmaException {
        if (!this.isConsumer) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Skipping subscription lookup (not a consumer session)", Tracer.Level.DEBUG);
            }
            return Collections.emptySet();
        }
        String queueName = this.binding.queueName();
        if (queueName == null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Skipping subscription lookup (no queue for session)", Tracer.Level.DEBUG);
            }
            return Collections.emptySet();
        }
        HashSet<String> rc = new HashSet<String>();
        this.tracer.log(this.tracePrefix + "Fetching guaranteed subscriptions on queue (using non-sequenced get)...", Tracer.Level.INFO);
        if (!this.getGuaranteedSubscriptionsNonSequencedGet(queueName, this.binding.vpnName(), rc)) {
            this.tracer.log(this.tracePrefix + "Too many subscriptions on queue to fit in a single response. Re-fetching subscriptions (using sequenced get)...", Tracer.Level.INFO);
            this.getGuaranteedSubscriptionsSequencedGet(queueName, this.binding.vpnName(), rc);
        }
        return rc;
    }

    private final boolean getGuaranteedSubscriptionsNonSequencedGet(String queueName, String vpnName, Set<String> rc) throws SmaException {
        Rpc.Show.Queue queueQuery = new Rpc.Show.Queue();
        queueQuery.setName(queueName);
        if (vpnName != null) {
            queueQuery.setVpnName(vpnName);
        }
        queueQuery.setSubscriptions(new KeywordType());
        Rpc.Show showRequest = new Rpc.Show();
        showRequest.setQueue(queueQuery);
        RpcReply reply = this.sempShowRequest(showRequest, true);
        if (reply.getLimitError() == null) {
            this.extractSubscriptionsFromSempShow(reply, queueName, rc);
            return true;
        }
        return false;
    }

    private final void getGuaranteedSubscriptionsSequencedGet(String queueName, String vpnName, Set<String> rc) throws SmaException {
        Rpc.Show.Queue queueQuery = new Rpc.Show.Queue();
        queueQuery.setName(queueName);
        if (vpnName != null) {
            queueQuery.setVpnName(vpnName);
        }
        queueQuery.setSubscriptions(new KeywordType());
        Rpc.Show showRequest = new Rpc.Show();
        showRequest.setQueue(queueQuery);
        long pageSize = this.binding.orphanSubscriptionCheckBatchSize();
        int nextIndex = -1;
        MoreCookie moreCookie = null;
        try {
            while (true) {
                RpcReply reply;
                queueQuery.setCount(new KeywordType());
                queueQuery.setNumElements(pageSize);
                if (moreCookie != null) {
                    queueQuery.setFollowing(new KeywordType());
                    queueQuery.setSubscriptionIndexParam(new BigInteger("" + nextIndex));
                    queueQuery.setQueueNameIndexParam(moreCookie.queueNameIndexParam());
                    queueQuery.setVpnIdIndexParam(moreCookie.vpnIdIndexParam());
                }
                if ((reply = this.sempShowRequest(showRequest, true)).getLimitError() == null) {
                    int fetched = this.extractSubscriptionsFromSempShow(reply, queueName, rc);
                    if ((long)fetched < pageSize) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Finished subscription sequenced get, fetched: " + rc.size(), Tracer.Level.DEBUG);
                        }
                        break;
                    }
                    nextIndex += fetched;
                    moreCookie = MoreCookie.valueOf(reply.getMoreCookie());
                    if (moreCookie != null) continue;
                    throw new SmaException("Failed to fetch subscriptions [malformed response - missing <more-cookie> element ");
                }
                if (pageSize == 1L) {
                    throw new SmaException("Failed to fetch subscriptions [received limit error on request with page size of 1]");
                }
                long oldPageSize = pageSize;
                pageSize = Math.max(1L, oldPageSize / 2L);
                if (!this.tracer.debug) continue;
                this.tracer.log(this.tracePrefix + "Failed to fetch subscriptions with page size of " + oldPageSize + ", retrying with a page size of " + pageSize, Tracer.Level.DEBUG);
            }
        }
        catch (SmaException thrown) {
            this.tracer.log(this.tracePrefix + "Error performing sequenced get for subscription on queue: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            throw thrown;
        }
    }

    private final int extractSubscriptionsFromSempShow(RpcReply reply, String queueName, Set<String> result) throws SmaException {
        int fetched = 0;
        try {
            RpcReply.Rpc.Show.Queue queueResponse = reply.getRpc().getShow().getQueue();
            if (queueResponse != null) {
                QueueType queue = null;
                RpcReply.Rpc.Show.Queue.Queues queues = queueResponse.getQueues();
                if (queues != null) {
                    for (QueueType candidate : queues.getQueue()) {
                        if (queueName.equals(candidate.getName())) {
                            queue = candidate;
                            break;
                        }
                        this.tracer.log(this.tracePrefix + "Found non matching queue '" + queueName + "'", Tracer.Level.WARNING);
                    }
                }
                if (queue == null) {
                    this.tracer.log(this.tracePrefix + "No queues found matching '" + queueName + "'", Tracer.Level.WARNING);
                } else {
                    long ts = System.currentTimeMillis();
                    QueueType.Subscriptions subscriptions = queue.getSubscriptions();
                    if (subscriptions == null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "No subscriptions found for '" + queueName + "'", Tracer.Level.DEBUG);
                        }
                    } else {
                        for (QueueType.Subscriptions.Subscription subscription : subscriptions.getSubscription()) {
                            if (this.tracer.debug) {
                                this.tracer.log(this.tracePrefix + "Got matching subscription for '" + queueName + "': '" + subscription.getTopic() + "'", Tracer.Level.DEBUG);
                            }
                            result.add(subscription.getTopic());
                            ++fetched;
                        }
                    }
                    this.tracer.log(this.tracePrefix + "Extracted " + fetched + " subscriptions from SEMP response in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts), (TimeUnit)TimeUnit.MILLISECONDS), Tracer.Level.INFO);
                }
            } else {
                this.tracer.log(this.tracePrefix + "No queues found matching '" + queueName + "'", Tracer.Level.WARNING);
            }
        }
        catch (Exception e) {
            throw new SmaException("Error reading SEMP show subscriptions reply: " + e.getMessage(), (Throwable)e);
        }
        return fetched;
    }

    private final RpcReply sempShowRequest(Rpc.Show showRequest, boolean traceResponseTime) throws SmaException {
        Rpc request = new Rpc();
        request.setShow(showRequest);
        XString showTopic = XString.create((int)256);
        showTopic.setValue("#SEMP/" + this.session.getRouterName() + "/SHOW");
        long ts = traceResponseTime ? System.currentTimeMillis() : 0L;
        RpcReply reply = this.sempRpcRequest(request, showTopic, true);
        if (traceResponseTime) {
            this.tracer.log(this.tracePrefix + "Received SEMP response in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts), (TimeUnit)TimeUnit.MILLISECONDS), Tracer.Level.INFO);
        }
        return reply;
    }

    private final RpcReply sempRpcRequest(Rpc request, XString topic, boolean allowRetries) throws SmaException {
        request.setSempVersion(this.binding.sempVersion());
        byte[] requestBytes = null;
        StringWriter writer = new StringWriter();
        try {
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.marshal((Object)request, (Writer)writer);
            requestBytes = writer.toString().getBytes("us-ascii");
        }
        catch (Exception e) {
            throw new SmaException("Error marshalling SEMP request: " + e.getMessage(), (Throwable)e);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Issuing SEMP request on '" + topic + "':\n" + writer.toString(), Tracer.Level.DEBUG);
        }
        byte[] response = this.request(topic, requestBytes, this.binding.sempRequestTimeout());
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received SEMP reply:\n" + new String(response), Tracer.Level.DEBUG);
        }
        RpcReply reply = null;
        try {
            reply = (RpcReply)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response));
        }
        catch (Exception e) {
            throw new SmaException("Error unmarshalling SEMP reply: " + e.getMessage() + "\nRequest was:\n" + writer.toString() + "\n\nResponse was:\n" + new String(response), (Throwable)e);
        }
        if (reply.getPermissionError() != null) {
            throw new SmaException("Permission error executing SEMP request: " + reply.getPermissionError() + "\nRequest was:\n" + writer.toString() + "\n\nResponse was:\n" + new String(response));
        }
        if (reply.getParseError() != null && reply.getSempVersion() != null && !reply.getSempVersion().equals(request.getSempVersion())) {
            this.tracer.log("SEMP Request replied with version mismatch - sent version '" + request.getSempVersion() + "', response version '" + reply.getSempVersion() + "' ... retrying.", Tracer.Level.INFO);
            this.binding.setSempVersion(reply.getSempVersion());
            if (allowRetries) {
                return this.sempRpcRequest(request, topic, false);
            }
        }
        if (reply.getParseError() != null) {
            throw new SmaException("SEMP lookup request error: '" + reply.getParseError() + "':\n" + new String(response));
        }
        if (reply.getExecuteResult() == null) {
            if (reply.getLimitError() != null) {
                return reply;
            }
            throw new SmaException("Missing execution result for SEMP subscription lookup:\n" + new String(response));
        }
        if (!"ok".equals(reply.getExecuteResult().getCode())) {
            throw new SmaException("Unexpected execution result (" + reply.getExecuteResult().getCode() + ") for SEMP subscription lookup:\n" + new String(response));
        }
        return reply;
    }

    private final void killSenderThread() {
        this.senderThread.stop((Throwable)((Object)new ESolException(51, "Triggering send failure in  [" + this.senderThread.getName() + "] detached sender thread")));
    }

    final void open() throws SmaException {
        String host = this.binding.getAddress();
        if (this.tracer.debug) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] HOST=" + host, Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Opening...", Tracer.Level.DEBUG);
        }
        boolean opened = false;
        int retriesAttempted = 0;
        block9: do {
            try {
                Properties props = this.getSessionProperties(this.providerProps);
                if (this.tracer.debug) {
                    this.tracer.log("Session properties...", Tracer.Level.DEBUG);
                    Enumeration<?> enumeration = props.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String key = (String)enumeration.nextElement();
                        String val = props.getProperty(key);
                        this.tracer.log("..." + key + "=" + val, Tracer.Level.DEBUG);
                    }
                }
                this.session = SolFactory.onlyInstance().createSession(host, this.userName, props, this.solxfProperties);
                if (this.tracer.debug) {
                    this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...connecting...", Tracer.Level.DEBUG);
                }
                this.session.connect();
                if (this.isConsumer) {
                    if (this.session.isCapable(ISolSession.CapabilityType.QUEUE_SUBSCRIPTIONS)) {
                        String queueName = this.binding.queueName();
                        if (queueName != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...getting queue '" + queueName + "'...", Tracer.Level.DEBUG);
                            }
                            this.queue = SolFactory.onlyInstance().createQueue(this.session, queueName);
                            if (this.binding.isProvisionQueue()) {
                                if (this.session.isCapable(ISolSession.CapabilityType.ENDPOINT_MANAGEMENT)) {
                                    if (this.tracer.debug) {
                                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...provisioning the queue...", Tracer.Level.DEBUG);
                                    }
                                    try {
                                        ISolSession.EndpointProperties ep = new ISolSession.EndpointProperties();
                                        ep.setPermission(ISolSession.EndpointProperties.PERMISSION_CONSUME);
                                        ep.setPermission(ISolSession.EndpointProperties.PERMISSION_DELETE);
                                        ep.setAccessType(ISolSession.EndpointProperties.ACCESSTYPE_EXCLUSIVE);
                                        ep.setQuota(this.binding.queueQuota());
                                        ep.setRespectsMsgTTL(false);
                                        this.session.provision(this.queue, ep);
                                    }
                                    catch (Exception e) {
                                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Failed to provision queue '" + queueName + "' [" + e.toString() + "]. Assuming queue is already provisioned.", Tracer.Level.WARNING);
                                    }
                                } else {
                                    this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] The solace session does not have endpoint management capability. Assuming queue '" + queueName + "' is already provisioned.", Tracer.Level.WARNING);
                                }
                            } else if (this.tracer.fine) {
                                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] queue name supplied, but queue provisioning is disabled ... Assuming queue '" + queueName + "' is already provisioned.", Tracer.Level.FINE);
                            }
                            if (this.tracer.debug) {
                                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...creating queue flow...", Tracer.Level.DEBUG);
                            }
                            this.flowReceiver = this.session.createFlow(this.queue, this.handler, this.getFlowProperties(this.providerProps));
                        } else if (this.tracer.fine) {
                            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] No queue name supplied. Guaranteed message receipt is disabled.", Tracer.Level.FINE);
                        }
                    } else if (this.tracer.fine) {
                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] The solace session does not have the capability to add subscription to queue. Guaranteed message receipt is disabled.", Tracer.Level.FINE);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...creating consumer...", Tracer.Level.DEBUG);
                    }
                    this.consumer = this.session.createMessageConsumer(this.handler);
                }
                if (this.isProducer) {
                    if (this.tracer.debug) {
                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...creating producer...", Tracer.Level.DEBUG);
                    }
                    this.producer = this.session.createMessageProducer(this.handler);
                    if (this.binding.detachedSends()) {
                        if (this.tracer.debug) {
                            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...starting detached sender...", Tracer.Level.DEBUG);
                        }
                        this.disruptor.start();
                    }
                } else if (this.binding.enableSempRequests()) {
                    if (this.tracer.debug) {
                        this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ...creating SEMP request producer...", Tracer.Level.DEBUG);
                    }
                    this.producer = this.session.createMessageProducer(this.handler);
                }
                opened = true;
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (this.session != null && e instanceof ESolException) {
                    switch (((ESolException)((Object)e)).errorCode()) {
                        case 2: 
                        case 5: 
                        case 12: 
                        case 19: 
                        case 25: 
                        case 37: 
                        case 40: {
                            break;
                        }
                        default: {
                            if (++retriesAttempted > this.sessionOpenRetryLimit) break;
                            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Solace connection failed due to  " + msg + ", Retrying in " + this.sessionOpenRetryInterval + "s ...", Tracer.Level.WARNING);
                            try {
                                this.close();
                                Thread.sleep(this.sessionOpenRetryInterval * 1000);
                                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Solace binding connect retry attempt ... " + retriesAttempted + " of " + this.sessionOpenRetryLimit, Tracer.Level.INFO);
                                continue block9;
                            }
                            catch (InterruptedException ignore) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                    }
                }
                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Failed in establishing connection to Solace with error code " + msg, Tracer.Level.SEVERE);
                this.close();
                if (e instanceof SmaPermanentException) {
                    throw (SmaPermanentException)((Object)e);
                }
                if (e instanceof SmaException) {
                    throw (SmaException)((Object)e);
                }
                throw new SmaException((Throwable)e);
            }
        } while (!opened);
    }

    final boolean isStarted() {
        return this.started;
    }

    final void start() throws SmaException {
        if (this.isConsumer) {
            if (this.tracer.debug) {
                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Starting consumers...", Tracer.Level.DEBUG);
            }
            this.consumer.start();
            if (this.binding.sleepBeforeSempChecksMillis() > 0L) {
                try {
                    this.tracer.log("Sleeping for " + UtlUnit.formatDuration((double)this.binding.sleepBeforeSempChecksMillis(), (TimeUnit)TimeUnit.MILLISECONDS) + " prior to session start SEMP checks", Tracer.Level.WARNING);
                    Thread.sleep(this.binding.sleepBeforeSempChecksMillis());
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new SmaPermanentException((Throwable)e1);
                }
            }
            this.validateMaxBindCount();
            try {
                this.validateSubscription();
            }
            catch (SolaceOrphanSubscriptionFoundSmaException e) {
                throw new SmaException(e.getMessage(), (Throwable)((Object)e));
            }
            this.started = true;
            if (this.flowReceiver != null) {
                this.flowReceiver.start();
            }
        }
    }

    final void subscribe(SolaceMessageChannel channel, XString topic) throws SmaException {
        if (this.isConsumer) {
            if (this.tracer.verbose) {
                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Subscribing to topic '" + topic + "' [channel=" + channel.getName() + "]", Tracer.Level.VERBOSE);
            }
            if (this.queue != null) {
                this.unsubscribeGuaranteed(channel, topic);
            }
        } else {
            throw new IllegalStateException("request to subscribe to topic '" + topic + "' [channel=" + channel.getName() + "] on a session not marked for consumption");
        }
        this.session.addSubscription(topic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void subscribeGuaranteed(SolaceMessageChannel channel, XString topic) throws SmaException {
        if (!this.isConsumer) throw new IllegalStateException("request to subscribe (guaranteed) to topic '" + topic + "' [channel=" + channel.getName() + "] on a session not marked for consumption");
        if (this.queue == null) throw new IllegalStateException("request to subscribe (guaranteed) to topic '" + topic + "' [channel=" + channel.getName() + "] on a session not enabled for guaranteed receipt (no queue_name supplied)");
        if (this.tracer.verbose) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Subscribing (guaranteed) to topic '" + topic + "' [channel=" + channel.getName() + "]", Tracer.Level.VERBOSE);
        }
        this.session.addSubscription(this.queue, topic);
        this.guaranteedSubscriptions.add(topic.getValue());
    }

    final void unsubscribe(SolaceMessageChannel channel, XString topic) throws SmaException {
        if (this.isConsumer) {
            if (this.tracer.verbose) {
                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Unsubscribing from topic '" + topic + "' [channel=" + channel.getName() + "]", Tracer.Level.VERBOSE);
            }
            if (this.queue != null) {
                this.unsubscribeGuaranteed(channel, topic);
            }
        } else {
            throw new IllegalStateException("request to unsubscribe to topic '" + topic + "' [channel=" + channel.getName() + "] on a session not marked for consumption");
        }
        this.session.removeSubscription(topic);
        this.guaranteedSubscriptions.remove(topic.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void unsubscribeGuaranteed(SolaceMessageChannel channel, XString topic) throws SmaException {
        if (!this.isConsumer) throw new IllegalStateException("request to unsubscribe (guaranteed) to topic '" + topic + "' [channel=" + channel.getName() + "] on a session not marked for consumption");
        if (this.queue == null) throw new IllegalStateException("request to unsubscribe (guaranteed) to topic '" + topic + "' [channel=" + channel.getName() + "] on a session not enabled for guaranteed receipt (no queue_name supplied)");
        if (this.tracer.verbose) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] Unsubscribing (guaranteed) from topic '" + topic + "' [channel=" + channel.getName() + "]", Tracer.Level.VERBOSE);
        }
        this.session.removeSubscription(this.queue, topic);
    }

    final void ack(long messageId) {
        if (this.tracer.debug) {
            this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] ACK, messageId=" + messageId, Tracer.Level.DEBUG);
        }
        if (null == this.flowReceiver) {
            if (this.tracer.debug) {
                this.tracer.log("[SolaceSession," + this.descriptor.getName() + "," + this.type + "] FlowReceiver is 'null', message must be received on a channel which is non-guaranteed, cannot ack this message ..", Tracer.Level.DEBUG);
            }
        } else {
            this.flowReceiver.ack(messageId);
        }
    }

    final void send(SolaceMessageChannel sender, MessageView view, IOBuffer serializedMessage, int serializedMessageOffset, int serializedMessageLength, IOBuffer serializedMetadata, int serializedMetadataOffset, int serializedMetadataLength, XString topic, MessageChannel.Qos qos, int flags) throws SmaException {
        if (this.isProducer) {
            if (this.binding.detachedSends()) {
                if (this.tracer.debug && this.binding.isFailOnNextSend()) {
                    this.tracer.log("===== Triggering send failure in  [" + this.senderThread.getName() + "] detached sender thread", Tracer.Level.DEBUG);
                    this.killSenderThread();
                }
                this.enqueForDetachedSend(sender, view, serializedMessage, serializedMessageOffset, serializedMessageLength, serializedMetadata, serializedMetadataOffset, serializedMetadataLength, topic, qos, flags);
            } else {
                if (this.tracer.debug && this.binding.isFailOnNextSend()) {
                    this.tracer.log("===== Triggering send failure in  [" + Thread.currentThread().getName() + "] thread", Tracer.Level.DEBUG);
                    throw new ESolException(51, "Triggering send failure in [" + Thread.currentThread().getName() + "] thread");
                }
                this.sendCore(sender, view, serializedMessage, serializedMessageOffset, serializedMessageLength, serializedMetadata, serializedMetadataOffset, serializedMetadataLength, topic, qos, flags);
            }
        } else {
            throw new IllegalStateException("request to send on a session not marked for production");
        }
    }

    final void getStats(StringBuilder buffer) {
        this.session.getStats(this.userName, this.isProducer, buffer);
    }

    final void close() {
        long slot;
        if (this.disruptor != null) {
            this.disruptor.halt();
        }
        if (this.senderThread != null) {
            int attempts = 0;
            while (++attempts <= 5 && this.senderThread.isAlive()) {
                try {
                    if (this.disruptor != null) {
                        this.disruptor.halt();
                    }
                    this.senderThread.join(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            UtlThread.deregister((Thread)this.senderThread);
            this.senderThread = null;
        }
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
        if (this.flowReceiver != null) {
            this.flowReceiver.stop();
            this.flowReceiver.close();
            this.flowReceiver = null;
        }
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if ((slot = this.sendContexts.nextRead()) >= 0L) {
            this.sendContexts.read(slot);
        }
    }

    final String getClientName() throws SmaException {
        return this.getClientName(this.isConsumer);
    }

    public final String getVersion() {
        return this.session.getVersion();
    }

    final String getRouterName() throws SmaException {
        return this.session.getRouterName();
    }

    final boolean supportsRequests() {
        return this.binding.enableSempRequests() && this.isConsumer && this.producer != null && this.producer.supportsRequests();
    }

    final byte[] request(XString requestTopic, byte[] requestContent, long timeoutMillis) throws SmaException {
        if (!this.supportsRequests()) {
            throw new SmaException("Cannot send request to '" + requestTopic + "' ... session doesn't support requests");
        }
        return this.producer.request(requestTopic, requestContent, timeoutMillis);
    }

    private final class SolaceEventHandler
    implements ISolMessageListener,
    ISolPublishEventHandler {
        private SolaceEventHandler() {
        }

        private final void checkAndInitializeConsumerThreadNameAndAffinity() {
            if (!SolaceSession.this.consumerThreadInitialized) {
                if (sessionDispatchThreadNames.get() == null) {
                    if (SolaceSession.this.isConsumer) {
                        if (SolaceSession.this.isProducer) {
                            sessionDispatchThreadNames.set(Thread.currentThread().getName() + "[X-SMA-" + SolaceSession.this.descriptor.getName() + "]");
                        } else {
                            sessionDispatchThreadNames.set(Thread.currentThread().getName() + "[X-SMA-" + SolaceSession.this.descriptor.getName() + "-IN]");
                        }
                        Thread.currentThread().setName((String)sessionDispatchThreadNames.get());
                        UtlThread.setCPUAffinityMask((long)SolaceSession.this.binding.getConsumerSessionCpuAffinityMask());
                    } else {
                        sessionDispatchThreadNames.set(Thread.currentThread().getName() + "[X-SMA-" + SolaceSession.this.descriptor.getName() + "-OUT]");
                        Thread.currentThread().setName((String)sessionDispatchThreadNames.get());
                        UtlThread.setCPUAffinityMask((long)SolaceSession.this.binding.getProducerSessionCpuAffinityMask());
                    }
                } else {
                    SolaceSession.this.consumerThreadInitialized = true;
                }
            }
        }

        private final void checkAndInitializeProducerThreadNameAndAffinity() {
            if (!SolaceSession.this.producerThreadInitialized) {
                if (sessionDispatchThreadNames.get() == null) {
                    if (SolaceSession.this.isConsumer) {
                        if (SolaceSession.this.isProducer) {
                            sessionDispatchThreadNames.set(Thread.currentThread().getName() + "[X-SMA-" + SolaceSession.this.descriptor.getName() + "]");
                        } else {
                            sessionDispatchThreadNames.set(Thread.currentThread().getName() + "[X-SMA-" + SolaceSession.this.descriptor.getName() + "-IN]");
                        }
                        Thread.currentThread().setName((String)sessionDispatchThreadNames.get());
                        UtlThread.setCPUAffinityMask((long)SolaceSession.this.binding.getConsumerSessionCpuAffinityMask());
                    } else {
                        sessionDispatchThreadNames.set(Thread.currentThread().getName() + "[X-SMA-" + SolaceSession.this.descriptor.getName() + "-OUT]");
                        Thread.currentThread().setName((String)sessionDispatchThreadNames.get());
                        UtlThread.setCPUAffinityMask((long)SolaceSession.this.binding.getProducerSessionCpuAffinityMask());
                    }
                } else {
                    SolaceSession.this.producerThreadInitialized = true;
                }
            }
        }

        @Override
        public final void onMessage(long messageId, long serializedMessage, int serializedMessageLength, long serializedMetadata, int serializedMetadataLength, long serializedUserdata, int serializedUserdataLength, XString topic, boolean ackRequired, long postWireTs) {
            if (SolaceSession.this.binding.rawMode() || serializedMetadata != 0L) {
                try {
                    this.checkAndInitializeConsumerThreadNameAndAffinity();
                    if (((SolaceSession)SolaceSession.this).tracer.debug) {
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Received a message, messageId=" + messageId + ", destinationName=" + topic.getValue() + ", ackRequired=" + ackRequired, Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] ...serializedMessage=" + serializedMessage + " (len=" + serializedMessageLength + ")", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] --------------------------------------------------", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "]" + IOBuffer.dump((long)serializedMessage, (int)0, (int)serializedMessageLength), Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] --------------------------------------------------", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] ...serializedMetadata=" + serializedMetadata + " (len=" + serializedMetadataLength + ")", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] --------------------------------------------------", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "]" + IOBuffer.dump((long)serializedMetadata, (int)0, (int)serializedMetadataLength), Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] --------------------------------------------------", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] ...serializedUserdata=" + serializedUserdata + " (len=" + serializedUserdataLength + ")", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] --------------------------------------------------", Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "]" + IOBuffer.dump((long)serializedUserdata, (int)0, (int)serializedUserdataLength), Tracer.Level.DEBUG);
                        SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] --------------------------------------------------", Tracer.Level.DEBUG);
                    }
                    SolaceSession.this.binding.onMessage(messageId, serializedMessage, serializedMessageLength, serializedMetadata, serializedMetadataLength, serializedUserdata, serializedUserdataLength, topic, ackRequired, postWireTs);
                }
                catch (Throwable e) {
                    SolaceSession.this.binding.onInboundMessageHandlingFault(messageId, topic, serializedMessage, serializedMessageLength, serializedMetadata, serializedMetadataLength, (Exception)((Object)new SmaException(e.getMessage(), e)));
                }
            } else {
                String error = "Inbound message is corrupt [no SMA metadata in message]";
                try {
                    this.onCorruptMessage(messageId, topic, serializedMessage, serializedMessageLength, serializedMetadata, serializedMetadataLength, new RuntimeException("Inbound message is corrupt [no SMA metadata in message]"));
                }
                catch (Throwable thrown) {
                    SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                }
            }
        }

        @Override
        public final void onCorruptMessage(long messageId, XString topic, long serializedMessage, int serializedMessageLength, long serializedMetadata, int serializedMetadataLength, Exception status) {
            if (SolaceSession.this.treatNonXInboundMessagesAsFault || serializedMetadata != 0L) {
                if (((SolaceSession)SolaceSession.this).tracer.debug) {
                    SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Received corrupted mesage (messageId=" + messageId + ")", Tracer.Level.DEBUG);
                    SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] ...serializedMessage  [" + serializedMessage + ", " + serializedMessageLength + "]", Tracer.Level.DEBUG);
                    SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] ...serializedMetadata [" + serializedMetadata + ", " + serializedMetadataLength + "]", Tracer.Level.DEBUG);
                }
                SolaceSession.this.binding.onInboundMessageHandlingFault(messageId, topic, serializedMessage, serializedMessageLength, serializedMetadata, serializedMetadataLength, status);
            } else {
                SolaceSession.this.binding.onNonXMessage(messageId, serializedMessage, serializedMessageLength, topic);
            }
        }

        @Override
        public final void onSessionReconnecting() {
            SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Session is reconnecting...", Tracer.Level.WARNING);
            SolaceSession.this.binding.onSessionReconnecting();
            SolaceSession.this.consumerThreadInitialized = false;
        }

        @Override
        public final void onSessionReconnected() {
            SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Session has reconnected...", Tracer.Level.WARNING);
            SolaceSession.this.binding.onSessionReconnected();
        }

        @Override
        public final void onSessionFailed(Exception cause) {
            SolaceSession.this.tracer.log("[SolaceSession," + SolaceSession.this.descriptor.getName() + "," + SolaceSession.this.type + "] Session has failed '" + cause + "'", Tracer.Level.SEVERE);
            SolaceSession.this.binding.onSessionFail(cause);
            SolaceSession.this.consumerThreadInitialized = false;
        }

        @Override
        public final void onAck(long key) {
            this.checkAndInitializeProducerThreadNameAndAffinity();
            SolaceSession.this.onAckNack(key, null);
        }

        @Override
        public final void onNack(long key, Exception cause) {
            this.checkAndInitializeProducerThreadNameAndAffinity();
            SolaceSession.this.onAckNack(key, cause);
        }
    }

    private final class SenderThreadFactory
    implements ThreadFactory {
        private SenderThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            return SolaceSession.this.senderThread = new SenderThread("X-SMA-Solace-Sender-" + SolaceSession.this.binding.getName(), r);
        }
    }

    private final class SenderThread
    extends Thread {
        private final Runnable r;

        SenderThread(String name, Runnable r) {
            this.setDaemon(true);
            this.setName(name);
            this.setUncaughtExceptionHandler(SolaceSession.this.sendThreadExceptionHandler);
            this.r = r;
        }

        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)SolaceSession.this.binding.getDetachedSendsCpuAffinityMask());
            this.r.run();
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        private CarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                SolaceSession.this.sendCore(event.sender, event.view, event.serializedMessage, event.serializedMessageOffset, event.serializedMessageLength, event.serializedMetadataLength > 0 ? event.serializedMetadata : null, event.serializedMetadataOffset, event.serializedMetadataLength, event.topic, event.qos, event.flags);
            }
            finally {
                event.view.dispose();
                if (Config.conserveMemory()) {
                    event.serializedMessage.dispose();
                    event.serializedMessage = null;
                    if (event.serializedMetadata != null) {
                        event.serializedMetadata.dispose();
                        event.serializedMetadata = null;
                    }
                }
            }
        }
    }

    private final class CarrierEventFactory
    implements EventFactory<CarrierEvent> {
        private CarrierEventFactory() {
        }

        public final CarrierEvent newInstance() {
            return new CarrierEvent();
        }
    }

    public final class CarrierEvent {
        SolaceMessageChannel sender;
        MessageView view;
        IOBuffer serializedMessage;
        int serializedMessageOffset;
        int serializedMessageLength;
        IOBuffer serializedMetadata;
        int serializedMetadataOffset;
        int serializedMetadataLength;
        XString topic = XString.create((int)256);
        MessageChannel.Qos qos;
        int flags;
    }

    private static final class MoreCookie {
        private final String _queueNameIndexParam;
        private final long _vpnIdIndexParam;

        private MoreCookie(RpcReply.MoreCookie moreCookie) throws SmaException {
            Element rpcElement = moreCookie.getAny();
            if (!rpcElement.getTagName().equals("rpc")) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - missing <more-cookie>/<rpc> element");
            }
            NodeList showNodes = rpcElement.getElementsByTagName("show");
            if (showNodes == null || showNodes.getLength() == 0) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - missing <more-cookie>/<rpc>/<show> element ");
            }
            Node showNode = showNodes.item(0);
            Node queueNode = null;
            NodeList showChildNodes = showNode.getChildNodes();
            for (int i = 0; i < showChildNodes.getLength(); ++i) {
                Node node = showChildNodes.item(i);
                if (node.getNodeName() == null || !node.getNodeName().equalsIgnoreCase("queue")) continue;
                queueNode = node;
                break;
            }
            if (queueNode == null) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - missing <more-cookie>/<rpc>/<show>/<queue> element ");
            }
            Node queueNameIndexParamNode = null;
            Node vpnIdIndexParamNode = null;
            NodeList queueChildNodes = queueNode.getChildNodes();
            for (int i = 0; i < queueChildNodes.getLength(); ++i) {
                Node node = queueChildNodes.item(i);
                if (node.getNodeName() != null && node.getNodeName().equalsIgnoreCase("queue-name-index-param")) {
                    queueNameIndexParamNode = node;
                    continue;
                }
                if (node.getNodeName() == null || !node.getNodeName().equalsIgnoreCase("vpn-id-index-param")) continue;
                vpnIdIndexParamNode = node;
            }
            if (queueNameIndexParamNode == null) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - missing <more-cookie>/<rpc>/<show>/<queue>/<queue-name-index-param> element ");
            }
            NodeList childNodes = queueNameIndexParamNode.getChildNodes();
            String queueNameIndexParam = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeName() == null || !node.getNodeName().equalsIgnoreCase("#text")) continue;
                queueNameIndexParam = node.getNodeValue();
                break;
            }
            if (queueNameIndexParam == null) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - no value in <more-cookie>/<rpc>/<show>/<queue>/<queue-name-index-param> element ");
            }
            if (vpnIdIndexParamNode == null) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - missing <more-cookie>/<rpc>/<show>/<queue>/<vpn-id-index-param> element ");
            }
            childNodes = vpnIdIndexParamNode.getChildNodes();
            Long vpnIdIndexParam = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeName() == null || !node.getNodeName().equalsIgnoreCase("#text")) continue;
                vpnIdIndexParam = Long.valueOf(node.getNodeValue());
                break;
            }
            if (vpnIdIndexParam == null) {
                throw new SmaException("Failed to fetch subscriptions [malformed response - no value in <more-cookie>/<rpc>/<show>/<queue>/<vpn-id-index-param> element ");
            }
            this._queueNameIndexParam = queueNameIndexParam;
            this._vpnIdIndexParam = vpnIdIndexParam;
        }

        static final MoreCookie valueOf(RpcReply.MoreCookie moreCookie) throws SmaException {
            if (moreCookie == null) {
                return null;
            }
            return new MoreCookie(moreCookie);
        }

        final String queueNameIndexParam() {
            return this._queueNameIndexParam;
        }

        final long vpnIdIndexParam() {
            return this._vpnIdIndexParam;
        }
    }

    private final class OutstandingSendContext {
        long id;
        SolaceMessageChannel sender;
        MessageView view;
        boolean acked;

        OutstandingSendContext() {
        }

        final OutstandingSendContext init(long id, SolaceMessageChannel sender, MessageView view) {
            this.id = id;
            this.sender = sender;
            this.view = view;
            this.acked = false;
            return this;
        }
    }

    private final class OutstandingSendContextFactory
    implements UtlConcurrentRingBuffer.ItemFactory<OutstandingSendContext> {
        private OutstandingSendContextFactory() {
        }

        public OutstandingSendContext createItem() {
            return new OutstandingSendContext();
        }

        public OutstandingSendContext[] createItemArray(int size) {
            return new OutstandingSendContext[size];
        }
    }
}

