/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.link.ELnkAlreadyPresentException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkRegistry;
import com.neeve.link.LnkSTRContainer;
import com.neeve.server.app.SrvAppManager;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.link.ESrvLinkException;
import com.neeve.server.link.ISrvLinkHandshakeCompletionHandler;
import com.neeve.server.link.SrvLink;
import com.neeve.server.link.SrvLinkAcceptor;
import com.neeve.server.link.SrvLinkClient;
import com.neeve.server.link.SrvLinkClientCollection;
import com.neeve.server.link.SrvLinkConfig;
import com.neeve.server.link.SrvLinkHandshakeFailureCompletionData;
import com.neeve.server.link.SrvLinkHandshakeSuccessCompletionData;
import com.neeve.server.link.SrvLinkHandshaker;
import com.neeve.server.link.SrvLinkObject;
import com.neeve.server.link.SrvLinkSmaMessageChannel;
import com.neeve.server.link.SrvLinkSmaProvider;
import com.neeve.server.thread.ISrvThreadAssignCompletionHandler;
import com.neeve.server.thread.SrvThreadAssignFailureCompletionData;
import com.neeve.server.thread.SrvThreadAssignSuccessCompletionData;
import com.neeve.server.thread.SrvThreadManager;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlStr;
import com.neeve.util.UtlThrowable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public final class SrvLinkInboundManager
extends SrvLinkObject {
    private final SrvConfigDescriptor configDescriptor;
    private final SrvThreadManager threadManager;
    private final SrvAppManager appManager;
    private final SrvLinkClientCollection clients;
    private final ClientHandshakeStartEventHandler clientHandshakeStartEventHandler;
    private final ClientHandshakeCompleteEventHandler clientHandshakeCompleteEventHandler;
    private final ClientLinkAssignCompleteEventHandler clientLinkAssignCompleteEventHandler;
    private final XLinkedHashMap<UtlAddressDescriptor, SrvLinkAcceptor> acceptors;
    private final XLinkedHashMap<IEmxDispatcher, STRContainer> containers;
    private static final long ACCEPTOR_STOP_WAIT_TIME = 30000L;

    private SrvLinkInboundManager(SrvConfigDescriptor configDescriptor, SrvThreadManager threadManager, SrvAppManager appManager) {
        this.configDescriptor = configDescriptor;
        this.threadManager = threadManager;
        this.appManager = appManager;
        this.clients = new SrvLinkClientCollection();
        this.clientHandshakeStartEventHandler = new ClientHandshakeStartEventHandler();
        this.clientHandshakeCompleteEventHandler = new ClientHandshakeCompleteEventHandler();
        this.clientLinkAssignCompleteEventHandler = new ClientLinkAssignCompleteEventHandler();
        this.acceptors = new XLinkedHashMap();
        this.containers = new XLinkedHashMap();
    }

    public static final SrvLinkInboundManager create(SrvConfigDescriptor configDescriptor, SrvThreadManager threadManager, SrvAppManager appManager) {
        return new SrvLinkInboundManager(configDescriptor, threadManager, appManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final STRContainer getContainer(IEmxDispatcher dispatcher) {
        XLinkedHashMap<IEmxDispatcher, STRContainer> xLinkedHashMap = this.containers;
        synchronized (xLinkedHashMap) {
            STRContainer container = (STRContainer)((Object)this.containers.get((Object)dispatcher));
            String containerName = dispatcher.getName();
            if (container == null) {
                try {
                    container = new STRContainer(containerName, dispatcher);
                }
                catch (ELnkAlreadyPresentException e) {
                    throw new InternalError("An inbound link container of name='" + containerName + "' is reportedly already present in the registry!");
                }
                this.containers.put((Object)dispatcher, (Object)container);
            }
            return container;
        }
    }

    private final UtlAddressDescriptor prepareDescriptorForAcceptor(String descriptorStr) {
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse((String)descriptorStr, null);
        descriptor.props.put("maxusers", "1");
        descriptor.props.put("threadingmodel", "strmtw");
        descriptor.props.remove("container");
        descriptor.props.remove("private");
        return descriptor;
    }

    private final void startClientAcceptor(IEmxDispatcher dispatcher, UtlAddressDescriptor descriptor) {
        try {
            if (dispatcher.getOwner() == Thread.currentThread()) {
                if (this.tracer.debug) {
                    this.tracer.log("Starting client acceptor [" + descriptor + "].", Tracer.Level.DEBUG);
                }
            } else {
                if (this.tracer.debug) {
                    this.tracer.log("Scheduling start for client acceptor [" + descriptor + "].", Tracer.Level.DEBUG);
                }
                throw new IllegalStateException("Running cient acceptor in non-admin thread is not supported");
            }
            SrvLinkAcceptor acceptor = new SrvLinkAcceptor(descriptor, new ClientAcceptorEventHandler(descriptor));
            acceptor.start(dispatcher);
            this.acceptors.put((Object)descriptor, (Object)acceptor);
            this.tracer.log("Client acceptor [" + descriptor + "] successfully started.", Tracer.Level.INFO);
        }
        catch (Exception e) {
            this.tracer.log("Failed to start client acceptor [" + descriptor + "] [" + e.toString() + "]", Tracer.Level.WARNING);
        }
    }

    private final UtlAddressDescriptor startClientAcceptor(String descriptorStr) {
        try {
            UtlAddressDescriptor descriptor = this.prepareDescriptorForAcceptor(descriptorStr);
            this.startClientAcceptor(this.threadManager.getThreadForAcceptor(descriptor), descriptor);
            return descriptor;
        }
        catch (Exception e) {
            this.tracer.log("Failed to start client acceptor [" + descriptorStr + "] [" + e.toString() + "]", Tracer.Level.WARNING);
            return null;
        }
    }

    private final void onClientLinkAccept(IEmxDispatcher dispatcher, ILnkPeerEndpoint pep, UtlAddressDescriptor descriptor, int sno) {
        SrvLink link = new SrvLink(pep, descriptor, sno);
        this.tracer.log("A new link " + (Object)((Object)link) + " was successfully accepted (threading model=" + pep.getRootEndpoint().getThreadingModel() + ").", Tracer.Level.INFO);
        IEmxUserEvent userEvent = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.clientHandshakeStartEventHandler).setAttachment((Object)link);
        this.threadManager.getThreadForHandshake(descriptor).schedUserEv(userEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onClientAcceptorStop(UtlAddressDescriptor descriptor) {
        this.tracer.log("Client acceptor [" + descriptor + "] stopped succesfully.", Tracer.Level.INFO);
        XLinkedHashMap<UtlAddressDescriptor, SrvLinkAcceptor> xLinkedHashMap = this.acceptors;
        synchronized (xLinkedHashMap) {
            this.acceptors.remove((Object)descriptor);
            this.acceptors.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onClientAcceptorFail(UtlAddressDescriptor descriptor, Exception e) {
        this.tracer.log("Client acceptor [" + descriptor + "] has failed [" + e.toString() + "].", Tracer.Level.WARNING);
        XLinkedHashMap<UtlAddressDescriptor, SrvLinkAcceptor> xLinkedHashMap = this.acceptors;
        synchronized (xLinkedHashMap) {
            this.acceptors.remove((Object)descriptor);
            this.acceptors.notifyAll();
        }
    }

    private final void onClientHandshakeStart(IEmxDispatcher dispatcher, SrvLink link) {
        try {
            this.tracer.log("Handing accepted link " + (Object)((Object)link) + " over to handshaker...", Tracer.Level.VERBOSE);
            new SrvLinkHandshaker(this.configDescriptor, this.appManager, link, dispatcher, this.clients, this.configDescriptor.getClientHandshakeTimeout(), this.clientHandshakeCompleteEventHandler);
        }
        catch (Exception e) {
            this.tracer.log("Accepted link " + (Object)((Object)link) + " open failed [Handshake start failure <" + e.toString() + ">]", Tracer.Level.WARNING);
            this.onLinkDown(link);
        }
    }

    private final void onClientHandshakeSuccess(SrvLink link, SrvLinkHandshakeSuccessCompletionData completionData) {
        SrvLinkClient client = completionData.client;
        link.setAgent(client);
        this.tracer.log("Handshake with client on accepted link " + (Object)((Object)link) + " completed successfully.", Tracer.Level.VERBOSE);
        try {
            this.clients.addClient(client);
            Properties props = new Properties();
            props.setProperty("ThreadAffinity", String.valueOf(link.getThreadAffinity()));
            this.threadManager.assignThreadToIOEntity((Object)link, props, this.clientLinkAssignCompleteEventHandler);
        }
        catch (Exception e) {
            this.tracer.log("Accepted link " + (Object)((Object)link) + " open failed [Post handshake processing failure <" + e.toString() + ">]", Tracer.Level.WARNING);
            this.onLinkDown(link);
        }
    }

    private final void onClientHandshakeFail(SrvLink link, SrvLinkHandshakeFailureCompletionData completionData) {
        this.tracer.log("Accepted link " + (Object)((Object)link) + " open failed [Handshake failure <" + completionData.cause.getMessage() + ">]", Tracer.Level.WARNING);
        this.onLinkDown(link);
    }

    private final void onClientLinkAssignSuccess(IEmxDispatcher dispatcher, SrvLink link) {
        this.tracer.log("Accepted link " + (Object)((Object)link) + " assigned to thread successfully.", Tracer.Level.VERBOSE);
        try {
            SrvLinkClient client = (SrvLinkClient)link.getAgent();
            link.getCommLink().setContainer((LnkContainer)this.getContainer(dispatcher));
            MessageBusBinding binding = this.appManager.getAppDirectBusBinding(client.getAppInfo().getName());
            if (binding != null) {
                if (binding.getDescriptor().getChannel(client.getName()) == null) {
                    binding.getDescriptor().addChannel(MessageChannelDescriptor.create((String)client.getName(), (MessageBusDescriptor)binding.getDescriptor()));
                }
            } else {
                throw new Exception("application '" + client.getAppInfo().getName() + "' is not loaded");
            }
            MessageChannel channel = binding.getMessageChannel(client.getName());
            ((SrvLinkSmaMessageChannel)channel).attachLink(this, link, dispatcher);
        }
        catch (Exception e) {
            this.tracer.log("Accepted link (client) " + (Object)((Object)link) + " open failed <" + e.toString() + ">", Tracer.Level.WARNING);
            this.onLinkDown(link);
        }
    }

    private final void onClientLinkAssignFail(SrvLink link, Exception cause) {
        this.tracer.log("Accepted link " + (Object)((Object)link) + " open failed [Thread assign failure <" + cause.getMessage() + ">]", Tracer.Level.WARNING);
        this.onLinkDown(link);
    }

    final void onLinkDown(SrvLink link) {
        try {
            SrvLinkClient client = (SrvLinkClient)link.getAgent();
            short ltp = client != null ? (short)client.getSrvLtp() : (short)-1;
            this.tracer.log("Closing link " + (Object)((Object)link) + "(ltp=" + ltp + ").", Tracer.Level.VERBOSE);
            link.getCommLink().close(ltp);
            if (client != null) {
                this.clients.removeClient(client.getName()).close();
            }
            this.tracer.log("Link " + (Object)((Object)link) + " closed successfully.", Tracer.Level.VERBOSE);
        }
        catch (Exception e) {
            this.tracer.log("Error in closing link " + (Object)((Object)link) + " [" + e.toString() + "]", Tracer.Level.WARNING);
        }
    }

    public final List<UtlAddressDescriptor> start() throws ESrvLinkException {
        this.tracer.log("Starting client acceptors...", Tracer.Level.INFO);
        LinkedList<UtlAddressDescriptor> connectorDescriptorSet = new LinkedList<UtlAddressDescriptor>();
        Set<String> acceptorSet = this.configDescriptor.getAcceptors();
        if (acceptorSet.size() > 0) {
            Iterator<String> iterator = acceptorSet.iterator();
            while (iterator.hasNext()) {
                UtlAddressDescriptor descriptor = this.startClientAcceptor(UtlStr.substEnv((String)iterator.next().trim()));
                if (descriptor == null || descriptor.getConnectorDescriptor() == null) continue;
                connectorDescriptorSet.add(descriptor.getConnectorDescriptor());
            }
        } else {
            this.tracer.log("No acceptors configured.", Tracer.Level.INFO);
        }
        return connectorDescriptorSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.acceptors;
        synchronized (object) {
            this.tracer.log("Stopping acceptors...", Tracer.Level.INFO);
            if (this.acceptors.size() > 0) {
                int size = this.acceptors.size();
                XIterator acceptorIterator = this.acceptors.reuseableValueIterator();
                while (acceptorIterator.hasNext()) {
                    SrvLinkAcceptor acceptor = (SrvLinkAcceptor)((Object)acceptorIterator.next());
                    try {
                        acceptor.stop();
                        if (size == this.acceptors.size()) continue;
                        size = this.acceptors.size();
                        acceptorIterator = this.acceptors.reuseableValueIterator();
                    }
                    catch (Throwable e) {
                        acceptorIterator.remove();
                        StringBuilder sb = new StringBuilder();
                        sb.append("Failed to stop an acceptor").append("\n");
                        sb.append("Stack Trace:").append("\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
                long start = System.currentTimeMillis();
                long remaining = 30000L;
                while (this.acceptors.size() > 0 && remaining > 0L) {
                    try {
                        this.acceptors.wait(remaining);
                        remaining = 30000L - (System.currentTimeMillis() - start);
                    }
                    catch (InterruptedException e) {
                        this.tracer.log("Interrupted while waiting for acceptors to close (" + this.acceptors.size() + " acceptors still running)", Tracer.Level.WARNING);
                        break;
                    }
                }
                this.tracer.log("Acceptors stopped (" + this.acceptors.size() + " acceptors still running)", Tracer.Level.INFO);
            } else {
                this.tracer.log("All acceptors are already stopped.", Tracer.Level.INFO);
            }
        }
        object = this.containers;
        synchronized (object) {
            XIterator containerIterator = this.containers.reuseableValueIterator();
            while (containerIterator.hasNext()) {
                LnkRegistry.getInstance().removeContainer(((STRContainer)((Object)containerIterator.next())).getName());
            }
            this.containers.clear();
        }
    }

    static {
        SrvLinkSmaProvider.register();
    }

    private final class ClientLinkAssignCompleteEventHandler
    implements ISrvThreadAssignCompletionHandler {
        private ClientLinkAssignCompleteEventHandler() {
        }

        @Override
        public final void onAssignComplete(IEmxDispatcher dispatcher, boolean status, Object data) {
            if (status) {
                SrvThreadAssignSuccessCompletionData completionData = (SrvThreadAssignSuccessCompletionData)data;
                SrvLinkInboundManager.this.onClientLinkAssignSuccess(dispatcher, (SrvLink)((Object)completionData.entity));
            } else {
                SrvThreadAssignFailureCompletionData completionData = (SrvThreadAssignFailureCompletionData)data;
                SrvLinkInboundManager.this.onClientLinkAssignFail((SrvLink)((Object)completionData.entity), completionData.cause);
            }
        }
    }

    private final class ClientHandshakeCompleteEventHandler
    implements ISrvLinkHandshakeCompletionHandler {
        private ClientHandshakeCompleteEventHandler() {
        }

        @Override
        public final void onHandshakeComplete(SrvLink link, boolean status, Object data) {
            if (status) {
                SrvLinkInboundManager.this.onClientHandshakeSuccess(link, (SrvLinkHandshakeSuccessCompletionData)data);
            } else {
                SrvLinkInboundManager.this.onClientHandshakeFail(link, (SrvLinkHandshakeFailureCompletionData)data);
            }
        }
    }

    private final class ClientHandshakeStartEventHandler
    implements IEmxEventHandler {
        private ClientHandshakeStartEventHandler() {
        }

        public boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            SrvLinkInboundManager.this.onClientHandshakeStart(dispatcher, (SrvLink)((Object)event.getAttachment()));
            return false;
        }
    }

    private final class ClientAcceptorEventHandler
    implements ILnkEventHandler {
        private final UtlAddressDescriptor descriptor;

        ClientAcceptorEventHandler(UtlAddressDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            if (type == 4) {
                LnkEvents.ContinuousAcceptCompleteEventData eventData = (LnkEvents.ContinuousAcceptCompleteEventData)data;
                if (eventData.status) {
                    SrvLinkInboundManager.this.onClientLinkAccept(dispatcher, eventData.pep, this.descriptor, eventData.sno);
                } else if (eventData.e instanceof ELnkOpCancelledException) {
                    SrvLinkInboundManager.this.onClientAcceptorStop(this.descriptor);
                } else {
                    SrvLinkInboundManager.this.onClientAcceptorFail(this.descriptor, (Exception)((Object)eventData.e));
                }
            } else {
                throw new InternalError("Received invalid event type [type=" + type + "].");
            }
        }
    }

    private final class STRContainer
    extends LnkSTRContainer {
        STRContainer(String name, IEmxDispatcher dispatcher) throws ELnkAlreadyPresentException {
            super(SrvLinkConfig.getConfig(), name, dispatcher, 0);
        }
    }
}

