/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.query.QueryException;
import com.neeve.query.QueryIndexer;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryRepositoryBase;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogQueryRepository;
import com.neeve.rog.log.RogLogReader;
import com.neeve.trace.Tracer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

class RogLogQueryRepositoryImpl
extends QueryRepositoryBase<Long, RogLogReader.Entry>
implements RogLogQueryRepository,
QueryIndexableRepository<Long, RogLogReader.Entry> {
    private final String KEY_UUID = "X-LOG-UUID";
    private final String KEY_LOG_NUMBER = "X-LIVE-LOG-NUMBER";
    private final RogLog log;
    private RogLogReader reader;
    private volatile boolean started = false;
    private IndexerThread indexerThread;
    private boolean closeLogOnClose = false;
    private HashSet<EntryIterator> openEntryIterators = new HashSet();

    RogLogQueryRepositoryImpl(RogLog log) {
        super(log.getLogFile().getParentFile(), log.getName(), null);
        this.log = log;
    }

    @Override
    public RogLog getLog() {
        return this.log;
    }

    @Override
    public Long getRecordId(RogLogReader.Entry record) {
        return record.getFilePosition();
    }

    @Override
    public RogLogReader.Entry retrieve(Long key) throws QueryException {
        if (!this.started) {
            throw new IllegalStateException("closed");
        }
        try {
            return this.reader.getEntryAt(key);
        }
        catch (Exception e) {
            throw new QueryException("Error fetching LogEntry at " + key + ": " + e.getMessage(), e);
        }
    }

    @Override
    public final Iterable<RogLogReader.Entry> retrieve(long startSeqNo, long endSeqNo) throws QueryException {
        try {
            return new EntryFetcher(startSeqNo, endSeqNo);
        }
        catch (Exception e) {
            throw new QueryException("Error fetching log entries: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void open() throws Exception {
        if (!this.started) {
            try {
                this.reader = this.log.createReader();
                this.reader.setLazyDeserialization(true);
                this.reader.rewind();
                this.indexerThread = new IndexerThread();
                this.indexerThread.start();
                this.started = true;
                super.open();
            }
            catch (Exception e) {
                super.close();
                throw e;
            }
        }
    }

    @Override
    protected final void onIndexerOpened(QueryIndexer<Long, RogLogReader.Entry> indexer) {
        String uuid = indexer.getIndexProperty("X-LOG-UUID");
        UUID logUUID = this.log.getLogUUID();
        String liveLogNumber = indexer.getIndexProperty("X-LIVE-LOG-NUMBER");
        boolean updateIndexMetadata = false;
        if (uuid != null) {
            UUID idxUUID = new UUID((CharSequence)uuid);
            if (!idxUUID.equals((Object)logUUID)) {
                this.tracer.log(this.getName() + " index is inconsistent: mismatched UUID ... the indexes will be rebuilt.", Tracer.Level.WARNING);
                indexer.clear(false);
                updateIndexMetadata = true;
            } else if (liveLogNumber == null || !liveLogNumber.equals(String.valueOf(this.log.getMetadata().getLiveLogNumber()))) {
                if (liveLogNumber != null) {
                    this.tracer.log(this.getName() + " index is inconsistent: index is for log number " + liveLogNumber + " log is at number " + this.log.getMetadata().getLiveLogNumber() + " ... the indexes will be rebuilt.", Tracer.Level.WARNING);
                } else {
                    this.tracer.log(this.getName() + " index is inconsistent: missing live log number ... the indexes will be rebuilt.", Tracer.Level.WARNING);
                }
                indexer.clear(false);
                updateIndexMetadata = true;
            } else if (indexer.getLiveCommitSequenceNumber() > this.log.getNextWritePointer()) {
                this.tracer.log(this.getName() + " index is inconsistent: index is at log posistion " + indexer.getLiveCommitSequenceNumber() + " but log is at " + this.log.getNextWritePointer() + " ... the indexes will be rebuilt.", Tracer.Level.WARNING);
                indexer.clear(false);
                updateIndexMetadata = true;
            }
        } else {
            if (!indexer.getIndexes().isEmpty()) {
                this.tracer.log(this.getName() + " index inconsistent or corrupt, metadata is missing  ... the indexes will be rebuilt.", Tracer.Level.WARNING);
                indexer.clear(false);
            }
            updateIndexMetadata = true;
        }
        if (updateIndexMetadata) {
            indexer.setIndexProperty("X-LOG-UUID", logUUID.toString());
            indexer.setIndexProperty("X-LIVE-LOG-NUMBER", "" + this.log.getMetadata().getLiveLogNumber());
            indexer.commit(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (this.started) {
            this.started = false;
            try {
                try {
                    this.indexerThread.close();
                }
                finally {
                    this.indexerThread = null;
                    super.close();
                }
            }
            finally {
                try {
                    this.reader.close();
                }
                finally {
                    this.reader = null;
                }
            }
            HashSet<EntryIterator> openEntryFetcherReadersToClose = new HashSet<EntryIterator>();
            HashSet<EntryIterator> hashSet = this.openEntryIterators;
            synchronized (hashSet) {
                openEntryFetcherReadersToClose.addAll(this.openEntryIterators);
                this.openEntryIterators.clear();
            }
            for (EntryIterator entryFetchingReader : openEntryFetcherReadersToClose) {
                entryFetchingReader.close(true);
            }
            if (this.closeLogOnClose) {
                this.log.close();
            }
        }
    }

    @Override
    public final synchronized void flushIndexing() throws QueryException {
        if (!this.started) {
            throw new QueryException("flushIndexing can't be called on a closed log");
        }
        try {
            this.indexerThread.flush();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new QueryException("Interrupted flushing repository indexes", e);
        }
    }

    @Override
    protected synchronized void stopIndexing() throws InterruptedException {
        this.indexerThread.pauseIndexing();
    }

    @Override
    protected final synchronized void startIndexing(long fromPos) throws QueryException {
        this.indexerThread.startIndexingFrom(fromPos);
    }

    @Override
    public long getCommitSequence(RogLogReader.Entry record) {
        return record.getFilePosition();
    }

    @Override
    public final boolean isLiveIndexingUpToDate() {
        if (!this.indexerThread.isLiveIndexingUpToDate()) {
            if (this.tracer.debug) {
                this.tracer.log("[RogLogQueryRepository] Returning live indexing not up to date. Indexing started: " + this.indexerThread.indexingStarted + " ", Tracer.Level.DEBUG);
            }
            return false;
        }
        this.flushIndexing();
        return true;
    }

    @Override
    protected boolean isOrderedRepository() {
        return true;
    }

    @Override
    public void setCloseLogOnClose(boolean val) {
        this.closeLogOnClose = val;
    }

    static /* synthetic */ Tracer access$100(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$200(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$300(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$400(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ QueryIndexer access$500(RogLogQueryRepositoryImpl x0) {
        return x0.indexer;
    }

    static /* synthetic */ Tracer access$600(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$700(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$800(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$900(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    static /* synthetic */ Tracer access$1000(RogLogQueryRepositoryImpl x0) {
        return x0.tracer;
    }

    private final class EntryIterator
    implements Iterator<RogLogReader.Entry> {
        private final long startPos;
        private final long limit;
        RogLogReader reader;
        RogLogReader.Entry nextEntry = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntryIterator(long startPos, long limit) throws Exception {
            this.startPos = startPos;
            this.limit = limit;
            this.reader = RogLogQueryRepositoryImpl.this.log.createReader();
            this.reader.setLazyDeserialization(true);
            HashSet hashSet = RogLogQueryRepositoryImpl.this.openEntryIterators;
            synchronized (hashSet) {
                if (RogLogQueryRepositoryImpl.this.started) {
                    RogLogQueryRepositoryImpl.this.openEntryIterators.add(this);
                }
            }
            if (!RogLogQueryRepositoryImpl.this.started) {
                this.reader.close();
                throw new QueryException("Can't create entry iterator when repository is closed");
            }
        }

        @Override
        public boolean hasNext() {
            if (!RogLogQueryRepositoryImpl.this.started || this.reader == null) {
                return false;
            }
            try {
                boolean hasNext;
                while (this.nextEntry == null) {
                    this.nextEntry = this.reader.next();
                    if (this.nextEntry != null && this.nextEntry.getFilePosition() < this.startPos) continue;
                }
                boolean bl = hasNext = this.nextEntry != null && this.nextEntry.getFilePosition() <= this.limit;
                if (!hasNext) {
                    this.close(false);
                }
                return hasNext;
            }
            catch (Exception e) {
                this.close(false);
                if (!RogLogQueryRepositoryImpl.this.started) {
                    throw new QueryException("Entry iterator closed [" + e.getMessage() + "]", e);
                }
                throw new QueryException("Transaction log read failure: " + e.getMessage(), e);
            }
        }

        @Override
        public RogLogReader.Entry next() {
            try {
                if (this.hasNext()) {
                    RogLogReader.Entry entry = this.nextEntry;
                    return entry;
                }
                RogLogReader.Entry entry = null;
                return entry;
            }
            finally {
                this.nextEntry = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void close(boolean preRemoved) {
            if (this.reader != null) {
                boolean removed = true;
                if (!preRemoved) {
                    HashSet hashSet = RogLogQueryRepositoryImpl.this.openEntryIterators;
                    synchronized (hashSet) {
                        removed = RogLogQueryRepositoryImpl.this.openEntryIterators.remove(this);
                    }
                }
                if (removed) {
                    try {
                        this.reader.close();
                        this.reader = null;
                    }
                    catch (Exception e1) {
                        RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Error closing entry reader: " + e1.getMessage(), Tracer.Level.SEVERE);
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported for a QueryRepository's iterators");
        }
    }

    private class EntryFetcher
    implements Iterable<RogLogReader.Entry> {
        private final long startPos;
        private final long limit;

        EntryFetcher(long startPos, long limit) throws Exception {
            this.startPos = startPos;
            this.limit = limit;
        }

        @Override
        public Iterator<RogLogReader.Entry> iterator() {
            try {
                return new EntryIterator(this.startPos, this.limit);
            }
            catch (Exception e2) {
                throw new QueryException("Error opening log entry fetching iterator: " + e2.getMessage(), e2);
            }
        }
    }

    private class IndexerThread
    implements Runnable {
        private Thread thread;
        private volatile AtomicBoolean running = new AtomicBoolean(false);
        private static final long TAILING_READ_MIN_RETRY_DELAY = 20L;
        private static final long TAILING_READ_MAX_RETRY_DELAY = 1000L;
        private final RogLogReader reader;
        private int COMMIT_THRESHOLD = 1000000;
        private volatile int pendingCommitCount = 0;
        private volatile long lastCommittedSeqNo = 0L;
        private volatile long lastCommitTs = 0L;
        private volatile boolean indexingStarted = false;
        private volatile boolean pauseRequested = false;
        private volatile long indexStartPos = 0L;
        private volatile boolean eofReached = false;
        private volatile boolean flushRequested = false;

        IndexerThread() throws Exception {
            this.reader = RogLogQueryRepositoryImpl.this.log.createReader();
            this.reader.setLazyDeserialization(true);
            this.reader.rewind();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [61[CATCHBLOCK]], but top level block is 11[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void flushCommits() throws InterruptedException {
            if (((RogLogQueryRepositoryImpl)RogLogQueryRepositoryImpl.this).tracer.debug) {
                RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Committing updated indexes (pendingCommitCount=" + this.pendingCommitCount + ")", Tracer.Level.DEBUG);
            }
            if (this.pendingCommitCount > 0) {
                RogLogQueryRepositoryImpl.this.commit(this.lastCommittedSeqNo);
                this.lastCommitTs = System.currentTimeMillis();
                this.pendingCommitCount = 0;
            }
            if (((RogLogQueryRepositoryImpl)RogLogQueryRepositoryImpl.this).tracer.debug) {
                RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Done", Tracer.Level.DEBUG);
            }
            if (this.flushRequested && this.eofReached) {
                if (((RogLogQueryRepositoryImpl)RogLogQueryRepositoryImpl.this).tracer.debug) {
                    RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Flush requested and EOF reached. Notifying waiters...", Tracer.Level.DEBUG);
                }
                IndexerThread indexerThread = this;
                synchronized (indexerThread) {
                    this.flushRequested = false;
                    this.notifyAll();
                }
            }
        }

        public void start() {
            if (this.thread != null && !this.running.get()) {
                try {
                    this.stop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.thread == null) {
                this.running.set(true);
                this.thread = new Thread((Runnable)this, RogLogQueryRepositoryImpl.this.getName() + "-QueryIndexer");
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws InterruptedException {
            if (this.thread != null) {
                try {
                    this.running.set(false);
                    IndexerThread indexerThread = this;
                    synchronized (indexerThread) {
                        this.indexingStarted = false;
                        this.notify();
                    }
                    this.thread.join();
                }
                finally {
                    this.thread = null;
                }
            }
        }

        public final void close() throws Exception {
            this.stop();
            this.reader.close();
        }

        public synchronized void flush() throws InterruptedException {
            if (!this.indexingStarted) {
                return;
            }
            this.eofReached = false;
            this.flushRequested = true;
            while (this.running.get() && !this.eofReached && this.flushRequested) {
                this.notifyAll();
                this.wait();
            }
            if (((RogLogQueryRepositoryImpl)RogLogQueryRepositoryImpl.this).tracer.debug) {
                RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Flush completed: " + this.lastCommittedSeqNo, Tracer.Level.DEBUG);
            }
        }

        public synchronized void pauseIndexing() throws InterruptedException {
            if (!this.indexingStarted) {
                return;
            }
            this.pauseRequested = true;
            this.notifyAll();
            while (this.running.get() && this.pauseRequested) {
                this.wait();
            }
            if (((RogLogQueryRepositoryImpl)RogLogQueryRepositoryImpl.this).tracer.debug) {
                RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Paused indexing " + this.lastCommittedSeqNo, Tracer.Level.DEBUG);
            }
        }

        public synchronized void startIndexingFrom(long fromPos) {
            try {
                this.reader.rewind();
            }
            catch (IOException e) {
                throw new QueryException("Error rewinding indexer log reader: " + e.getMessage(), e);
            }
            this.indexingStarted = true;
            this.eofReached = false;
            this.indexStartPos = Math.max(this.reader.getFilePosition(), fromPos);
            this.notifyAll();
            if (((RogLogQueryRepositoryImpl)RogLogQueryRepositoryImpl.this).tracer.debug) {
                RogLogQueryRepositoryImpl.this.tracer.log("[RogLogQueryRepository] Started indexing " + this.indexStartPos, Tracer.Level.DEBUG);
            }
        }

        public synchronized boolean isLiveIndexingUpToDate() {
            return this.eofReached;
        }
    }
}

