/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.persist;

import com.neeve.perf.serialization.MessageFactory;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.rog.log.RogMessageLog;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.stats.StatsLatencyWriter;
import com.neeve.util.UtlThread;
import jargs.gnu.CmdLineParser;
import java.text.DecimalFormat;
import java.util.Properties;

public final class MessageLogger {
    private final RogMessageLog _logger;
    private final DecimalFormat _dfmt = new DecimalFormat("#,###");

    MessageLogger(Properties props) throws Exception {
        this._logger = RogMessageLog.create((String)"perf", (Properties)props);
    }

    private final void registerFactories() throws Exception {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory("com.neeve.perf.serialization.rumi.protobuf.MessageFactory");
    }

    private final IRogMessage createMessage() {
        return (IRogMessage)new MessageFactory("rumi.protobuf").createCar(true);
    }

    private final void write(int count, int warmupTime, int rate, int numPerCommit, boolean syncOnCommit, long nanoTimeOverhead, boolean noLatencyWrites, boolean printIntervalStats) throws Exception {
        IRogMessage message = this.createMessage();
        StatsLatencyWriter lw = new StatsLatencyWriter("write", noLatencyWrites ? null : "latencies.write.bin", printIntervalStats);
        System.out.println("Writing...");
        int i = 1;
        long start = System.nanoTime();
        long nanosPerMsg = rate > 0 ? 1000000000L / (long)rate : 0L;
        long next = start + nanosPerMsg;
        boolean warmupCompleted = false;
        int postWarmupCount = 0;
        long postWarmupStart = 0L;
        lw.start(rate, count);
        while (i < count) {
            long current = System.nanoTime();
            if (current >= next) {
                boolean commitStart = numPerCommit == 1 || (i + 1) % numPerCommit == 1;
                boolean commitEnd = numPerCommit == 1 || (i + 1) % numPerCommit == 0;
                long t0 = System.nanoTime();
                this._logger.log(message, commitStart, commitEnd, commitEnd && syncOnCommit);
                int writeTime = (int)(System.nanoTime() - t0 - nanoTimeOverhead);
                lw.write(writeTime);
                next += nanosPerMsg;
                ++i;
                if (warmupCompleted) {
                    ++postWarmupCount;
                }
            }
            if (warmupCompleted || current - start <= (long)warmupTime * 1000000000L) continue;
            System.out.println("Warm up complete.");
            postWarmupStart = current;
            warmupCompleted = true;
        }
        long stop = System.nanoTime();
        lw.close();
        int overallRate = (int)((long)postWarmupCount * 1000000000L / (stop - postWarmupStart));
        System.out.println("Wrote " + this._dfmt.format(postWarmupCount) + " messages @ " + this._dfmt.format(overallRate) + " msgs/sec post warmup.");
        System.out.println("Write complete (run rumi-reporter on latencies.write.bin to calculate latency stats)");
    }

    private final void read(int count, int warmupTime) {
        System.out.println("Reading...");
        MessageReceiver receiver = new MessageReceiver(warmupTime);
        this._logger.read((IRogMessageLogger.IMessageReceiver)receiver);
        receiver.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(int count, int warmupTime, int rate, int numPerCommit, boolean syncOnCommit, boolean noLatencyWrites, boolean printIntervalStats) throws Exception {
        try {
            long nanoTimeOverhead = 0L;
            long start = System.nanoTime();
            System.out.println("Calculating nanoTime() overhead...");
            for (int i = 0; i < 100000000; ++i) {
                System.nanoTime();
            }
            nanoTimeOverhead = (System.nanoTime() - start) / 100000000L;
            System.out.println("Registering factories...");
            this.registerFactories();
            System.out.println("Opening logger...");
            this._logger.open();
            this.write(count, warmupTime, rate, numPerCommit, syncOnCommit, nanoTimeOverhead, noLatencyWrites, printIntervalStats);
            System.out.println("");
            this._logger.flush(syncOnCommit);
            this.read(count, warmupTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("Closing logger...");
            this._logger.close();
        }
    }

    private static void printUsage() {
        System.err.println("Usage MessageLogger");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-k, --logLocation} the directory where to create the log]");
        System.err.println("   Specifies the directory where the log should be created (default=\".\")");
        System.err.println(" [{-o, --logMode} the transaction log open mode]");
        System.err.println("   Specifies the mode to open the transaction log in, Valid values are 'rw', 'rws' and 'rwd' (default='rw')");
        System.err.println(" [{-i, --initialLogLength} the preallocated length of the transaction log]");
        System.err.println("   Specifies the preallocated length (in gigabytes) of the transaction log (default=1)");
        System.err.println(" [{-z, --zeroOutInitial} zeroes out the preallocated length. only applies if --initialLength is specified and > 0]");
        System.err.println("   Specifies whether to zero out the preallocated length of the transaction log (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-a, --writeBufferSize} specifies the log write buffer size]");
        System.err.println("   Specifies, in bytes, the log's write buffer size (default=8192)");
        System.err.println(" [{-m, --flushUsingMappedMemory} whether to flush using a memory mapped region of the log");
        System.err.println("   Specifies whether to use a memory mapped region of the log to perform flush operations (default=false)");
        System.err.println(" [{-f, --flushOnCommit} whether to flush the transaction log on every commit]");
        System.err.println("   Specifies whether the in memory cached entries of the log are forcibly flushed on every commit (default=false)");
        System.err.println("   <Note: A flush does not imply sync>");
        System.err.println(" [{-n, --numPerCommit} number of writes per commit]");
        System.err.println("   Number of writes per commit (default=1)");
        System.err.println(" [{-y, --syncOnCommit} force sync on every commit]");
        System.err.println("   Forcibly sync to disk on each commit (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-d, --detached} detached]");
        System.err.println("   Switches on detached writes (concurrent write in a separate thread) on or off (default=false)");
        System.err.println(" [{-q, --queueDepth} queue depth for detached writes]");
        System.err.println("   Specifies the queue depth for detached writes (default=1024)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-l, --publisherClaimStrategy} disruptor publisher claim strategy for detached writes]");
        System.err.println("   Specifies the disruptor publisher claim strategy. Valid values are SingleThreaded | MultiThreaded | MultiThreadedSufficientCores (default=MultiThreadedSufficientCores)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-w, --writerWaitStrategy} disruptor writer wait strategy for detached writes]");
        System.err.println("   Specifies the disruptor writer claim strategy. Valid values are Sleeping | Yielding | Blocking | BusySpin (default=Yielding)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-b, --readBufferSize} specifies the log read buffer size]");
        System.err.println("   Specifies, in bytes, the log's read buffer size (default=8192)");
        System.err.println(" [{-p, --pageSize} specifies the disk subsystem page size]");
        System.err.println("   Specifies (in bytes) the page size to use when reading/writing from/to disk (default=8192)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-c, --count} number of messages to persist]");
        System.err.println("   Number of messages to persist (default=10,000,000)");
        System.err.println(" [{-t, --warmupTime} Warmup time]");
        System.err.println("   Warmup time, in seconds, for calculation of throughput stats (default=2 (2 seconds))");
        System.err.println(" [{-r, --rate} write rate]");
        System.err.println("   Rate at which to persist messages (default=-1 (unlimited))");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-a, --noLatencyWrites} don't write latencies to a file");
        System.err.println("   Indicates that latencies should not be written to a file (default=false)");
        System.err.println(" [{-b, --printIntervalStats} print interval latency stats");
        System.err.println("   Indicates that latencies stats should be printed on a periodic basis in addition to at the end (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-j, --affinity} CPU affinity of the write/read thread");
        System.err.println("   Sets the CPU affinity of the thread performing the read/write (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-h, --help} print this help string]");
    }

    public static final void main(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option logLocationOption = parser.addStringOption('k', "logLocation");
        CmdLineParser.Option logModeOption = parser.addStringOption('m', "logMode");
        CmdLineParser.Option initialLogLengthOption = parser.addIntegerOption('i', "initialLogLength");
        CmdLineParser.Option zeroOutInitialOption = parser.addBooleanOption('z', "zeroOutInitial");
        CmdLineParser.Option writeBufferSizeOption = parser.addIntegerOption('a', "writeBufferSize");
        CmdLineParser.Option flushUsingMappedMemoryOption = parser.addBooleanOption('m', "flushUsingMappedMemory");
        CmdLineParser.Option flushOnCommitOption = parser.addBooleanOption('f', "flushOnCommit");
        CmdLineParser.Option numPerCommitOption = parser.addIntegerOption('n', "numPerCommit");
        CmdLineParser.Option syncOnCommitOption = parser.addBooleanOption('y', "syncOnCommit");
        CmdLineParser.Option detachedOption = parser.addBooleanOption('d', "detached");
        CmdLineParser.Option queueDepthOption = parser.addIntegerOption('q', "queueDepth");
        CmdLineParser.Option publisherClaimStrategyOption = parser.addStringOption('l', "publisherClaimStrategy");
        CmdLineParser.Option writerWaitStrategyOption = parser.addStringOption('w', "writerWaitStrategy");
        CmdLineParser.Option writerAffinityOption = parser.addStringOption('x', "writerAffinity");
        CmdLineParser.Option readBufferSizeOption = parser.addIntegerOption('b', "readBufferSize");
        CmdLineParser.Option pageSizeOption = parser.addIntegerOption('p', "pageSize");
        CmdLineParser.Option countOption = parser.addIntegerOption('c', "count");
        CmdLineParser.Option warmupTimeOption = parser.addIntegerOption('t', "warmupTime");
        CmdLineParser.Option rateOption = parser.addIntegerOption('r', "rate");
        CmdLineParser.Option noLatencyWritesOption = parser.addBooleanOption('a', "noLatencyWrites");
        CmdLineParser.Option printIntervalStatsOption = parser.addBooleanOption('b', "printIntervalStats");
        CmdLineParser.Option affinityOption = parser.addStringOption('j', "affinity");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
            if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                String affinityStr = (String)parser.getOptionValue(affinityOption, null);
                if (affinityStr != null) {
                    System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
                    UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)affinityStr));
                }
                Properties props = new Properties();
                props.setProperty("storeRoot", (String)parser.getOptionValue(logLocationOption, (Object)"."));
                props.setProperty("logMode", (String)parser.getOptionValue(logModeOption, (Object)"rw"));
                props.setProperty("initialLogLength", String.valueOf(parser.getOptionValue(initialLogLengthOption, (Object)1)));
                props.setProperty("zeroOutInitial", (Boolean)parser.getOptionValue(zeroOutInitialOption, (Object)false) != false ? "true" : "false");
                props.setProperty("writeBufferSize", String.valueOf(parser.getOptionValue(writeBufferSizeOption, (Object)8192)));
                props.setProperty("flushUsingMappedMemory", (Boolean)parser.getOptionValue(flushUsingMappedMemoryOption, (Object)false) != false ? "true" : "false");
                props.setProperty("flushOnCommit", (Boolean)parser.getOptionValue(flushOnCommitOption, (Object)false) != false ? "true" : "false");
                props.setProperty("detachedPersist", (Boolean)parser.getOptionValue(detachedOption, (Object)false) != false ? "true" : "false");
                props.setProperty("queueDepth", String.valueOf(parser.getOptionValue(queueDepthOption, (Object)1024)));
                props.setProperty("queueOfferStrategy", (String)parser.getOptionValue(publisherClaimStrategyOption, (Object)"SingleThreaded"));
                props.setProperty("queueWaitStrategy", (String)parser.getOptionValue(writerWaitStrategyOption, (Object)"Yielding"));
                props.setProperty("queueDrainerCpuAffinityMask", (String)parser.getOptionValue(writerAffinityOption, (Object)"[0]"));
                props.setProperty("pageSize", String.valueOf(parser.getOptionValue(pageSizeOption, (Object)4096)));
                props.setProperty("readBufferSize", String.valueOf(parser.getOptionValue(readBufferSizeOption, (Object)8192)));
                System.out.println("");
                System.out.println("***** Parameters");
                System.out.println("***** ...logLocation=" + props.getProperty("storeRoot"));
                System.out.println("***** ...logMode=" + props.getProperty("logMode"));
                System.out.println("***** ...initialLogLength=" + props.getProperty("initialLogLength"));
                System.out.println("***** ...zeroOutInitial=" + props.getProperty("zeroOutInitial"));
                System.out.println("*****");
                System.out.println("***** ...writeBufferSize=" + props.getProperty("writeBufferSize"));
                System.out.println("***** ...flushUsingMappedMemory=" + props.getProperty("flushUsingMappedMemory"));
                System.out.println("***** ...flushOnCommit=" + props.getProperty("flushOnCommit"));
                int numPerCommit = (Integer)parser.getOptionValue(numPerCommitOption, (Object)1);
                System.out.println("***** ...numPerCommit=" + numPerCommit);
                boolean syncOnCommit = (Boolean)parser.getOptionValue(syncOnCommitOption, (Object)false);
                System.out.println("***** ...syncOnCommit=" + syncOnCommit);
                System.out.println("*****");
                System.out.println("***** ...detached=" + props.getProperty("detachedPersist"));
                System.out.println("***** ......queueDepth=" + props.getProperty("queueDepth"));
                System.out.println("***** ......publisherClaimStrategy=" + props.getProperty("queueOfferStrategy"));
                System.out.println("***** ......writerWaitStrategy=" + props.getProperty("queueWaitStrategy"));
                System.out.println("***** ......writerAffinity=" + props.getProperty("queueDrainerCpuAffinityMask"));
                System.out.println("*****");
                System.out.println("***** ...readBufferSize=" + props.getProperty("readBufferSize"));
                System.out.println("***** ...pageSize=" + props.getProperty("pageSize"));
                System.out.println("*****");
                int count = (Integer)parser.getOptionValue(countOption, (Object)10000000);
                System.out.println("***** ...count=" + count);
                int warmupTime = (Integer)parser.getOptionValue(warmupTimeOption, (Object)2);
                System.out.println("***** ...warmupTime=" + warmupTime);
                int rate = (Integer)parser.getOptionValue(rateOption, (Object)-1);
                System.out.println("***** ...rate=" + rate);
                System.out.println("*****");
                boolean noLatencyWrites = (Boolean)parser.getOptionValue(noLatencyWritesOption, (Object)false);
                System.out.println("***** ...noLatencyWrites=" + noLatencyWrites);
                boolean printIntervalStats = (Boolean)parser.getOptionValue(printIntervalStatsOption, (Object)false);
                System.out.println("***** ...printIntervalStats=" + printIntervalStats);
                System.out.println("*****");
                System.out.println("***** ...affinity=" + affinityStr);
                System.out.println("");
                new MessageLogger(props).run(count, warmupTime, rate, numPerCommit, syncOnCommit, noLatencyWrites, printIntervalStats);
            } else {
                MessageLogger.printUsage();
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            MessageLogger.printUsage();
        }
    }

    private final class MessageReceiver
    implements IRogMessageLogger.IMessageReceiver {
        private int _i = 0;
        private long _start = System.nanoTime();
        private int _warmupTime;
        private boolean _warmupCompleted;
        private int _postWarmupCount;
        private long _postWarmupStart;

        MessageReceiver(int warmupTime) {
            this._warmupTime = warmupTime;
            this._warmupCompleted = false;
            this._postWarmupCount = 0;
            this._postWarmupStart = 0L;
        }

        final void done() {
            long current = System.nanoTime();
            int overallRate = (int)((long)this._postWarmupCount * 1000000000L / (current - this._postWarmupStart));
            System.out.println("Read " + MessageLogger.this._dfmt.format(this._postWarmupCount) + " messages @ " + MessageLogger.this._dfmt.format(overallRate) + " messages/sec post warmup.");
        }

        public final void handleMessage(IRogMessage message) {
            ++this._i;
            if (this._warmupCompleted) {
                ++this._postWarmupCount;
            }
            long current = System.nanoTime();
            if (!this._warmupCompleted && current - this._start > (long)this._warmupTime * 1000000000L) {
                System.out.println("Warm up complete.");
                this._postWarmupStart = current;
                this._warmupCompleted = true;
            }
        }
    }
}

