/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.io.IOBuffer;
import com.neeve.perf.common.SystemProperties;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;

@AnnotatedCommand.Command(keywords={"RdmaStreamingReceiver"}, description="A blocking receiver to test RDMA streaming performance")
public class RdmaStreamingReceiver
extends AnnotatedCommand
implements IEmxNwLnkPeerEndpoint.IDataReceiver {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. rdma://192.168.1.7:12000")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=99, longForm="cpuAffinityMask", description="which CPU(s) to affinitize the sending thread to")
    private String _cpuAffinityMask;
    private IOBuffer readBuffer = IOBuffer.create((int)1024);

    public final void execute() throws Exception {
        if (this._cpuAffinityMask != null) {
            System.out.println("[RdmaStreamingReceiver] Affinitizing thread to CPU " + this._cpuAffinityMask);
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this._cpuAffinityMask));
        }
        SystemProperties.dump();
        System.out.println("[RdmaStreamingReceiver] Accepting link...");
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(EmxFactory.EmxImpl.UCX, this._descriptor, null);
        IEmxNwLnkPeerEndpoint pep = sep.accept();
        while (true) {
            pep.read((IEmxNwLnkPeerEndpoint.IDataReceiver)this);
        }
    }

    public final void onData(long addr, int offset, int length) {
        this.readBuffer = IOBuffer.ensureCapacity((IOBuffer)this.readBuffer, (int)length, (boolean)true);
        this.readBuffer.putFrom(0, addr, offset, length);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
        new RdmaStreamingReceiver().run(args);
    }
}

