/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkConnector;
import com.neeve.io.IOBuffer;
import com.neeve.perf.common.SystemProperties;
import com.neeve.stats.StatsLatencyWriter;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlTime;
import java.text.DecimalFormat;

@AnnotatedCommand.Command(keywords={"BlockingPingPongSender"}, description="A blocking sender to test ping pong performance using EMX links")
public class BlockingPingPongSender
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&localifaddr=192.168.1.8&localport=12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=109, longForm="messageSize", defaultValue="256", required=true, description="The size of the message to ping pong")
    private int _messageSize;
    @AnnotatedCommand.Option(shortForm=99, longForm="testCount", defaultValue="300000", description="The number of messages to send")
    private int _testCount;
    @AnnotatedCommand.Option(shortForm=114, longForm="testRate", defaultValue="10000", description="The rate at which to send messages")
    private int _testRate;
    @AnnotatedCommand.Option(shortForm=97, longForm="cpuAffinityMask", description="which CPU(s) to affinitize the sending thread to")
    private String _cpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=112, longForm="spinRead", description="whether to spin or block on the read")
    private boolean _spinRead;
    @AnnotatedCommand.Option(shortForm=111, longForm="oneWayLatency", description="whether to calculate one-way latency values")
    private boolean _oneWay;
    @AnnotatedCommand.Option(shortForm=105, longForm="printIntervalStats", description="whether to output stats at periodic intervals instead of only at the end")
    private boolean _printIntervalStats;
    @AnnotatedCommand.Option(shortForm=102, longForm="dontWriteLatenciesToFile", description="whether to suppress writing latency values to a file")
    private boolean _dontWriteLatenciesToFile;

    private void doPingPong(EmxNwLnk link, IOBuffer message) throws Exception {
        link.write(message, 0, this._messageSize);
        int bytesRead = 0;
        while ((bytesRead += link.read()) < this._messageSize) {
        }
    }

    public void execute() throws Exception {
        SystemProperties.dump();
        DecimalFormat dfmt = new DecimalFormat("#,###");
        System.out.println("[BlockingPingPongSender] Message size:" + this._messageSize);
        System.out.println("[BlockingPingPongSender] Test count:" + dfmt.format(this._testCount));
        System.out.println("[BlockingPingPongSender] Test rate:" + dfmt.format(this._testRate));
        System.out.println("[BlockingPingPongSender] CPU affinity mask:" + this._cpuAffinityMask);
        System.out.println("[BlockingPingPongSender] SpinRead:" + this._spinRead);
        System.out.println("[BlockingPingPongSender] One way latency:" + this._oneWay);
        System.out.println("[BlockingPingPongSender] Print interval stats:" + this._printIntervalStats);
        System.out.println("[BlockingPingPongSender] Write latencies to file:" + !this._dontWriteLatenciesToFile);
        if (this._cpuAffinityMask != null) {
            System.out.println("[BlockingPingPongSender] Affinitizing thread to CPU " + this._cpuAffinityMask);
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this._cpuAffinityMask));
        }
        System.out.println("[BlockingPingPongSender] Establishing link...");
        EmxNwLnkConnector connector = EmxNwLnkConnector.create((String)this._descriptor);
        EmxNwLnk link = connector.connect();
        System.out.println("[BlockingPingPongSender] Configuring link (message size=" + this._messageSize + ")...");
        IOBuffer readBuffer = IOBuffer.create((int)this._messageSize);
        link.setReadBuffer(readBuffer, 0);
        link.configureBlockingRead(!this._spinRead);
        link.configureBlockingWrite(true);
        IOBuffer message = IOBuffer.create((int)this._messageSize);
        System.out.println("[BlockingPingPongSender] Calculating UtlTime.now() overhead...");
        long nanoTimeOverhead = 0L;
        long start = UtlTime.now();
        int i = 0;
        while ((long)i < 100000000L) {
            UtlTime.now();
            ++i;
        }
        nanoTimeOverhead = (UtlTime.now() - start) / 100000000L;
        System.out.println("[BlockingPingPongSender] ..." + nanoTimeOverhead + "ns");
        StatsLatencyWriter lw = new StatsLatencyWriter("nw-lat", this._dontWriteLatenciesToFile ? null : "latencies.send.bin", this._printIntervalStats);
        System.out.println("[BlockingPingPongSender] Running test (" + this._testCount + " messages)...");
        int i2 = 0;
        long nanosPerMsg = this._testRate > 0 ? 1000000000L / (long)this._testRate : 0L;
        long next = UtlTime.now() + nanosPerMsg;
        lw.start(this._testRate, this._testCount);
        while (i2 < this._testCount) {
            long ts1 = UtlTime.now();
            if (ts1 < next) continue;
            this.doPingPong(link, message);
            long ts2 = UtlTime.now();
            int latency = (int)(ts2 - ts1 - nanoTimeOverhead);
            if (this._oneWay) {
                latency /= 2;
            }
            lw.write(latency);
            ++i2;
            next += nanosPerMsg;
        }
        lw.close();
        link.close();
        if (!this._dontWriteLatenciesToFile) {
            System.out.println("[BlockingPingPongSender] Test complete (run rumi-reporter on latencies.send.bin to calculate latency stats).");
        } else {
            System.out.println("[BlockingPingPongSender] Test complete.");
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
        new BlockingPingPongSender().run(args);
    }
}

