/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin;

import com.neeve.server.admin.AdminObject;
import com.neeve.server.admin.AdminSessionProvider;
import com.neeve.server.admin.AdminSessionProviderDescriptor;
import com.neeve.server.admin.EAdminException;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

final class AdminSessionProviderRegistry
extends AdminObject {
    private static final AdminSessionProviderRegistry instance = new AdminSessionProviderRegistry();
    private final HashMap<String, AdminSessionProvider> providers = new HashMap();

    private AdminSessionProviderRegistry() {
    }

    public static final AdminSessionProviderRegistry getInstance() {
        return instance;
    }

    private final AdminSessionProvider createProvider(String className, String name, Properties props) throws EAdminException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EAdminException("Admin session provider class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new EAdminException("Admin session provider class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method providerCreateMethod = null;
        try {
            providerCreateMethod = providerClass.getMethod("create", String.class, Properties.class);
        }
        catch (SecurityException e) {
            throw new EAdminException("Access to instantiation method in admin provider class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new EAdminException("Instantiation method in admin provider admin class [" + className + "] could not be found");
        }
        AdminSessionProvider provider = null;
        try {
            try {
                Object[] parameters = new Object[]{name, props};
                provider = (AdminSessionProvider)providerCreateMethod.invoke(null, parameters);
                if (provider == null) {
                    throw new EAdminException("Instantiation method in admin session provider class [" + className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new EAdminException("Instantiation method in admin session provider class [" + className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new EAdminException("Access to instantiation method in admin session provider class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof EAdminException) {
                throw (EAdminException)((Object)e.getCause());
            }
            throw new EAdminException(e.getCause());
        }
        return provider;
    }

    private final AdminSessionProvider createProvider(String name) throws EAdminException {
        if (AdminSessionProviderDescriptor.exists(name)) {
            try {
                AdminSessionProviderDescriptor descriptor = AdminSessionProviderDescriptor.load(name);
                return this.createProvider(descriptor.getClassName(), descriptor.getName(), descriptor.getProperties());
            }
            catch (EAdminException e) {
                throw new EAdminException("Failed to load admin session provider descriptor from configuration repository [" + e.toString() + "]");
            }
        }
        throw new EAdminException("invalid provider '" + name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerProvider(AdminSessionProvider provider) throws EAdminException {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        HashMap<String, AdminSessionProvider> hashMap = this.providers;
        synchronized (hashMap) {
            if (this.tracer.debug) {
                this.tracer.log("[AdminSessionProviderRegistry] Registering provider '" + provider.getName() + "'...", Tracer.Level.DEBUG);
            }
            this.providers.put(provider.getName(), provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdminSessionProvider getProvider(String name) throws EAdminException {
        HashMap<String, AdminSessionProvider> hashMap = this.providers;
        synchronized (hashMap) {
            AdminSessionProvider provider;
            if (this.tracer.debug) {
                this.tracer.log("[AdminSessionProviderRegistry] Getting provider '" + name + "'...", Tracer.Level.DEBUG);
            }
            if ((provider = this.providers.get(name)) == null) {
                if (this.tracer.debug) {
                    this.tracer.log("[AdminSessionProviderRegistry] Admin session provider not created. Creating...", Tracer.Level.DEBUG);
                }
                provider = this.createProvider(name);
                this.providers.put(name, provider);
            } else if (this.tracer.debug) {
                this.tracer.log("[AdminSessionProviderRegistry] Admin session provider already created. Returning...", Tracer.Level.DEBUG);
            }
            return provider;
        }
    }
}

