/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.deploy;

import com.neeve.deploy.HostCollection;
import com.neeve.deploy.Model;
import com.neeve.deploy.Server;
import com.neeve.discovery.DiscoveryCacheEvents;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryCacheEventHandler;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.trace.Tracer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class Host {
    private final HostCollection collection;
    private final InetAddress address;
    private final IDiscoveryCache discoveryCache;
    private final IDiscoveryCacheEventHandler discoveryCacheEventHandler;
    private final HashMap<String, Server> servers;
    private final Tracer tracer;
    private final String tracePrefix;
    private volatile EventHandler eventHandler;

    Host(HostCollection collection, InetAddress address, Tracer tracer) {
        this.collection = collection;
        this.address = address;
        this.discoveryCache = collection.discoveryCache;
        this.discoveryCacheEventHandler = new DiscoveryCacheEventHandler();
        this.servers = new HashMap();
        this.tracer = tracer;
        this.tracePrefix = "[Host (" + address.getHostName() + ")] ";
    }

    private final boolean isOnThisHost(IDiscoveryEntity entity) {
        try {
            return InetAddress.getByName(entity.getHost()).equals(this.address);
        }
        catch (UnknownHostException e) {
            this.tracer.log(this.tracePrefix + "Failed to get the IP address of entity host '" + entity.getHost() + "' [" + e.toString() + "]. Ignoring host...", Tracer.Level.WARNING);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onServerUp(IDiscoveryEntity entity) {
        Server server = this.getServer(entity.getName());
        if (server == null) {
            server = new Server(this, entity.getName(), entity, this.tracer);
            HashMap<String, Server> hashMap = this.servers;
            synchronized (hashMap) {
                this.servers.put(entity.getName(), server);
            }
            try {
                this.collection.getModel().scheduleAction((IEmxAction)new IEmxAction<Server, Object>(){

                    public final Object execute(IEmxDispatcher dispatcher, Server server) throws Exception {
                        EventHandler eventHandler = Host.this.eventHandler;
                        server.open();
                        if (server.getState() != Server.State.Open) {
                            Host.this.tracer.log(Host.this.tracePrefix + "Server not open after processing server up [state=" + (Object)((Object)server.getState()) + "]", Tracer.Level.WARNING);
                        }
                        if (eventHandler != null) {
                            eventHandler.onServerUp(server);
                        }
                        return null;
                    }
                }, server);
            }
            catch (Exception e) {
                this.tracer.log(this.tracePrefix + "Failed to schedule processing of new server [" + e.toString() + ". Server will not appear in view...", Tracer.Level.WARNING);
            }
        } else {
            this.tracer.log(this.tracePrefix + "Received SERVER UP event for an existing server '" + entity.getName() + "'...", Tracer.Level.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onServerDown(IDiscoveryEntity entity) {
        Server server = this.getServer(entity.getName());
        if (server != null) {
            Host host = this;
            synchronized (host) {
                this.servers.remove(entity.getName());
            }
            try {
                this.collection.getModel().scheduleAction((IEmxAction)new IEmxAction<Server, Object>(){

                    public final Object execute(IEmxDispatcher dispatcher, Server server) throws Exception {
                        server.close();
                        EventHandler eventHandler = Host.this.eventHandler;
                        if (eventHandler != null) {
                            eventHandler.onServerDown(server);
                        }
                        return null;
                    }
                }, server);
            }
            catch (Exception e) {
                this.tracer.log(this.tracePrefix + "Failed to schedule processing of server down [" + e.toString() + ". Server will not disappear from view...", Tracer.Level.WARNING);
            }
        } else {
            this.tracer.log(this.tracePrefix + "Received SERVER DOWN event for an non-existing server '" + entity.getName() + "'...", Tracer.Level.DEBUG);
        }
    }

    public final void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening...", Tracer.Level.DEBUG);
        }
        Object object = this.discoveryCache.getCacheLock();
        synchronized (object) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Finding running servers...", Tracer.Level.DEBUG);
            }
            int count = 0;
            Set entities = this.discoveryCache.matches("Server");
            for (IDiscoveryEntity entity : entities) {
                if (this.isOnThisHost(entity)) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...found server '" + entity.getName() + "'.", Tracer.Level.DEBUG);
                    }
                    this.onServerUp(entity);
                }
                ++count;
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Found " + count + " servers.", Tracer.Level.DEBUG);
            }
            this.discoveryCache.addEventHandler(this.discoveryCacheEventHandler);
        }
    }

    final Model getModel() {
        return this.collection.getModel();
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Server getServer(String name) {
        HashMap<String, Server> hashMap = this.servers;
        synchronized (hashMap) {
            return this.servers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Server> getServers() {
        HashSet<Server> ret = new HashSet<Server>();
        HashMap<String, Server> hashMap = this.servers;
        synchronized (hashMap) {
            for (Server server : this.servers.values()) {
                ret.add(server);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        this.discoveryCache.removeEventHandler(this.discoveryCacheEventHandler);
        HashMap<String, Server> hashMap = this.servers;
        synchronized (hashMap) {
            for (Server server : this.servers.values()) {
                server.close();
            }
        }
    }

    public static interface EventHandler {
        public void onServerUp(Server var1);

        public void onServerDown(Server var1);
    }

    private final class DiscoveryCacheEventHandler
    implements IDiscoveryCacheEventHandler {
        private DiscoveryCacheEventHandler() {
        }

        public final void onEvent(IDiscoveryCache cache, int type, Object data) {
            switch (type) {
                case 0: {
                    DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)data;
                    if (eventData.oldEntity != null && eventData.oldEntity.getType().equals("Server") && Host.this.isOnThisHost(eventData.oldEntity)) {
                        if (((Host)Host.this).tracer.debug) {
                            Host.this.tracer.log(Host.this.tracePrefix + "Server '" + eventData.oldEntity.getName() + "' is down (recycle).", Tracer.Level.DEBUG);
                        }
                        Host.this.onServerDown(eventData.oldEntity);
                    }
                    if (!eventData.newEntity.getType().equals("Server") || !Host.this.isOnThisHost(eventData.newEntity)) break;
                    if (((Host)Host.this).tracer.debug) {
                        Host.this.tracer.log(Host.this.tracePrefix + "Server entity '" + eventData.newEntity.getName() + "' is up.", Tracer.Level.DEBUG);
                    }
                    Host.this.onServerUp(eventData.newEntity);
                    break;
                }
                case 1: {
                    DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)data;
                    if (!eventData.removedEntity.getType().equals("Server") || !Host.this.isOnThisHost(eventData.removedEntity)) break;
                    if (((Host)Host.this).tracer.debug) {
                        Host.this.tracer.log(Host.this.tracePrefix + "Server '" + eventData.removedEntity.getName() + "' is down (removed).", Tracer.Level.DEBUG);
                    }
                    Host.this.onServerDown(eventData.removedEntity);
                }
            }
        }
    }
}

