/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.deploy;

import com.neeve.deploy.App;
import com.neeve.deploy.AppChannel;
import com.neeve.server.mon.SrvMonAppBusBindingState;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class AppBus {
    private final App app;
    private final String name;
    private final Tracer tracer;
    private final String tracePrefix;
    private final HashMap<String, AppChannel> channels;
    private volatile EventHandler eventHandler;
    private volatile State state;

    AppBus(App app, String name, Tracer tracer) {
        this.app = app;
        this.name = name;
        this.tracer = tracer;
        this.tracePrefix = "[AppBus (" + this.getName() + ")] ";
        this.channels = new HashMap();
        this.state = State.from(app.getServer().getSession().getWatchedAppBusBindingState(app.getName(), name));
        if (tracer.debug) {
            tracer.log(this.tracePrefix + "Created (" + (Object)((Object)this.getState()) + ")...", Tracer.Level.DEBUG);
        }
    }

    private final void setState(State state) {
        EventHandler eventHandler;
        this.state = state;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Changed state (" + (Object)((Object)this.getState()) + ")...", Tracer.Level.DEBUG);
        }
        if ((eventHandler = this.eventHandler) != null) {
            eventHandler.onStateChange(state);
        }
    }

    final void init() {
        try {
            String[] channelNames;
            for (String channelName : channelNames = this.app.getServer().getSession().getWatchedAppBusChannels(this.app.getName(), this.name)) {
                if (channelName == null) continue;
                this.onChannelOpen(channelName);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    final void onStateChange() {
        this.setState(State.from(this.app.getServer().getSession().getWatchedAppBusBindingState(this.app.getName(), this.name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onChannelOpen(String channelName) {
        if (this.getChannel(channelName) == null) {
            AppChannel channel = new AppChannel(this, channelName, this.tracer);
            HashMap<String, AppChannel> hashMap = this.channels;
            synchronized (hashMap) {
                this.channels.put(channelName, channel);
            }
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onChannelOpened(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onChannelClose(String channelName) {
        EventHandler eventHandler;
        AppChannel channel = null;
        HashMap<String, AppChannel> hashMap = this.channels;
        synchronized (hashMap) {
            channel = this.channels.remove(channelName);
        }
        if (channel != null && (eventHandler = this.eventHandler) != null) {
            eventHandler.onChannelClosed(channel);
        }
    }

    public final void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public final String getName() {
        return this.name;
    }

    public final State getState() {
        return this.state;
    }

    public final App getApp() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppChannel getChannel(String name) {
        HashMap<String, AppChannel> hashMap = this.channels;
        synchronized (hashMap) {
            return this.channels.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<AppChannel> getChannels() {
        HashSet<AppChannel> ret = new HashSet<AppChannel>();
        HashMap<String, AppChannel> hashMap = this.channels;
        synchronized (hashMap) {
            for (AppChannel channel : this.channels.values()) {
                ret.add(channel);
            }
        }
        return ret;
    }

    public static interface EventHandler {
        public void onStateChange(State var1);

        public void onChannelOpened(AppChannel var1);

        public void onChannelClosed(AppChannel var1);
    }

    public static enum State {
        Created,
        Opening,
        Opened,
        Failed;


        public static final State from(SrvMonAppBusBindingState val) {
            switch (val) {
                case Created: {
                    return Created;
                }
                case Opening: {
                    return Opening;
                }
                case Opened: {
                    return Opened;
                }
                case Failed: {
                    return Failed;
                }
            }
            throw new IllegalArgumentException("invalid value");
        }
    }
}

