/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solace;

import com.neeve.io.IIOBufferBackedEntity;
import com.neeve.io.IOBuffer;
import com.neeve.io.IONativePacket;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.solace.SolaceBindingConstants;
import com.neeve.solace.SolaceBindingProperties;
import com.neeve.solace.SolaceMessageBusBinding;
import com.neeve.solace.SolaceProtobufUtil;
import com.neeve.solace.SolaceSession;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

final class SolaceMessageChannel
extends MessageChannelBase {
    private final SolaceMessageBusBinding binding;
    private final SolaceSession sendSession;
    private final SolaceSession receiveSession;
    private final XString dynamicTopicPrefix;
    private final XString topic;
    private final XString requestorIdBuilder;
    private final IONativePacket ioNativePacket;
    private final boolean isJNI;
    private String[] filters;
    private final SolaceProtobufUtil.VarintDesyncLength sendDesyncLength = new SolaceProtobufUtil.VarintDesyncLength();
    private final SolaceProtobufUtil.VarintDesyncLength recvDesyncLength = new SolaceProtobufUtil.VarintDesyncLength();

    SolaceMessageChannel(MessageChannelDescriptor descriptor, SolaceMessageBusBinding binding, SolaceSession sendSession, SolaceSession receiveSession, boolean isJNI) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
        this.sendSession = sendSession;
        this.receiveSession = receiveSession;
        this.dynamicTopicPrefix = XString.create((String)(descriptor.getName() + "/"));
        this.topic = XString.create((int)256);
        this.topic.setValue(descriptor.getName());
        this.requestorIdBuilder = XString.create((int)256);
        this.ioNativePacket = new IONativePacket();
        this.isJNI = isJNI;
    }

    private final XString resolveTopic(XString keyOrFilter, boolean topicStartsWithChannel) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Constructing topic using [keyOrFilter=" + keyOrFilter + ", topicStartsWithChannel=" + topicStartsWithChannel + "]...", Tracer.Level.DEBUG);
        }
        if (keyOrFilter == null || keyOrFilter.length() == 0) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is null. using static topic", Tracer.Level.DEBUG);
            }
            return this.topic;
        }
        if (topicStartsWithChannel) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic starts with channel. preparing topic...", Tracer.Level.DEBUG);
            }
            this.topic.clear(false);
            this.topic.append(this.dynamicTopicPrefix).append(keyOrFilter);
            return this.topic;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic does not starts with channel. using keyOrFilter as topic...", Tracer.Level.DEBUG);
        }
        return keyOrFilter;
    }

    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        XString topic = this.resolveTopic(filter == null ? null : XString.create((String)filter), topicStartsWithChannel);
        if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Subscribing to (guaranteed) topic '" + topic + "'...", Tracer.Level.DEBUG);
            }
            this.receiveSession.subscribeGuaranteed(this, topic);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Subscribing to (best effort) topic '" + topic + "'...", Tracer.Level.DEBUG);
            }
            this.receiveSession.subscribe(this, topic);
        }
    }

    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        XString topic = this.resolveTopic(filter == null ? null : XString.create((String)filter), topicStartsWithChannel);
        if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Unsubscribing from (guaranteed) topic '" + topic + "'...", Tracer.Level.DEBUG);
            }
            this.receiveSession.unsubscribeGuaranteed(this, topic);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Unsubscribing from (best effort) topic '" + topic + "'...", Tracer.Level.DEBUG);
            }
            this.receiveSession.unsubscribe(this, topic);
        }
    }

    private final boolean messageViewTypeAlreadySet(IOBuffer buffer) {
        return buffer != null ? SolaceProtobufUtil.desyncVarint32(buffer, 0, this.sendDesyncLength) >>> 3 == 1 : false;
    }

    private final void setMessageViewType(short messageType, IOBuffer buffer, int offset) {
        offset += SolaceProtobufUtil.syncVarint32(8, buffer, offset);
        SolaceProtobufUtil.syncVarint32(messageType, buffer, offset);
    }

    private final short getMessageViewType(long buffer, int len) throws SmaException {
        if (len == 0) {
            throw new SmaException(this.tracePrefix + "message is corrupt [no message type in message body]");
        }
        short fieldId = SolaceProtobufUtil.fieldId(SolaceProtobufUtil.desyncVarint32(buffer, 0, len, this.recvDesyncLength));
        if (fieldId != 1) {
            throw new SmaException(this.tracePrefix + "message is corrupt [first field (id=" + fieldId + ") is not a message type field (id=1)]");
        }
        return (short)SolaceProtobufUtil.desyncVarint32(buffer, this.recvDesyncLength.value, len, this.recvDesyncLength);
    }

    private final MessageTransportHeaders prepareTransportHeadersForInboundMessage(long messageId, short metadataVersion, long serializedMetadata, int serializedMetadataLength, long serializedUserdata, int serializedUserdataLength) {
        MessageTransportHeaders transportHeaders;
        if (this.binding.isEnableInboundTransportHeaders()) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Inbound transport headers is enabled. Setting transport headers from inbound message.", Tracer.Level.DEBUG);
            }
            transportHeaders = MessageTransportHeaders.create();
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...adding message id.", Tracer.Level.DEBUG);
            }
            transportHeaders.addHeader(SolaceBindingConstants.TRANSPORT_HEADER_MESSAGE_ID, messageId);
            if (this.getId() == Short.MAX_VALUE && serializedMetadataLength > 0) {
                int messageChannelNameLength;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...adding received channel.", Tracer.Level.DEBUG);
                }
                if ((messageChannelNameLength = MessageMetadata.getMessageChannelNameLength((short)metadataVersion, (long)serializedMetadata, (int)0)) == 0) {
                    transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, MessageMetadata.getMessageChannelId((short)metadataVersion, (long)serializedMetadata, (int)0));
                } else {
                    transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, serializedMetadata, MessageMetadata.getMessageChannelNamePos((short)metadataVersion, (long)serializedMetadata, (int)0), messageChannelNameLength);
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...not adding received channel.", Tracer.Level.DEBUG);
            }
            if (serializedUserdataLength > 0) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...adding user data.", Tracer.Level.DEBUG);
                }
                transportHeaders.addHeader(SolaceBindingProperties.TRANSPORT_PROPNAME_USERDATA, serializedUserdata, 0, serializedUserdataLength);
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...not adding user data.", Tracer.Level.DEBUG);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Inbound transport headers is disabled. Not setting transport headers from inbound message.", Tracer.Level.DEBUG);
            }
            transportHeaders = null;
        }
        return transportHeaders;
    }

    private final short resolveMessageTypeForInboundMessage(long serializedMessage, int serializedMessageLength, short metadataVersion, long serializedMetadata, int serializedMetadataLength) throws SmaException {
        short messageType = serializedMetadataLength > 0 ? (metadataVersion == 1 && MessageMetadata.getMessageEncodingType((short)metadataVersion, (long)serializedMetadata, (int)0) == 4 ? this.getMessageViewType(serializedMessage, serializedMessageLength) : MessageMetadata.getMessageViewType((short)metadataVersion, (long)serializedMetadata, (int)0)) : (short)1;
        return messageType;
    }

    private final XString prepareSendTopic(MessageView view) throws SmaException {
        XString key = view.getMessageKeyAsRaw();
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(key != null && key.length() != 0 || topicStartsWithChannel)) {
            throw new SmaException("send performed with null key on channel '" + this.getName() + "' but binding '" + this.binding.getName() + "' configured to not prepend topic with channel");
        }
        return this.resolveTopic(key, topicStartsWithChannel);
    }

    final void onMessage(long messageId, long serializedMessage, int serializedMessageLength, long serializedMetadata, int serializedMetadataLength, long serializedUserdata, int serializedUserdataLength, XString topic, boolean ackRequired, long postWireTs) throws Exception {
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.d1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)serializedMessage);
        long preDeserializeTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        short metadataVersion = serializedMetadata != 0L ? MessageMetadata.getVersion((long)serializedMetadata, (int)0) : (short)0;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received message (id='" + messageId + "', metadata=" + (serializedMetadata != 0L ? MessageMetadata.toString((long)serializedMetadata, (int)0) : "null") + ").", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "...serializedMessage=" + serializedMessage + " (len=" + serializedMessageLength + ")", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + IOBuffer.dump((long)serializedMessage, (int)0, (int)serializedMessageLength), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "...serializedUserdata=" + serializedUserdata + " (len=" + serializedUserdataLength + ")", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + " --------------------------------------------------", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + IOBuffer.dump((long)serializedUserdata, (int)0, (int)serializedUserdataLength), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + " --------------------------------------------------", Tracer.Level.DEBUG);
        }
        MessageTransportHeaders transportHeaders = this.prepareTransportHeadersForInboundMessage(messageId, metadataVersion, serializedMetadata, serializedMetadataLength, serializedUserdata, serializedUserdataLength);
        this.ioNativePacket.init(serializedMessage, 0, serializedMessageLength);
        short messageType = this.resolveMessageTypeForInboundMessage(serializedMessage, serializedMessageLength, metadataVersion, serializedMetadata, serializedMetadataLength);
        try {
            this.onMessage(this.ioNativePacket, transportHeaders, serializedMetadataLength > 0 ? (short)MessageMetadata.getMessageViewFactory((short)metadataVersion, (long)serializedMetadata, (int)0) : (short)39, messageType, serializedMetadataLength > 0 ? (int)MessageMetadata.getMessageEncodingType((short)metadataVersion, (long)serializedMetadata, (int)0) : 6, serializedMetadataLength > 0 ? MessageMetadata.getMessageSender((short)metadataVersion, (long)serializedMetadata, (int)0) : 0, serializedMetadataLength > 0 ? MessageMetadata.getMessageFlow((short)metadataVersion, (long)serializedMetadata, (int)0) : 0, serializedMetadataLength > 0 ? MessageMetadata.getMessageSno((short)metadataVersion, (long)serializedMetadata, (int)0) : 0L, serializedMetadataLength > 0 ? MessageMetadata.getRequestId((short)metadataVersion, (long)serializedMetadata, (int)0) : 0L, serializedMetadataLength > 0 ? MessageMetadata.getRequestorIdToRaw((short)metadataVersion, (long)serializedMetadata, (int)0, (XString)this.requestorIdBuilder) : null, (XString)(this.binding.isSetKeyOnReceipt() ? topic : null), ackRequired ? this.binding.createAcknowledger(messageId) : null, 0L, 0L, postWireTs, preDeserializeTs);
        }
        catch (RuntimeException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.tracePrefix).append("Exception on message dispatch\n").append("...metadata=").append(serializedMetadata != 0L ? MessageMetadata.toString((long)serializedMetadata, (int)0) : "null").append("\n").append("...message=").append(IOBuffer.dump((long)serializedMessage, (int)0, (int)serializedMessageLength)).append("\n").append("...messageType=").append(messageType).append("\n").append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
            throw e;
        }
    }

    final void onAckNack(MessageView view, Exception status) {
        this.onMessageStability(view, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doSend(MessageView view, int flags) throws SmaException {
        int serializedMetadataLength;
        int serializedMetadataOffset;
        IOBuffer serializedMetadata;
        int metadataVersion;
        MessageMetadata metadata;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
        if (MessageLatencyManager.captureMsgLatencyStats) {
            view.setPreSerializeTs(UtlTime.now());
        }
        int messageEncodingType = view.getMessageEncodingType();
        if (!this.binding.rawMode()) {
            metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
            metadataVersion = this.binding.getMetadataVersion();
            switch (metadataVersion) {
                case 1: {
                    if (messageEncodingType != 4) {
                        throw new UnsupportedOperationException("V1 SMA metadata is only supported with Protobuf encoding type");
                    }
                    metadata.serializeV1((byte)messageEncodingType, view.getVfid(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
                    break;
                }
                case 2: {
                    metadata.serializeV2((byte)messageEncodingType, view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
                    break;
                }
                case 3: {
                    metadata.serializeV3((byte)messageEncodingType, view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw(), view.getRequestId(), view.getRequestorIdAsRaw());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported metadata version [" + metadataVersion + "]");
                }
            }
            serializedMetadata = metadata.getBuffer().getBackingBufferUnsafe();
            serializedMetadataOffset = 0;
            serializedMetadataLength = metadata.getBuffer().getLength();
        } else {
            metadata = null;
            metadataVersion = 0;
            serializedMetadata = null;
            serializedMetadataOffset = 0;
            serializedMetadataLength = 0;
        }
        try {
            boolean bl;
            block35: {
                int serializedMessageLength;
                int serializedMessageOffset;
                IOBuffer serializedMessage;
                boolean serializedMessageIsDetached = false;
                switch (messageEncodingType) {
                    case 1: {
                        IIOBufferBackedEntity ioBufferBackedMessage;
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM. Serializing...", Tracer.Level.DEBUG);
                        }
                        if (view.getMessage() instanceof IIOBufferBackedEntity) {
                            ioBufferBackedMessage = (IIOBufferBackedEntity)view.getMessage();
                            serializedMessage = ioBufferBackedMessage.getSerializedBuffer();
                            serializedMessageOffset = 0;
                            serializedMessageLength = ioBufferBackedMessage.getSerializedBufferLength();
                            break;
                        }
                        serializedMessage = view.serializeToIOBuffer(true);
                        serializedMessageOffset = 0;
                        serializedMessageLength = serializedMessage.getLength();
                        serializedMessageIsDetached = true;
                        break;
                    }
                    case 6: {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Encoding type is QUARK. Serializing...", Tracer.Level.DEBUG);
                        }
                        IIOBufferBackedEntity ioBufferBackedMessage = (IIOBufferBackedEntity)view.getMessage();
                        serializedMessage = ioBufferBackedMessage.getSerializedBuffer();
                        serializedMessageOffset = 0;
                        serializedMessageLength = ioBufferBackedMessage.getSerializedBufferLength();
                        break;
                    }
                    case 4: {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF. Serializing...", Tracer.Level.DEBUG);
                        }
                        IIOBufferBackedEntity ioBufferBackedMessage = (IIOBufferBackedEntity)view.getMessage();
                        if (metadataVersion > 1 || this.messageViewTypeAlreadySet(ioBufferBackedMessage.getSerializedBuffer())) {
                            if (this.tracer.debug) {
                                if (metadataVersion > 1) {
                                    this.tracer.log(this.tracePrefix + "...metadata version is V" + metadataVersion + ". not prepending message type to serialized data", Tracer.Level.DEBUG);
                                } else {
                                    this.tracer.log(this.tracePrefix + "...serialized data already contains message type. not prepending message type to serialized data.", Tracer.Level.DEBUG);
                                }
                            }
                            serializedMessage = ioBufferBackedMessage.getSerializedBuffer();
                            serializedMessageOffset = 0;
                            serializedMessageLength = ioBufferBackedMessage.getSerializedBufferLength();
                            break;
                        }
                        int serializedMessageTypeFieldLength = SolaceProtobufUtil.primitiveFieldSerializedLength(1, view.getMessageType());
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...metadata version is V1 and serialized payload does not contain message type. prepending message type (message type len = " + serializedMessageTypeFieldLength + ", serialized message len = " + ioBufferBackedMessage.getSerializedBufferLength() + ")...", Tracer.Level.DEBUG);
                        }
                        serializedMessage = IOBuffer.create((int)(serializedMessageTypeFieldLength + ioBufferBackedMessage.getSerializedBufferLength()));
                        serializedMessageOffset = 0;
                        serializedMessageLength = serializedMessage.getLength();
                        this.setMessageViewType(view.getMessageType(), serializedMessage, serializedMessageOffset);
                        if (serializedMessageLength > serializedMessageTypeFieldLength) {
                            serializedMessage.putFrom(serializedMessageTypeFieldLength, ioBufferBackedMessage.getSerializedBuffer(), 0, serializedMessageLength - serializedMessageTypeFieldLength);
                        }
                        serializedMessageIsDetached = true;
                        break;
                    }
                    default: {
                        throw new SmaException("unknown encoding type '" + messageEncodingType + "'");
                    }
                }
                XString topic = this.prepareSendTopic(view);
                try {
                    if (MessageLatencyManager.captureMsgLatencyStats) {
                        view.setPostSerializeTs(UtlTime.now());
                    }
                    MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Sending through session", Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... Message is " + serializedMessage, Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... Metadata is " + metadata, Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... Topic is " + topic, Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + UtlBuffer.dump((String)"", (ByteBuffer)serializedMessage.getBufferUnsafe(), (int)0, (int)serializedMessageLength), Tracer.Level.DEBUG);
                        this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    }
                    this.sendSession.send(this, view, serializedMessage, serializedMessageOffset, serializedMessageLength, serializedMetadata, serializedMetadataOffset, serializedMetadataLength, topic, this.descriptor.getChannelQos(), flags);
                    bl = true;
                    if (!serializedMessageIsDetached) break block35;
                }
                catch (Throwable throwable) {
                    if (serializedMessageIsDetached) {
                        serializedMessage.dispose();
                    }
                    throw throwable;
                }
                serializedMessage.dispose();
            }
            return bl;
        }
        finally {
            if (metadata != null) {
                metadata.dispose();
            }
        }
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter on channel '" + this.getName() + "' but binding '" + this.binding.getName() + "' configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter on channel '" + this.getName() + "' but binding '" + this.binding.getName() + "'  configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
        this.binding.onChannelClose(this);
    }

    public final String getType() {
        return "Solace";
    }
}

