/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.protobuf.adm;

import com.github.os72.protocjar.Protoc;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.EAdmException;
import com.neeve.adm.IAdmGenerator;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.config.Config;
import com.neeve.protobuf.adm.ProtobufAdmFactoryGenerator;
import com.neeve.protobuf.adm.ProtobufAdmNodeGenerator;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlThrowable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;

public final class ProtobufAdmGenerator
implements IAdmGenerator {
    private final String name;
    private final Tracer tracer;
    private final File resolvedIdlTempDir;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
    private final ProtobufAdmFactoryGenerator factoryGenerator;
    private final ProtobufAdmNodeGenerator nodeGenerator;
    private File googleDescriptorIDLFile;
    private File googleDescriptorIDLFileBaseDir;
    private File admTypesIDLFile;
    private File admTypesIDLFileBaseDir;
    public static final String NAME = "protobuf";

    private ProtobufAdmGenerator(String name) {
        this.name = name;
        this.tracer = Tracer.get((String)"nv.adm");
        this.resolvedIdlTempDir = new File(System.getProperty("user.home") + File.separator + ".nvx" + File.separator + "adm" + File.separator + "protoc" + File.separator + UUID.randomUUID().toString());
        this.factoryGenerator = new ProtobufAdmFactoryGenerator();
        this.nodeGenerator = new ProtobufAdmNodeGenerator();
    }

    public static final IAdmGenerator create(String name) throws EAdmException {
        return new ProtobufAdmGenerator(name);
    }

    private final File getBaseDirFromAbsolute(AdmModel model, File outdir) throws EAdmException {
        return this.getBaseDirFromResourceDirectory(model.getNamespace(), outdir);
    }

    private final File getBaseDirFromResourceDirectory(String namespace, File directory) throws EAdmException {
        File baseDir = directory.getAbsoluteFile();
        StringTokenizer tok = new StringTokenizer(namespace, ".");
        int packageLevels = tok.countTokens();
        if (!baseDir.getAbsolutePath().endsWith(namespace.replace('.', File.separatorChar))) {
            throw new EAdmException("Output directory does not match namespace: " + baseDir + " doesn't correspond to " + namespace);
        }
        for (int i = 0; i < packageLevels; ++i) {
            baseDir = baseDir.getParentFile();
        }
        return baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File resolveImportedIdl(AdmModel model, String namespace, String protobufOuterClassName, File outDir, File resolveDir) throws Exception {
        File resolved;
        String protoResourcePath;
        block34: {
            protoResourcePath = namespace.replace('.', '/') + "/" + protobufOuterClassName + ".proto";
            if (this.tracer.debug) {
                this.tracer.log("Resolving protobuf idl: " + protoResourcePath, Tracer.Level.DEBUG);
            }
            resolved = null;
            URL url = this.getClass().getClassLoader().getResource(protoResourcePath);
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource(protoResourcePath);
            }
            if (url == null && model.getExternalProtoDirs() != null) {
                for (File ext : model.getExternalProtoDirs()) {
                    if (!ext.isDirectory()) {
                        throw new IllegalArgumentException("External protodir '" + ext + "' is not a directory");
                    }
                    resolved = new File(ext, protoResourcePath);
                    if (resolved.exists()) continue;
                    resolved = null;
                }
            }
            if (resolved == null && url == null && this.resolvedIdlTempDir.exists() && this.resolvedIdlTempDir.isDirectory() && !(resolved = new File(this.resolvedIdlTempDir, protoResourcePath)).exists()) {
                resolved = null;
            }
            if (outDir != null && resolved == null && url == null && !(resolved = new File(outDir, protoResourcePath)).exists()) {
                resolved = null;
            }
            if (url != null) {
                if (this.tracer.debug) {
                    this.tracer.log("Resolved protobuf idl: " + url, Tracer.Level.DEBUG);
                }
                if (!url.toURI().toString().contains(".jar!") && url.toURI().getScheme().equals("file")) {
                    resolved = new File(url.toURI());
                    if (!resolved.exists()) {
                        resolved = null;
                    }
                } else {
                    if (this.tracer.debug) {
                        this.tracer.log("Extracting protobuf idl: " + url + " to " + resolveDir, Tracer.Level.DEBUG);
                    }
                    if (resolveDir != null) {
                        resolved = new File(resolveDir, protoResourcePath);
                        try {
                            URLConnection c = url.openConnection();
                            long embeddedTimestamp = c.getLastModified();
                            boolean extract = true;
                            if (!resolved.exists()) {
                                resolved.getParentFile().mkdirs();
                                resolved.createNewFile();
                            } else {
                                if (this.tracer.debug) {
                                    this.tracer.log("Source idl last modified : " + new Date(embeddedTimestamp), Tracer.Level.DEBUG);
                                }
                                if (this.tracer.debug) {
                                    this.tracer.log("Target idl last modified : " + new Date(resolved.lastModified()), Tracer.Level.DEBUG);
                                }
                                if (resolved.lastModified() < embeddedTimestamp) {
                                    if (this.tracer.debug) {
                                        this.tracer.log("Overwriting stale idl " + resolved.toString() + "(" + new Date(resolved.lastModified()) + " older than " + new Date(embeddedTimestamp), Tracer.Level.DEBUG);
                                    }
                                    resolved.delete();
                                    for (int i = 0; resolved.exists() && i < 5; ++i) {
                                        Thread.sleep(1000L);
                                        resolved.delete();
                                    }
                                    resolved.createNewFile();
                                } else {
                                    extract = false;
                                }
                            }
                            if (!extract) break block34;
                            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(resolved));
                                 BufferedInputStream bis = new BufferedInputStream(url.openStream());){
                                int b;
                                while ((b = bis.read()) != -1) {
                                    bos.write(b);
                                }
                                bos.flush();
                            }
                            resolved.setLastModified(embeddedTimestamp);
                        }
                        catch (IOException ioe) {
                            throw new Exception("There was an error extracting proto file '" + url + "': " + ioe.getMessage(), ioe);
                        }
                    }
                }
            }
        }
        if (resolved == null) {
            this.tracer.log("Failed to resolve protobuf idl: " + protoResourcePath, Tracer.Level.WARNING);
        } else if (this.tracer.debug) {
            this.tracer.log("Resolved " + resolved, Tracer.Level.DEBUG);
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File generateProtobufIDL(AdmModel model, File outdir, File importedIdlOutputFolder, File modelBundleOutputDirectory, boolean absolute) throws Exception {
        File file;
        PrintWriter writer = null;
        String idlFilename = model.getProtobufOuterClassName() + ".proto";
        File idlFile = null;
        String idlOutputDir = absolute ? outdir.getAbsolutePath() : outdir + File.separator + model.getNamespace().replace(".", File.separator);
        String idlFullFilename = idlOutputDir + File.separator + idlFilename;
        idlFile = new File(idlFullFilename);
        if (!idlFile.exists()) {
            idlFile.getParentFile().mkdirs();
            idlFile.createNewFile();
        }
        writer = new PrintWriter(idlFullFilename);
        try {
            Collection imports;
            writer.println("// ****************************************************************************");
            writer.println("// ******** THIS FILE WAS GENERATED BY RUMI CODE GENERATION TOOLS *************");
            writer.println("// ******** ON " + String.format("%-56s", dateFormat.format(new Date())) + "***");
            writer.println("// ****************************************************************************");
            if (model.getNamespace() != null) {
                writer.println("package " + model.getNamespace() + ";");
            }
            if ((imports = model.getModelImports()).size() > 0) {
                String importPath;
                AdmModel importedModel;
                HashSet<String> included = new HashSet<String>();
                writer.println("");
                for (AdmModelImport modelImport : imports) {
                    importedModel = modelImport.getModel();
                    importPath = importedModel.getNamespace().replace(".", "/") + "/" + importedModel.getProtobufOuterClassName();
                    included.add(importPath);
                    if (this.tracer.debug) {
                        this.tracer.log("Adding import idl " + importPath, Tracer.Level.DEBUG);
                    }
                    writer.println("import \"" + importPath + ".proto\";");
                }
                for (AdmModelImport modelImport : model.getTransitiveFieldImportModels().values()) {
                    importedModel = modelImport.getModel();
                    importPath = importedModel.getNamespace().replace(".", "/") + "/" + importedModel.getProtobufOuterClassName();
                    if (!included.contains(importPath)) {
                        if (this.tracer.debug) {
                            this.tracer.log("Adding transitively imported idl " + importPath, Tracer.Level.INFO);
                        }
                        writer.println("import \"" + importPath + ".proto\";");
                        continue;
                    }
                    if (!this.tracer.debug) continue;
                    this.tracer.log("Skipping transitively imported idl " + importPath + " (already declared)", Tracer.Level.INFO);
                }
            }
            writer.println("import \"com/neeve/adm/types/protobuf/AdmTypes.proto\";");
            Iterator enumIterator = model.getEnumerations().iterator();
            while (enumIterator.hasNext()) {
                writer.println("");
                ((AdmEnumeration)enumIterator.next()).generateProtobufIDL(writer);
            }
            Iterator messageIterator = model.getMessages().iterator();
            while (messageIterator.hasNext()) {
                writer.println("");
                this.nodeGenerator.generateProtobufIDL((AdmEntity)messageIterator.next(), writer);
            }
            Iterator entityIterator = model.getEntities().iterator();
            while (entityIterator.hasNext()) {
                writer.println("");
                this.nodeGenerator.generateProtobufIDL((AdmEntity)entityIterator.next(), writer);
            }
            Iterator collIterator = model.getCollections().iterator();
            while (collIterator.hasNext()) {
                writer.println("");
                this.nodeGenerator.generateProtobufIDL((AdmCollection)collIterator.next(), writer);
            }
            file = idlFile;
            writer.close();
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                if (model.getProtobufIDLOutputDir() != null) {
                    File target = new File(model.getProtobufIDLOutputDir() + File.separator + model.getNamespace().replace(".", File.separator), idlFile.getName());
                    if (!target.getParentFile().exists()) {
                        target.getParentFile().mkdirs();
                    }
                    UtlFile.copyFile((File)idlFile, (File)target);
                }
                if (modelBundleOutputDirectory != null) {
                    UtlFile.copyFileWithNamespaceToDirectory((File)idlFile, (File)modelBundleOutputDirectory, (String)model.getNamespace(), (String)idlFilename);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new EAdmException("Failed to create protobuf IDL file '" + idlFilename + "' [" + e.toString() + "]", (Throwable)e);
            }
        }
        if (model.getProtobufIDLOutputDir() != null) {
            File target = new File(model.getProtobufIDLOutputDir() + File.separator + model.getNamespace().replace(".", File.separator), idlFile.getName());
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            UtlFile.copyFile((File)idlFile, (File)target);
        }
        if (modelBundleOutputDirectory != null) {
            UtlFile.copyFileWithNamespaceToDirectory((File)idlFile, (File)modelBundleOutputDirectory, (String)model.getNamespace(), (String)idlFilename);
        }
        return file;
    }

    private final File generateOrResolveProtobufIDL(AdmModel model, File outdir, File importedIdlOutputFolder, File modelBundleOutputDirectory, boolean absolute, boolean skipExisting, boolean skipResolve) throws Exception {
        String idlFilename = model.getProtobufOuterClassName() + ".proto";
        File idlFile = null;
        try {
            Object target;
            if (!skipResolve) {
                idlFile = this.resolveImportedIdl(model, model.getNamespace(), model.getProtobufOuterClassName(), outdir, importedIdlOutputFolder);
            }
            if (idlFile == null || !skipExisting) {
                idlFile = this.generateProtobufIDL(model, outdir, importedIdlOutputFolder, modelBundleOutputDirectory, absolute);
            } else if (modelBundleOutputDirectory != null && !((File)(target = UtlFile.newFileWithNamespace((File)modelBundleOutputDirectory, (String)model.getNamespace(), (String)(model.getProtobufOuterClassName() + ".proto")))).exists()) {
                if (!((File)target).getParentFile().exists()) {
                    ((File)target).getParentFile().mkdirs();
                }
                UtlFile.copyFile((File)idlFile, (File)target);
            }
            for (AdmModelImport modelImport : model.getModelImports()) {
                this.generateOrResolveProtobufIDL(modelImport.getModel(), outdir, importedIdlOutputFolder, modelBundleOutputDirectory, absolute, true, false);
            }
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create protobuf IDL file '" + idlFilename + "' [" + e.toString() + "]", (Throwable)e);
        }
        return idlFile;
    }

    private final Collection<File> recursivelyResolveRawImportedIdl(AdmModel model, File protoImport, File outDir, File targetDir, Set<String> alreadyResolved) {
        HashSet<File> rc = new HashSet<File>();
        if (alreadyResolved == null) {
            alreadyResolved = new HashSet<String>();
        }
        IdlParser parsed = null;
        try {
            parsed = new IdlParser(protoImport);
            if (alreadyResolved.contains(parsed.qualifiedName)) {
                return rc;
            }
            alreadyResolved.add(parsed.qualifiedName);
            File importBaseDir = this.getBaseDirFromResourceDirectory(parsed.packageName, protoImport.getParentFile());
            this.tracer.log("Resolved raw imported idl from '" + protoImport + "' base: '" + importBaseDir + "'", Tracer.Level.DEBUG);
            rc.add(importBaseDir);
        }
        catch (Throwable thrown) {
            this.tracer.log("Failed to parse imported proto for " + protoImport + ": " + thrown.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            return rc;
        }
        for (String nestedImport : parsed.imports) {
            if (nestedImport == null || nestedImport.startsWith("com/neeve/adm/types/protobuf/AdmTypes") || nestedImport.startsWith("google/protobuf/descriptor")) continue;
            int packageDelim = nestedImport.lastIndexOf("/");
            String importNamespace = "";
            String importModelName = "";
            if (packageDelim >= 0) {
                importNamespace = nestedImport.substring(0, packageDelim);
                importModelName = nestedImport.substring(packageDelim + 1);
                if (importModelName.endsWith(".proto")) {
                    importModelName = importModelName.substring(0, importModelName.length() - 6);
                }
            } else {
                importModelName = nestedImport;
            }
            try {
                File nestedProto = this.resolveImportedIdl(model, importNamespace, importModelName, outDir, targetDir);
                if (nestedProto != null) {
                    rc.addAll(this.recursivelyResolveRawImportedIdl(model, nestedProto, outDir, targetDir, alreadyResolved));
                    continue;
                }
                this.tracer.log("Failed to resolve raw imported idl from '" + nestedImport + "'", Tracer.Level.WARNING);
            }
            catch (Exception e) {
                this.tracer.log("Failed to resolved nested raw import proto '" + nestedImport + "': " + e.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
        return rc;
    }

    private final Collection<File> recursivelyResolveImportIdl(AdmModel model, File outDir, File targetDir, Set<String> alreadyResolved) throws Exception {
        HashSet<File> rc = new HashSet<File>();
        this.tracer.log("Resolving imported idl for " + model.getNamespace().replace('.', '/') + "/" + model.getProtobufOuterClassName() + ".proto", Tracer.Level.DEBUG);
        File proto = this.resolveImportedIdl(model, model.getNamespace(), model.getProtobufOuterClassName(), outDir, targetDir);
        if (proto != null) {
            File importBaseDir = this.getBaseDirFromAbsolute(model, proto.getParentFile());
            this.tracer.log("Resolved '" + proto + "' base: '" + importBaseDir + "'", Tracer.Level.DEBUG);
            rc.add(importBaseDir);
            if (alreadyResolved == null) {
                alreadyResolved = new HashSet<String>();
            }
            rc.addAll(this.recursivelyResolveRawImportedIdl(model, proto, outDir, targetDir, alreadyResolved));
        } else {
            System.err.println("WARN: Couldn't find imported protobuf file: " + model.getNamespace().replace('.', '/') + "/" + model.getProtobufOuterClassName() + ".proto");
        }
        return rc;
    }

    private final ProtobufIDLGenerationInfo doProtobufIDLGeneration(AdmModel model, File outdir, boolean absolute) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log("Generating protobuf IDL to '" + outdir.getAbsolutePath() + "...", Tracer.Level.DEBUG);
        }
        ProtobufIDLGenerationInfo ret = new ProtobufIDLGenerationInfo();
        ret.importedIdlOutputFolder = outdir;
        if (!model.isCopyImportedProtosToOutputDir()) {
            File tempFile = File.createTempFile("admtemp", Long.toString(System.nanoTime()));
            tempFile.deleteOnExit();
            tempFile.delete();
            ret.importIdlTempFolder = new File(tempFile.getParentFile(), "adm" + Long.toString(System.nanoTime()));
            if (!ret.importIdlTempFolder.mkdirs()) {
                this.tracer.log("Failed to create temporary idl output folder: " + ret.importIdlTempFolder, Tracer.Level.WARNING);
            } else {
                ret.importedIdlOutputFolder = ret.importIdlTempFolder;
            }
        }
        File modelBundleOutputDirectory = (File)model.getDirectives().getValue("modelBundleOutputDir");
        ret.idlFullFilename = this.generateOrResolveProtobufIDL(model, outdir, ret.importedIdlOutputFolder, modelBundleOutputDirectory, absolute, false, true).getAbsolutePath();
        return ret;
    }

    private final void resolveCommonIDLFiles(AdmModel model, File outDir) throws Exception {
        if (this.googleDescriptorIDLFileBaseDir == null) {
            this.googleDescriptorIDLFile = this.resolveImportedIdl(model, "google.protobuf", "descriptor", outDir, this.resolvedIdlTempDir);
            if (this.googleDescriptorIDLFile != null) {
                this.googleDescriptorIDLFileBaseDir = this.getBaseDirFromResourceDirectory("google.protobuf", this.googleDescriptorIDLFile.getParentFile());
            } else {
                throw new Exception("Failed to resolve google.protobuf.descripto.proto");
            }
        }
        if (this.admTypesIDLFileBaseDir == null) {
            this.admTypesIDLFile = this.resolveImportedIdl(model, "com.neeve.adm.types.protobuf", "AdmTypes", outDir, this.resolvedIdlTempDir);
            if (this.admTypesIDLFile != null) {
                this.admTypesIDLFileBaseDir = this.getBaseDirFromResourceDirectory("com.neeve.adm.types.protobuf", this.admTypesIDLFile.getParentFile());
            } else {
                throw new Exception("Failed to resolve com.neeve.adm.types.protobuf.AdmTypes.proto");
            }
        }
    }

    private final void copyCommonIDLFilesToBundleDir(AdmModel model) throws Exception {
        File modelBundleOutputDirectory = (File)AdmModel.DIRECTIVE_DEFINITIONS.getValue("modelBundleOutputDir");
        if (modelBundleOutputDirectory != null) {
            File admTypesTargetIDL;
            File descriptorTargetIDL = UtlFile.newFileWithNamespace((File)modelBundleOutputDirectory, (String)"google.protobuf", (String)"descriptor.proto");
            if (!descriptorTargetIDL.exists()) {
                if (!descriptorTargetIDL.getParentFile().exists()) {
                    descriptorTargetIDL.getParentFile().mkdirs();
                }
                UtlFile.copyFile((File)this.googleDescriptorIDLFile, (File)descriptorTargetIDL);
            }
            if (!(admTypesTargetIDL = UtlFile.newFileWithNamespace((File)modelBundleOutputDirectory, (String)"com.neeve.adm.types.protobuf", (String)"AdmTypes.proto")).exists()) {
                if (!admTypesTargetIDL.getParentFile().exists()) {
                    admTypesTargetIDL.getParentFile().mkdirs();
                }
                UtlFile.copyFile((File)this.admTypesIDLFile, (File)admTypesTargetIDL);
            }
        }
    }

    private final List<String> buildProtocCommand(AdmModel model, String idlFullFilename, File importedIdlOutputFolder, File baseDir, File outDir, boolean absolute) throws Exception {
        boolean useBundledProtoc;
        LinkedList<String> command = new LinkedList<String>();
        boolean bl = useBundledProtoc = model.isUseBundledProtoc() && Config.getValue((String)"nvx.adm.codegen.protoc.path") == null;
        if (!useBundledProtoc) {
            String protocPath = Config.getValue((String)"nvx.adm.codegen.protoc.path", null);
            command.add(protocPath == null ? "protoc" : protocPath + File.separator + "protoc");
        }
        command.add("--java_out=" + outDir.getAbsolutePath());
        HashSet<File> pathFiles = new HashSet<File>();
        if (absolute) {
            File absOutDir = new File(idlFullFilename).getParentFile();
            command.add("--proto_path=" + absOutDir.getAbsolutePath());
            pathFiles.add(absOutDir);
        }
        if (!pathFiles.contains(baseDir)) {
            command.add("--proto_path=" + baseDir.getAbsolutePath());
            pathFiles.add(baseDir);
        }
        if (!model.getModelImports().isEmpty()) {
            HashSet<String> alreadyResolved = new HashSet<String>();
            for (AdmModelImport modelImport : model.getModelImports()) {
                for (File importDir : this.recursivelyResolveImportIdl(modelImport.getModel(), outDir, importedIdlOutputFolder, alreadyResolved)) {
                    if (pathFiles.contains(importDir)) continue;
                    command.add("--proto_path=" + importDir);
                    pathFiles.add(importDir);
                }
            }
        }
        if (model.getExternalProtoDirs() != null) {
            for (File ext : model.getExternalProtoDirs()) {
                if (!ext.isDirectory()) {
                    throw new IllegalArgumentException("External protodir '" + ext + "' is not a directory");
                }
                if (pathFiles.contains(ext)) continue;
                command.add("--proto_path=" + ext.getAbsolutePath());
                pathFiles.add(ext);
            }
        }
        if (this.googleDescriptorIDLFileBaseDir != null && !pathFiles.contains(this.googleDescriptorIDLFileBaseDir)) {
            command.add("--proto_path=" + this.googleDescriptorIDLFileBaseDir.getAbsolutePath());
            pathFiles.add(this.googleDescriptorIDLFileBaseDir);
        }
        if (this.admTypesIDLFileBaseDir != null && !pathFiles.contains(this.admTypesIDLFileBaseDir)) {
            command.add("--proto_path=" + this.admTypesIDLFileBaseDir.getAbsolutePath());
            pathFiles.add(this.admTypesIDLFileBaseDir);
        }
        command.add(idlFullFilename);
        return command;
    }

    private final void doProtobufGeneration(AdmModel model, File baseDir, File outDir, boolean absolute) throws Exception {
        File importIdlTempFolder;
        if (this.googleDescriptorIDLFileBaseDir == null || this.admTypesIDLFileBaseDir == null) {
            this.resolveCommonIDLFiles(model, outDir);
        }
        ProtobufIDLGenerationInfo idlGenerationInfo = this.doProtobufIDLGeneration(model, outDir, absolute);
        File importedIdlOutputFolder = idlGenerationInfo.importedIdlOutputFolder;
        String idlFullFilename = idlGenerationInfo.idlFullFilename;
        List<String> command = this.buildProtocCommand(model, idlFullFilename, importedIdlOutputFolder, baseDir, outDir, absolute);
        if (!model.isUseBundledProtoc()) {
            String line;
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (!this.tracer.debug) continue;
                this.tracer.log("[protoc output]" + line, Tracer.Level.DEBUG);
            }
        } else {
            int exitCode = Protoc.runProtoc((String[])command.toArray(new String[0]));
            if (exitCode != 0) {
                StringBuilder protocCommand = new StringBuilder();
                for (String str : command) {
                    protocCommand.append(str).append(" ");
                }
                this.tracer.log("protoc generation returned with error code " + exitCode + ". Command issued was:\n" + protocCommand, Tracer.Level.SEVERE);
                if (model.getModelBuildErrorAggregator() != null) {
                    model.getModelBuildErrorAggregator().add("protoc generation returned with error code " + exitCode + ". Command issued was:\n" + protocCommand, CgSourceCodeErrorAggregator.Severity.ERROR, model.getCodeSource(), null);
                }
            }
        }
        if (absolute && model.getNamespace() != null) {
            String idlName = model.getProtobufOuterClassName();
            File genFile = AdmModel.resolveAbsoluteClassFile((File)outDir, (String)model.getNamespace(), (String)idlName);
            UtlFile.copyFile((File)genFile, (File)AdmModel.resolveAbsoluteClassFile((File)outDir, null, (String)idlName));
            genFile.delete();
        }
        if ((importIdlTempFolder = idlGenerationInfo.importIdlTempFolder) != null && importIdlTempFolder.exists()) {
            UtlFile.deleteDirectory((File)importIdlTempFolder);
        }
    }

    private final boolean generatePacketTypePerObjectType(String encodingType) {
        return encodingType.equalsIgnoreCase("xbuf") || encodingType.equalsIgnoreCase("xbuf2");
    }

    public final String getName() {
        return this.name;
    }

    public final short getMaxFieldId() {
        return Short.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateClasses(AdmModel model, File outdir, boolean absolute, boolean generateArrayGetterEmptyIfNull) throws Exception {
        try {
            this.resolveCommonIDLFiles(model, outdir);
            if (model.getBooleanDirective("generateProtobufClasses")) {
                this.doProtobufGeneration(model, absolute ? this.getBaseDirFromAbsolute(model, outdir) : outdir, outdir, absolute);
            } else {
                this.doProtobufIDLGeneration(model, outdir, absolute);
            }
            String encodingType = model.getStringDirective("encodingType");
            boolean packetTypePerObjectType = this.generatePacketTypePerObjectType(encodingType);
            this.tracer.log("Generating class files (" + this.getName() + ") to '" + outdir.getAbsolutePath() + "' (absolute=" + absolute + ")...", Tracer.Level.INFO);
            for (AdmFactory factory : model.getFactories()) {
                AdmSourceCodeBuilder codeBuilder = factory.startClassGeneration(encodingType, packetTypePerObjectType);
                this.factoryGenerator.generateClass(factory, codeBuilder);
                factory.completeClassGeneration(codeBuilder, outdir, absolute);
            }
            Iterator enumIterator = model.getEnumerations().iterator();
            while (enumIterator.hasNext()) {
                ((AdmEnumeration)enumIterator.next()).generateClass(outdir, absolute);
            }
            for (AdmCollection collection : model.getCollections()) {
                AdmSourceCodeBuilder codeBuilder = collection.startClassGeneration();
                this.nodeGenerator.generateClass(collection, encodingType, codeBuilder);
                collection.completeClassGeneration(codeBuilder, outdir, absolute);
            }
            for (AdmMessage message : model.getMessages()) {
                AdmSourceCodeBuilder codeBuilder = message.startClassGeneration();
                this.nodeGenerator.generateClass((AdmEntity)message, encodingType, generateArrayGetterEmptyIfNull, packetTypePerObjectType, codeBuilder);
                message.completeClassGeneration(codeBuilder, outdir, absolute);
            }
            for (AdmEntity entity : model.getEntities()) {
                AdmSourceCodeBuilder codeBuilder = entity.startClassGeneration();
                this.nodeGenerator.generateClass(entity, encodingType, generateArrayGetterEmptyIfNull, packetTypePerObjectType, codeBuilder);
                entity.completeClassGeneration(codeBuilder, outdir, absolute);
            }
            this.copyCommonIDLFilesToBundleDir(model);
        }
        finally {
            try {
                UtlFile.deleteDirectory((File)this.resolvedIdlTempDir);
            }
            catch (Throwable e) {
                this.tracer.log("Failed to delete resolved IDL temp dir (" + this.resolvedIdlTempDir + "): " + e.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
    }

    private final class ProtobufIDLGenerationInfo {
        File importIdlTempFolder;
        File importedIdlOutputFolder;
        String idlFullFilename;

        private ProtobufIDLGenerationInfo() {
        }
    }

    private final class IdlParser {
        String qualifiedName;
        String packageName;
        String modelName;
        HashSet<String> imports = new HashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IdlParser(File idlFile) throws IOException {
            this.modelName = idlFile.getName();
            if (this.modelName.endsWith(".proto")) {
                this.modelName = this.modelName.substring(0, this.modelName.length() - 6);
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(idlFile));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("package")) {
                        this.packageName = line.substring("package".length());
                        this.packageName = this.packageName.trim();
                        this.packageName = this.packageName.substring(0, this.packageName.length() - 1);
                        continue;
                    }
                    if (!line.startsWith("import")) continue;
                    String importName = line.substring("import".length());
                    importName = importName.trim();
                    importName = importName.substring(0, importName.length() - 1);
                    while (importName.startsWith("\"") && importName.endsWith("\"")) {
                        importName = importName.substring(1, importName.length() - 1);
                    }
                    this.imports.add(importName);
                }
            }
            if (this.packageName == null) {
                this.packageName = "";
                this.qualifiedName = this.modelName;
            } else {
                this.qualifiedName = this.packageName + "." + this.modelName;
            }
            ProtobufAdmGenerator.this.tracer.log("Parsed import idl '" + idlFile + "' qualifiedName: " + this.qualifiedName + ", imports: " + this.imports, Tracer.Level.DEBUG);
        }
    }
}

