/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.protobuf.adm;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmSourceCodeBuilder;
import java.util.Iterator;

public final class ProtobufAdmFactoryGenerator {
    private final void writeObjectFactoryMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmEntity) {
            AdmEntity entity = (AdmEntity)type;
            codeBuilder.last().appendln("    final private static ThreadLocal<" + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument> _" + AdmGenerator.toFirstLetterLowercase((String)entity.getName()) + "PoolGetArgument = new ThreadLocal<" + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument>() {");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final protected " + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument initialValue() {");
            codeBuilder.last().appendln("            return new " + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    };");
        }
        if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(int, id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + "." + type.getName() + "PoolFactoryItemCreateArgument arg = _" + AdmGenerator.toFirstLetterLowercase((String)type.getName()) + "PoolGetArgument.get();");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = " + type.getName() + "._entityPool.get(arg.init(id));");
            codeBuilder.last().appendln("        if (!arg.wasCreated) val.undispose(id);");
            codeBuilder.last().appendln("        if (grid >= 0) {");
            codeBuilder.last().appendln("            val.setGraphId(grid);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return val;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid) {");
            if (type instanceof AdmMessage) {
                codeBuilder.last().appendln("        return create" + type.getName() + "(grid, null);");
            } else {
                codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = create" + type.getName() + "(grid, null);");
                codeBuilder.last().appendln("        val.ensureOId();");
                codeBuilder.last().appendln("        return val;");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        } else if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(id);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(new %{com.eaio.uuid.UUID}());");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + "." + type.getName() + "PoolFactoryItemCreateArgument arg = _" + AdmGenerator.toFirstLetterLowercase((String)type.getName()) + "PoolGetArgument.get();");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = " + type.getName() + "._entityPool.get(arg.init(id));");
            codeBuilder.last().appendln("        if (!arg.wasCreated) val.undispose(id);");
            codeBuilder.last().appendln("        return val;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            if (type instanceof AdmMessage) {
                codeBuilder.last().appendln("        return create" + type.getName() + "(null);");
            } else {
                codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = create" + type.getName() + "(null);");
                codeBuilder.last().appendln("        val.ensureOId();");
                codeBuilder.last().appendln("        return val;");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        }
    }

    final void writeObjectFactoryMethods(AdmFactory factory, AdmSourceCodeBuilder codeBuilder) {
        Iterator iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
            this.writeObjectFactoryMethods(type, codeBuilder);
            if (!iterator.hasNext()) continue;
            codeBuilder.last().appendln("");
        }
    }

    final void writeIStoreObjectFactoryMethods(AdmFactory factory, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.ods.IStoreObjectFactory}#getOfid}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public short getOfid() {");
        codeBuilder.last().appendln("        return OFID;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.ods.IStoreObjectFactory}#create}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.ods.IStoreObject} create(final short type,");
        codeBuilder.last().appendln("                                                      final %{com.eaio.uuid.UUID} id,");
        codeBuilder.last().appendln("                                                      final %{com.neeve.ods.IStoreObject}.EncodingType encodingType,");
        codeBuilder.last().appendln("                                                      final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            switch (encodingType) {");
        codeBuilder.last().appendln("                case Protobuf:");
        codeBuilder.last().appendln("                case Xbuf:");
        codeBuilder.last().appendln("                case Xbuf2:");
        codeBuilder.last().appendln("                    switch (type) {");
        Iterator iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
            codeBuilder.last().appendln("                        case ID_" + type.getName() + ":");
            if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
                codeBuilder.last().appendln("                            return create" + type.getName() + "(-1, id).deserialize(packet);");
            } else {
                codeBuilder.last().appendln("                            return create" + type.getName() + "(id).deserialize(packet);");
            }
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                        default:");
        codeBuilder.last().appendln("                            throw new RuntimeException(\"unknown object type: \" + type);");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("                default:");
        codeBuilder.last().appendln("                    throw new RuntimeException(\"unknown encoding type: \" + encodingType);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    final void writeMessageViewFactoryMethods(AdmFactory factory, AdmSourceCodeBuilder codeBuilder) {
        AdmFactoryType type;
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.sma.MessageViewFactory}#getVfid}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public short getVfid() {");
        codeBuilder.last().appendln("        return VFID;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.sma.MessageViewFactory}#create}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.sma.MessageView} create(final short type) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            switch (type) {");
        Iterator iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                case ID_" + type.getName() + ":");
            codeBuilder.last().appendln("                    return create" + type.getName() + "();");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                default:");
        codeBuilder.last().appendln("                    throw new RuntimeException(\"unknown messsage type: \" + type);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.sma.MessageViewFactory}#wrap}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.sma.MessageView} wrap(final short type, final int encodingType, final Object message) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            switch (encodingType) {");
        codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF:");
        codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF:");
        codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF2:");
        codeBuilder.last().appendln("                    if (message instanceof %{com.neeve.io.IONativePacket}) {");
        codeBuilder.last().appendln("                        switch (type) {");
        iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
            codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom(((%{com.neeve.io.IONativePacket})message).addr, ((%{com.neeve.io.IONativePacket})message).offset, ((%{com.neeve.io.IONativePacket})message).length);");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                            default:");
        codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
        codeBuilder.last().appendln("                        }");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                    else if (message instanceof %{com.neeve.io.IOBufferPacket}) {");
        codeBuilder.last().appendln("                        switch (type) {");
        iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
            codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom(((%{com.neeve.io.IOBufferPacket})message).buf, ((%{com.neeve.io.IOBufferPacket})message).offset, ((%{com.neeve.io.IOBufferPacket})message).length);");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                            default:");
        codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
        codeBuilder.last().appendln("                        }");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                    else if (message instanceof %{com.neeve.pkt.PktPacket}) {");
        codeBuilder.last().appendln("                        switch (type) {");
        iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
            codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom((%{com.neeve.pkt.PktPacket})message);");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                            default:");
        codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
        codeBuilder.last().appendln("                        }");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                    else if (message instanceof byte[]) {");
        codeBuilder.last().appendln("                        switch (type) {");
        iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
            codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom((byte[])message, 0, ((byte[])message).length);");
            codeBuilder.last().appendln("                            }");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                            default:");
        codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
        codeBuilder.last().appendln("                        }");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                    else if (message instanceof %{java.nio.ByteBuffer}) {");
        codeBuilder.last().appendln("                        switch (type) {");
        iterator = factory.typeIterator();
        while (iterator.hasNext()) {
            type = (AdmFactoryType)iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
            codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom((%{java.nio.ByteBuffer})message);");
            codeBuilder.last().appendln("                            }");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                            default:");
        codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
        codeBuilder.last().appendln("                        }");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                    else {");
        codeBuilder.last().appendln("                        throw new RuntimeException(\"unsupported serialized form '\" + message.getClass().getName() + \"' for XBUF encoded message\");");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("                default:");
        codeBuilder.last().appendln("                    throw new RuntimeException(\"unknown encoding type: \" + encodingType);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    final void generateClass(AdmFactory factory, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("");
        this.writeObjectFactoryMethods(factory, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeIStoreObjectFactoryMethods(factory, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeMessageViewFactoryMethods(factory, codeBuilder);
    }
}

