/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.emx.EmxNwLnkNonBlockingReader;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.io.IOBuffer;
import com.neeve.perf.common.SystemProperties;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;

@AnnotatedCommand.Command(keywords={"NonBlockingStreamingReceiver"}, description="A non-blocking receiver to test streaming performance")
public class NonBlockingStreamingReceiver
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=109, longForm="messageSize", defaultValue="256", required=true, description="The size of the message being streamed")
    private int _messageSize;
    @AnnotatedCommand.Option(shortForm=99, longForm="cpuAffinityMask", description="the CPU() to affinitize the reading thread to")
    private String _cpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=115, longForm="stats", defaultValue="false", required=true, description="Whether to output incremental throughput stats")
    private boolean _stats;
    private EmxNwLnkNonBlockingReader reader;

    public void execute() throws Exception {
        SystemProperties.dump();
        EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create((String)this._descriptor, (EmxNwLnkAcceptor.Callback)new AcceptCallback());
        this.reader = EmxNwLnkNonBlockingReader.create((EmxNwLnkReader.Callback)new ReadCallback());
        new ReaderThread().start();
        new Thread((Runnable)acceptor).run();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
        new NonBlockingStreamingReceiver().run(args);
    }

    private final class ReaderThread
    extends Thread {
        ReaderThread() throws Exception {
            super((Runnable)NonBlockingStreamingReceiver.this.reader);
        }

        @Override
        public final void run() {
            if (NonBlockingStreamingReceiver.this._cpuAffinityMask != null) {
                System.out.println("[NonBlockingStreamingReceiver] Affinitizing thread to CPU " + NonBlockingStreamingReceiver.this._cpuAffinityMask);
                UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)NonBlockingStreamingReceiver.this._cpuAffinityMask));
            }
            super.run();
        }
    }

    private final class ReadCallback
    implements EmxNwLnkReader.Callback {
        private long start;
        private long deltaStart;
        private int numRcvd;
        private int deltaNumRcvd;

        private ReadCallback() {
        }

        public final int handleReadData(EmxNwLnk lnk, IOBuffer iobuf, int length) {
            int count = length / NonBlockingStreamingReceiver.this._messageSize;
            if (NonBlockingStreamingReceiver.this._stats) {
                long now = System.currentTimeMillis();
                if (this.start == 0L) {
                    this.start = this.deltaStart = now;
                }
                this.numRcvd += count;
                this.deltaNumRcvd += count;
                if (now - this.deltaStart >= 1000L) {
                    long deltaRate = (long)this.deltaNumRcvd * 1000L / (now - this.deltaStart);
                    long overallRate = (long)this.numRcvd * 1000L / (now - this.start);
                    System.out.println("[NonBlockingStreamingReceiver] RATE [" + deltaRate + "," + overallRate + "]");
                    this.deltaStart = now;
                    this.deltaNumRcvd = 0;
                }
            }
            return NonBlockingStreamingReceiver.this._messageSize * count;
        }

        public final void handleLinkClosure(EmxNwLnk lnk) {
            System.out.println("[NonBlockingStreamingReceiver] Link closed by peer");
        }

        public final void handleLinkFailure(EmxNwLnk lnk, Throwable cause) {
            cause.printStackTrace();
        }
    }

    private final class AcceptCallback
    implements EmxNwLnkAcceptor.Callback {
        private AcceptCallback() {
        }

        public final void handleAcceptedLink(EmxNwLnk link) {
            try {
                System.out.println("Accepted a new connection");
                NonBlockingStreamingReceiver.this.reader.addLink(link);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public final void handleAcceptorFailure(Throwable cause) {
            cause.printStackTrace();
        }
    }
}

