/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import cern.colt.list.BooleanArrayList;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.list.LongArrayList;
import cern.colt.list.ObjectArrayList;
import com.neeve.cli.CliException;
import com.neeve.lang.XCollection;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XLinkedList;
import java.util.Iterator;
import java.util.List;

public class CliParser {
    private final XLinkedHashMap<String, Option> optionsBySwitch = new XLinkedHashMap();
    private final XLinkedList<String> args = new XLinkedList();

    /*
     * Enabled aggressive block sorting
     */
    public void parse(String[] args) throws OptionException {
        this.args.clear();
        Iterator options = ((XCollection)this.optionsBySwitch.values()).iterator();
        while (options.hasNext()) {
            ((Option)options.next()).clear();
        }
        int i = 0;
        while (true) {
            block17: {
                String arg;
                block15: {
                    block12: {
                        Option option;
                        block21: {
                            block18: {
                                block19: {
                                    block20: {
                                        block16: {
                                            int eq;
                                            block14: {
                                                block13: {
                                                    if (i >= args.length) return;
                                                    arg = args[i];
                                                    if (!arg.startsWith("-")) break block12;
                                                    if (!args[i].startsWith("--")) break block13;
                                                    if (arg.equals("--")) {
                                                        for (int j = i + 1; j < args.length; ++j) {
                                                            this.args.add(args[j]);
                                                        }
                                                        return;
                                                    }
                                                    break block14;
                                                }
                                                if (arg.length() <= 2) break block14;
                                                break block15;
                                            }
                                            if ((eq = arg.indexOf(61)) == -1) break block16;
                                            if (eq == 0) {
                                                throw new OptionException("Invalid option '" + arg + "' option name expected before '='");
                                            }
                                            option = this.optionsBySwitch.get(arg.substring(0, eq));
                                            if (option == null) {
                                                throw new OptionException("Unknown option '-" + arg.substring(0, eq) + "'");
                                            }
                                            String value = "";
                                            if (eq + 1 < arg.length()) {
                                                value = arg.substring(eq + 1);
                                            }
                                            option.addValue(value);
                                            break block17;
                                        }
                                        option = this.optionsBySwitch.get(args[i]);
                                        if (option == null) {
                                            throw new OptionException("Unknown option '" + args[i] + "'");
                                        }
                                        if (option.type != OptionType.Boolean) break block18;
                                        if (i + 1 >= args.length) break block19;
                                        String next = args[i + 1];
                                        if (!Boolean.FALSE.toString().equalsIgnoreCase(next) && !Boolean.TRUE.toString().equalsIgnoreCase(next)) break block20;
                                        ++i;
                                        break block21;
                                    }
                                    option.addValue(Boolean.TRUE.toString());
                                    break block17;
                                }
                                option.addValue(Boolean.TRUE.toString());
                                break block17;
                            }
                            ++i;
                        }
                        if (i >= args.length) {
                            throw new OptionException("Value expected after option '" + arg + "'");
                        }
                        option.addValue(args[i]);
                        break block17;
                    }
                    this.args.add(args[i]);
                    break block17;
                }
                for (int p = 1; p < arg.length(); ++p) {
                    char flag = arg.charAt(p);
                    Option option = this.optionsBySwitch.get("-" + flag);
                    if (option == null) {
                        throw new OptionException("Unknown option '-" + flag + "'");
                    }
                    if (option.type != OptionType.Boolean) {
                        throw new OptionException("'-" + flag + "' is not an option flag");
                    }
                    option.addValue(Boolean.TRUE.toString());
                }
            }
            ++i;
        }
    }

    public Object getOptionValue(Option option) {
        return option.getValue();
    }

    public Object getOptionValue(Option option, Object defaultValue) {
        Object value = option.getValue();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public List<Object> getOptionValues(Option option) {
        return option.getValues();
    }

    public String[] getRemainingArgs() {
        return this.args.toArray(new String[0]);
    }

    public BooleanOption addBooleanOption(char shortForm, String longForm) {
        return (BooleanOption)this.registerOption(shortForm, longForm, OptionType.Boolean);
    }

    public BooleanOption addBooleanOption(String longForm) {
        return (BooleanOption)this.registerOption(longForm, OptionType.Boolean);
    }

    public IntegerOption addIntegerOption(char shortForm, String longForm) {
        return (IntegerOption)this.registerOption(shortForm, longForm, OptionType.Integer);
    }

    public IntegerOption addIntegerOption(String longForm) {
        return (IntegerOption)this.registerOption(longForm, OptionType.Integer);
    }

    public DoubleOption addDoubleOption(char shortForm, String longForm) {
        return (DoubleOption)this.registerOption(shortForm, longForm, OptionType.Double);
    }

    public DoubleOption addDoubleOption(String longForm) {
        return (DoubleOption)this.registerOption(longForm, OptionType.Double);
    }

    public StringOption addStringOption(char shortForm, String longForm) {
        return (StringOption)this.registerOption(shortForm, longForm, OptionType.String);
    }

    public LongOption addLongOption(char shortForm, String longForm) {
        return (LongOption)this.registerOption(shortForm, longForm, OptionType.Long);
    }

    public LongOption addLongOption(String longForm) {
        return (LongOption)this.registerOption(longForm, OptionType.Long);
    }

    private Option registerOption(char shortForm, String longForm, OptionType type) {
        Option option = Option.create(shortForm, longForm, type);
        Option existing = this.optionsBySwitch.put("--" + option.longForm, option);
        if (existing != null && existing.shortForm != '\uffffffff') {
            this.optionsBySwitch.remove("-" + existing.shortForm);
        }
        if (shortForm != '\uffffffff' && (existing = this.optionsBySwitch.put("-" + option.shortForm, option)) != null) {
            this.optionsBySwitch.remove("--" + existing.longForm);
        }
        return option;
    }

    private Option registerOption(String longForm, OptionType type) {
        return this.registerOption('\uffff', longForm, type);
    }

    public static final class StringOption
    extends Option {
        private final ObjectArrayList values = new ObjectArrayList();

        StringOption(char shortForm, String longForm) {
            super(shortForm, longForm, OptionType.String);
        }

        @Override
        public final String getValue() {
            return !this.hasValue() ? null : this.getStringValue();
        }

        @Override
        public final boolean hasValue() {
            return this.values.size() > 0;
        }

        public final String getStringValue() {
            if (this.hasValue()) {
                return (String)this.values.get(this.values.size() - 1);
            }
            return null;
        }

        @Override
        public final List<Object> getValues() {
            return this.values.toList();
        }

        public List<String> getStringValues() {
            return this.values.toList();
        }

        @Override
        final void addValue(String value) {
            this.values.add((Object)value);
        }

        @Override
        public void clear() {
            this.values.clear();
        }
    }

    public static final class DoubleOption
    extends Option {
        private final DoubleArrayList values = new DoubleArrayList();

        DoubleOption(char shortForm, String longForm) {
            super(shortForm, longForm, OptionType.Double);
        }

        @Override
        public final Double getValue() {
            return !this.hasValue() ? null : Double.valueOf(this.getDoubleValue());
        }

        @Override
        public final boolean hasValue() {
            return this.values.size() > 0;
        }

        public final double getDoubleValue() {
            if (this.hasValue()) {
                return this.values.get(this.values.size() - 1);
            }
            return -1.0;
        }

        @Override
        public final List<Object> getValues() {
            return this.values.toList();
        }

        public List<Double> getDoubleValues() {
            return this.values.toList();
        }

        @Override
        final void addValue(String value) {
            this.values.add(Double.valueOf(value).doubleValue());
        }

        @Override
        public void clear() {
            this.values.clear();
        }
    }

    public static final class IntegerOption
    extends Option {
        private final IntArrayList values = new IntArrayList();

        IntegerOption(char shortForm, String longForm) {
            super(shortForm, longForm, OptionType.Integer);
        }

        @Override
        public final Object getValue() {
            return !this.hasValue() ? null : Integer.valueOf(this.getIntegerValue());
        }

        @Override
        public final boolean hasValue() {
            return this.values.size() > 0;
        }

        public final int getIntegerValue() {
            if (this.hasValue()) {
                return this.values.get(this.values.size() - 1);
            }
            return -1;
        }

        @Override
        public final List<Object> getValues() {
            return this.values.toList();
        }

        public List<Integer> getIntegerValues() {
            return this.values.toList();
        }

        @Override
        final void addValue(String value) {
            this.values.add(Integer.valueOf(value).intValue());
        }

        @Override
        public void clear() {
            this.values.clear();
        }
    }

    public static final class LongOption
    extends Option {
        private final LongArrayList values = new LongArrayList();

        LongOption(char shortForm, String longForm) {
            super(shortForm, longForm, OptionType.Long);
        }

        @Override
        public final Object getValue() {
            return !this.hasValue() ? null : Long.valueOf(this.getLongValue());
        }

        @Override
        public final boolean hasValue() {
            return this.values.size() > 0;
        }

        public final long getLongValue() {
            if (this.hasValue()) {
                return this.values.get(this.values.size() - 1);
            }
            return -1L;
        }

        @Override
        public final List<Object> getValues() {
            return this.values.toList();
        }

        public List<Long> getLongValues() {
            return this.values.toList();
        }

        @Override
        final void addValue(String value) {
            this.values.add(Long.valueOf(value).longValue());
        }

        @Override
        public void clear() {
            this.values.clear();
        }
    }

    public static final class BooleanOption
    extends Option {
        private final BooleanArrayList values = new BooleanArrayList();

        BooleanOption(char shortForm, String longForm) {
            super(shortForm, longForm, OptionType.Boolean);
        }

        @Override
        public final Object getValue() {
            return !this.hasValue() ? null : Boolean.valueOf(this.getBooleanValue());
        }

        @Override
        public final boolean hasValue() {
            return this.values.size() > 0;
        }

        public final boolean getBooleanValue() {
            if (this.hasValue()) {
                return this.values.get(this.values.size() - 1);
            }
            return false;
        }

        @Override
        public final List<Object> getValues() {
            return this.values.toList();
        }

        public List<Boolean> getBooleanValues() {
            return this.values.toList();
        }

        @Override
        final void addValue(String value) {
            this.values.add(Boolean.valueOf(value).booleanValue());
        }

        @Override
        public void clear() {
            this.values.clear();
        }
    }

    public static abstract class Option {
        final OptionType type;
        final char shortForm;
        final String longForm;

        Option(char shortForm, String longForm, OptionType type) {
            this.type = type;
            this.shortForm = shortForm;
            this.longForm = longForm;
        }

        static final Option create(char shortForm, String longForm, OptionType type) {
            switch (type) {
                case Boolean: {
                    return new BooleanOption(shortForm, longForm);
                }
                case Double: {
                    return new DoubleOption(shortForm, longForm);
                }
                case Integer: {
                    return new IntegerOption(shortForm, longForm);
                }
                case Long: {
                    return new LongOption(shortForm, longForm);
                }
                case String: {
                    return new StringOption(shortForm, longForm);
                }
            }
            return null;
        }

        public abstract Object getValue();

        public abstract boolean hasValue();

        public abstract List<Object> getValues();

        abstract void addValue(String var1);

        abstract void clear();
    }

    private static enum OptionType {
        Boolean,
        Integer,
        Long,
        Double,
        String;

    }

    public class OptionException
    extends CliException {
        private static final long serialVersionUID = 1L;

        OptionException(String message) {
            super(message);
        }

        OptionException(String message, Throwable throwable) {
            super(message, throwable);
        }

        OptionException(Throwable throwable) {
            super(throwable);
        }
    }
}

