/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.client;

import com.neeve.aep.AepEngine;
import com.neeve.client.EClientException;
import com.neeve.client.IClientResponseCallback;
import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlLinkedLongMap;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThrowable;

public abstract class AbstractClient {
    private final String _clientName;
    private final String _serviceName;
    private final String _clientInstanceId;
    private final XString _clientId;
    private final String _clientConfigParamPrefix;
    private final String _clientInstanceConfigParamPrefix;
    private final String _globallyUniqueClientName;
    private final MessageBusDescriptor _busDescriptor;
    private final EventHandler _eventHandler;
    private final UtlLinkedLongMap<RequestTableEntry> _requestTable;
    private final RequestTableEntryPoolFactory _requestTableEntryPoolFactory;
    private final UtlPool<RequestTableEntry> _requestTableEntryPool;
    private final SequenceNumberGenerator _snoGenerator;
    private final Tracer _tracer;
    private final String _tracePrefix;
    private volatile IClientResponseCallback _responseCallback;
    private MessageChannel _requestChannel;
    private MessageBusBinding _binding;
    private long _sno;
    private State _state;
    private String _connectionDescriptor;
    private int _responseTimeout;
    private long ts = 0L;

    protected AbstractClient(String serviceName, String clientName, String clientInstanceId) {
        try {
            if (clientName == null) {
                throw new IllegalArgumentException("client name cannot be null");
            }
            if (serviceName == null) {
                throw new IllegalArgumentException("service name cannot be null");
            }
            this._clientName = clientName;
            this._serviceName = serviceName;
            this._clientInstanceId = clientInstanceId;
            this._clientId = XString.create((String)(this._clientName + "-" + this._clientInstanceId));
            this._globallyUniqueClientName = this._serviceName + ".client." + this._clientName + "." + this._clientInstanceId;
            this._tracer = Tracer.get((String)"nv.client");
            this._tracePrefix = "[" + this._globallyUniqueClientName + "] ";
            this._clientConfigParamPrefix = this._serviceName + ".client." + this._clientName;
            this._clientInstanceConfigParamPrefix = this._clientConfigParamPrefix + "." + this._clientInstanceId;
            this.loadConfig();
            this._requestTable = new UtlLinkedLongMap(10000);
            this._requestTableEntryPoolFactory = new RequestTableEntryPoolFactory();
            this._requestTableEntryPool = UtlPool.create((String)"requestTable.entry", (String)"RequestTableEntry", (UtlPool.Factory)this._requestTableEntryPoolFactory, (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
            this._snoGenerator = new SequenceNumberGenerator();
            this._busDescriptor = this.createMessageBusDescriptor();
            this._eventHandler = new EventHandler();
            this._state = State.Initialized;
        }
        catch (Exception e) {
            if (e instanceof EClientException) {
                throw (EClientException)e;
            }
            throw new EClientException(e);
        }
    }

    private final int getConfigValue(String name, int defVal) {
        return Config.getValue((String)(this._clientInstanceConfigParamPrefix + "." + name), (int)Config.getValue((String)(this._clientConfigParamPrefix + "." + name), (int)defVal));
    }

    private final String getConfigValue(String name, String defVal) {
        return Config.getValue((String)(this._clientInstanceConfigParamPrefix + "." + name), (String)Config.getValue((String)(this._clientConfigParamPrefix + "." + name), (String)defVal));
    }

    private final void loadConfig() {
        this._connectionDescriptor = this.getConfigValue("connectionDescriptor", null);
        this._responseTimeout = Math.max(1, this.getConfigValue("responseTimeout", 60));
        if (this._tracer.getLevel().val <= Tracer.Level.CONFIG.val) {
            this._tracer.log(this._tracePrefix + "Client '" + this._globallyUniqueClientName + " config {", Tracer.Level.CONFIG);
            this._tracer.log(this._tracePrefix + "...connectionDescriptor=" + this._connectionDescriptor, Tracer.Level.CONFIG);
            this._tracer.log(this._tracePrefix + "...responseTimeout= " + this._responseTimeout, Tracer.Level.CONFIG);
            this._tracer.log(this._tracePrefix + "}", Tracer.Level.CONFIG);
        }
    }

    private final MessageBusDescriptor getAbstractBusDescriptor() throws SmaException {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.exists((String)this._globallyUniqueClientName) ? MessageBusDescriptor.load((String)this._globallyUniqueClientName) : MessageBusDescriptor.create((String)this._globallyUniqueClientName);
        return AepEngine.configureClientBusDescriptor((MessageBusDescriptor)busDescriptor, (String)this._serviceName, (String)this.getConfigValue("requestsChannelKey", null), (String)this.getConfigValue("responsesChannelKey", null));
    }

    private final MessageBusDescriptor createMessageBusDescriptor() throws Exception {
        MessageBusDescriptor busDescriptor = this.getAbstractBusDescriptor();
        if (this._connectionDescriptor != null) {
            busDescriptor.setProviderConfig(this._connectionDescriptor);
        }
        if (busDescriptor.getProviderConfig().get("Provider") == null) {
            throw new IllegalStateException("message bus connection descriptor has not been configured");
        }
        busDescriptor.setProviderConfigProperty("enable_concurrent_sends", "true");
        MessageChannelDescriptor responsesChannelDescriptor = busDescriptor.getChannel("responses");
        responsesChannelDescriptor.setChannelFilter("clientId=" + this._clientId.getValue());
        return busDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchReplies(Exception e) {
        UtlLinkedLongMap<RequestTableEntry> utlLinkedLongMap = this._requestTable;
        synchronized (utlLinkedLongMap) {
            for (RequestTableEntry entry : this._requestTable.values()) {
                entry.error = e;
            }
            this._requestTable.clear();
            this._requestTable.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onResponse(MessageView view) {
        RequestTableEntry entry;
        long sno = view.getRequestId();
        if (this._tracer.debug) {
            this._tracer.log(this._tracePrefix + "Received response for request #" + sno, Tracer.Level.DEBUG);
        }
        UtlLinkedLongMap<RequestTableEntry> utlLinkedLongMap = this._requestTable;
        synchronized (utlLinkedLongMap) {
            entry = (RequestTableEntry)this._requestTable.get(sno);
            if (entry != null) {
                if (this._tracer.debug) {
                    this._tracer.log(this._tracePrefix + "Found request table entry for request #" + sno + ".", Tracer.Level.DEBUG);
                }
                entry.response = view;
                entry.response.acquire();
                if (entry.async) {
                    if (this._tracer.debug) {
                        this._tracer.log(this._tracePrefix + "Request is async. Removing from table...", Tracer.Level.DEBUG);
                    }
                    this._requestTable.remove(sno);
                } else {
                    if (this._tracer.debug) {
                        this._tracer.log(this._tracePrefix + "Request is a sync request. Waking up waiters...", Tracer.Level.DEBUG);
                    }
                    this._requestTable.notifyAll();
                }
            } else {
                this._tracer.log("Request #" + sno + " not found for inbound response. Discarding response...", Tracer.Level.WARNING);
            }
            if (System.currentTimeMillis() - this.ts >= 1000L) {
                this.ts = System.currentTimeMillis();
            }
        }
        if (entry != null && entry.async) {
            try {
                if (this._responseCallback != null) {
                    if (this._tracer.debug) {
                        this._tracer.log(this._tracePrefix + "Request is async. Dispatching to user...", Tracer.Level.DEBUG);
                    }
                    try {
                        this._responseCallback.handleResponse(entry.request.getRequestId(), entry.request, entry.response);
                    }
                    catch (Throwable e) {
                        this._tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                    }
                } else {
                    this._tracer.log(this._tracePrefix + "Discarding response for request #" + entry.request.getRequestId() + " [No registered reply callback]", Tracer.Level.DEBUG);
                }
            }
            finally {
                entry.dispose();
            }
        }
    }

    private final void openMessagingConnection() throws Exception {
        this._binding = MessageBusBindingFactory.getInstance().createBinding(this._globallyUniqueClientName, this._busDescriptor, (IEventHandler)this._eventHandler);
        this._binding.setSequenceNumberGenerator((MessageBusBinding.SequenceNumberGenerator)this._snoGenerator);
        this._requestChannel = this._binding.getMessageChannel("requests");
        this._binding.getMessageChannel("responses").join(0);
        this._binding.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long addMessageToRequestTable(MessageView view) {
        long sno = this._sno++;
        view.setRequestId(sno);
        view.setRequestorIdAsRaw(this._clientId);
        UtlLinkedLongMap<RequestTableEntry> utlLinkedLongMap = this._requestTable;
        synchronized (utlLinkedLongMap) {
            this._requestTable.put(sno, (Object)((RequestTableEntry)view.getTag(5)));
        }
        view.setTag(5, null);
        return sno;
    }

    private final void closeMessagingConnection() {
        try {
            this._binding.close(0);
        }
        catch (SmaException e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this._tracer.log(this._tracePrefix + "Failed to close messaging connection [" + error + "]", Tracer.Level.WARNING);
        }
    }

    public final AbstractClient registerResponseCallback(IClientResponseCallback cb) {
        this._responseCallback = cb;
        return this;
    }

    public final void open() {
        try {
            switch (this._state) {
                case Initialized: {
                    this.openMessagingConnection();
                    this._state = State.Started;
                    break;
                }
                default: {
                    throw new IllegalStateException("client already open");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof EClientException) {
                throw (EClientException)e;
            }
            throw new EClientException(e);
        }
    }

    public final void setResponseTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0");
        }
        this._responseTimeout = timeout;
    }

    public final int getResponseTimeout() {
        return this._responseTimeout;
    }

    public final String getServiceName() {
        return this._serviceName;
    }

    public final String getName() {
        return this._clientName;
    }

    public final String getInstanceId() {
        return this._clientInstanceId;
    }

    public final State getState() {
        return this._state;
    }

    protected final long sendRequest(MessageView msg, boolean async) {
        if (async && this._responseCallback == null) {
            throw new IllegalStateException("response callback needs to be registered for async request-response");
        }
        if (this._tracer.debug) {
            this._tracer.log(this._tracePrefix + "Sending request (state=" + (Object)((Object)this._state) + ")", Tracer.Level.DEBUG);
        }
        try {
            switch (this._state) {
                case Initialized: {
                    this.open();
                    return this.sendRequest(msg, async);
                }
                case Started: {
                    msg.setTag(5, (Object)((RequestTableEntry)this._requestTableEntryPool.get(null)).init(msg, async));
                    this._requestChannel.sendMessage(msg, 0);
                    if (this._tracer.debug) {
                        this._tracer.log(this._tracePrefix + "Request sent (# " + msg.getMessageSequenceNumber() + ")", Tracer.Level.DEBUG);
                    }
                    return msg.getRequestId();
                }
                case Reconnecting: {
                    throw new EClientException("messaging connection is down");
                }
                case Stopped: {
                    throw new IllegalStateException("illegal state '" + (Object)((Object)this._state) + "'");
                }
            }
            throw new IllegalStateException("unknown state '" + (Object)((Object)this._state) + "'");
        }
        catch (Exception e) {
            if (e instanceof EClientException) {
                throw (EClientException)e;
            }
            throw new EClientException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T waitForResponse(long requestId, int timeout) {
        try {
            switch (this._state) {
                case Started: 
                case Reconnecting: {
                    if (this._tracer.debug) {
                        this._tracer.log(this._tracePrefix + "Waiting for response for # " + requestId, Tracer.Level.DEBUG);
                    }
                    UtlLinkedLongMap<RequestTableEntry> utlLinkedLongMap = this._requestTable;
                    synchronized (utlLinkedLongMap) {
                        long remainingTime;
                        RequestTableEntry entry = (RequestTableEntry)this._requestTable.get(requestId);
                        if (entry == null) {
                            throw new IllegalArgumentException("invalid request id #" + requestId);
                        }
                        long expiryTime = System.currentTimeMillis() + (long)(timeout * 1000);
                        while (entry.response == null && (remainingTime = Math.max(0L, expiryTime - System.currentTimeMillis())) > 0L) {
                            if (this._tracer.debug) {
                                this._tracer.log(this._tracePrefix + "Remaining time for response for #" + requestId + " is " + remainingTime + "ms", Tracer.Level.DEBUG);
                            }
                            this._requestTable.wait(remainingTime);
                        }
                        this._requestTable.remove(requestId);
                        try {
                            if (entry.response != null) {
                                if (this._tracer.debug) {
                                    this._tracer.log(this._tracePrefix + "Received response for request #" + requestId, Tracer.Level.DEBUG);
                                }
                                entry.response.acquire();
                                MessageView messageView = entry.response;
                                return (T)messageView;
                            }
                            if (this._tracer.debug) {
                                this._tracer.log(this._tracePrefix + "Response for request #" + requestId + " timed out", Tracer.Level.DEBUG);
                            }
                            throw new EClientException("timed out");
                        }
                        finally {
                            entry.dispose();
                        }
                    }
                }
                case Stopped: {
                    throw new IllegalStateException("illegal state '" + (Object)((Object)this._state) + "'");
                }
            }
            throw new IllegalStateException("unknown state '" + (Object)((Object)this._state) + "'");
        }
        catch (Exception e) {
            if (e instanceof EClientException) {
                throw (EClientException)e;
            }
            throw new EClientException(e);
        }
    }

    public final void close() {
        switch (this._state) {
            case Initialized: 
            case Stopped: {
                break;
            }
            case Started: 
            case Reconnecting: {
                try {
                    this.closeMessagingConnection();
                    break;
                }
                finally {
                    this._state = State.Stopped;
                }
            }
            default: {
                throw new IllegalStateException("invalid state '" + (Object)((Object)this._state) + "'");
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static enum State {
        Initialized,
        Started,
        Reconnecting,
        Stopped;

    }

    private final class SequenceNumberGenerator
    implements MessageBusBinding.SequenceNumberGenerator {
        private SequenceNumberGenerator() {
        }

        public final long nextSno(MessageView view) {
            return AbstractClient.this.addMessageToRequestTable(view);
        }
    }

    private final class EventHandler
    implements IEventHandler {
        private EventHandler() {
        }

        public final void onEvent(Event event) {
            switch (event.getType()) {
                case 105: {
                    MessageEvent messageEvent = (MessageEvent)event;
                    if (messageEvent.getMessageChannel().getId() == 2) {
                        AbstractClient.this.onResponse(messageEvent.getMessageView());
                        break;
                    }
                    AbstractClient.this._tracer.log("Received message on request channel. Discarding...", Tracer.Level.WARNING);
                    break;
                }
            }
        }
    }

    private static final class RequestTableEntryPoolFactory
    implements UtlPool.Factory<RequestTableEntry> {
        private RequestTableEntryPoolFactory() {
        }

        public final RequestTableEntry createItem(Object object) {
            return new RequestTableEntry();
        }

        public final RequestTableEntry[] createItemArray(int size) {
            return new RequestTableEntry[size];
        }
    }

    private static final class RequestTableEntry
    implements UtlPool.Item<RequestTableEntry> {
        Exception error;
        MessageView request;
        MessageView response;
        boolean async;
        private UtlPool<RequestTableEntry> _pool;

        private RequestTableEntry() {
        }

        final void dispose() {
            if (this._pool != null) {
                this._pool.put((UtlPool.Item)this);
            }
        }

        final RequestTableEntry init(MessageView view, boolean async) {
            this.error = null;
            this.request = view;
            this.response = null;
            this.async = async;
            return this;
        }

        public final RequestTableEntry init() {
            this.request.dispose();
            if (this.response != null) {
                this.response.dispose();
            }
            return this;
        }

        public final RequestTableEntry setPool(UtlPool<RequestTableEntry> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<RequestTableEntry> getPool() {
            return this._pool;
        }
    }
}

