/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.neeve.ods.impl.StorePacketPersisterStatsBase;
import com.neeve.rog.log.IRogLogStats;
import com.neeve.rog.log.RogLog;
import com.neeve.util.UtlFile;

final class RogLogStats
extends StorePacketPersisterStatsBase
implements IRogLogStats {
    private final RogLog log;
    private long fileSizeLast;
    private long fileSizeUsedLast;

    RogLogStats(RogLog log, String name, String startProp) {
        super(log, "nv.rog.log", name, "nv.rog.log.stats", startProp);
        this.log = log;
        this.startPeriodicOutputIfConfigured();
    }

    @Override
    public final synchronized void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long fileSizeCurrent = this.getFileSize();
        long fileSizeUsedCurrent = this.getFileSizeUsed();
        double fileSizeRate = (double)fileSizeCurrent * 1000.0 / (double)deltaTotalTime;
        double deltaFileSizeRate = (double)(fileSizeCurrent - this.fileSizeLast) * 1000.0 / (double)deltaTime;
        double fileSizeUsedRate = (double)fileSizeUsedCurrent * 1000.0 / (double)deltaTotalTime;
        double deltaFileSizeUsedRate = (double)(fileSizeUsedCurrent - this.fileSizeUsedLast) * 1000.0 / (double)deltaTime;
        super.get(sb);
        sb.append(String.format("Disk Size{%s(%s %s)} Used{%s(%s %s)}", UtlFile.readableFileSize((long)fileSizeCurrent), UtlFile.readableFileSize((long)((long)fileSizeRate)), UtlFile.readableFileSize((long)((long)deltaFileSizeRate)), UtlFile.readableFileSize((long)fileSizeUsedCurrent), UtlFile.readableFileSize((long)((long)fileSizeUsedRate)), UtlFile.readableFileSize((long)((long)deltaFileSizeUsedRate))));
    }

    @Override
    public long getFileSizeUsed() {
        if (this.log.isOpen()) {
            try {
                return this.log.getSize();
            }
            catch (Throwable thrown) {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public long getFileSize() {
        if (this.log.isOpen()) {
            try {
                return this.log.getAllocatedSize();
            }
            catch (Throwable thrown) {
                return -1L;
            }
        }
        return -1L;
    }
}

