/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.rog.log.RogLog;
import com.neeve.util.UtlBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class RogLogMetadata {
    private final String name;
    private final File root;
    private final File metadataFile;
    private RandomAccessFile file;
    private ByteBuffer buffer;
    private boolean cdcEnabled;
    private static final int FLG_IS_BACKUP = 4;
    private static final int FLG_IS_MESSAGE_LOGGER = 8;
    private static final int OFFSET_VERSION = 0;
    private static final int OFFSET_FLAGS = 1;
    private static final int OFFSET_LIVE_LOG_NUMBER = 5;
    private static final int OFFSET_CDC_LOG_NUMBER = 9;
    private static final int OFFSET_CDC_CHECKPOINT_VERSION = 13;
    private static final int OFFSET_CDC_CURSOR = 21;
    private static final int OFFSET_UUID_LOW = 29;
    private static final int OFFSET_UUID_HIGH = 37;
    private static final int OFFSET_LAST_VALIDATED_POSITION = 45;
    private static final byte CURRENT_VERSION = 1;
    private static final int[] METADATA_VERSION_LENGTHS = new int[]{0, 53};
    static final int CURRENT_VERSION_LENGTH = METADATA_VERSION_LENGTHS[METADATA_VERSION_LENGTHS.length - 1];
    static final String FILE_SUFFIX = ".metadata";

    public RogLogMetadata(File root, String name) {
        this.root = root;
        this.name = name;
        this.metadataFile = new File(root, name + FILE_SUFFIX);
    }

    private final void init(IStoreBinding.Role role) {
        boolean bl = this.cdcEnabled = this.getCdcLogNumber() >= 0;
        if (role != null) {
            this.setIsBackup(role == IStoreBinding.Role.Backup);
        }
    }

    public final void sync() throws IOException {
        if (this.buffer != null) {
            ((MappedByteBuffer)this.buffer).force();
        }
    }

    public final boolean exists() {
        return this.metadataFile.exists();
    }

    public final void open(IOElasticBuffer from, int offset, IStoreBinding.Role role) throws Exception {
        RogLog.checkAndCreateStoreRoot(this.root);
        boolean newFile = false;
        if (!this.metadataFile.exists()) {
            this.metadataFile.createNewFile();
            newFile = true;
        }
        this.file = new RandomAccessFile(this.metadataFile, "rwd");
        this.file.seek(0L);
        if (newFile) {
            this.buffer = ByteBuffer.allocate(CURRENT_VERSION_LENGTH);
            this.setVersion((byte)1);
            this.setLiveLogNumber(0);
            this.disableCdc();
            this.setCdcCheckpointVersion(0L);
            this.setLogUUID(new UUID());
            this.file.write(this.buffer.array());
        }
        this.buffer = this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, CURRENT_VERSION_LENGTH);
        if (from != null) {
            this.deserialize(from, offset, role);
        } else {
            this.init(role);
        }
        byte version = this.getVersion();
        if (version != 1) {
            throw new Exception("invalid metadata version (" + version + ") for " + this.metadataFile);
        }
    }

    public final void open() throws Exception {
        this.open(null, 0, null);
    }

    public final File getRoot() {
        return this.root;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isOpen() {
        return this.file != null;
    }

    private final void setVersion(byte version) {
        this.buffer.put(0, version);
    }

    public final byte getVersion() {
        return this.buffer.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIsBackup(boolean isBackup) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            int flags = this.buffer.getInt(1);
            flags = isBackup ? (flags |= 4) : (flags &= 0xFFFFFFFB);
            this.buffer.putInt(1, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsBackup() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return (this.buffer.getInt(1) & 4) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIsPureMessageLogger(boolean isMessageLogger) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            int flags = this.buffer.getInt(1);
            flags = isMessageLogger ? (flags |= 8) : (flags &= 0xFFFFFFF7);
            this.buffer.putInt(1, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsPureMessageLogger() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return (this.buffer.getInt(1) & 8) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLiveLogNumber(int val) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            this.buffer.putInt(5, val);
            this.buffer.putLong(45, -1L);
        }
    }

    public static final int getLiveLogNumber(IOElasticBuffer buffer) {
        return buffer.getInt(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLiveLogNumber() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return this.buffer.getInt(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCdcLogNumber(int val) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            this.buffer.putInt(9, val);
            this.buffer.putLong(21, -1L);
            this.cdcEnabled = val >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCdcLogNumber() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return this.buffer.getInt(9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCdcCheckpointVersion(long val) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            this.buffer.putLong(13, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getCdcCheckpointVersion() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return this.buffer.getLong(13);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCdcCursor(long val) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            this.buffer.putLong(21, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getCdcCursor() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return this.buffer.getLong(21);
        }
    }

    public final boolean isCdcEnabled() {
        return this.cdcEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCdcEnabled(boolean enabled) {
        if (enabled) {
            RogLogMetadata rogLogMetadata = this;
            synchronized (rogLogMetadata) {
                if (!this.isCdcEnabled()) {
                    this.setCdcLogNumber(0);
                }
            }
        } else {
            this.setCdcLogNumber(-1);
        }
    }

    @Deprecated
    public final void enableCdc() {
        this.setCdcEnabled(true);
    }

    @Deprecated
    public final void disableCdc() {
        this.setCdcEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogUUID(UUID uuid) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            this.buffer.putLong(29, uuid.getTime());
            this.buffer.putLong(37, uuid.getClockSeqAndNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UUID getLogUUID() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            long low = this.buffer.getLong(29);
            long high = this.buffer.getLong(37);
            return new UUID(low, high);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLastValidatedPosition(long position) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            this.buffer.putLong(45, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLastValidatedPosition() {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            return this.buffer.getLong(45);
        }
    }

    public final void renameTo(String newName) throws IOException {
        File newFile = new File(this.root, newName + FILE_SUFFIX);
        File currentFile = new File(this.root, this.name + FILE_SUFFIX);
        if (!currentFile.renameTo(newFile)) {
            throw new IOException("metadata rename to " + newName + "failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(IOElasticBuffer to) {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            to.putFrom(0, this.buffer, CURRENT_VERSION_LENGTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(IOElasticBuffer from, int offset, IStoreBinding.Role role) throws Exception {
        RogLogMetadata rogLogMetadata = this;
        synchronized (rogLogMetadata) {
            if (from.get(offset + 0) != 1) {
                throw new IllegalArgumentException("invalid version in serialized metadata [exp=1, actual=" + from.get(0) + "]");
            }
            if (from.getLength() - offset != CURRENT_VERSION_LENGTH) {
                throw new IllegalArgumentException("invalid length of serialized metadata [exp=" + CURRENT_VERSION_LENGTH + ", actual=" + from.getLength() + "]");
            }
            from.getTo(offset, this.buffer, from.getLength());
            this.init(role);
        }
    }

    public final void close() throws IOException {
        this.sync();
        if (this.file != null) {
            this.file.close();
            try {
                UtlBuffer.releaseBuffer((ByteBuffer)this.buffer);
            }
            catch (Throwable thrown) {
                System.err.println("Error unmapping metadata buffer [" + thrown.getMessage() + "]");
                this.buffer = null;
            }
            this.file = null;
        }
        this.cdcEnabled = false;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Metadata for:").append(this.name).append("\n");
        sb.append("...").append("Version=").append(this.getVersion()).append("\n");
        sb.append("...").append("LogUUID=").append(this.getLogUUID()).append("\n");
        sb.append("...").append("Backup=").append(this.getIsBackup()).append("\n");
        sb.append("...").append("LastValidatedPosition=").append(this.getLastValidatedPosition()).append("\n");
        sb.append("...").append("LiveLogNumber=").append(this.getLiveLogNumber()).append("\n");
        sb.append("...").append("CdcEnabled=").append(this.isCdcEnabled()).append("\n");
        sb.append("...").append("CdcCheckpointVersion=").append(this.getCdcCheckpointVersion()).append("\n");
        sb.append("...").append("CdcCursor=").append(this.getCdcCursor()).append("\n");
        sb.append("...").append("CdcLogNumber=").append(this.getCdcLogNumber()).append("\n");
        sb.append("...").append("PureMessageLogger=").append(this.getIsPureMessageLogger()).append("\n");
        return sb.toString();
    }
}

