/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.rog.ERogIllegalParentReferenceException;
import com.neeve.rog.IRogCollectionNode;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogContainerNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.impl.RogTransactionalField;
import com.neeve.sma.MessageView;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public abstract class RogCollectionNode<V extends IRogCollectionNodeElement>
extends RogContainerNode
implements IRogCollectionNode<V> {
    private long fidOffset;
    private long nextAvailableFid;

    protected RogCollectionNode(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.reset();
    }

    public static final List<RogTransactionalField<? extends RogNode, ?>> getFields() {
        return Collections.emptyList();
    }

    private final void reset() {
        this.fidOffset = -1L;
        this.nextAvailableFid = -1L;
    }

    private final long allocFid() {
        if (this.fidOffset == -1L) {
            this.nextAvailableFid = this.fidOffset = (long)(this.getLastFid() + 1);
        }
        return this.nextAvailableFid++;
    }

    private final void releaseFid(long fid) {
        if (this.fidOffset == -1L) {
            throw new IllegalArgumentException("fid has not been allocated");
        }
    }

    private final boolean isDynamicFid(long fid) {
        return this.fidOffset > 0L && fid >= this.fidOffset;
    }

    @Override
    protected final void addChildrenToStore() {
        XIterator<V> iterator = this.reusableChildIterator();
        while (iterator.hasNext()) {
            IRogCollectionNodeElement child = (IRogCollectionNodeElement)iterator.next();
            this.addNodeToStore(child.getFid(), (RogNode)((Object)child));
            if (!(child instanceof RogContainerNode)) continue;
            ((RogContainerNode)((Object)child)).addChildrenToStore();
        }
    }

    @Override
    protected final void removeChildrenFromStore() {
        XIterator<V> iterator = this.reusableChildIterator();
        while (iterator.hasNext()) {
            IRogCollectionNodeElement child = (IRogCollectionNodeElement)iterator.next();
            if (child instanceof RogContainerNode) {
                ((RogContainerNode)((Object)child)).removeChildrenFromStore();
            }
            this.removeNodeFromStore(child.getFid(), (RogNode)((Object)child));
        }
    }

    protected final void addChild(V node) {
        this.assertSingleParent((IRogNode)node);
        if (node.getFid() != 0L) {
            if (node.getParent() == this) {
                throw new ERogIllegalParentReferenceException("'" + node.getClass().getSimpleName() + "' cannot be added to this '" + this.getClass().getSimpleName() + "' collection it is already an element of this collection and can only be added once.");
            }
            throw new IllegalArgumentException("Node already has a fid!");
        }
        node.setFid(this.allocFid());
        this.addChild(node.getFid(), (RogNode)node);
    }

    protected final void removeChild(V node) {
        if (node.getFid() == 0L) {
            throw new IllegalArgumentException("node does not have a fid");
        }
        long fid = node.getFid();
        node.setFid(0L);
        this.removeChild(fid, (RogNode)node);
        this.releaseFid(fid);
    }

    protected abstract XIterator<V> reusableChildIterator();

    protected abstract PktPacket getStoreCommitPacket();

    protected PktPacket serializeForStoreCommit() {
        PktPacket packet = this.getStoreCommitPacket();
        ((PktBodyData)packet.getBody()).setBufferLength(0);
        return packet;
    }

    protected void deserializeFromStoreReplicationOrInit(PktPacket packet) {
        packet.dispose();
    }

    public String serializeToJson() {
        throw new UnsupportedOperationException();
    }

    public IRogNode deserializeFromJson(String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void dump(StringBuilder sb, String leader, String leaderConcat) {
        super.dump(sb, leader, leaderConcat);
        XIterator<V> iterator = this.reusableChildIterator();
        while (iterator.hasNext()) {
            ((IRogCollectionNodeElement)iterator.next()).dump(sb, leader + leaderConcat, leaderConcat);
        }
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            XIterator<V> iterator = this.reusableChildIterator();
            while (iterator.hasNext()) {
                this.removeChild((V)((IRogCollectionNodeElement)iterator.next()));
            }
            this.reset();
        }
        return count;
    }

    public byte[] serializeToByteArray() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer serializeToByteBuffer() {
        throw new UnsupportedOperationException();
    }

    public IOBuffer serializeToIOBuffer(boolean useNative) {
        throw new UnsupportedOperationException();
    }

    public PktPacket serializeToPacket() {
        throw new UnsupportedOperationException();
    }

    public MessageView deserializeFromByteArray(byte[] array) {
        throw new UnsupportedOperationException();
    }

    public MessageView deserializeFromByteBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public MessageView deserializeFromPacket(PktPacket packet) {
        throw new UnsupportedOperationException();
    }

    public void sync() {
        throw new UnsupportedOperationException();
    }
}

