/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.neeve.query.QueryException;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryAggregateResult;
import com.neeve.query.impl.QueryConcatenatedResult;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryInterleavedResult;
import com.neeve.query.impl.QueryOrderedAggregateResult;
import com.neeve.query.impl.QuerySortArea;
import com.neeve.query.impl.QuerySortAreaImpl;
import com.neeve.query.impl.QuerySortAreaProvider;
import com.neeve.query.impl.index.IdxIndexerImpl;
import com.neeve.query.impl.predicates.PredicateBase;
import com.neeve.query.impl.util.collect.UtlIterators;
import com.neeve.query.index.IdxField;
import com.neeve.query.predicates.Predicate;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryResultSetImpl<ID, REC>
implements QueryResultSet<REC> {
    private List<IdxField<REC, ?>> fields = Lists.newArrayList();
    private List<String> fieldNames = Lists.newArrayList();
    private Map<String, Integer> fieldIndexes = Maps.newHashMap();
    private List<QueryResult<REC>> queryResults = Lists.newArrayList();
    private QueryResult<REC> queryResult = null;
    private QueryResultSet.Row<REC> currentRow = null;
    private QueryResultSet.Collation collation = QueryResultSet.Collation.CONCATENATE;
    private Comparator<QueryResultSet.Row<REC>> interleaveComparator = null;
    private Iterator<QueryResultSet.Row<REC>> iterator = null;
    private Range<Integer> limit;
    private int iterationCount = 0;
    private int count = -1;
    private QuerySortAreaProvider<REC> sortAreaProvider;
    private QuerySortArea<REC> sortArea = null;

    public Function<REC, QueryResultSet.Row<REC>> recordToRow(final IdxIndexerImpl.IdMapper<ID, REC> idMapper) {
        return new Function<REC, QueryResultSet.Row<REC>>(){

            public QueryResultSet.Row<REC> apply(REC record) {
                Object key = idMapper.getRecordId(record);
                return new RowImpl(record, key);
            }
        };
    }

    public Iterable<QueryResultSet.Row<REC>> forRecords(Iterable<REC> records, IdxIndexerImpl.IdMapper<ID, REC> idMapper) {
        return Iterables.transform(records, this.recordToRow(idMapper));
    }

    public Iterable<QueryResultSet.Row<REC>> forRecords(IdxIndexerImpl.IdMapper<ID, REC> idMapper, REC ... records) {
        ArrayList rows = Lists.newArrayList();
        for (REC record : records) {
            RowImpl row = new RowImpl(record, idMapper.getRecordId(record));
            rows.add(row);
        }
        return rows;
    }

    public RowImpl forRecord(REC record, ID recordId) {
        return new RowImpl(record, recordId);
    }

    public RowImpl forAggregate(QueryAggregateField.Aggregate<REC> aggregate) {
        return new RowImpl(aggregate);
    }

    public <T> Iterable<QueryResultSet.Row<REC>> forEntries(final IdxField<REC, T> field, final Iterable<Map.Entry<T, ID>> entries) {
        return new Iterable<QueryResultSet.Row<REC>>(){

            @Override
            public Iterator<QueryResultSet.Row<REC>> iterator() {
                return new Iterator<QueryResultSet.Row<REC>>(){
                    Iterator<Map.Entry<T, ID>> entryIter;
                    {
                        this.entryIter = entries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entryIter.hasNext();
                    }

                    @Override
                    public QueryResultSet.Row<REC> next() {
                        Map.Entry entry = this.entryIter.next();
                        return new RowImpl(field, entry);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Predicate<QueryResultSet.Row<REC>> createPredicate(final Predicate<REC> recordPredicate) {
        return new PredicateBase<QueryResultSet.Row<REC>>(){

            public boolean apply(QueryResultSet.Row<REC> row) {
                Object record = row.getRecord();
                return recordPredicate.apply(record);
            }

            public String toString() {
                return recordPredicate.toString();
            }

            @Override
            public double getCost() {
                return recordPredicate.getCost();
            }

            @Override
            public void regularize() {
                if (recordPredicate instanceof PredicateBase) {
                    PredicateBase recordPredicateImpl = (PredicateBase)recordPredicate;
                    recordPredicateImpl.regularize();
                }
            }

            @Override
            public void prioritizeBy(Comparator<Predicate<?>> comparator) {
                if (recordPredicate instanceof PredicateBase) {
                    PredicateBase recordPredicateImpl = (PredicateBase)recordPredicate;
                    recordPredicateImpl.prioritizeBy(comparator);
                }
            }
        };
    }

    public QueryResultSetImpl(QuerySortAreaProvider<REC> sortAreaProvider) {
        this.sortAreaProvider = sortAreaProvider;
    }

    public void addColumn(String name, IdxField<REC, ?> field) {
        this.fields.add(field);
        this.fieldNames.add(name);
        int columnIndex = this.fields.size();
        this.fieldIndexes.put(name, columnIndex);
    }

    public void addColumn(IdxField<REC, ?> field) {
        this.addColumn(field.getName(), field);
    }

    @Override
    public void setCollation(QueryResultSet.Collation collation) {
        this.collation = collation;
    }

    public void setInterleaveComparator(Comparator<QueryResultSet.Row<REC>> comparator) {
        this.interleaveComparator = comparator;
    }

    public QuerySortArea<REC> getSortArea() {
        if (this.sortArea == null) {
            this.sortArea = this.sortAreaProvider.createSortArea();
        }
        return this.sortArea;
    }

    public void addQueryResult(QueryResult<REC> queryResult) {
        this.queryResults.add(queryResult);
    }

    @Override
    public boolean absolute(int row) {
        if (row < 0) {
            throw new UnsupportedOperationException("absolute from last position is not yet supported");
        }
        this.beforeFirst();
        for (int i = 0; i < row; ++i) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void beforeFirst() {
        this.iterationCount = 0;
        if (this.queryResults.size() == 1) {
            this.queryResult = this.queryResults.get(0);
        } else {
            switch (this.collation) {
                case CONCATENATE: {
                    this.queryResult = new QueryConcatenatedResult<REC>(this.queryResults);
                    break;
                }
                case INTERLEAVE: {
                    this.queryResult = new QueryInterleavedResult<REC>(this.queryResults, this.interleaveComparator);
                    break;
                }
                case AGGREGATE: {
                    this.queryResult = new QueryAggregateResult<REC>(this.queryResults, this);
                    break;
                }
                case ORDERED_AGGREGATE: {
                    this.queryResult = new QueryOrderedAggregateResult<REC>(this, this.queryResults, this.interleaveComparator);
                    break;
                }
                default: {
                    throw new QueryException("Collation is not set.");
                }
            }
        }
        this.iterator = this.queryResult.iterator();
        if (this.limit != null) {
            this.iterator = UtlIterators.limit(this.iterator, this.limit);
        }
    }

    private void prepareForIteration() {
        if (this.queryResult == null) {
            this.beforeFirst();
        }
    }

    @Override
    public QueryResult<REC> getQueryResult() {
        this.beforeFirst();
        return this.queryResult;
    }

    @Override
    public int getCount() {
        if (this.count == -1) {
            this.prepareForIteration();
            this.count = this.queryResult.size();
        }
        return this.count;
    }

    @Override
    public int getEstimatedCount() {
        this.prepareForIteration();
        return this.queryResult.estimatedSize();
    }

    @Override
    public boolean isFullScan() {
        this.prepareForIteration();
        return this.queryResult.isFullScan();
    }

    @Override
    public boolean next() {
        this.prepareForIteration();
        boolean hasNext = this.iterator.hasNext();
        if (hasNext) {
            this.currentRow = this.iterator.next();
            ++this.iterationCount;
        } else {
            this.currentRow = null;
            this.count = this.iterationCount;
        }
        return hasNext;
    }

    @Override
    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    private IdxField<REC, ?> getField(int columnIndex) {
        if (this.currentRow == null) {
            throw new QueryException("There is no current row.");
        }
        return this.fields.get(columnIndex - 1);
    }

    @Override
    public short getShort(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getShort(columnIndex);
    }

    @Override
    public byte getByte(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getByte(columnIndex);
    }

    @Override
    public int getInteger(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getInteger(columnIndex);
    }

    @Override
    public long getLong(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getDouble(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getBoolean(columnIndex);
    }

    @Override
    public char getChar(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getChar(columnIndex);
    }

    @Override
    public <T> T getObject(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getObject(columnIndex);
    }

    @Override
    public String getString(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getString(columnIndex);
    }

    @Override
    public Date getDate(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getDate(columnIndex);
    }

    @Override
    public BigInteger getBigInteger(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getBigInteger(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public Currency getCurrency(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getCurrency(columnIndex);
    }

    @Override
    public <S> S[] getArray(String columnName) {
        if (!this.fieldIndexes.containsKey(columnName)) {
            throw new QueryException("Undefined column: " + columnName);
        }
        int columnIndex = this.fieldIndexes.get(columnName);
        return this.getArray(columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex) {
        IdxField<REC, ?> field = this.getField(columnIndex);
        if ("x_repository_name".equals(field.getName())) {
            return (T)this.queryResult.getRepositoryAlias();
        }
        return (T)this.currentRow.getValue(field);
    }

    @Override
    public short getShort(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Short)) {
            throw new QueryException("Column " + columnIndex + " does not contain Short values.");
        }
        return (Short)value;
    }

    @Override
    public byte getByte(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Byte)) {
            throw new QueryException("Column " + columnIndex + " does not contain Byte values.");
        }
        return (Byte)value;
    }

    @Override
    public int getInteger(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Integer)) {
            throw new QueryException("Column " + columnIndex + " does not contain Integer values.");
        }
        return (Integer)value;
    }

    @Override
    public long getLong(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Long)) {
            throw new QueryException("Column " + columnIndex + " does not contain Long values.");
        }
        return (Long)value;
    }

    @Override
    public float getFloat(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Float)) {
            throw new QueryException("Column " + columnIndex + " does not contain Float values.");
        }
        return ((Float)value).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Double)) {
            throw new QueryException("Column " + columnIndex + " does not contain Double values.");
        }
        return (Double)value;
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Boolean)) {
            throw new QueryException("Column " + columnIndex + " does not contain Boolean values.");
        }
        return (Boolean)value;
    }

    @Override
    public char getChar(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Character)) {
            throw new QueryException("Column " + columnIndex + " does not contain Character values.");
        }
        return ((Character)value).charValue();
    }

    @Override
    public String getString(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (value != null && !(value instanceof String)) {
            throw new QueryException("Column " + columnIndex + " does not contain String values.");
        }
        return (String)value;
    }

    @Override
    public Date getDate(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Date)) {
            throw new QueryException("Column " + columnIndex + " does not contain Date values.");
        }
        return (Date)value;
    }

    @Override
    public BigInteger getBigInteger(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof BigInteger)) {
            throw new QueryException("Column " + columnIndex + " does not contain BigInteger values.");
        }
        return (BigInteger)value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof BigDecimal)) {
            throw new QueryException("Column " + columnIndex + " does not contain BigDecimal values.");
        }
        return (BigDecimal)value;
    }

    @Override
    public Currency getCurrency(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Currency)) {
            throw new QueryException("Column " + columnIndex + " does not contain Currency values.");
        }
        return (Currency)value;
    }

    @Override
    public <S> S[] getArray(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Array)) {
            throw new QueryException("Column " + columnIndex + " does not contain Array values.");
        }
        return (Object[])value;
    }

    @Override
    public REC getRawResult() {
        return this.currentRow.getRecord();
    }

    @Override
    public List<IdxField<REC, ?>> getSelectedFields() {
        return this.fields;
    }

    @Override
    public List<String> getSelectedFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void close() {
        for (QueryResult<REC> queryResult : this.queryResults) {
            queryResult.close();
        }
        if (this.sortArea != null) {
            ((QuerySortAreaImpl)this.sortArea).close();
        }
    }

    public void setLimit(Range<Integer> limit) {
        this.limit = limit;
    }

    @Override
    public QueryPlan getPlan(String repository) {
        for (QueryResult<REC> queryResult : this.queryResults) {
            if (!queryResult.getRepositoryAlias().equalsIgnoreCase(repository)) continue;
            return queryResult.getPlan();
        }
        return null;
    }

    public List<QueryPlan> getAllPlans() {
        ArrayList plans = Lists.newArrayList();
        for (QueryResult<REC> queryResult : this.queryResults) {
            plans.add(queryResult.getPlan());
        }
        return plans;
    }

    @Override
    public final void describePlan(PrintStream out) {
        String indent = "  ";
        int level = 0;
        out.println("Query Plan: ");
        ++level;
        if (this.queryResults.size() > 1 && this.collation != null) {
            this.indent(out, "  ", level);
            out.print((Object)this.collation);
            out.println(":");
            ++level;
        }
        for (QueryResult<REC> queryResult : this.queryResults) {
            this.indent(out, "  ", level);
            out.print(queryResult.getRepositoryAlias());
            out.print(": ");
            List<? extends QueryPlan.Step> steps = queryResult.getPlan().getSteps();
            for (int i = 0; i < steps.size(); ++i) {
                if (i > 0) {
                    out.print("->");
                }
                out.print(steps.get(i));
            }
            out.println();
        }
    }

    private final void indent(PrintStream out, String indent, int level) {
        for (int i = 0; i < level; ++i) {
            out.print(indent);
        }
    }

    public final class RowImpl
    implements QueryResultSet.Row<REC> {
        private static final long serialVersionUID = 1L;
        private final ID recordId;
        private transient REC record;
        private final QueryAggregateField.Aggregate<REC> aggregate;
        private Map<String, Object> fieldValues = null;

        private RowImpl(REC record, ID recordId) {
            this.recordId = recordId;
            this.record = record;
            this.aggregate = null;
        }

        private RowImpl(QueryAggregateField.Aggregate<REC> aggregate) {
            this.recordId = null;
            this.record = null;
            this.aggregate = aggregate;
        }

        public RowImpl(IdxField<REC, ?> field, Map.Entry<?, ID> entry) {
            this.recordId = entry.getValue();
            this.record = null;
            this.aggregate = null;
            this.fieldValues = Maps.newHashMap();
            this.fieldValues.put(field.getCanonicalName(), entry.getKey());
        }

        public void reloadRecord(QueryIndexableRepository<ID, REC> repository) {
            if (this.record == null && this.recordId != null) {
                this.record = repository.retrieve(this.recordId);
            }
        }

        @Override
        public REC getRecord() {
            if (this.record == null && this.recordId != null) {
                throw new QueryException("Record [" + this.recordId + "] has not been loaded.");
            }
            return this.record;
        }

        public QueryAggregateField.Aggregate<REC> getAggregate() {
            return this.aggregate;
        }

        @Override
        public <T> T getValue(IdxField<REC, T> field) {
            String canonicalName;
            if (this.aggregate != null) {
                if (field instanceof QueryAggregateField) {
                    return (T)this.aggregate.yield((QueryAggregateField)field);
                }
                return this.aggregate.yieldKey(field);
            }
            if (this.fieldValues != null && this.fieldValues.containsKey(canonicalName = field.getCanonicalName())) {
                return (T)this.fieldValues.get(canonicalName);
            }
            Object rec = this.getRecord();
            return (T)field.apply(rec);
        }
    }
}

