/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.config.Config;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreWriter;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.impl.StorePacketPersisterStatsBase;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDisruptor;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;

public abstract class StorePacketPersisterBase
extends OdsObject
implements IStoreWriter {
    private final String id;
    private final UtlPool<WriteQueueElement> writeQueueEntryPool;
    private final UtlList writeQueue;
    private final boolean detached;
    private final boolean shared;
    private final int queueDepth;
    private final String claimStrategyStr;
    private final String waitStrategyStr;
    private final IStoreWriter.Parameters parameters;
    private final boolean recordLegLatencies;
    private final Disruptor<CarrierEvent> disruptor;
    private final long writerCpuAffinityMask;
    private WriterThread writer;
    private StorePacketPersisterStatsBase stats;
    protected final RingBuffer<CarrierEvent> ringBuffer;
    protected final boolean flushOnCommit;
    protected volatile IStoreBinding.Role role;
    protected volatile Exception failure;
    protected static final String PROP_DETACHED = "detachedPersist";
    protected static final String PROP_DETACHED_QUEUE_DEPTH = "queueDepth";
    protected static final String PROP_DETACHED_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    protected static final String PROP_DETACHED_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    protected static final String PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK = "queueDrainerCpuAffinityMask";
    protected static final String PROP_SHARED = "shared";
    protected static final String PROP_FLUSH_ON_COMMIT = "flushOnCommit";
    protected static final String PROP_RECORD_LEG_LATENCIES = "recordLegLatencies";

    protected StorePacketPersisterBase(RootConfig.ObjectConfig config, String idSuffix, Properties props) {
        super(config);
        this.id = "X-ODS-Store" + idSuffix;
        boolean administrative = UtlProps.getValue((Properties)props, (String)"administrative", (boolean)false);
        boolean bl = this.detached = UtlProps.getValue((Properties)props, (String)PROP_DETACHED, (String)UtlProps.getValue((Properties)props, (String)"detachedWrite", (String)UtlProps.getValue((Properties)props, (String)"detachedSend", null))) == null && !administrative && (Config.compatibleWith3x() && Config.tuneForLatency() || Config.tuneForThroughput()) ? true : UtlProps.getValue((Properties)props, (String)PROP_DETACHED, (boolean)UtlProps.getValue((Properties)props, (String)"detachedWrite", (boolean)UtlProps.getValue((Properties)props, (String)"detachedSend", (boolean)false)));
        if (this.detached) {
            this.queueDepth = UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_DEPTH, (int)1024);
            ProducerType producerType = UtlDisruptor.legacyClaimStrategyStrToProducerType((String)(Config.tuneForLatency() ? "SingleThreaded" : (Config.tuneForThroughput() ? "MultiThreadedSufficientCores" : UtlProps.getValue((Properties)props, (String)"publisherClaimStrategy", (String)UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_OFFER_STRATEGY, (String)"MultiThreaded")))));
            this.claimStrategyStr = UtlDisruptor.toProducerTypeStr((ProducerType)producerType);
            WaitStrategy waitStrategy = UtlDisruptor.getWaitStrategy((String)UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_WAIT_STRATEGY, null), (!administrative ? 1 : 0) != 0);
            this.waitStrategyStr = UtlDisruptor.waitStrategyToStr((WaitStrategy)waitStrategy);
            this.writerCpuAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)"cpuAffinityMask", (String)UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK, (String)UtlThread.getDefaultCPUAffinityMask())));
            this.disruptor = UtlDisruptor.createSingleConsumerDisruptor((EventFactory)new CarrierEventFactory(), (int)this.queueDepth, (ThreadFactory)new WriterThreadFactory(), (ProducerType)producerType, (WaitStrategy)waitStrategy, (EventHandler)new CarrierEventProcessor());
            this.ringBuffer = this.disruptor.getRingBuffer();
            this.disruptor.start();
        } else {
            this.queueDepth = 0;
            this.claimStrategyStr = "N/A";
            this.waitStrategyStr = "N/A";
            this.writerCpuAffinityMask = 0L;
            this.disruptor = null;
            this.ringBuffer = null;
        }
        this.writeQueue = UtlList.create();
        this.writeQueueEntryPool = UtlPool.create((String)"ods.pktjrnlr.writeq", (String)new UUID().toString(), (UtlPool.Factory)new WriteQueueElementFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.shared = UtlProps.getValue((Properties)props, (String)PROP_SHARED, (boolean)false);
        this.flushOnCommit = UtlProps.getValue((Properties)props, (String)PROP_FLUSH_ON_COMMIT, (boolean)true);
        this.recordLegLatencies = UtlProps.getValue((Properties)props, (String)PROP_RECORD_LEG_LATENCIES, (boolean)Config.getValue((String)"nv.stats.latency.leg.store.enabled", (boolean)Config.getValue((String)"nv.ods.latency.stats", (boolean)false)));
        this.parameters = new IStoreWriter.Parameters(this.detached, this.flushOnCommit);
    }

    protected StorePacketPersisterBase(String idSuffix, Properties props) {
        this(null, idSuffix, props);
    }

    private final String commitEntryTypeToStr(short commitEntryType) {
        switch (commitEntryType) {
            case 1: {
                return "Put";
            }
            case 2: {
                return "Update";
            }
            case 3: {
                return "Remove";
            }
            case 4: {
                return "Send";
            }
            case 5: {
                return "Message";
            }
        }
        return "Unknown";
    }

    protected final void dumpParams(String prefix, StringBuilder sb) {
        sb.append(prefix).append("shared=" + this.shared).append("\n");
        sb.append(prefix).append("flushOnCommit=" + this.flushOnCommit).append("\n");
        sb.append(prefix).append("detached=" + this.detached).append("\n");
        sb.append(prefix).append("...queueDepth=" + this.queueDepth).append("\n");
        sb.append(prefix).append("...claimStrategy=" + this.claimStrategyStr).append("\n");
        sb.append(prefix).append("...waitStrategy=" + this.waitStrategyStr).append("\n");
        sb.append(prefix).append("...affinityMask=" + this.writerCpuAffinityMask).append("\n");
    }

    protected final void dumpStackTraceBeforeFail(String str, Throwable e) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(str).append("\n");
            sb.append("Stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Failing persister...\n");
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void pruneWriteQueue(long stableTransactionId) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Pruning write queue (size=" + this.writeQueue.count() + ", stable transaction id=" + stableTransactionId + ")...", Tracer.Level.DEBUG);
        }
        WriteQueueElement wqe = null;
        int count = 0;
        while ((wqe = (WriteQueueElement)this.writeQueue.first()) != null && wqe.transactionId <= stableTransactionId) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "...X " + (Object)((Object)wqe) + "", Tracer.Level.DEBUG);
            }
            wqe.unlink();
            wqe.dispose();
            ++count;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "...pruned " + count + " entries.", Tracer.Level.DEBUG);
        }
    }

    private final void flushWriteQueue() throws Exception {
        WriteQueueElement wqe = null;
        int count = 0;
        while ((wqe = (WriteQueueElement)this.writeQueue.first()) != null) {
            wqe.unlink();
            try {
                this.doWrite(wqe.packet);
            }
            finally {
                wqe.dispose();
            }
            ++count;
        }
        this.tracer.log(this.tracePrefix() + "Flushed " + count + " in-doubt entries from write queue", Tracer.Level.INFO);
    }

    private final void write(PktPacket packet, long transactionId, long stableTransactionId, boolean commitEnd) throws Exception {
        if (this.role == IStoreBinding.Role.Primary || !this.shared) {
            if (this.writeQueue.count() > 0) {
                this.flushWriteQueue();
            }
            this.doWrite(packet);
        } else {
            WriteQueueElement wqe = (WriteQueueElement)this.writeQueueEntryPool.get(null);
            packet.acquire();
            wqe.packet.putFrom(packet);
            wqe.transactionId = transactionId;
            wqe.stableTransactionId = stableTransactionId;
            this.writeQueue.append((UtlListElement)wqe);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Enqueued " + (Object)((Object)wqe) + " in write queue", Tracer.Level.DEBUG);
            }
            if (commitEnd) {
                this.pruneWriteQueue(stableTransactionId);
            }
        }
    }

    private final void write(PktPacket packet, boolean sync) {
        try {
            PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
            long transactionId = subheaderODS.getTransactionId();
            long stableTransactionId = subheaderODS.getStableTransactionId();
            boolean commitEnd = subheaderODS.getFlagCommitEnd();
            this.write(packet, transactionId, stableTransactionId, commitEnd);
            if (commitEnd && this.flushOnCommit && this.hasBufferedDataToFlush() || sync) {
                this.flushCore(sync);
            }
            if (this.stats != null) {
                switch (subheaderODS.getCommitEntryType()) {
                    case 1: {
                        ++this.stats.numPutsRecorded;
                        break;
                    }
                    case 2: {
                        ++this.stats.numUpdatesRecorded;
                        break;
                    }
                    case 3: {
                        ++this.stats.numRemovesRecorded;
                        break;
                    }
                    case 4: {
                        ++this.stats.numSendsRecorded;
                        break;
                    }
                }
            }
            if (commitEnd) {
                ++this.stats.numCommits;
            }
        }
        catch (Throwable e) {
            this.dumpStackTraceBeforeFail("Exception encountered during write of commit packet", e);
            this.doFail(new OdsException(e));
        }
    }

    private final void flushCore(boolean sync) {
        if (this.role == IStoreBinding.Role.Primary || !this.shared) {
            try {
                if (this.writeQueue.count() > 0) {
                    this.flushWriteQueue();
                }
                this.doFlush(sync);
            }
            catch (Throwable e) {
                this.dumpStackTraceBeforeFail("Exception encountered during flush", e);
                this.doFail(new OdsException(e));
            }
        }
    }

    private final void stopCore() {
        this.writeQueueEntryPool.close();
        if (this.stats != null) {
            this.stats.close();
        }
    }

    protected final boolean isDetached() {
        return this.detached;
    }

    final int getWriteQueueSize() {
        return this.writeQueue.count;
    }

    final int getDisruptorCapacity() {
        return this.ringBuffer != null ? this.ringBuffer.getBufferSize() : -1;
    }

    final int getDisruptorRemaining() {
        return this.ringBuffer != null ? (int)this.ringBuffer.remainingCapacity() : -1;
    }

    final String getDisruptorClaimStrategy() {
        return this.claimStrategyStr;
    }

    final String getDisruptorWaitStrategy() {
        return this.waitStrategyStr;
    }

    protected final void setStats(StorePacketPersisterStatsBase stats) {
        this.stats = stats;
    }

    protected void doChangeRole(IStoreBinding.Role role) {
        this.role = role;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Role changed to '" + (Object)((Object)role) + "'", Tracer.Level.DEBUG);
        }
    }

    protected abstract void doWritePersisterMetadata(IOElasticBuffer var1, int var2) throws Exception;

    protected abstract void doWrite(PktPacket var1) throws Exception;

    protected abstract boolean hasBufferedDataToFlush();

    protected abstract void doFlush(boolean var1) throws Exception;

    protected abstract void doFail(Exception var1);

    protected abstract String tracePrefix();

    protected final boolean depacketize(PktPacket packet, StoreCommitEntry commitEntry) throws OdsException {
        PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
        if (subheaderODS == null) {
            throw new OdsException("received invalid packet [no ODS subheader]");
        }
        short commitEntryType = subheaderODS.getCommitEntryType();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "...commit entry (type=" + this.commitEntryTypeToStr(commitEntryType) + ").", Tracer.Level.DEBUG);
        }
        if (commitEntryType != 5) {
            commitEntry.init(packet);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "......{id=" + (commitEntry.oid != null ? commitEntry.oid.toString() : "null") + ", ofid=" + commitEntry.ofid + ", otype=" + commitEntry.otype + ", encoding=" + (Object)((Object)commitEntry.contentEncodingType) + ").", Tracer.Level.DEBUG);
            }
            return true;
        }
        return false;
    }

    protected final void stop() {
        if (this.ringBuffer != null) {
            if (this.writer.isAlive()) {
                long sequence = this.ringBuffer.next();
                CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
                carrierEvent.stop = true;
                this.ringBuffer.publish(sequence);
            }
            if (this.writer != Thread.currentThread()) {
                while (this.writer.isAlive()) {
                    try {
                        this.writer.join(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            UtlThread.deregister((Thread)this.writer);
        } else {
            this.stopCore();
        }
    }

    protected final void onFailure(Exception cause) {
        this.failure = cause;
    }

    @Override
    public final IStoreWriter.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public final boolean isShared() {
        return this.shared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onRoleChange(IStoreBinding.Role role) {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Changing role to '" + (Object)((Object)role) + "'...", Tracer.Level.DEBUG);
        }
        if (this.ringBuffer != null) {
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.role = role;
            carrierEvent.publishTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.doChangeRole(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeCommitEntry(PktPacket packet, boolean sync) {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Writing (sync=" + sync + ", detached=" + (this.ringBuffer != null) + ")...", Tracer.Level.DEBUG);
        }
        if (this.ringBuffer != null) {
            long offerTime = this.recordLegLatencies ? UtlTime.now() : 0L;
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.publishTs = offerTime;
            carrierEvent.packet.putFrom(packet);
            carrierEvent.write = true;
            carrierEvent.flush = false;
            carrierEvent.sync = sync;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.write(packet, sync);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush(boolean sync) {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Flushing (detached=" + (this.ringBuffer != null) + ")...", Tracer.Level.DEBUG);
        }
        if (this.ringBuffer != null) {
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.publishTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            carrierEvent.write = false;
            carrierEvent.flush = true;
            carrierEvent.sync = sync;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.flushCore(sync);
            }
        }
    }

    protected final class CarrierEvent {
        public long publishTs;
        public IStoreBinding.Role role;
        public final PktPacket packet = PktFactory.getInstance().createPacket(264);
        public boolean write;
        public boolean flush;
        public boolean sync;
        public boolean stop;

        final void reset() {
            this.publishTs = 0L;
            this.role = null;
            this.write = false;
            this.flush = false;
            this.sync = false;
            this.stop = false;
            if (Config.conserveMemory()) {
                this.packet.reset(true);
            } else {
                this.packet.getBody().reset(false);
            }
        }
    }

    private final class WriterThreadFactory
    implements ThreadFactory {
        private WriterThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            return StorePacketPersisterBase.this.writer = new WriterThread(StorePacketPersisterBase.this.id, r);
        }
    }

    private final class WriterThread
    extends Thread {
        private final Runnable r;

        WriterThread(String name, Runnable r) {
            this.setDaemon(true);
            this.setName(name);
            this.r = r;
        }

        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)StorePacketPersisterBase.this.writerCpuAffinityMask);
            this.r.run();
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        private CarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.stop) {
                    StorePacketPersisterBase.this.disruptor.halt();
                    StorePacketPersisterBase.this.stopCore();
                } else if (StorePacketPersisterBase.this.failure == null) {
                    if (StorePacketPersisterBase.this.stats != null && event.publishTs > 0L) {
                        ((StorePacketPersisterBase)StorePacketPersisterBase.this).stats.o2p.add((double)(UtlTime.now() - event.publishTs));
                    }
                    if (event.role != null) {
                        StorePacketPersisterBase.this.doChangeRole(event.role);
                    }
                    if (event.write) {
                        StorePacketPersisterBase.this.write(event.packet, event.sync);
                    }
                    if (event.flush || event.sync) {
                        StorePacketPersisterBase.this.flushCore(event.sync);
                    }
                }
            }
            catch (Throwable e) {
                StorePacketPersisterBase.this.dumpStackTraceBeforeFail("Unhandled exception encountered in detached persister", e);
                StorePacketPersisterBase.this.doFail(new OdsException(e));
            }
            finally {
                event.reset();
            }
        }
    }

    private final class CarrierEventFactory
    implements EventFactory<CarrierEvent> {
        private CarrierEventFactory() {
        }

        public final CarrierEvent newInstance() {
            return new CarrierEvent();
        }
    }

    private final class WriteQueueElementFactory
    implements UtlPool.Factory<WriteQueueElement> {
        private WriteQueueElementFactory() {
        }

        public final WriteQueueElement createItem(Object object) {
            return new WriteQueueElement();
        }

        public final WriteQueueElement[] createItemArray(int size) {
            return new WriteQueueElement[size];
        }
    }

    private final class WriteQueueElement
    extends UtlListElement
    implements UtlPool.Item<WriteQueueElement> {
        private final PktPacket packet = PktFactory.getInstance().createPacket(264);
        private long transactionId;
        private long stableTransactionId;
        private UtlPool<WriteQueueElement> pool;

        private WriteQueueElement() {
        }

        final void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final WriteQueueElement init() {
            if (Config.conserveMemory()) {
                this.packet.reset(true);
            } else {
                this.packet.getBody().reset(false);
            }
            this.transactionId = 0L;
            this.stableTransactionId = 0L;
            return this;
        }

        public final WriteQueueElement setPool(UtlPool<WriteQueueElement> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<WriteQueueElement> getPool() {
            return this.pool;
        }

        public final String toString() {
            return "[txnid=" + this.transactionId + ", stbltxnid=" + this.stableTransactionId + "]";
        }
    }
}

