/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkOpTimeoutException;
import com.neeve.link.ELnkOpWouldAsyncException;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.ILnkServerEndpointCore;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkObject;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;

public final class LnkServerEndpoint
extends LnkObject
implements ILnkServerEndpoint {
    private final ILnkServerEndpointCore sep;
    private final AcceptCompleteEventHandler acceptCompleteEventHandler;
    private final TimeoutEventHandler timeoutEventHandler;
    private final NotifyEventHandler notifyEventHandler;
    private AcceptPostContext context;
    private State state;

    private LnkServerEndpoint(RootConfig.ObjectConfig config, ILnkServerEndpointCore sep) {
        super(config);
        this.sep = sep;
        this.acceptCompleteEventHandler = new AcceptCompleteEventHandler();
        this.timeoutEventHandler = new TimeoutEventHandler();
        this.notifyEventHandler = new NotifyEventHandler();
        this.state = State.READY;
    }

    private final void dispatchCompletion(LnkEvents.ConnectAcceptCompleteEventData completionEvent) {
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("Completion event is being dispatched in the context of the wrong thread!");
        }
        try {
            this.context.handler.onEvent(this.context.dispatcher, this, 2, completionEvent);
        }
        catch (Exception e) {
            if (completionEvent.status) {
                this.tracer.log("Exception thrown by handler of the event indicating successful acceptance of a '' link [" + e.toString() + "]. Closing established link...", Tracer.Level.DIAGNOSE);
                try {
                    completionEvent.pep.close((short)-1);
                }
                catch (Exception e1) {
                    this.tracer.log("Failure to close an accepted link upon receiving an exception from the handler of the accept completion event [" + e1.toString() + "]. Ignoring.", Tracer.Level.DIAGNOSE);
                }
            }
            this.tracer.log("Exception thrown by handler of the event indicating failed acceptance of '' link [" + e.toString() + "]. Ignoring.", Tracer.Level.DIAGNOSE);
        }
    }

    private final void onEvent(Event event, Object data) throws ELnkInvalidStateException, ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log("Server endpoint state machine ENTRY [event=" + (Object)((Object)event) + " state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
        }
        block1 : switch (this.state) {
            case READY: {
                switch (event) {
                    case ON_ACCEPT: {
                        this.context = (AcceptPostContext)data;
                        if (this.tracer.debug) {
                            this.tracer.log("Accepting...", Tracer.Level.DEBUG);
                        }
                        this.sep.acceptPost(this.context.dispatcher, this.acceptCompleteEventHandler.reset(), this.context.flags);
                        if (this.acceptCompleteEventHandler.wasInvoked()) break block1;
                        if (this.tracer.debug) {
                            this.tracer.log("Accept pending.", Tracer.Level.DEBUG);
                        }
                        if ((this.context.flags & 2) == 2) {
                            if (this.tracer.debug) {
                                this.tracer.log("NO_ASYNC flag specified. Returning with exception...", Tracer.Level.DEBUG);
                            }
                            throw new ELnkOpWouldAsyncException();
                        }
                        this.onEvent(Event.ON_ACCEPT_PENDING, null);
                        break block1;
                    }
                    case ON_ACCEPT_PENDING: {
                        if (this.context.timeout > 0) {
                            if (this.tracer.debug) {
                                this.tracer.log("Starting accept timer alarm [timeout=" + this.context.timeout + "ms]...", Tracer.Level.DEBUG);
                            }
                            this.context.alarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, this.timeoutEventHandler, this.context.timeout);
                            this.context.dispatcher.schedAlarmEv(this.context.alarmEvent);
                        } else if (this.tracer.debug) {
                            this.tracer.log("Inifinite timeout requested [" + this.context.timeout + "ms]. Not starting timer alarm.", Tracer.Level.DEBUG);
                        }
                        this.state = State.ACCEPTING;
                        break block1;
                    }
                    case ON_ACCEPT_COMPLETE: {
                        if ((this.context.flags & 1) == 1) {
                            if (this.tracer.debug) {
                                this.tracer.log("IMMEDIATE_DISPATCH flag specified. Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                            }
                            this.state = State.READY;
                            this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                            break block1;
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("IMMEDIATE_DISPATCH flag not specified. Scheduling completion event " + data + "]...", Tracer.Level.DEBUG);
                        }
                        this.context.userEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.notifyEventHandler);
                        this.context.dispatcher.schedUserEv((IEmxUserEvent)this.context.userEvent.setAttachment(data));
                        this.state = State.NOTIFYING;
                        break block1;
                    }
                    case ON_CLOSE: {
                        if (this.tracer.debug) {
                            this.tracer.log("Closing wrapped endpoint...", Tracer.Level.DEBUG);
                        }
                        this.sep.close();
                        this.state = State.CLOSED;
                        break block1;
                    }
                    default: {
                        throw new ELnkInvalidStateException(event.toString(), this.state.toString());
                    }
                }
            }
            case ACCEPTING: {
                switch (event) {
                    case ON_ACCEPT_COMPLETE: {
                        if (this.context.alarmEvent != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Stopping alarm...", Tracer.Level.DEBUG);
                            }
                            this.context.dispatcher.unschedAlarmEv(this.context.alarmEvent);
                        } else if (this.tracer.debug) {
                            this.tracer.log("Alarm not started.", Tracer.Level.DEBUG);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.READY;
                        this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                        break block1;
                    }
                    case ON_CANCEL: {
                        if (this.context.alarmEvent != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Stopping alarm...", Tracer.Level.DEBUG);
                            }
                            this.context.dispatcher.unschedAlarmEv(this.context.alarmEvent);
                        } else if (this.tracer.debug) {
                            this.tracer.log("Alarm not started.", Tracer.Level.DEBUG);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Cancelling accept on wrapped endpoint.", Tracer.Level.DEBUG);
                        }
                        this.sep.acceptCancel(0);
                        LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(new ELnkOpCancelledException());
                        if (this.tracer.debug) {
                            this.tracer.log("Scheduling completion event " + completionEvent + "...", Tracer.Level.DEBUG);
                        }
                        this.context.userEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.notifyEventHandler);
                        this.context.dispatcher.schedUserEv((IEmxUserEvent)this.context.userEvent.setAttachment(completionEvent));
                        this.state = State.CANCELLING;
                        break block1;
                    }
                    case ON_TIMEOUT: {
                        if (this.tracer.debug) {
                            this.tracer.log("Cancelling accept on wrapped endpoint.", Tracer.Level.DEBUG);
                        }
                        this.sep.acceptCancel(0);
                        LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(new ELnkOpTimeoutException());
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + completionEvent + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.READY;
                        this.dispatchCompletion(completionEvent);
                        break block1;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case NOTIFYING: {
                switch (event) {
                    case ON_NOTIFY: {
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.READY;
                        this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                        break block1;
                    }
                    case ON_CANCEL: {
                        LnkEvents.ConnectAcceptCompleteEventData oldCompletionEvent = (LnkEvents.ConnectAcceptCompleteEventData)this.context.userEvent.getAttachment();
                        LnkEvents.ConnectAcceptCompleteEventData newCompletionEvent = new LnkEvents.ConnectAcceptCompleteEventData(new ELnkOpCancelledException());
                        if (this.tracer.debug) {
                            this.tracer.log("Replacing completion event " + oldCompletionEvent + " with completion event " + newCompletionEvent + "...", Tracer.Level.DEBUG);
                        }
                        try {
                            oldCompletionEvent.pep.close((short)-1);
                        }
                        catch (Exception e) {
                            this.tracer.log("Failed to close accepted peer endpoint on cancellation of an accept [" + e.toString() + "]", Tracer.Level.DIAGNOSE);
                        }
                        this.context.userEvent.setAttachment(newCompletionEvent);
                        this.state = State.CANCELLING;
                        break block1;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case CANCELLING: {
                switch (event) {
                    case ON_NOTIFY: {
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.READY;
                        this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                        break block1;
                    }
                    case ON_CANCEL: {
                        break block1;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case CLOSED: {
                switch (event) {
                    case ON_CLOSE: {
                        break block1;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            default: {
                throw new InternalError("Invalid state [" + this.state.toString() + "]");
            }
        }
    }

    public static ILnkServerEndpoint create(RootConfig.ObjectConfig config, ILnkServerEndpointCore sep) {
        return new LnkServerEndpoint(config, sep);
    }

    @Override
    public final void acceptPost(IEmxDispatcher dispatcher, ILnkEventHandler handler, int timeout, int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (dispatcher.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        this.onEvent(Event.ON_ACCEPT, new AcceptPostContext(dispatcher, handler, timeout, flags));
    }

    @Override
    public final void acceptCancel(int flags) throws ELnkInvalidStateException, ELnkNotOwnerException {
        if (this.context != null && this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        try {
            this.onEvent(Event.ON_CANCEL, new AcceptCancelContext(flags));
        }
        catch (ELnkOpFailedException e) {
            throw new InternalError("Accept cancel operation threw ELnkOpFailedException!");
        }
    }

    @Override
    public final void close() throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.context != null && this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        this.onEvent(Event.ON_CLOSE, null);
    }

    protected final void finalize() {
        block2: {
            try {
                this.onEvent(Event.ON_CLOSE, null);
            }
            catch (Exception e) {
                if (!this.tracer.debug) break block2;
                this.tracer.log("Failed to close server endpoint on finalization [" + e.toString() + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final class AcceptCancelContext {
        final int flags;

        AcceptCancelContext(int flags) {
            this.flags = flags;
        }
    }

    private final class AcceptPostContext {
        final IEmxDispatcher dispatcher;
        final ILnkEventHandler handler;
        final int timeout;
        final int flags;
        IEmxAlarmEvent alarmEvent;
        IEmxUserEvent userEvent;

        AcceptPostContext(IEmxDispatcher dispatcher, ILnkEventHandler handler, int timeout, int flags) {
            this.dispatcher = dispatcher;
            this.handler = handler;
            this.timeout = timeout;
            this.flags = flags;
        }
    }

    private final class NotifyEventHandler
    implements IEmxEventHandler {
        private NotifyEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            try {
                LnkServerEndpoint.this.onEvent(Event.ON_NOTIFY, event.getAttachment());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class TimeoutEventHandler
    implements IEmxEventHandler {
        private TimeoutEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            try {
                LnkServerEndpoint.this.onEvent(Event.ON_TIMEOUT, null);
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class AcceptCompleteEventHandler
    implements ILnkEventHandlerCore {
        private boolean wasInvoked;

        private AcceptCompleteEventHandler() {
        }

        final AcceptCompleteEventHandler reset() {
            this.wasInvoked = false;
            return this;
        }

        final boolean wasInvoked() {
            return this.wasInvoked;
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, int event, Object data) {
            if (event != 2) {
                throw new InternalError("Received unexpected event [" + event + "] from wrapped endpoint");
            }
            try {
                this.wasInvoked = true;
                LnkServerEndpoint.this.onEvent(Event.ON_ACCEPT_COMPLETE, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum Event {
        ON_ACCEPT,
        ON_ACCEPT_PENDING,
        ON_ACCEPT_COMPLETE,
        ON_NOTIFY,
        ON_CANCEL,
        ON_TIMEOUT,
        ON_CLOSE;

    }

    private static enum State {
        READY,
        ACCEPTING,
        NOTIFYING,
        CANCELLING,
        CLOSED;

    }
}

