/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.kafka;

import com.neeve.config.Config;
import com.neeve.event.IEventHandler;
import com.neeve.kafka.KafkaMessageBusBinding;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessagingProvider;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.DefaultMessageChannelKeyNormalizer;
import com.neeve.sma.impl.MessageChannelKeyNormalizer;
import com.neeve.sma.impl.MessagingProviderBase;
import java.util.Properties;

public class KafkaProvider
extends MessagingProviderBase {
    static final int MAX_KAFKA_KEY_LENGTH = Config.getValue((String)"nv.sma.kafkamaxkeylength", (int)250);
    static final MessageChannelKeyNormalizer KEY_NORMALIZER = new KafkaKeyNormalizer();

    public KafkaProvider(String name, Properties props) {
        super(null, name, props);
    }

    public final MessageBusBinding doCreateBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        return new KafkaMessageBusBinding(userName, descriptor, eventHandler);
    }

    public static final MessagingProvider create(String name, Properties props) throws SmaException {
        return new KafkaProvider(name, props);
    }

    public final MessageChannelKeyNormalizer createMessageChannelKeyNormalizer(MessageChannelDescriptor channelDescriptor) {
        return KEY_NORMALIZER;
    }

    private static class KafkaKeyNormalizer
    extends DefaultMessageChannelKeyNormalizer {
        private KafkaKeyNormalizer() {
        }

        public char getHierarchicalKeyDelimiter() {
            return '.';
        }

        public final int getMaxKeyLength() {
            return 249;
        }

        public final String cleanFilterLevel(String filterLevel) {
            if (filterLevel.equals(">")) {
                return filterLevel;
            }
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < filterLevel.length(); ++j) {
                char c = filterLevel.charAt(j);
                if (j + 1 == filterLevel.length() && c == '*') {
                    sb.append(c);
                    continue;
                }
                sb.append(Character.isLetterOrDigit(c) ? Character.valueOf(c) : "_");
            }
            return sb.toString();
        }
    }
}

