/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.emx.EmxNwLnkBlockingReader;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.io.IOBuffer;
import com.neeve.perf.common.SystemProperties;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;

@AnnotatedCommand.Command(keywords={"BlockingPingPongReceiver"}, description="A blocking receiver to test ping pong performance using EMX links")
public class BlockingPingPongReceiver
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=109, longForm="messageSize", defaultValue="256", required=true, description="The size of the the message being ping ponged")
    private int _messageSize;
    @AnnotatedCommand.Option(shortForm=99, longForm="cpuAffinityMask", description="the CPU(s) to affinitize the reading thread to")
    private String _cpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=112, longForm="spinRead", description="whether to spin or block on the read")
    private boolean _spinRead;
    @AnnotatedCommand.Option(shortForm=115, longForm="stats", defaultValue="false", required=true, description="Whether to output incremental throughput stats")
    private boolean _stats;

    public void execute() throws Exception {
        SystemProperties.dump();
        EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create((String)this._descriptor, (EmxNwLnkAcceptor.Callback)new AcceptCallback());
        EmxNwLnk link = acceptor.accept();
        link.configureBlockingWrite(true);
        new ReaderThread(link, this._spinRead).start();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
        new BlockingPingPongReceiver().run(args);
    }

    private final class ReaderThread
    extends Thread {
        ReaderThread(EmxNwLnk link, boolean spinRead) throws Exception {
            super((Runnable)EmxNwLnkBlockingReader.create((EmxNwLnk)link, (EmxNwLnkReader.Callback)new ReadCallback(), (boolean)spinRead));
        }

        @Override
        public final void run() {
            if (BlockingPingPongReceiver.this._cpuAffinityMask != null) {
                System.out.println("[BlockingPingPongReceiver] Affinitizing thread to CPU " + BlockingPingPongReceiver.this._cpuAffinityMask);
                UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)BlockingPingPongReceiver.this._cpuAffinityMask));
            }
            super.run();
        }
    }

    private final class ReadCallback
    implements EmxNwLnkReader.Callback {
        private final IOBuffer message;
        private long start;
        private long deltaStart;
        private int numRcvd;
        private int deltaNumRcvd;

        private ReadCallback() {
            this.message = IOBuffer.create((int)BlockingPingPongReceiver.this._messageSize);
        }

        public final int handleReadData(EmxNwLnk link, IOBuffer iobuf, int length) {
            int count = length / BlockingPingPongReceiver.this._messageSize;
            try {
                if (count > 0) {
                    int messageBoundary = 0;
                    for (int i = 0; i < count; ++i) {
                        this.message.putLong(0, iobuf.getLong(messageBoundary));
                        link.write(this.message, 0, BlockingPingPongReceiver.this._messageSize);
                        messageBoundary += BlockingPingPongReceiver.this._messageSize;
                    }
                    if (BlockingPingPongReceiver.this._stats) {
                        long now = System.currentTimeMillis();
                        if (this.start == 0L) {
                            this.start = this.deltaStart = now;
                        }
                        this.numRcvd += count;
                        this.deltaNumRcvd += count;
                        if (now - this.deltaStart >= 1000L) {
                            long deltaRate = (long)this.deltaNumRcvd * 1000L / (now - this.deltaStart);
                            long overallRate = (long)this.numRcvd * 1000L / (now - this.start);
                            System.out.println("[BlockingPingPongReceiver] RATE [" + deltaRate + "," + overallRate + "]");
                            this.deltaStart = now;
                            this.deltaNumRcvd = 0;
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return BlockingPingPongReceiver.this._messageSize * count;
        }

        public final void handleLinkClosure(EmxNwLnk lnk) {
            System.out.println("[BlockingPingPongReceiver] Link closed by peer");
        }

        public final void handleLinkFailure(EmxNwLnk lnk, Throwable cause) {
            cause.printStackTrace();
        }
    }

    private final class AcceptCallback
    implements EmxNwLnkAcceptor.Callback {
        private AcceptCallback() {
        }

        public final void handleAcceptedLink(EmxNwLnk link) {
        }

        public final void handleAcceptorFailure(Throwable cause) {
        }
    }
}

