/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.test;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class UnitTest {
    private static final HashSet<String> enabledTestGroups;
    private static boolean testBedRootWasSet;
    private static boolean verbose;
    private static Boolean inMavenOrIDE;
    private int counter = 0;
    @Rule
    public TestName testcaseName = new TestName();
    @Rule
    public TestWatcher watcher = new TestWatcher(){
        private long startTime = System.currentTimeMillis();

        private long testDuration() {
            return (System.currentTimeMillis() - this.startTime) / 1000L;
        }

        protected void starting(Description description) {
            if (UnitTest.verbose()) {
                System.out.println("STARTING testcase " + description.getMethodName());
            }
        }

        protected void succeeded(Description description) {
            if (UnitTest.verbose() || System.currentTimeMillis() - this.startTime <= 10000L) {
                // empty if block
            }
            System.out.println("FINISHED testcase " + description.getMethodName() + " [SUCCESS] (" + this.testDuration() + "s)");
        }

        protected void failed(Throwable e, Description description) {
            System.out.println("FAILED testcase " + description.getMethodName() + "[FAILED" + (e != null ? " (" + e.getMessage() + ")]" : "]") + this.testDuration() + "s)");
        }

        protected void skipped(AssumptionViolatedException e, Description description) {
            System.out.println("SKIPPED testcase " + description.getMethodName() + "[SKIPPED" + e != null ? " (" + e.getMessage() + ")]" : "]");
        }
    };

    private static boolean isEclipse() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[stack.length - 1].toString().indexOf("eclipse") > 0;
    }

    private static boolean isIntelliJ() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[stack.length - 1].toString().contains("intellij");
    }

    private static boolean isMavenSurefire() {
        return System.getProperties().containsKey("surefire.test.class.path");
    }

    private static void deleteDirectory(File dir) throws IOException {
        File[] entries = dir.listFiles();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].isDirectory()) {
                    UnitTest.deleteDirectory(entries[i]);
                    continue;
                }
                entries[i].delete();
            }
        }
        dir.delete();
    }

    protected static File getProjectBaseDirectory() {
        String basedir = System.getProperty("basedir");
        if (basedir != null) {
            return new File(basedir);
        }
        return new File(".");
    }

    protected static void configureForInMemoryConfigRepo(Class<?> testClass) {
    }

    protected static boolean isTestInEnabledGroups(String testGroup) {
        boolean ret = enabledTestGroups.contains("all");
        if (!ret && testGroup != null) {
            ret = testGroup.equalsIgnoreCase("any") || enabledTestGroups.contains(testGroup.toLowerCase());
        }
        return ret;
    }

    private boolean isTestInEnabledGroups() {
        String testGroup = null;
        RunIn runInAnnotation = this.getClass().getAnnotation(RunIn.class);
        if (runInAnnotation != null) {
            testGroup = runInAnnotation.group();
        }
        return UnitTest.isTestInEnabledGroups(testGroup);
    }

    protected void testDesc(String s) {
        System.out.print("#" + ++this.counter + "-" + s);
    }

    protected static void testSuccess(String s) {
        System.out.println("OK [" + s + "]");
    }

    protected static void testFailure(String s) {
        System.out.println("FAIL [" + s + "]");
        throw new Error(s);
    }

    protected static boolean verbose() {
        return verbose;
    }

    protected static void setVerbose(boolean verbose) {
        UnitTest.verbose = verbose;
    }

    protected static File getTestbedRoot() {
        return new File(System.getProperty("NVROOT"));
    }

    @BeforeClass
    public static void initializeUnitTest() throws IOException {
        if (System.getProperty("NVROOT") == null) {
            File rdat;
            File testRoot = UnitTest.getProjectBaseDirectory().getCanonicalFile();
            if (inMavenOrIDE == null) {
                inMavenOrIDE = UnitTest.isEclipse() || UnitTest.isIntelliJ() || UnitTest.isMavenSurefire();
            }
            if (inMavenOrIDE.booleanValue()) {
                if (new File(testRoot, "target").exists()) {
                    testRoot = new File(testRoot, "target/testbed");
                }
                System.setProperty("nv.data.directory", new File(testRoot, "rdat").getCanonicalPath());
            }
            System.setProperty("NVROOT", testRoot.getCanonicalPath());
            testBedRootWasSet = true;
            if (!testRoot.exists()) {
                testRoot.mkdirs();
            }
            if ((rdat = new File(testRoot, "rdat")).exists()) {
                UnitTest.deleteDirectory(rdat);
            }
        }
        verbose = new Boolean(System.getProperty("nv.test.verbose", "false"));
    }

    @Before
    public void shouldTestRun() {
        Assume.assumeTrue((boolean)this.isTestInEnabledGroups());
    }

    @AfterClass
    public static void finalizeUnitTest() {
        if (testBedRootWasSet) {
            System.clearProperty("NVROOT");
            testBedRootWasSet = false;
        }
    }

    static {
        verbose = false;
        inMavenOrIDE = null;
        System.setProperty("nv.enable.unsupported", "true");
        enabledTestGroups = new HashSet();
        String commaSeparatedEnabledTestGroups = System.getProperty("nv.test.groups", null);
        if (commaSeparatedEnabledTestGroups != null) {
            StringTokenizer tokenizer = new StringTokenizer(commaSeparatedEnabledTestGroups, ",", false);
            while (tokenizer.hasMoreTokens()) {
                enabledTestGroups.add(tokenizer.nextToken().toLowerCase());
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RunIn {
        public String group();
    }
}

