/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.ArgumentHandler;
import com.neeve.cli.CliException;
import com.neeve.cli.CliParser;
import com.neeve.cli.FieldValueApplier;
import com.neeve.cli.IndentingWriter;
import com.neeve.cli.OptionHandler;
import com.neeve.cli.ParameterValueApplier;
import com.neeve.cli.RemainingArgsHandler;
import com.neeve.cli.annotations.Argument;
import com.neeve.cli.annotations.Command;
import com.neeve.cli.annotations.Option;
import com.neeve.cli.annotations.RemainingArgs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;

public class CommandExecutor {
    private final CliParser parser = new CliParser();
    private final ArrayList<ArgumentHandler> argHandlers = new ArrayList();
    private final ArrayList<OptionHandler> optionHandlers = new ArrayList();
    private final Command command;
    private final String name;
    private final String displayName;
    private String[] aliases;
    private final String description;
    private final Object runMethodContainer;
    private final Method runMethod;
    private final Object[] runMethodParameters;
    private final Class<?>[] runMethodParameterTypes;
    private final String[] group;
    private final boolean hidden;
    private RemainingArgsHandler remaingArgsHandler;
    private boolean showHelp;
    private StringBuilder usage = null;

    private CommandExecutor(Object container, Method runMethod) throws CliException {
        Command command = null;
        this.runMethodContainer = container;
        this.runMethod = runMethod;
        this.runMethodParameterTypes = runMethod.getParameterTypes();
        this.runMethodParameters = new Object[this.runMethodParameterTypes.length];
        if (container.getClass().getAnnotation(Command.class) != null) {
            command = container.getClass().getAnnotation(Command.class);
            this.aliases = command.aliases();
            if (runMethod.getAnnotation(Command.class) != null) {
                throw new CliException("Both method container '" + container.getClass().getName() + "' and method '" + runMethod.getName() + "' are annotated with Command.");
            }
            this.parseFieldContainerAnnotations(container);
            this.name = "<null>".equals(command.name()) ? container.getClass().getSimpleName().toLowerCase() : command.name();
            this.displayName = "<null>".equals(command.displayName()) ? null : command.displayName();
            this.group = command.group();
            this.hidden = command.hidden();
        } else if (runMethod.getAnnotation(Command.class) != null) {
            String runMethodLowerCase;
            command = runMethod.getAnnotation(Command.class);
            this.aliases = command.aliases();
            this.parseRunMethodAnnotations(container, runMethod);
            if (!runMethod.isAccessible()) {
                runMethod.setAccessible(true);
            }
            this.name = "<null>".equals(command.name()) ? runMethod.getName() : command.name();
            this.displayName = "<null>".equals(command.displayName()) ? null : command.displayName();
            this.group = command.group();
            this.hidden = command.hidden();
            if ("<null>".equals(command.name()) && !this.name.equals(runMethodLowerCase = runMethod.getName().toLowerCase()) && this.aliases.length > 0) {
                String[] newAliases = new String[this.aliases.length + 1];
                System.arraycopy(this.aliases, 0, newAliases, 0, this.aliases.length);
                this.aliases = newAliases;
                this.aliases[this.aliases.length - 1] = runMethodLowerCase;
            }
        } else {
            throw new CliException("Neither method container '" + container.getClass().getName() + "' nor method '" + runMethod.getName() + "' are annotated with Command.");
        }
        Collections.sort(this.argHandlers);
        short position = 0;
        boolean optionalOnly = false;
        for (ArgumentHandler handler : this.argHandlers) {
            if (handler.position <= position) {
                throw new CliException("Illegal command argument position '" + handler.position + "' for arg '" + handler.name + "' in command '" + this.name + "', a position greater than " + position + " is required.");
            }
            if (optionalOnly && handler.required) {
                throw new CliException("Command argument can't be required for arg '" + handler.name + "' in command '" + this.name + "', required arguments cannot fallow optional arguments.");
            }
            position = handler.position;
            optionalOnly = optionalOnly || !handler.required;
        }
        this.command = command;
        this.description = !"<null>".equals(command.description()) ? WordUtils.wrap((String)command.description(), (int)80, (String)"\n  ", (boolean)false) : WordUtils.wrap((String)("Invokes " + container.getClass().getName() + "." + runMethod.getName() + "(...)."), (int)80, (String)"\n  ", (boolean)false);
    }

    public List<ArgumentHandler> getArgumentHandlers() {
        return this.argHandlers;
    }

    public boolean getSupportsRemainingArgs() {
        return this.remaingArgsHandler != null;
    }

    public RemainingArgsHandler getRemainingArgsHandler() {
        return this.remaingArgsHandler;
    }

    public List<OptionHandler> getOptionHandlers() {
        return this.optionHandlers;
    }

    public String getCommandName() {
        return this.name;
    }

    public String getCommandDisplayName() {
        return this.displayName;
    }

    public String[] getCommandAliases() {
        return this.aliases.length > 0 ? this.aliases : null;
    }

    public String getCommandDescription() {
        return this.description;
    }

    public boolean isCommandHidden() {
        return this.hidden;
    }

    public String[] getCommandGroup() {
        return this.group;
    }

    public Class<?> getReturnType() {
        return this.runMethod.getReturnType();
    }

    public static CommandExecutor createExecutor(Object targetObject, Method runMethod) throws CliException {
        return new CommandExecutor(targetObject, runMethod);
    }

    public static CommandExecutor createExecutor(Object targetObject, String commandName) throws CliException {
        for (Method m : targetObject.getClass().getMethods()) {
            Command command = m.getAnnotation(Command.class);
            if (command == null) continue;
            if (command.name().equalsIgnoreCase(commandName)) {
                return CommandExecutor.createExecutor(targetObject, m);
            }
            for (String alias : command.aliases()) {
                if (!alias.equalsIgnoreCase(commandName)) continue;
                return CommandExecutor.createExecutor(targetObject, m);
            }
        }
        return null;
    }

    public static void invokeAndExit(Object targetObject, String commandName, String[] args) throws CliException {
        CommandExecutor ce = CommandExecutor.createExecutor(targetObject, commandName);
        try {
            ce.execute(args);
            if (ce.wasHelpRequested()) {
                ce.help(System.out);
                System.exit(-1);
            }
            System.exit(0);
        }
        catch (InvocationTargetException e) {
            System.err.println("Command execution failed: " + e.getMessage());
            System.exit(-1);
        }
        catch (CliException e) {
            System.err.println("Command execution failed: " + e.getMessage());
            ce.help(System.out);
            System.exit(-1);
        }
    }

    public final boolean wasHelpRequested() {
        return this.showHelp;
    }

    public final Object execute(String ... args) throws InvocationTargetException, CliException {
        this.showHelp = false;
        if (this.command != null && this.command.disabled()) {
            throw new CliException("Command '" + this.command.name() + "' is disabled by annotation");
        }
        try {
            int parsedArgs;
            if (this.optionHandlers.size() > 0 && (this.command == null || this.command.parseOptions())) {
                this.parser.parse(args);
                for (OptionHandler handler : this.optionHandlers) {
                    handler.parseOption();
                }
                args = this.parser.getRemainingArgs();
            } else if (args.length > 0 && (args[0].equals("-h") || args[0].equals("--help"))) {
                this.showHelp = true;
                String[] remaining = new String[args.length - 1];
                if (remaining.length > 0) {
                    System.arraycopy(args, 1, remaining, 0, remaining.length);
                }
                args = remaining;
            }
            if (this.showHelp) {
                return null;
            }
            if (args.length > this.argHandlers.size() && this.remaingArgsHandler == null) {
                throw new CliException("Too many arguments (" + args.length + ") for command '" + this.name + "' " + Arrays.asList(args));
            }
            for (parsedArgs = 0; parsedArgs < this.argHandlers.size(); ++parsedArgs) {
                String arg = null;
                if (parsedArgs < args.length) {
                    arg = args[parsedArgs];
                }
                this.argHandlers.get(parsedArgs).parse(arg);
            }
            if (this.remaingArgsHandler != null) {
                if (parsedArgs < args.length) {
                    String[] remainingArgs = new String[args.length - parsedArgs];
                    System.arraycopy(args, parsedArgs, remainingArgs, 0, args.length - parsedArgs);
                    this.remaingArgsHandler.parse(remainingArgs);
                } else {
                    this.remaingArgsHandler.parse(null);
                }
            }
        }
        catch (CliException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CliException("Error parsing command: " + e.getMessage(), e);
        }
        try {
            return this.executeCommand();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new CliException("'" + this.name + "' was interrupted", ie);
        }
        catch (InvocationTargetException ite) {
            throw ite;
        }
        catch (Throwable e) {
            throw new CliException("Error executing '" + this.name + "': " + e.getMessage(), e);
        }
    }

    private Object executeCommand() throws InvocationTargetException, Throwable {
        return this.runMethod.invoke(this.runMethodContainer, this.runMethodParameters);
    }

    private void parseRunMethodAnnotations(Object container, Method runMethod) throws CliException {
        Annotation[][] annotations = runMethod.getParameterAnnotations();
        int argCount = 0;
        int annotatedArgCount = 0;
        for (int i = 0; i < this.runMethodParameterTypes.length; ++i) {
            ParameterValueApplier applier = new ParameterValueApplier(this.runMethodParameters, this.runMethodParameterTypes[i], i);
            Option option = this.findAnnotation(annotations[i], Option.class);
            if (option != null) {
                this.optionHandlers.add(new OptionHandler(applier, this.parser, option));
                continue;
            }
            Argument argument = this.findAnnotation(annotations[i], Argument.class);
            if (argument != null) {
                this.argHandlers.add(new ArgumentHandler(applier, argument));
                ++annotatedArgCount;
                continue;
            }
            RemainingArgs remainingArgs = this.findAnnotation(annotations[i], RemainingArgs.class);
            if (remainingArgs != null) {
                if (this.remaingArgsHandler != null) {
                    throw new CliException("The method '" + runMethod.getName() + "' in '" + container.getClass().getName() + "' has multiple @RemainingArgs annotated parameters");
                }
                this.remaingArgsHandler = new RemainingArgsHandler(applier, remainingArgs);
                continue;
            }
            if (annotatedArgCount > 0) {
                throw new CliException("The method '" + runMethod.getName() + "' in '" + container.getClass().getName() + "' is missing an @Argument or @Option annotation on parameter " + (i + 1));
            }
            this.argHandlers.add(new ArgumentHandler(applier, "arg" + ++argCount, null, null, null, (short)(i + 1), true, new String[0]));
        }
    }

    private <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> annotation) {
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotation.isAssignableFrom(annotations[i].getClass())) continue;
            return (T)annotations[i];
        }
        return null;
    }

    private void parseFieldContainerAnnotations(Object fieldContainer) throws CliException {
        this.parseFieldContainerAnnotations(fieldContainer, fieldContainer.getClass());
    }

    private void parseFieldContainerAnnotations(Object fieldContainer, Class<?> type) throws CliException {
        if (type.getSuperclass() != Object.class) {
            this.parseFieldContainerAnnotations(fieldContainer, type.getSuperclass());
        }
        for (Field field : type.getDeclaredFields()) {
            FieldValueApplier applier = new FieldValueApplier(fieldContainer, field);
            if (field.isAnnotationPresent(Option.class)) {
                field.setAccessible(true);
                Option option = field.getAnnotation(Option.class);
                this.optionHandlers.add(new OptionHandler(applier, this.parser, option));
            }
            if (type != this.getClass()) continue;
            if (field.isAnnotationPresent(Argument.class)) {
                field.setAccessible(true);
                this.argHandlers.add(new ArgumentHandler(applier, field.getAnnotation(Argument.class)));
            }
            if (!field.isAnnotationPresent(RemainingArgs.class)) continue;
            field.setAccessible(true);
            this.remaingArgsHandler = new RemainingArgsHandler(applier, field.getAnnotation(RemainingArgs.class));
        }
    }

    public void helpHtml(IndentingWriter out) throws IOException {
        out.print("<div class=\"commandDescription\">").print(this.description).println("</div>");
        this.usageHtml(out);
    }

    public void usageHtml(IndentingWriter out) throws IOException {
        if (this.usage == null) {
            this.usage(new PrintStream(new ByteArrayOutputStream()));
        }
        out.println("<div class=\"preformatted panel\" style=\"border-width: 1px;\">").indent();
        out.println("<div class=\"preformattedContent panelContent\">").indent();
        out.println("<pre>").indent();
        out.println(StringEscapeUtils.escapeHtml((String)this.usage.toString()), true);
        out.deindent().println("</pre>");
        out.deindent().println("</div>");
        out.deindent().println("</div>");
    }

    public final void help(PrintStream out) {
        out.print(this.name);
        if (this.aliases.length > 0) {
            boolean first = true;
            for (String keyword : this.aliases) {
                if (!first) {
                    out.print(" | ");
                } else {
                    first = false;
                }
                out.print(keyword);
            }
            out.println();
        }
        out.println("  " + this.description);
        out.flush();
        this.usage(out);
    }

    public void usage(PrintStream out) {
        if (this.usage == null) {
            boolean first;
            StringTokenizer tokenizer;
            StringBuilder usage;
            StringBuilder builder = new StringBuilder();
            builder.append("Usage:\n");
            builder.append("  ").append(this.name).append(" ");
            for (OptionHandler optionHandler : this.optionHandlers) {
                if (optionHandler.option.hidden()) continue;
                if (!optionHandler.option.required()) {
                    builder.append("[");
                }
                builder.append("-").append(optionHandler.option.shortForm());
                if (!optionHandler.option.required()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            for (ArgumentHandler argumentHandler : this.argHandlers) {
                if (!argumentHandler.required) {
                    builder.append("[");
                }
                builder.append("<").append(argumentHandler.name).append(">");
                if (!argumentHandler.required) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            builder.append("\n\n");
            String optionIndent = "       ";
            String string = "           ";
            if (!this.optionHandlers.isEmpty()) {
                for (OptionHandler optionHandler : this.optionHandlers) {
                    if (optionHandler.option.hidden()) continue;
                    usage = new StringBuilder();
                    optionHandler.appendUsage(usage);
                    tokenizer = new StringTokenizer(usage.toString(), "\n", true);
                    first = true;
                    while (tokenizer.hasMoreTokens()) {
                        builder.append(first ? optionIndent : string).append(WordUtils.wrap((String)tokenizer.nextToken(), (int)68, (String)("\n" + string), (boolean)false));
                        first = false;
                    }
                    builder.append("\n\n");
                }
            }
            if (!this.argHandlers.isEmpty()) {
                for (ArgumentHandler argumentHandler : this.argHandlers) {
                    usage = new StringBuilder();
                    argumentHandler.appendUsage(usage);
                    tokenizer = new StringTokenizer(usage.toString(), "\n", true);
                    first = true;
                    while (tokenizer.hasMoreTokens()) {
                        builder.append(first ? optionIndent : string).append(WordUtils.wrap((String)tokenizer.nextToken(), (int)68, (String)("\n" + string), (boolean)false));
                        first = false;
                    }
                    builder.append("\n\n");
                }
            }
            if (this.remaingArgsHandler != null) {
                StringBuilder usage2 = new StringBuilder();
                this.remaingArgsHandler.appendUsage(usage2);
                StringTokenizer stringTokenizer = new StringTokenizer(usage2.toString(), "\n", true);
                boolean first2 = true;
                while (stringTokenizer.hasMoreTokens()) {
                    builder.append(first2 ? optionIndent : string).append(WordUtils.wrap((String)stringTokenizer.nextToken(), (int)68, (String)("\n" + string), (boolean)false));
                    first2 = false;
                }
                builder.append("\n\n");
            }
            this.usage = builder;
        }
        out.println(this.usage);
    }
}

