/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.types;

import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.MethodAliasInfo;

public class RoutineAliasInfo
extends MethodAliasInfo {
    private int parameterCount;
    private DataTypeDescriptor[] parameterTypes;
    private String[] parameterNames;
    private int[] parameterModes;
    private int dynamicResultSets;
    private DataTypeDescriptor returnType;
    private String language;
    private String parameterStyle;
    private SQLAllowed sqlAllowed;
    private boolean deterministic;
    private boolean definersRights;
    private String specificName;
    private boolean calledOnNullInput;

    public RoutineAliasInfo(String methodName, int parameterCount, String[] parameterNames, DataTypeDescriptor[] parameterTypes, int[] parameterModes, int dynamicResultSets, String language, String parameterStyle, SQLAllowed sqlAllowed, boolean deterministic, boolean definersRights, boolean calledOnNullInput, DataTypeDescriptor returnType) {
        super(methodName);
        this.parameterCount = parameterCount;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
        this.parameterModes = parameterModes;
        this.dynamicResultSets = dynamicResultSets;
        this.language = language;
        this.parameterStyle = parameterStyle;
        this.sqlAllowed = sqlAllowed;
        this.deterministic = deterministic;
        this.definersRights = definersRights;
        this.calledOnNullInput = calledOnNullInput;
        this.returnType = returnType;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int[] getParameterModes() {
        return this.parameterModes;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int getMaxDynamicResultSets() {
        return this.dynamicResultSets;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getParameterStyle() {
        return this.parameterStyle;
    }

    public SQLAllowed getSQLAllowed() {
        return this.sqlAllowed;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public boolean hasDefinersRights() {
        return this.definersRights;
    }

    public boolean calledOnNullInput() {
        return this.calledOnNullInput;
    }

    public DataTypeDescriptor getReturnType() {
        return this.returnType;
    }

    public boolean isFunction() {
        return this.returnType != null;
    }

    @Override
    public boolean isTableFunction() {
        if (this.returnType == null) {
            return false;
        }
        return this.returnType.isRowMultiSet();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < this.parameterCount; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (this.returnType == null) {
                sb.append(RoutineAliasInfo.parameterMode(this.parameterModes[i]));
                sb.append(' ');
            }
            if (this.parameterNames[i] != null) {
                sb.append(this.parameterNames[i]);
                sb.append(' ');
            }
            sb.append(this.parameterTypes[i].getSQLstring());
        }
        sb.append(')');
        if (this.returnType != null) {
            sb.append(" RETURNS " + this.returnType.getSQLstring());
        }
        sb.append(" LANGUAGE ");
        sb.append(this.language);
        if (this.parameterStyle != null) {
            sb.append(" PARAMETER STYLE ");
            sb.append(this.parameterStyle);
        }
        if (this.deterministic) {
            sb.append(" DETERMINISTIC ");
        }
        if (this.definersRights) {
            sb.append(" EXTERNAL SECURITY DEFINER");
        }
        if (this.sqlAllowed != null) {
            sb.append(" ");
            sb.append(this.sqlAllowed.getSQL());
        }
        if (this.returnType == null && this.dynamicResultSets != 0) {
            sb.append(" DYNAMIC RESULT SETS ");
            sb.append(this.dynamicResultSets);
        }
        if (this.returnType != null) {
            sb.append(this.calledOnNullInput ? " CALLED " : " RETURNS NULL ");
            sb.append("ON NULL INPUT");
        }
        return sb.toString();
    }

    public static String parameterMode(int parameterMode) {
        switch (parameterMode) {
            case 1: {
                return "IN";
            }
            case 4: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
        }
        return "UNKNOWN";
    }

    public static enum SQLAllowed {
        MODIFIES_SQL_DATA("MODIFIES SQL DATA"),
        READS_SQL_DATA("READS SQL DATA"),
        CONTAINS_SQL("CONTAINS SQL"),
        NO_SQL("NO SQL");

        private String sql;

        private SQLAllowed(String sql) {
            this.sql = sql;
        }

        public String getSQL() {
            return this.sql;
        }
    }
}

