/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.Lists;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryRepository;
import com.neeve.query.QueryResult;
import java.util.List;

public abstract class QueryCompositeResult<T>
implements QueryResult<T> {
    protected List<QueryResult<T>> queryResults;
    protected QueryResult<T> currentQueryResult;

    public QueryCompositeResult(Iterable<QueryResult<T>> queryResults) {
        this.queryResults = Lists.newArrayList(queryResults);
        this.currentQueryResult = null;
    }

    @Override
    public int size() {
        int size = 0;
        for (QueryResult<T> qr : this.queryResults) {
            size += qr.size();
        }
        return size;
    }

    @Override
    public int estimatedSize() {
        int size = 0;
        for (QueryResult<T> qr : this.queryResults) {
            size += qr.estimatedSize();
        }
        return size;
    }

    @Override
    public boolean isFullScan() {
        boolean foundIndexRead = false;
        for (QueryResult<T> queryResult : this.queryResults) {
            if (queryResult.isFullScan()) continue;
            foundIndexRead = true;
            break;
        }
        return !foundIndexRead;
    }

    @Override
    public void setPrefetchCount(int prefetchCount) {
        for (QueryResult<T> qr : this.queryResults) {
            qr.setPrefetchCount(prefetchCount);
        }
    }

    @Override
    public QueryRepository<?, T> getRepository() {
        return this.currentQueryResult != null ? this.currentQueryResult.getRepository() : null;
    }

    @Override
    public String getRepositoryAlias() {
        return this.currentQueryResult != null ? this.currentQueryResult.getRepositoryAlias() : null;
    }

    @Override
    public QueryPlan getPlan() {
        return null;
    }

    @Override
    public void close() {
        for (QueryResult<T> qr : this.queryResults) {
            qr.close();
        }
    }
}

