/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmType;

public abstract class AdmScopedType
extends AdmType {
    private final String namespace;

    protected AdmScopedType(AdmModel model, String namespace, String name) {
        super(model, name);
        if (namespace == null) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = namespace;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public final String getJavaTypeName() {
        String name = this.getName();
        if (AdmModel.RESERVED_TYPE_NAMES.contains(name)) {
            return this.getFullName();
        }
        return name;
    }

    public static final String constructFullName(String namespace, String name) {
        return namespace + "." + name;
    }

    @Override
    public final String getFullName() {
        return AdmScopedType.constructFullName(this.getNamespace(), this.getName());
    }

    public final boolean getGenerateEmbeddedEntityInterfaces() {
        return this.getModel().getBooleanDirective("generateEmbeddedEntityInterfaces");
    }

    public final boolean getGenerateEmbeddedEntitiesNonFinal() {
        return this.getModel().getBooleanDirective("generateEmbeddedEntitiesNonFinal");
    }

    public final boolean getGenerateDefaultGetters() {
        return this.getModel().getBooleanDirective("generateDefaultGetters");
    }

    public final boolean getGenerateThrowOnUnsetGetters() {
        return this.getModel().getBooleanDirective("generateThrowOnUnsetGetters");
    }

    public final boolean getGenerateRequiredFieldValidators() {
        return this.getModel().getBooleanDirective("generateRequiredFieldValidators");
    }

    public final boolean getGenerateFluentInterfaceSetters() {
        return this.getModel().getBooleanDirective("generateBuilderInterfaceSetters");
    }

    public final boolean getGenerateFluentSetters() {
        return this.getModel().getBooleanDirective("generateFluentSetters");
    }

    public final boolean getGenerateDeprecatedAccessors() {
        return this.getModel().getBooleanDirective("generateDeprecatedAccessors");
    }
}

