/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlText;
import java.beans.Introspector;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UtlReflection {
    protected static final Object[] NO_ARGS = new Object[0];
    protected static final ConcurrentHashMap<Class<?>, Map<String, Method>> accessorCache = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Class<?>, Map<String, Method>> checkerCache = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Class<?>, Map<String, Method>> setterCache = new ConcurrentHashMap();

    public static void collectNonPublicMethods(Class<?> clazz, Collection<Method> target) {
        for (Method m : clazz.getDeclaredMethods()) {
            if ((m.getModifiers() & 1) > 0) continue;
            target.add(m);
        }
        Class<?> superType = clazz.getSuperclass();
        if (superType != null && superType != Object.class) {
            UtlReflection.collectNonPublicMethods(superType, target);
        }
    }

    public static Collection<Method> collectAllMethods(Class<?> clazz) {
        LinkedHashSet<Method> target = new LinkedHashSet<Method>();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            target.add(method);
        }
        UtlReflection.collectNonPublicMethods(clazz, target);
        return target;
    }

    public static Collection<Field> collectAllFields(Class<?> clazz) {
        LinkedHashSet<Field> target = new LinkedHashSet<Field>();
        UtlReflection.collectAllFields(clazz, target);
        return target;
    }

    public static void collectAllFields(Class<?> clazz, Collection<Field> target) {
        for (Field field : clazz.getDeclaredFields()) {
            target.add(field);
        }
        Class<?> superType = clazz.getSuperclass();
        if (superType != null && superType != Object.class) {
            UtlReflection.collectAllFields(superType, target);
        }
    }

    public static final Class<?> getUnwrappedReturnType(Class<?> type, String path) {
        if (type == null) {
            return null;
        }
        if (UtlText.isNullOrEmpty(path)) {
            return type;
        }
        Method m = path.indexOf(46) == -1 ? UtlReflection.getNonNestedAccessor(type, path) : UtlReflection.getAccessor(type, 0, path.split("\\."));
        if (m == null) {
            return null;
        }
        Class<?> c = m.getReturnType();
        return c;
    }

    public static Method getGetter(Class<?> type, String property) {
        if (property.indexOf(46) == -1) {
            return UtlReflection.getNonNestedAccessor(type, property);
        }
        return UtlReflection.getAccessor(type, 0, property.split("\\."));
    }

    public static boolean hasPath(Class<?> type, String path) {
        if (path.equals("")) {
            return true;
        }
        Class<?> pathType = type;
        for (String pathComponent : path.split("\\.")) {
            Method getter = UtlReflection.getGetter(pathType, pathComponent);
            if (getter == null) {
                if (pathType.isInterface()) {
                    getter = UtlReflection.getGetter(Object.class, pathComponent);
                }
                if (getter == null) {
                    return false;
                }
            }
            pathType = getter.getReturnType();
        }
        return true;
    }

    public static boolean hasPath(Object object, String path) {
        String pathRemainder;
        String pathComponent;
        if (object == null) {
            return false;
        }
        if (path.equals("")) {
            return true;
        }
        int dotLocation = path.indexOf(".");
        if (dotLocation == -1) {
            pathComponent = path;
            pathRemainder = null;
        } else {
            pathComponent = path.substring(0, dotLocation);
            pathRemainder = path.substring(dotLocation + 1);
        }
        Object component = UtlReflection.getProperty(object, pathComponent);
        if (component == null) {
            return UtlReflection.hasPath(object.getClass(), path);
        }
        if (pathRemainder != null) {
            return UtlReflection.hasPath(component, pathRemainder);
        }
        return true;
    }

    public static <T> T getProperty(Object object, String path) {
        if (path.indexOf(46) == -1) {
            return UtlReflection.getNonNestedProperty(object, path);
        }
        return UtlReflection.getProperty(object, 0, path.split("\\."));
    }

    public static void setNonNestedProperty(Object object, String property, Object value) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (object == null) {
            throw new IllegalArgumentException("Target object cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        Method m = UtlReflection.getSetters(object.getClass()).get(property);
        if (m == null) {
            throw new NoSuchMethodException("No property '" + property + "' found for '" + object.getClass().getSimpleName());
        }
        if (value == null) {
            if (m.getParameterTypes()[0].isPrimitive()) {
                throw new IllegalArgumentException("Can't set property '" + property + "' with type '" + m.getParameterTypes()[0].getSimpleName() + "' to null");
            }
        } else {
            value = UtlDataTypes.convert(m.getParameterTypes()[0], value);
        }
        m.invoke(object, value);
    }

    public static <T> T getProperty(Object object, int pathOffset, String ... path) {
        if (object == null) {
            return null;
        }
        T value = UtlReflection.getNonNestedProperty(object, path[pathOffset]);
        if (value == null) {
            return null;
        }
        if (path.length - 1 == pathOffset) {
            return value;
        }
        return UtlReflection.getProperty(value, ++pathOffset, path);
    }

    public static <T> T getNonNestedProperty(Object object, String field) {
        if (object == null) {
            return null;
        }
        Method m = UtlReflection.getAccessors(object.getClass()).get(field);
        if (m != null && UtlReflection.getHasPropertyCheckerValue(object, field)) {
            try {
                return (T)m.invoke(object, NO_ARGS);
            }
            catch (Exception e) {
                throw new RuntimeException("Error accessing property '" + field + " on '" + object.getClass().getSimpleName() + "': " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static final boolean getHasPropertyCheckerValue(Object object, String name) {
        Method m = UtlReflection.getNonNestedChecker(object.getClass(), name);
        if (m != null) {
            try {
                return (Boolean)m.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking field checker " + m.toString());
            }
        }
        return true;
    }

    protected static Method getAccessor(Class<?> type, int pathOffset, String ... path) {
        Method accessor = UtlReflection.getNonNestedAccessor(type, path[pathOffset]);
        if (accessor == null && type.isInterface()) {
            accessor = UtlReflection.getNonNestedAccessor(Object.class, path[pathOffset]);
        }
        if (accessor == null) {
            return null;
        }
        if (path.length - 1 == pathOffset) {
            return accessor;
        }
        return UtlReflection.getAccessor(accessor.getReturnType(), ++pathOffset, path);
    }

    public static Method getNonNestedAccessor(Class<?> type, String field) {
        return UtlReflection.getAccessors(type).get(field);
    }

    public static Method getNonNestedChecker(Class<?> type, String field) {
        return UtlReflection.getCheckers(type).get(field);
    }

    private static final Map<String, Method> getAccessors(Class<?> type) {
        Map<String, Method> methods = accessorCache.get(type);
        if (methods != null) {
            return methods;
        }
        UtlReflection.loadAccessors(type);
        return accessorCache.get(type);
    }

    private static final Map<String, Method> getCheckers(Class<?> type) {
        Map<String, Method> methods = checkerCache.get(type);
        if (methods != null) {
            return methods;
        }
        UtlReflection.loadAccessors(type);
        return checkerCache.get(type);
    }

    private static final Map<String, Method> getSetters(Class<?> type) {
        Map<String, Method> methods = setterCache.get(type);
        if (methods != null) {
            return methods;
        }
        UtlReflection.loadAccessors(type);
        return setterCache.get(type);
    }

    private static final void loadAccessors(Class<?> type) {
        Map<String, Method> checkers = new HashMap();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        Map<String, Method> methods = new HashMap();
        for (Method method : type.getMethods()) {
            String property;
            String methodName = method.getName();
            if (methodName.length() >= 4 && methodName.startsWith("set") && method.getParameterTypes().length == 1) {
                property = method.getName().substring(3);
                setters.put(property, method);
                setters.put(Introspector.decapitalize(property), method);
            }
            if (method.getParameterTypes() != null && method.getParameterTypes().length > 0 || method.getName().endsWith("OrThrow") || method.getName().endsWith("EmptyIfNull") || method.getName().endsWith("AsRaw")) continue;
            if (methodName.length() >= 4 && methodName.startsWith("get")) {
                property = method.getName().substring(3);
                methods.put(property, method);
                methods.put(Introspector.decapitalize(property), method);
                continue;
            }
            if (methodName.length() >= 3 && methodName.startsWith("is")) {
                property = method.getName().substring(2);
                if (methods.containsKey(property)) continue;
                methods.put(property, method);
                methods.put(Introspector.decapitalize(property), method);
                continue;
            }
            if (methodName.length() < 4 || !(method.getReturnType() == Boolean.TYPE & methodName.startsWith("has"))) continue;
            property = method.getName().substring(3);
            checkers.put(property, method);
            checkers.put(Introspector.decapitalize(property), method);
        }
        checkers = Collections.unmodifiableMap(checkers);
        methods = Collections.unmodifiableMap(methods);
        accessorCache.put(type, methods);
        checkerCache.put(type, checkers);
        setterCache.put(type, setters);
    }

    public static final Set<String> getProperties(Class<?> type) {
        return new HashSet<String>(UtlReflection.getAccessors(type).keySet());
    }

    public static final Set<String> getDecamelcasedProperties(Class<?> type) {
        HashSet<String> properties = new HashSet<String>();
        for (String property : UtlReflection.getAccessors(type).keySet()) {
            properties.add(Introspector.decapitalize(property));
        }
        return properties;
    }

    public static final Set<String> getNonObjectProperties(Class<?> type) {
        HashSet<String> rc = new HashSet<String>(UtlReflection.getAccessors(type).keySet());
        rc.removeAll(UtlReflection.getAccessors(Object.class).keySet());
        return rc;
    }

    public static final Set<String> getDecamelCasedNonObjectProperties(Class<?> type) {
        HashSet<String> rc = new HashSet<String>(UtlReflection.getDecamelcasedProperties(type));
        rc.removeAll(UtlReflection.getDecamelcasedProperties(Object.class));
        return rc;
    }

    public static Set<String> getDeclaredProperties(Class<?> type) {
        HashSet<String> properties = new HashSet<String>();
        for (Method method : type.getDeclaredMethods()) {
            String property;
            String methodName = method.getName();
            if (methodName.length() >= 4 && methodName.startsWith("get")) {
                property = Introspector.decapitalize(method.getName().substring(3));
                properties.add(property);
                continue;
            }
            if (methodName.length() < 3 || !methodName.startsWith("is")) continue;
            property = Introspector.decapitalize(method.getName().substring(2));
            properties.add(property);
        }
        return properties;
    }

    public static void appendMethodAndCodeSource(Method method, StringBuilder builder) {
        builder.append(method.toString());
        URL codesource = null;
        try {
            codesource = method.getDeclaringClass().getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        builder.append(" [");
        if (codesource == null) {
            builder.append("unknown code source");
        } else if (codesource.getProtocol().equalsIgnoreCase("file")) {
            try {
                builder.append(new File(codesource.toURI()));
            }
            catch (URISyntaxException e) {
                builder.append(codesource);
            }
        } else {
            builder.append(codesource);
        }
        builder.append("]");
    }

    public static Method getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        for (Method method : UtlReflection.collectAllMethods(type)) {
            if (!method.getName().equals(name) || !UtlReflection.signatureMatch(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    private static final boolean signatureMatch(Class<?>[] s1, Class<?>[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null != (s2 == null)) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == s2[i]) continue;
            return false;
        }
        return true;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        if (method.isAnnotationPresent(annotationClass)) {
            return method.getAnnotation(annotationClass);
        }
        if (method.getDeclaringClass().getSuperclass() != null) {
            try {
                Method m = method.getDeclaringClass().getSuperclass().getMethod(method.getName(), method.getParameterTypes());
                return UtlReflection.getAnnotation(m, annotationClass);
            }
            catch (NoSuchMethodException nsme) {
                return null;
            }
        }
        return null;
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        return UtlReflection.getAnnotation(method, annotationClass) != null;
    }
}

