/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.util.StringTokenizer;

public final class UtlFabricAddress {
    public static int create(short routerL2Addr, short routerL1Addr, short clientAddr) {
        return (routerL2Addr & 0x3FF) << 22 | routerL1Addr << 14 | clientAddr & 0x3FFF;
    }

    public static short extractRouterL2(int addr) {
        return (short)((addr & 0xFFC00000) >>> 22);
    }

    public static short extractRouterL1(int addr) {
        return (short)((addr & 0x3FC000) >>> 14);
    }

    public static int extractRouter(int addr) {
        return UtlFabricAddress.create(UtlFabricAddress.extractRouterL2(addr), UtlFabricAddress.extractRouterL1(addr), (short)0);
    }

    public static short extractClient(int addr) {
        return (short)(addr & 0x3FFF);
    }

    public static void validateRouterL2(short routerL2Addr) {
        short maxRouterL2Addr = UtlFabricAddress.extractRouterL2(-1);
        short minRouterL2Addr = 1;
        if (routerL2Addr < minRouterL2Addr || routerL2Addr > maxRouterL2Addr) {
            throw new IllegalArgumentException("Router L2 address out of range <min=" + minRouterL2Addr + " max=" + maxRouterL2Addr + " parsed=" + routerL2Addr + ">");
        }
    }

    public static void validateRouterL1(short routerL1Addr) {
        short maxRouterL1Addr = UtlFabricAddress.extractRouterL1(-1);
        short minRouterL1Addr = 0;
        if (routerL1Addr < minRouterL1Addr || routerL1Addr > maxRouterL1Addr) {
            throw new IllegalArgumentException("Router L1 address out of range <min=" + minRouterL1Addr + " max=" + maxRouterL1Addr + " parsed=" + routerL1Addr + ">");
        }
    }

    public static void validateClient(short clientAddr) {
        short maxClientAddr = UtlFabricAddress.extractClient(-1);
        short minClientAddr = 0;
        if (clientAddr < minClientAddr || clientAddr > maxClientAddr) {
            throw new IllegalArgumentException("Client address out of range <min=" + minClientAddr + " max=" + maxClientAddr + " parsed=" + clientAddr + ">");
        }
    }

    public static String toString(int addr) {
        return String.valueOf(UtlFabricAddress.extractRouterL2(addr)) + "." + String.valueOf(UtlFabricAddress.extractRouterL1(addr)) + "." + String.valueOf(UtlFabricAddress.extractClient(addr));
    }

    public static int fromString(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ".");
        short routerL2Addr = 0;
        short routerL1Addr = 0;
        short clientAddr = 0;
        try {
            if (tokenizer.hasMoreTokens()) {
                routerL2Addr = Short.parseShort(tokenizer.nextToken());
                UtlFabricAddress.validateRouterL2(routerL2Addr);
            }
            if (tokenizer.hasMoreTokens()) {
                routerL1Addr = Short.parseShort(tokenizer.nextToken());
                UtlFabricAddress.validateRouterL1(routerL1Addr);
            }
            if (tokenizer.hasMoreTokens()) {
                clientAddr = Short.parseShort(tokenizer.nextToken());
                UtlFabricAddress.validateClient(clientAddr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return UtlFabricAddress.create(routerL2Addr, routerL1Addr, clientAddr);
    }

    public static boolean isTargetingRouter(short destL1Addr, short destL2Addr, short routerL1Addr, short routerL2Addr) {
        return !(destL2Addr != 0 && destL2Addr != routerL2Addr || destL1Addr != 0 && destL1Addr != routerL1Addr);
    }
}

