/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XIndex;
import com.neeve.lang.XIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class XIndexedList<E>
extends XCollection<E>
implements List<E>,
RandomAccess {
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int M1 = 1023;
    private transient E[] _low = new Object[16];
    private transient E[][] _high = new Object[1][];
    private transient int _capacity = 16;
    private transient int _size;
    private static final Object[] NULL_BLOCK = new Object[1024];

    public XIndexedList() {
        this._high[0] = this._low;
    }

    public XIndexedList(int capacity) {
        this();
        while (capacity > this._capacity) {
        }
    }

    public XIndexedList(Collection<? extends E> values) {
        this(values.size());
        this.addAll(values);
    }

    public static <E> XIndexedList<E> newInstance() {
        return new XIndexedList<E>();
    }

    public void setSize(int size) {
        while (this._size < size) {
            this.addLast(null);
        }
        while (this._size > size) {
            this.removeLast();
        }
    }

    @Override
    public final E get(int index) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return index < 1024 ? this._low[index] : this._high[index >> 10][index & 0x3FF];
    }

    @Override
    public final E set(int index, E value) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        E[] low = this._high[index >> 10];
        E previous = low[index & 0x3FF];
        low[index & 0x3FF] = value;
        return previous;
    }

    @Override
    public final boolean add(E value) {
        if (this._size >= this._capacity) {
            this.increaseCapacity();
        }
        this._high[this._size >> 10][this._size & 0x3FF] = value;
        ++this._size;
        return true;
    }

    @Override
    public final E getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._low[0];
    }

    @Override
    public final E getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this._size - 1);
    }

    @Override
    public final void addLast(E value) {
        this.add(value);
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        E[] low = this._high[this._size >> 10];
        E previous = low[this._size & 0x3FF];
        low[this._size & 0x3FF] = null;
        return previous;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this._size; i += 1024) {
            int count = Math.min(this._size - i, 1024);
            E[] low = this._high[i >> 10];
            System.arraycopy(NULL_BLOCK, 0, low, 0, count);
        }
        this._size = 0;
    }

    public void reset() {
        this.clear();
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int shift = values.size();
        this.shiftRight(index, shift);
        Iterator<E> valuesIterator = values.iterator();
        int n = index + shift;
        for (int i = index; i < n; ++i) {
            this._high[i >> 10][i & 0x3FF] = valuesIterator.next();
        }
        this._size += shift;
        return shift != 0;
    }

    @Override
    public final void add(int index, E value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.shiftRight(index, 1);
        this._high[index >> 10][index & 0x3FF] = value;
        ++this._size;
    }

    @Override
    public final E remove(int index) {
        E previous = this.get(index);
        this.shiftLeft(index + 1, 1);
        --this._size;
        this._high[this._size >> 10][this._size & 0x3FF] = null;
        return previous;
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > toIndex || toIndex > this._size) {
            throw new IndexOutOfBoundsException("XList removeRange(" + fromIndex + ", " + toIndex + ") index out of bounds, size: " + this._size);
        }
        int shift = toIndex - fromIndex;
        this.shiftLeft(toIndex, shift);
        this._size -= shift;
        int n = this._size + shift;
        for (int i = this._size; i < n; ++i) {
            this._high[i >> 10][i & 0x3FF] = null;
        }
    }

    @Override
    public final int indexOf(Object value) {
        int count;
        for (int i = 0; i < this._size; i += count) {
            E[] low = this._high[i >> 10];
            count = Math.min(low.length, this._size - i);
            for (int j = 0; j < count; ++j) {
                if (!XIndexedList.equals(value, low[j])) continue;
                return i + j;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object value) {
        int count;
        for (int i = this._size - 1; i >= 0; i -= count) {
            E[] low = this._high[i >> 10];
            int j = count = (i & 0x3FF) + 1;
            while (--j >= 0) {
                if (!XIndexedList.equals(value, low[j])) continue;
                return i + j - count + 1;
            }
        }
        return -1;
    }

    @Override
    public XIterator<E> iterator() {
        return XListIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator() {
        return XListIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException();
        }
        return XListIterator.valueOf(this, index, 0, this._size);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubTable.valueOf(this, fromIndex, toIndex - fromIndex);
    }

    public final void trimToSize() {
        while (this._capacity - this._size > 1024) {
            this._capacity -= 1024;
            this._high[this._capacity >> 10] = null;
        }
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        this.quicksort(0, this._size - 1, comparator);
    }

    private void quicksort(int first, int last, Comparator<? super E> cmp) {
        int pivIndex = 0;
        if (first < last) {
            pivIndex = this.partition(first, last, cmp);
            this.quicksort(first, pivIndex - 1, cmp);
            this.quicksort(pivIndex + 1, last, cmp);
        }
    }

    private int partition(int f, int l, Comparator<? super E> cmp) {
        E piv = this.get(f);
        int up = f;
        int down = l;
        while (true) {
            if (cmp.compare(this.get(up), piv) <= 0 && up < l) {
                ++up;
                continue;
            }
            while (cmp.compare(this.get(down), piv) > 0 && down > f) {
                --down;
            }
            if (up < down) {
                E temp = this.get(up);
                this.set(up, this.get(down));
                this.set(down, temp);
            }
            if (down <= up) break;
        }
        this.set(f, this.get(down));
        this.set(down, piv);
        return down;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final XCollection.Record head() {
        return XIndex.valueOf(-1);
    }

    @Override
    public final XCollection.Record tail() {
        return XIndex.valueOf(this._size);
    }

    @Override
    public final E valueOf(XCollection.Record record) {
        return this.get(((XIndex)record).intValue());
    }

    @Override
    public final void delete(XCollection.Record record) {
        this.remove(((XIndex)record).intValue());
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    @Override
    public final boolean contains(Object value) {
        return this.indexOf(value) >= 0;
    }

    protected final int getCapacity() {
        return this._capacity;
    }

    private void increaseCapacity() {
        if (this._capacity < 1024) {
            this._capacity <<= 1;
            Object[] tmp = new Object[this._capacity];
            System.arraycopy(this._low, 0, tmp, 0, this._size);
            this._low = tmp;
            this._high[0] = tmp;
        } else {
            int j = this._capacity >> 10;
            if (j >= this._high.length) {
                Object[][] tmp = new Object[this._high.length * 2][];
                System.arraycopy(this._high, 0, tmp, 0, this._high.length);
                this._high = tmp;
            }
            this._high[j] = new Object[1024];
            this._capacity += 1024;
        }
    }

    private void shiftRight(int index, int shift) {
        while (this._size + shift >= this._capacity) {
            this.increaseCapacity();
        }
        int i = this._size;
        while (--i >= index) {
            int dest = i + shift;
            this._high[dest >> 10][dest & 0x3FF] = this._high[i >> 10][i & 0x3FF];
        }
    }

    private void shiftLeft(int index, int shift) {
        for (int i = index; i < this._size; ++i) {
            int dest = i - shift;
            this._high[dest >> 10][dest & 0x3FF] = this._high[i >> 10][i & 0x3FF];
        }
    }

    private static final class XListIterator<E>
    implements ListIterator<E>,
    XIterator<E> {
        private XIndexedList<E> _list;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;
        private E[] _low;
        private E[][] _high;

        private XListIterator() {
        }

        public static <E> XListIterator<E> valueOf(XIndexedList<E> list, int nextIndex, int start, int end) {
            XListIterator<E> iterator = new XListIterator<E>();
            iterator._list = list;
            iterator._start = start;
            iterator._end = end;
            iterator._nextIndex = nextIndex;
            iterator._low = ((XIndexedList)list)._low;
            iterator._high = ((XIndexedList)list)._high;
            iterator._currentIndex = -1;
            return iterator;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public E next() {
            int i;
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            return (i = (this._currentIndex = this._nextIndex++)) < 1024 ? this._low[i] : this._high[i >> 10][i & 0x3FF];
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        @Override
        public E previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            int i = this._nextIndex;
            return i < 1024 ? this._low[i] : this._high[i >> 10][i & 0x3FF];
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(E o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.add(this._nextIndex++, o);
            ++this._end;
            this._currentIndex = -1;
        }

        @Override
        public void set(E o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._list.set(this._currentIndex, o);
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentIndex >= 0) {
                this._list.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }

        @Override
        public XIterator<E> toFirst() {
            this._start = 0;
            this._end = this._list.size();
            this._nextIndex = 0;
            this._low = ((XIndexedList)this._list)._low;
            this._high = ((XIndexedList)this._list)._high;
            this._currentIndex = -1;
            return this;
        }
    }

    private static final class SubTable<E>
    extends XCollection<E>
    implements List<E>,
    RandomAccess {
        private XIndexedList<E> _list;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        public static <E> SubTable<E> valueOf(XIndexedList<E> list, int offset, int size) {
            SubTable<E> subTable = new SubTable<E>();
            subTable._list = list;
            subTable._offset = offset;
            subTable._size = size;
            return subTable;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return XIndex.valueOf(-1);
        }

        @Override
        public XCollection.Record tail() {
            return XIndex.valueOf(this._size);
        }

        @Override
        public E valueOf(XCollection.Record record) {
            return this._list.get(((XIndex)record).intValue() + this._offset);
        }

        @Override
        public void delete(XCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> values) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._list.get(index + this._offset);
        }

        @Override
        public E set(int index, E value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._list.set(index + this._offset, value);
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public int indexOf(Object value) {
            int i = -1;
            while (++i < this._size) {
                if (!SubTable.equals(value, this._list.get(i + this._offset))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            int i = this._size;
            while (--i >= 0) {
                if (!SubTable.equals(value, this._list.get(i + this._offset))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XListIterator.valueOf(this._list, index + this._offset, this._offset, this._offset + this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            return SubTable.valueOf(this._list, this._offset + fromIndex, toIndex - fromIndex);
        }
    }
}

