/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepConstants;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepObject;
import com.neeve.aep.EAepException;
import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.StoreDescriptor;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.stats.Stats;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class AepEngineDescriptor
extends AepObject {
    @Deprecated
    private static final String ENABLE_FULL_MESSAGE_TRACE_PROPNAME = "nv.aep.msg.trace.full";
    private String name;
    private String displayName;
    private final List<String> stateFactories;
    private final List<String> messageFactories;
    private final Map<String, Map<String, ChannelConfig>> channels;
    private final Map<String, Properties> busConnectionProperties;
    private String storeName;
    private AepEngine.HAPolicy haPolicy;
    private AepEngine.ReplicationPolicy replicationPolicy;
    private AepEngine.MessagingStartFailPolicy messagingStartFailPolicy;
    private AepEngine.MessageBusBindingFailPolicy messageBusBindingFailPolicy;
    private AepEngine.InboundMessageLoggingPolicy inboundMessageLoggingPolicy;
    private AepEngine.InboundMessageLoggingFailurePolicy inboundMessageLoggingFailurePolicy;
    private AepEngine.OutboundMessageLoggingPolicy outboundMessageLoggingPolicy;
    private AepEngine.OutboundMessageLoggingFailurePolicy outboundMessageLoggingFailurePolicy;
    private AepEngine.PerTransactionStatsLoggingPolicy perTransactionStatsLoggingPolicy;
    private AepEngine.PerTransactionStatsLoggingFailurePolicy perTransactionStatsLoggingFailurePolicy;
    private AepEngine.AppExceptionHandlingPolicy appExceptionHandlingPolicy;
    private AepEngine.MessageSendExceptionHandlingPolicy sendExceptionHandlingPolicy;
    private AepEngine.MessageSendStabilityFailureHandlingPolicy sendStabilityFailureHandlingPolicy;
    private AepEngine.EventMultiplexerType emuxType;
    private AepEngine.InboundEventAcknowledgementPolicy inboundEventAcknowledgementPolicy;
    private Properties emuxProperties;
    private Properties inboundMessageLoggingProperties;
    private Properties outboundMessageLoggingProperties;
    private Properties perTransactionStatsLoggingProperties;
    private Map<AepEngine.StartupExpectation, Enum<?>> startupExpectations;
    private int adaptiveCommitBatchCeiling;
    private boolean enableMultipleFlows;
    private boolean enableEnableReplayOnRollback;
    private boolean dispatchTransactionStageEvents;
    private boolean enableTransactionCommitSuspension;
    private boolean enableTransactionSavepoints;
    private boolean replicateSolicitedSends;
    private boolean replicateUnsolicitedSends;
    private boolean sequenceUnsolicitedSends;
    private boolean sequenceUnsolicitedWithSolicitedSends;
    private boolean dispatchSendStabilityEvents;
    private boolean disposeOnSend;
    private int clusterHeartbeatInterval;
    private boolean administrative;
    private int stuckAlertEventThreshold = 0;
    private boolean performDuplicateChecking;
    private boolean performMidstreamInitializationValidation;
    private boolean enableSequenceNumberTrace;
    private boolean enableEventTrace;
    private boolean enableTransactionTrace;
    private boolean enableScheduleTrace;
    private boolean enableMessageTrace;
    private boolean enableAlertTrace;
    private boolean messageTraceInJson;
    private RogLogUtil.JsonPrettyPrintStyle messageTraceJsonStyle;
    private RogLogUtil.MetadataDisplayPolicy messageTraceMetadataDisplayPolicy;
    private boolean messageTraceFilterUnsetFields;
    private int maxEnvironmentProviders;
    private boolean enableSendCommitCompleteSequenceAlerts;
    private boolean setInboundMessagesAsReadOnly;
    private boolean setOutboundMessagesAsReadOnly;
    private boolean captureMessageTypeStats;
    private String messageTypeStatsLatenciesToCapture;
    private boolean captureTransactionLatencyStats;
    private boolean captureTransactionLatencyStatsExplicitlySet;
    private boolean captureEventLatencyStats;
    private boolean capturePerTransactionStats;
    private boolean replicateInParallel;
    private boolean preserveChannelJoinsOnStop;
    private boolean setSupportMetadata;
    private boolean setOutboundSequenceNumbers;
    private boolean syncInjectedMessages;
    private boolean stopOnJVMShutdown;
    private boolean enableTypeBasedRouting;

    private AepEngineDescriptor(String name) {
        this.name = name;
        this.stateFactories = new ArrayList<String>();
        this.messageFactories = new ArrayList<String>();
        this.channels = new HashMap<String, Map<String, ChannelConfig>>();
        this.busConnectionProperties = new HashMap<String, Properties>();
        this.haPolicy = AepEngine.HAPolicy.StateReplication;
        this.replicationPolicy = AepEngine.ReplicationPolicy.Pipelined;
        this.messagingStartFailPolicy = AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails;
        this.messageBusBindingFailPolicy = AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails;
        this.inboundMessageLoggingPolicy = AepEngine.InboundMessageLoggingPolicy.Off;
        this.inboundMessageLoggingFailurePolicy = AepEngine.InboundMessageLoggingFailurePolicy.StopEngine;
        this.outboundMessageLoggingPolicy = AepEngine.OutboundMessageLoggingPolicy.Off;
        this.outboundMessageLoggingFailurePolicy = AepEngine.OutboundMessageLoggingFailurePolicy.StopEngine;
        this.perTransactionStatsLoggingPolicy = AepEngine.PerTransactionStatsLoggingPolicy.Off;
        this.perTransactionStatsLoggingFailurePolicy = AepEngine.PerTransactionStatsLoggingFailurePolicy.StopLogging;
        this.appExceptionHandlingPolicy = AepEngine.AppExceptionHandlingPolicy.RollbackAndStop;
        this.sendExceptionHandlingPolicy = AepEngine.MessageSendExceptionHandlingPolicy.TreatAsStabilityFailure;
        this.sendStabilityFailureHandlingPolicy = AepEngine.MessageSendStabilityFailureHandlingPolicy.StopEngine;
        this.emuxType = AepEngine.EventMultiplexerType.valueOf(Config.getValue((String)"nv.aep.emuxtype", (String)"DedicatedThreaded"));
        this.emuxProperties = new Properties();
        this.inboundMessageLoggingProperties = new Properties();
        this.outboundMessageLoggingProperties = new Properties();
        this.perTransactionStatsLoggingProperties = new Properties();
        this.startupExpectations = new HashMap();
        this.adaptiveCommitBatchCeiling = 0;
        this.enableMultipleFlows = false;
        this.enableEnableReplayOnRollback = false;
        this.dispatchTransactionStageEvents = false;
        this.enableTransactionCommitSuspension = false;
        this.enableTransactionSavepoints = false;
        this.replicateSolicitedSends = true;
        this.replicateUnsolicitedSends = false;
        this.sequenceUnsolicitedSends = false;
        this.sequenceUnsolicitedWithSolicitedSends = false;
        this.disposeOnSend = true;
        this.clusterHeartbeatInterval = 0;
        this.administrative = false;
        this.stuckAlertEventThreshold = 0;
        this.performDuplicateChecking = Config.getValue((String)"nv.aep.duplicate.checking", (boolean)true);
        this.performMidstreamInitializationValidation = Config.getValue((String)"nv.aep.midstreaminit.validation", (boolean)true);
        this.enableSequenceNumberTrace = Config.getValue((String)"nv.aep.sno.trace.enable", (boolean)false);
        this.enableEventTrace = Config.getValue((String)"nv.aep.event.trace.enable", (boolean)false);
        this.enableTransactionTrace = Config.getValue((String)"nv.aep.txn.trace.enable", (boolean)false);
        this.enableScheduleTrace = Config.getValue((String)"nv.aep.sched.trace.enable", (boolean)false);
        this.enableAlertTrace = Config.getValue((String)"nv.aep.alert.trace.enable", (boolean)true);
        this.enableMessageTrace = Config.getValue((String)"nv.aep.msg.trace.enable", (boolean)false);
        this.messageTraceInJson = Config.getValue((String)"nv.aep.msg.trace.json", (boolean)true);
        this.messageTraceJsonStyle = RogLogUtil.JsonPrettyPrintStyle.valueOf((String)Config.getValue((String)"nv.aep.msg.trace.jsonstyle", (String)"SingleLine"));
        boolean messageTracerFull = Config.getValue((String)ENABLE_FULL_MESSAGE_TRACE_PROPNAME, (boolean)false);
        this.messageTraceMetadataDisplayPolicy = RogLogUtil.MetadataDisplayPolicy.valueOf((String)Config.getValue((String)"nv.aep.msg.trace.metadata", (String)(messageTracerFull ? RogLogUtil.MetadataDisplayPolicy.On.name() : "Only")));
        this.messageTraceFilterUnsetFields = Config.getValue((String)"nv.aep.msg.trace.filterunsetfields", (boolean)true);
        this.maxEnvironmentProviders = Config.getValue((String)"nv.aep.maxenvironmentproviders", (int)256);
        this.enableSendCommitCompleteSequenceAlerts = Config.getValue((String)"nv.aep.enablesendcommitcompletesequencealerts", (boolean)false);
        this.setInboundMessagesAsReadOnly = Config.getValue((String)"nv.aep.inbound.setasreadonly", (boolean)true);
        this.setOutboundMessagesAsReadOnly = Config.getValue((String)"nv.aep.outbound.setasreadonly", (boolean)true);
        this.captureMessageTypeStats = Config.getValue((String)String.format("nv.aep.%s.msgtype.stats", name), (boolean)false);
        this.captureTransactionLatencyStats = Config.getValue((String)String.format("nv.aep.%s.latency.stats", name), (boolean)AepConstants.CAPTURE_TRANSACTION_LATENCY_STATS_DEFAULT);
        this.capturePerTransactionStats = Config.getValue((String)String.format("nv.aep.%s.pertransactiontiming.stats", name), (boolean)false);
        this.captureEventLatencyStats = Config.getValue((String)String.format("nv.aep.%s.event.latency.stats", name), (boolean)false);
        this.replicateInParallel = Config.getValue((String)"nv.aep.replicateinparallel", (boolean)false);
        this.inboundEventAcknowledgementPolicy = AepEngine.InboundEventAcknowledgementPolicy.valueOf(Config.getValue((String)"nv.aep.inboundeventackpolicy", (String)"Default"));
        this.setPreserveChannelJoinsOnStop(false);
        this.setSupportMetadata = Config.getValue((String)"nv.aep.inbound.setsupportmetadata", (boolean)true);
        this.setOutboundSequenceNumbers = Config.getValue((String)"nv.aep.inbound.setoutboundsequencenumbers", (boolean)true);
        this.syncInjectedMessages = Config.getValue((String)"nv.aep.syncinjectedmessages", (boolean)false);
        this.enableTypeBasedRouting = Config.getValue((String)"nv.aep.enabletypebasedrouting", (boolean)true);
        this.stopOnJVMShutdown = Config.getValue((String)"nv.aep.stoponjvmshutdown", (boolean)true);
        this.messageTypeStatsLatenciesToCapture = Config.getValue((String)"nv.aep.%s.msgtype.stats.latenciestocapture", (String)"all");
    }

    private final String channelListToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("");
        Iterator<String> busNameIterator = this.getBuses().iterator();
        while (busNameIterator.hasNext()) {
            String busName = busNameIterator.next();
            Map<String, ChannelConfig> busChannels = this.getChannels(busName);
            if (busChannels.size() > 0) {
                Iterator<String> channelNameIterator = busChannels.keySet().iterator();
                while (channelNameIterator.hasNext()) {
                    String channelName = channelNameIterator.next();
                    builder.append(channelName).append("@").append(busName);
                    builder.append("&").append(busChannels.get(channelName).serialize());
                    if (!channelNameIterator.hasNext()) continue;
                    builder.append(",");
                }
            } else {
                builder.append("null").append("@").append(busName);
            }
            if (!busNameIterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private final AepEngineDescriptor addRemoveChannel(String channelDescriptor, boolean add) {
        int index1 = channelDescriptor.indexOf(64);
        int index2 = channelDescriptor.indexOf(38);
        if (index2 < 0) {
            index2 = channelDescriptor.length();
        }
        if (index1 <= index2 - 1 && index2 != channelDescriptor.length() - 1) {
            String busName = index1 >= 0 ? channelDescriptor.substring(index1 + 1, index2).trim() : "$global$";
            String channelName = channelDescriptor.substring(0, index1 >= 0 ? index1 : index2).trim();
            if (add) {
                if (channelName.length() == 0 || channelName.equals("null")) {
                    this.addBus(busName);
                } else {
                    this.addChannel(busName, channelName, ChannelConfig.from(index2 < channelDescriptor.length() ? channelDescriptor.substring(index2 + 1, channelDescriptor.length()) : null));
                }
            } else if (channelName.length() == 0 || channelName.equals("null")) {
                this.removeBus(busName);
            } else {
                this.removeChannel(busName, channelName);
            }
        } else {
            throw new IllegalArgumentException("channel descriptor must of the form channelName@busName&props1=val1&...propN=valN");
        }
        return this;
    }

    private final String factoriesListToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> stringListIterator = list.iterator();
        while (stringListIterator.hasNext()) {
            String val = stringListIterator.next();
            sb.append(val);
            if (!stringListIterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public final AepEngineDescriptor setName(String val) {
        this.name = val;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final AepEngineDescriptor addStateFactory(String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException("factory class name cannot be null");
        }
        this.stateFactories.add(factoryClassName);
        return this;
    }

    public final List<String> getStateFactories() {
        return this.stateFactories;
    }

    public final AepEngineDescriptor addMessageFactory(String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException("factory class name cannot be null");
        }
        this.messageFactories.add(factoryClassName);
        return this;
    }

    public final List<String> getMessageFactories() {
        return this.messageFactories;
    }

    public final AepEngineDescriptor addBus(String busName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        Map<String, ChannelConfig> busChannels = this.channels.get(busName);
        if (busChannels == null) {
            busChannels = new LinkedHashMap<String, ChannelConfig>();
            this.channels.put(busName, busChannels);
        }
        return this;
    }

    public final AepEngineDescriptor setBusConnectionProperty(String busName, String propName, String propVal) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        if (propVal == null) {
            throw new IllegalArgumentException("property value cannot be null (use clearBusConnectionProperty to clear a bus connection's property)");
        }
        Properties properties = this.busConnectionProperties.get(busName);
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(propName, propVal);
        this.busConnectionProperties.put(busName, properties);
        return this;
    }

    public final String setBusConnectionProperty(String busName, String propName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        Properties properties = this.busConnectionProperties.get(busName);
        if (properties != null) {
            return properties.getProperty(propName);
        }
        return null;
    }

    public final AepEngineDescriptor clearBusConnectionProperty(String busName, String propName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        Properties properties = this.busConnectionProperties.get(busName);
        if (properties != null) {
            properties.remove(propName);
        }
        return this;
    }

    public final AepEngineDescriptor setBusConnectionProperties(String busName, Properties properties) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null (use clearBusConnectionProperties to clear a bus connection's properties)");
        }
        this.busConnectionProperties.put(busName, properties);
        return this;
    }

    public final Properties getBusConnectionProperties(String busName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        return this.busConnectionProperties.get(busName);
    }

    public final AepEngineDescriptor clearBusConnectionProperties(String busName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        this.busConnectionProperties.remove(busName);
        return this;
    }

    public final Set<String> getBusConnectionsWithConfiguration() {
        return this.busConnectionProperties.keySet();
    }

    public final AepEngineDescriptor removeBus(String busName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        this.channels.remove(busName);
        return this;
    }

    public final AepEngineDescriptor addChannel(String channelName, ChannelConfig channelConfig) {
        return this.addChannel("$global$", channelName, channelConfig);
    }

    public final AepEngineDescriptor addChannel(String busName, String channelName, ChannelConfig channelConfig) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (channelName == null) {
            throw new IllegalArgumentException("channel name cannot be null");
        }
        if (channelConfig == null) {
            throw new IllegalArgumentException("channel config cannot be null");
        }
        this.addBus(busName);
        Map<String, ChannelConfig> busChannels = this.channels.get(busName);
        busChannels.put(channelName, channelConfig);
        return this;
    }

    public final AepEngineDescriptor removeChannel(String busName, String channelName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (channelName == null) {
            throw new IllegalArgumentException("channel name cannot be null");
        }
        Map<String, ChannelConfig> busChannels = this.channels.get(busName);
        if (busChannels != null) {
            busChannels.remove(channelName);
            if (busChannels.size() == 0) {
                this.channels.remove(busName);
            }
        }
        return this;
    }

    public final AepEngineDescriptor addChannel(String channelDescriptor) {
        return this.addRemoveChannel(channelDescriptor, true);
    }

    public final AepEngineDescriptor removeChannel(String channelDescriptor) {
        return this.addRemoveChannel(channelDescriptor, false);
    }

    public final Set<String> getBuses() {
        return this.channels.keySet();
    }

    public final Map<String, ChannelConfig> getChannels(String busName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        return this.channels.get(busName);
    }

    public final ChannelConfig getChannelConfig(String busName, String channelName) {
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (channelName == null) {
            throw new IllegalArgumentException("channel name cannot be null");
        }
        Map<String, ChannelConfig> busChannels = this.getChannels(busName);
        if (busChannels != null) {
            return busChannels.get(channelName);
        }
        return null;
    }

    public final AepEngineDescriptor setStore(String storeName) {
        if (storeName != null && this.getEnableTransactionCommitSuspension()) {
            throw new IllegalStateException("transaction commit suspension is currently not supported for clustered engines");
        }
        this.storeName = storeName;
        return this;
    }

    public final String getStore() {
        return this.storeName;
    }

    public final AepEngineDescriptor setHAPolicy(AepEngine.HAPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        if (val == AepEngine.HAPolicy.StateReplication && this.getEnableTransactionCommitSuspension()) {
            throw new IllegalStateException("transaction commit suspension is currently not supported with state replication");
        }
        if (val == AepEngine.HAPolicy.EventSourcing && this.getReplicateUnsolicitedSends()) {
            throw new IllegalStateException("replication of unsolicited sends is only applicable to state replication");
        }
        this.haPolicy = val;
        return this;
    }

    public final AepEngine.HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    public final AepEngineDescriptor setReplicationPolicy(AepEngine.ReplicationPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.replicationPolicy = val;
        return this;
    }

    public final AepEngine.ReplicationPolicy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public final AepEngineDescriptor setMessagingStartFailPolicy(AepEngine.MessagingStartFailPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.messagingStartFailPolicy = val;
        return this;
    }

    public final AepEngine.MessagingStartFailPolicy getMessagingStartFailPolicy() {
        return this.messagingStartFailPolicy;
    }

    public final AepEngineDescriptor setMessageBusBindingFailPolicy(AepEngine.MessageBusBindingFailPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.messageBusBindingFailPolicy = val;
        return this;
    }

    public final AepEngine.MessageBusBindingFailPolicy getMessageBusBindingFailPolicy() {
        return this.messageBusBindingFailPolicy;
    }

    public final AepEngineDescriptor setInboundMessageLoggingPolicy(AepEngine.InboundMessageLoggingPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.inboundMessageLoggingPolicy = val;
        return this;
    }

    public final AepEngine.InboundMessageLoggingPolicy getInboundMessageLoggingPolicy() {
        return this.inboundMessageLoggingPolicy;
    }

    public final AepEngineDescriptor setInboundMessageLoggingFailurePolicy(AepEngine.InboundMessageLoggingFailurePolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.inboundMessageLoggingFailurePolicy = val;
        return this;
    }

    public AepEngine.InboundMessageLoggingFailurePolicy getInboundMessageLoggingFailurePolicy() {
        return this.inboundMessageLoggingFailurePolicy;
    }

    public final AepEngineDescriptor setInboundMessageLoggingProperty(String name, String val) {
        if (name == null || val == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.inboundMessageLoggingProperties.setProperty(name, val);
        return this;
    }

    public final String getInboundMessageLoggingProperty(String name) {
        return this.inboundMessageLoggingProperties.getProperty(name);
    }

    public final AepEngineDescriptor clearInboundMessageLoggingProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.inboundMessageLoggingProperties.remove(name);
        return this;
    }

    public final AepEngineDescriptor setInboundMessageLoggingProperties(Properties val) {
        this.inboundMessageLoggingProperties = val;
        return this;
    }

    public final Properties getInboundMessageLoggingProperties() {
        return this.inboundMessageLoggingProperties;
    }

    public final AepEngineDescriptor setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.outboundMessageLoggingPolicy = val;
        return this;
    }

    public final AepEngine.OutboundMessageLoggingPolicy getOutboundMessageLoggingPolicy() {
        return this.outboundMessageLoggingPolicy;
    }

    public final AepEngineDescriptor setOutboundMessageLoggingFailurePolicy(AepEngine.OutboundMessageLoggingFailurePolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.outboundMessageLoggingFailurePolicy = val;
        return this;
    }

    public AepEngine.OutboundMessageLoggingFailurePolicy getOutboundMessageLoggingFailurePolicy() {
        return this.outboundMessageLoggingFailurePolicy;
    }

    public final AepEngineDescriptor setOutboundMessageLoggingProperty(String name, String val) {
        if (name == null || val == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.outboundMessageLoggingProperties.setProperty(name, val);
        return this;
    }

    public final String getOutboundMessageLoggingProperty(String name) {
        return this.outboundMessageLoggingProperties.getProperty(name);
    }

    public final AepEngineDescriptor clearOutboundMessageLoggingProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.outboundMessageLoggingProperties.remove(name);
        return this;
    }

    public final AepEngineDescriptor setOutboundMessageLoggingProperties(Properties val) {
        this.outboundMessageLoggingProperties = val;
        return this;
    }

    public final Properties getOutboundMessageLoggingProperties() {
        return this.outboundMessageLoggingProperties;
    }

    public final AepEngineDescriptor setPerTransactionStatsLoggingPolicy(AepEngine.PerTransactionStatsLoggingPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.perTransactionStatsLoggingPolicy = val;
        return this;
    }

    public final AepEngine.PerTransactionStatsLoggingPolicy getPerTransactionStatsLoggingPolicy() {
        return this.perTransactionStatsLoggingPolicy;
    }

    public final AepEngineDescriptor setPerTransactionStatsLoggingFailurePolicy(AepEngine.PerTransactionStatsLoggingFailurePolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.perTransactionStatsLoggingFailurePolicy = val;
        return this;
    }

    public AepEngine.PerTransactionStatsLoggingFailurePolicy getPerTransactionStatsLoggingFailurePolicy() {
        return this.perTransactionStatsLoggingFailurePolicy;
    }

    public final AepEngineDescriptor setPerTransactionStatsLoggingProperty(String name, String val) {
        if (name == null || val == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.perTransactionStatsLoggingProperties.setProperty(name, val);
        return this;
    }

    public final String getPerTransactionStatsLoggingProperty(String name) {
        return this.perTransactionStatsLoggingProperties.getProperty(name);
    }

    public final AepEngineDescriptor clearPerTransactionStatsLoggingProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.perTransactionStatsLoggingProperties.remove(name);
        return this;
    }

    public final AepEngineDescriptor setPerTransactionStatsLoggingProperties(Properties val) {
        this.perTransactionStatsLoggingProperties = val;
        return this;
    }

    public final Properties getPerTransactionStatsLoggingProperties() {
        return this.perTransactionStatsLoggingProperties;
    }

    @Deprecated
    public final AepEngineDescriptor setMessageSendPolicy(AepEngine.MessageSendPolicy val) {
        return this;
    }

    @Deprecated
    public final AepEngine.MessageSendPolicy getMessageSendPolicy() {
        return AepEngine.MessageSendPolicy.ReplicateBeforeSend;
    }

    public final AepEngineDescriptor setAppExceptionHandlingPolicy(AepEngine.AppExceptionHandlingPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("app exception handling policy cannot be null");
        }
        this.appExceptionHandlingPolicy = val;
        return this;
    }

    public final AepEngine.AppExceptionHandlingPolicy getAppExceptionHandlingPolicy() {
        return this.appExceptionHandlingPolicy;
    }

    public final AepEngineDescriptor setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("message send exception handling policy cannot be null");
        }
        this.sendExceptionHandlingPolicy = val;
        return this;
    }

    public final AepEngine.MessageSendExceptionHandlingPolicy getMessageSendExceptionHandlingPolicy() {
        return this.sendExceptionHandlingPolicy;
    }

    public final AepEngineDescriptor setMessageSendStabilityFailureHandlingPolicy(AepEngine.MessageSendStabilityFailureHandlingPolicy val) {
        if (val == null) {
            throw new IllegalArgumentException("message send stability failure handling policy cannot be null");
        }
        this.sendStabilityFailureHandlingPolicy = val;
        return this;
    }

    public final AepEngine.MessageSendStabilityFailureHandlingPolicy getMessageSendStabilityFailureHandlingPolicy() {
        return this.sendStabilityFailureHandlingPolicy;
    }

    public final AepEngineDescriptor setEventMultiplexerType(AepEngine.EventMultiplexerType val) {
        if (val == null) {
            throw new IllegalArgumentException("event multiplexer type cannot be null");
        }
        this.emuxType = val;
        return this;
    }

    public final AepEngine.EventMultiplexerType getEventMultiplexerType() {
        return this.emuxType;
    }

    public final AepEngineDescriptor setEventMultiplexerProperty(String name, String val) {
        if (name == null || val == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.emuxProperties.setProperty(name, val);
        return this;
    }

    public final String getEventMultiplexerProperty(String name) {
        return this.emuxProperties.getProperty(name);
    }

    public final AepEngineDescriptor clearEventMultiplexerProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.emuxProperties.remove(name);
        return this;
    }

    public final AepEngineDescriptor setEventMultiplexerProperties(Properties val) {
        this.emuxProperties = val;
        return this;
    }

    public final Properties getEventMultiplexerProperties() {
        return this.emuxProperties;
    }

    public final AepEngineDescriptor setStartupExpectation(AepEngine.StartupExpectation expectation, Enum<?> val) {
        if (expectation == null || val == null) {
            throw new IllegalArgumentException("expectation name or value cannot be null");
        }
        this.startupExpectations.put(expectation, val);
        return this;
    }

    public final Enum<?> getStartupExpectation(AepEngine.StartupExpectation expectation) {
        return this.startupExpectations.get((Object)expectation);
    }

    public final AepEngineDescriptor clearStartupExpectation(AepEngine.StartupExpectation expectation) {
        if (expectation == null) {
            throw new IllegalArgumentException("expectation name cannot be null");
        }
        this.startupExpectations.remove((Object)expectation);
        return this;
    }

    public final AepEngineDescriptor setStartupExpectations(Map<AepEngine.StartupExpectation, Enum<?>> val) {
        this.startupExpectations = val;
        return this;
    }

    public final Map<AepEngine.StartupExpectation, Enum<?>> getStartupExpectations() {
        return this.startupExpectations;
    }

    public final AepEngineDescriptor setAdaptiveCommitBatchCeiling(int val) {
        if (val > 0 && this.getEnableTransactionCommitSuspension()) {
            throw new IllegalStateException("transaction commit suspension is currently not supported with adaptive commit batching");
        }
        this.adaptiveCommitBatchCeiling = val;
        return this;
    }

    public final int getAdaptiveCommitBatchCeiling() {
        return this.adaptiveCommitBatchCeiling;
    }

    public final AepEngineDescriptor setEnableMultipleFlows(boolean val) {
        this.enableMultipleFlows = val;
        return this;
    }

    public final boolean getEnableMultipleFlows() {
        return this.enableMultipleFlows;
    }

    public final AepEngineDescriptor setEnableReplayOnRollback(boolean val) {
        this.enableEnableReplayOnRollback = val;
        return this;
    }

    public final boolean getEnableReplayOnRollback() {
        return this.enableEnableReplayOnRollback;
    }

    public final AepEngineDescriptor setDispatchTransactionStageEvents(boolean val) {
        this.dispatchTransactionStageEvents = val;
        return this;
    }

    public final boolean getDispatchTransactionStageEvents() {
        return this.dispatchTransactionStageEvents;
    }

    public final AepEngineDescriptor setEnableTransactionCommitSuspension(boolean val) {
        if (this.getStore() != null && val) {
            throw new IllegalStateException("transaction commit suspension is currently not supported for clustered engines");
        }
        if (this.getAdaptiveCommitBatchCeiling() > 0 && val) {
            throw new IllegalStateException("transaction commit suspension is currently not supported with adaptive commit batching");
        }
        if (this.getHAPolicy() == AepEngine.HAPolicy.StateReplication && val) {
            throw new IllegalStateException("transaction commit suspension is currently not supported with state replication");
        }
        this.enableTransactionCommitSuspension = val;
        return this;
    }

    public final boolean getEnableTransactionCommitSuspension() {
        return this.enableTransactionCommitSuspension;
    }

    public final boolean getEnableTransactionSavepoints() {
        return this.enableTransactionSavepoints;
    }

    public final void setEnableTransactionSavepoints(boolean enableTransactionSavepoints) {
        this.enableTransactionSavepoints = enableTransactionSavepoints;
    }

    public final AepEngineDescriptor setReplicateSolicitedSends(boolean val) {
        if (this.getReplicateUnsolicitedSends() && !val) {
            throw new IllegalStateException("replication of solicited sends must be enabled if replication of unsolicited sends is enabled");
        }
        this.replicateSolicitedSends = val;
        return this;
    }

    public final boolean getReplicateSolicitedSends() {
        return this.replicateSolicitedSends;
    }

    public final AepEngineDescriptor setReplicateUnsolicitedSends(boolean val) {
        if (this.getHAPolicy() == AepEngine.HAPolicy.EventSourcing && val) {
            throw new IllegalStateException("replication of unsolicited sends is not applicable to event sourcing");
        }
        if (!this.getReplicateSolicitedSends() && val) {
            throw new IllegalStateException("replication of solicited sends must be enabled if replication of unsolicited sends is to be enabled");
        }
        this.replicateUnsolicitedSends = val;
        return this;
    }

    public final boolean getReplicateUnsolicitedSends() {
        return this.replicateUnsolicitedSends;
    }

    public final AepEngineDescriptor setSequenceUnsolicitedSends(boolean val) {
        this.sequenceUnsolicitedSends = val;
        return this;
    }

    public final boolean getSequenceUnsolicitedSends() {
        return this.sequenceUnsolicitedSends;
    }

    public final AepEngineDescriptor setDispatchSendStabilityEvents(boolean val) {
        this.dispatchSendStabilityEvents = val;
        return this;
    }

    public boolean getDispatchSendStabilityEvents() {
        return this.dispatchSendStabilityEvents;
    }

    public final AepEngineDescriptor setClusterHeartbeatInterval(int val) {
        this.clusterHeartbeatInterval = val > 0 ? Math.max(val, 100) : val;
        return this;
    }

    public final int getClusterHeartbeatInterval() {
        return this.clusterHeartbeatInterval;
    }

    public final AepEngineDescriptor setSequenceUnsolicitedWithSolicitedSends(boolean val) {
        this.sequenceUnsolicitedWithSolicitedSends = val;
        return this;
    }

    public final boolean getSequenceUnsolicitedWithSolicitedSends() {
        return this.sequenceUnsolicitedWithSolicitedSends;
    }

    public final AepEngineDescriptor setDisposeOnSend(boolean val) {
        this.disposeOnSend = val;
        return this;
    }

    public final boolean getDisposeOnSend() {
        return this.disposeOnSend;
    }

    public final void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final AepEngineDescriptor setAdministrative(boolean val) {
        this.administrative = val;
        return this;
    }

    public final boolean getAdministrative() {
        return this.administrative;
    }

    public final AepEngineDescriptor setStuckAlertEventThreshold(int thresholdSeconds) {
        this.stuckAlertEventThreshold = thresholdSeconds;
        return this;
    }

    public final int getStuckAlertEventThreshold() {
        return this.stuckAlertEventThreshold;
    }

    public final AepEngineDescriptor setPerformDuplicateChecking(boolean val) {
        this.performDuplicateChecking = val;
        return this;
    }

    public final boolean getPerformDuplicateChecking() {
        return this.performDuplicateChecking;
    }

    public final AepEngineDescriptor setPerformMidstreamInitializationValidation(boolean val) {
        this.performMidstreamInitializationValidation = val;
        return this;
    }

    public final boolean getPerformMidstreamInitializationValidation() {
        return this.performMidstreamInitializationValidation;
    }

    public final AepEngineDescriptor setEnableSequenceNumberTrace(boolean val) {
        this.enableSequenceNumberTrace = val;
        return this;
    }

    public final boolean getEnableSequenceNumberTrace() {
        return this.enableSequenceNumberTrace;
    }

    public final AepEngineDescriptor setEnableEventTrace(boolean val) {
        this.enableEventTrace = val;
        return this;
    }

    public final boolean getEnableEventTrace() {
        return this.enableEventTrace;
    }

    public final AepEngineDescriptor setEnableTransactionTrace(boolean val) {
        this.enableTransactionTrace = val;
        return this;
    }

    public final boolean getEnableTransactionTrace() {
        return this.enableTransactionTrace;
    }

    public final AepEngineDescriptor setEnableScheduleTrace(boolean val) {
        this.enableScheduleTrace = val;
        return this;
    }

    public final boolean getEnableScheduleTrace() {
        return this.enableScheduleTrace;
    }

    public final AepEngineDescriptor setEnableAlertTrace(boolean val) {
        this.enableAlertTrace = val;
        return this;
    }

    public final boolean getEnableAlertTrace() {
        return this.enableAlertTrace;
    }

    public final AepEngineDescriptor setEnableMessageTrace(boolean val) {
        this.enableMessageTrace = val;
        return this;
    }

    public final boolean getEnableMessageTrace() {
        return this.enableMessageTrace;
    }

    public final AepEngineDescriptor setMessageTraceInJson(boolean val) {
        this.messageTraceInJson = val;
        return this;
    }

    public final boolean getMessageTraceInJson() {
        return this.messageTraceInJson;
    }

    public final AepEngineDescriptor setMessageTraceJsonStyle(RogLogUtil.JsonPrettyPrintStyle val) {
        this.messageTraceJsonStyle = val;
        return this;
    }

    public final RogLogUtil.JsonPrettyPrintStyle getMessageTraceJsonStyle() {
        return this.messageTraceJsonStyle;
    }

    public final AepEngineDescriptor setMessageTraceMetadataDisplayPolicy(RogLogUtil.MetadataDisplayPolicy val) {
        this.messageTraceMetadataDisplayPolicy = val;
        return this;
    }

    public final RogLogUtil.MetadataDisplayPolicy getMessageTraceMetadataDisplayPolicy() {
        return this.messageTraceMetadataDisplayPolicy;
    }

    public final AepEngineDescriptor setMessageTraceFilterUnsetFields(boolean val) {
        this.messageTraceFilterUnsetFields = val;
        return this;
    }

    public final boolean getMessageTraceFilterUnsetFields() {
        return this.messageTraceFilterUnsetFields;
    }

    public final AepEngineDescriptor setMaxEnvironmentProviders(int val) {
        this.maxEnvironmentProviders = val;
        return this;
    }

    public final int getMaxEnvironmentProviders() {
        return this.maxEnvironmentProviders;
    }

    public final AepEngineDescriptor setEnableSendCommitCompleteSequenceAlerts(boolean val) {
        this.enableSendCommitCompleteSequenceAlerts = val;
        return this;
    }

    public final boolean getEnableSendCommitCompleteSequenceAlerts() {
        return this.enableSendCommitCompleteSequenceAlerts;
    }

    public final AepEngineDescriptor setSetInboundMessagesAsReadOnly(boolean val) {
        this.setInboundMessagesAsReadOnly = val;
        return this;
    }

    public final boolean getSetInboundMessagesAsReadOnly() {
        return this.setInboundMessagesAsReadOnly;
    }

    public final AepEngineDescriptor setSetOutboundMessagesAsReadOnly(boolean val) {
        this.setOutboundMessagesAsReadOnly = val;
        return this;
    }

    public final boolean getSetOutboundMessagesAsReadOnly() {
        return this.setOutboundMessagesAsReadOnly;
    }

    public final AepEngineDescriptor setCaptureMessageTypeStats(boolean val) {
        this.captureMessageTypeStats = val;
        return this;
    }

    public final boolean getCaptureMessageTypeStats() {
        return this.captureMessageTypeStats;
    }

    public final AepEngineDescriptor setMessageTypeStatsLatenciesToCapture(String list) {
        this.messageTypeStatsLatenciesToCapture = list;
        return this;
    }

    public final String getMessageTypeStatsLatenciesToCapture() {
        return this.messageTypeStatsLatenciesToCapture == null ? "all" : this.messageTypeStatsLatenciesToCapture;
    }

    public final AepEngineDescriptor setCaptureTransactionLatencyStats(boolean val) {
        this.captureTransactionLatencyStats = val;
        this.captureTransactionLatencyStatsExplicitlySet = true;
        return this;
    }

    public final boolean getCaptureTransactionLatencyStats() {
        if (!this.captureTransactionLatencyStatsExplicitlySet) {
            this.setCaptureTransactionLatencyStats(Config.getValue((String)"nv.stats.latency.leg.transaction.enabled", (boolean)Stats.LatencyManager.recordLegLatencies));
        }
        return this.captureTransactionLatencyStats;
    }

    public final AepEngineDescriptor setCapturePerTransactionStats(boolean val) {
        this.capturePerTransactionStats = val;
        return this;
    }

    public final boolean getCapturePerTransactionStats() {
        return this.capturePerTransactionStats;
    }

    public final AepEngineDescriptor setCaptureEventLatencyStats(boolean val) {
        this.captureEventLatencyStats = val;
        return this;
    }

    public final boolean getCaptureEventLatencyStats() {
        return this.captureEventLatencyStats;
    }

    public final AepEngineDescriptor setReplicateInParallel(boolean val) {
        this.replicateInParallel = val;
        return this;
    }

    public final boolean getReplicateInParallel() {
        return this.replicateInParallel;
    }

    public final boolean getPreserveChannelJoinsOnStop() {
        return this.preserveChannelJoinsOnStop;
    }

    public final AepEngineDescriptor setPreserveChannelJoinsOnStop(boolean preserveChannelJoinsOnStop) {
        this.preserveChannelJoinsOnStop = preserveChannelJoinsOnStop;
        return this;
    }

    public final AepEngineDescriptor setSetSupportMetadata(boolean val) {
        this.setSupportMetadata = val;
        return this;
    }

    public final boolean getSetSupportMetadata() {
        return this.setSupportMetadata;
    }

    public final AepEngineDescriptor setSetOutboundSequenceNumbers(boolean val) {
        this.setOutboundSequenceNumbers = val;
        return this;
    }

    public final boolean getSetOutboundSequenceNumbers() {
        return this.setOutboundSequenceNumbers;
    }

    public final AepEngine.InboundEventAcknowledgementPolicy getInboundEventAcknowledgementPolicy() {
        return this.inboundEventAcknowledgementPolicy;
    }

    public final AepEngineDescriptor setInboundEventAcknowledgementPolicy(AepEngine.InboundEventAcknowledgementPolicy policy) {
        this.inboundEventAcknowledgementPolicy = policy;
        return this;
    }

    public final boolean getSyncInjectedMessages() {
        return this.syncInjectedMessages;
    }

    public final void setSyncInjectedMessages(boolean syncInjectedMessages) {
        this.syncInjectedMessages = syncInjectedMessages;
    }

    public final boolean getEnableTypeBasedRouting() {
        return this.enableTypeBasedRouting;
    }

    public final void setEnableTypeBasedRouting(boolean enableTypeBasedRouting) {
        this.enableTypeBasedRouting = enableTypeBasedRouting;
    }

    public final boolean getStopOnJVMShutdown() {
        return this.stopOnJVMShutdown;
    }

    public final void setStopOnJVMShutdown(boolean stopOnJVMShutdown) {
        this.stopOnJVMShutdown = stopOnJVMShutdown;
    }

    public final void save(IConfigRepository repo) throws EAepException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            StringWriter writer;
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/aep/engines");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/aep/engines");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            if (this.displayName != null) {
                entity.setProperty("DisplayName", this.getDisplayName());
            }
            entity.setProperty("StateFactories", this.factoriesListToString(this.stateFactories));
            entity.setProperty("MessageFactories", this.factoriesListToString(this.messageFactories));
            entity.setProperty("Channels", this.channelListToString());
            if (this.storeName != null) {
                entity.setProperty("Store", this.storeName);
            }
            Properties properties = new Properties();
            for (Map.Entry<String, Properties> entry : this.busConnectionProperties.entrySet()) {
                writer = new StringWriter();
                entry.getValue().store(writer, null);
                properties.setProperty(entry.getKey(), writer.toString());
            }
            writer = new StringWriter();
            properties.store(writer, null);
            entity.setProperty("BusConnectionProperties", writer.toString());
            entity.setProperty("HAPolicy", this.haPolicy.toString());
            entity.setProperty("ReplicationPolicy", this.replicationPolicy.toString());
            entity.setProperty("MessagingStartFailPolicy", this.messagingStartFailPolicy.toString());
            entity.setProperty("MessageBusBindingFailPolicy", this.messageBusBindingFailPolicy.toString());
            entity.setProperty("InboundMessageLoggingPolicy", this.inboundMessageLoggingPolicy.toString());
            entity.setProperty("InboundMessageLoggingFailurePolicy", this.inboundMessageLoggingFailurePolicy.toString());
            writer = new StringWriter();
            this.inboundMessageLoggingProperties.store(writer, null);
            entity.setProperty("InboundMessageLoggingProperties", writer.toString());
            entity.setProperty("OutboundMessageLoggingPolicy", this.outboundMessageLoggingPolicy.toString());
            entity.setProperty("OutboundMessageLoggingFailurePolicy", this.outboundMessageLoggingFailurePolicy.toString());
            writer = new StringWriter();
            this.outboundMessageLoggingProperties.store(writer, null);
            entity.setProperty("OutboundMessageLoggingProperties", writer.toString());
            entity.setProperty("PerTransactionStatsLoggingPolicy", this.perTransactionStatsLoggingPolicy.toString());
            entity.setProperty("PerTransactionStatsLoggingFailurePolicy", this.perTransactionStatsLoggingFailurePolicy.toString());
            writer = new StringWriter();
            this.perTransactionStatsLoggingProperties.store(writer, null);
            entity.setProperty("PerTransactionStatsLoggingProperties", writer.toString());
            entity.setProperty("AppExceptionHandlingPolicy", this.appExceptionHandlingPolicy.toString());
            entity.setProperty("MessageSendExceptionHandlingPolicy", this.sendExceptionHandlingPolicy.toString());
            entity.setProperty("MessageSendStabilityFailureHandlingPolicy", this.sendStabilityFailureHandlingPolicy.toString());
            entity.setProperty("EventMultiplexerType", this.emuxType.toString());
            writer = new StringWriter();
            this.emuxProperties.store(writer, null);
            entity.setProperty("EventMultiplexerProperties", writer.toString());
            if (this.startupExpectations.get((Object)AepEngine.StartupExpectation.Role) != null) {
                entity.setProperty("ExpectedStartupRole", this.startupExpectations.get((Object)AepEngine.StartupExpectation.Role).name());
            }
            if (this.startupExpectations.get((Object)AepEngine.StartupExpectation.LogEmptiness) != null) {
                entity.setProperty("ExpectedLogEmptiness", this.startupExpectations.get((Object)AepEngine.StartupExpectation.LogEmptiness).name());
            }
            entity.setProperty("AdaptiveCommitBatchCeiling", String.valueOf(this.adaptiveCommitBatchCeiling));
            entity.setProperty("EnableMultipleFlows", String.valueOf(this.enableMultipleFlows));
            entity.setProperty("EnableReplayOnRollback", String.valueOf(this.enableEnableReplayOnRollback));
            entity.setProperty("DispatchTransactionStageEvents", String.valueOf(this.dispatchTransactionStageEvents));
            entity.setProperty("EnableTransactionCommitSuspension", String.valueOf(this.enableTransactionCommitSuspension));
            entity.setProperty("EnableTransactionSavepoints", String.valueOf(this.enableTransactionSavepoints));
            entity.setProperty("ReplicateSolicitedSends", String.valueOf(this.replicateSolicitedSends));
            entity.setProperty("ReplicateUnsolicitedSends", String.valueOf(this.replicateUnsolicitedSends));
            entity.setProperty("SequenceUnsolicitedSends", String.valueOf(this.sequenceUnsolicitedSends));
            entity.setProperty("SequenceUnsolicitedWithSolicitedSends", String.valueOf(this.sequenceUnsolicitedWithSolicitedSends));
            entity.setProperty("DispatchSendStabilityEvents", String.valueOf(this.dispatchSendStabilityEvents));
            entity.setProperty("DisposeOnSend", String.valueOf(this.disposeOnSend));
            entity.setProperty("ClusterHeartbeatInterval", String.valueOf(this.clusterHeartbeatInterval));
            entity.setProperty("Administrative", String.valueOf(this.administrative));
            entity.setProperty("StuckAlertEventThreshold", String.valueOf(this.stuckAlertEventThreshold));
            entity.setProperty("PerformDuplicateChecking", String.valueOf(this.performDuplicateChecking));
            entity.setProperty("PerformMidstreamInitializationValidation", String.valueOf(this.performMidstreamInitializationValidation));
            entity.setProperty("EnableSequenceNumberTrace", String.valueOf(this.enableSequenceNumberTrace));
            entity.setProperty("EnableEventTrace", String.valueOf(this.enableEventTrace));
            entity.setProperty("EnableAlertTrace", String.valueOf(this.enableAlertTrace));
            entity.setProperty("EnableTransactionTrace", String.valueOf(this.enableTransactionTrace));
            entity.setProperty("EnableScheduleTrace", String.valueOf(this.enableScheduleTrace));
            entity.setProperty("EnableMessageTrace", String.valueOf(this.enableMessageTrace));
            entity.setProperty("MessageTraceInJson", String.valueOf(this.messageTraceInJson));
            entity.setProperty("MessageTraceJsonStyle", this.messageTraceJsonStyle.toString());
            entity.setProperty("MessageTraceMetadataDisplayPolicy", this.messageTraceMetadataDisplayPolicy.toString());
            entity.setProperty("MessageTraceFilterUnsetFields", String.valueOf(this.messageTraceFilterUnsetFields));
            entity.setProperty("MaxEnvironmentProviders", String.valueOf(this.maxEnvironmentProviders));
            entity.setProperty("EnableSendCommitCompleteSequenceAlerts", String.valueOf(this.enableSendCommitCompleteSequenceAlerts));
            entity.setProperty("SetInboundMessagesAsReadOnly", String.valueOf(this.setInboundMessagesAsReadOnly));
            entity.setProperty("SetOutboundMessagesAsReadOnly", String.valueOf(this.setOutboundMessagesAsReadOnly));
            entity.setProperty("CaptureMessageTypeStats", String.valueOf(this.captureMessageTypeStats));
            if (this.messageTypeStatsLatenciesToCapture != null) {
                entity.setProperty("MessageTypeStatsLatenciesToCapture", String.valueOf(this.messageTypeStatsLatenciesToCapture));
            }
            if (this.captureTransactionLatencyStatsExplicitlySet) {
                entity.setProperty("CaptureTransactionLatencyStats", String.valueOf(this.captureTransactionLatencyStats));
            }
            entity.setProperty("CapturePerTransactionStats", String.valueOf(this.capturePerTransactionStats));
            entity.setProperty("CaptureEventLatencyStats", String.valueOf(this.captureEventLatencyStats));
            entity.setProperty("ReplicateInParallel", String.valueOf(this.replicateInParallel));
            entity.setProperty("PreserveChannelJoinsOnStop", String.valueOf(this.preserveChannelJoinsOnStop));
            entity.setProperty("SetSupportMetadata", String.valueOf(this.setSupportMetadata));
            entity.setProperty("SetOutboundSequenceNumbers", String.valueOf(this.setOutboundSequenceNumbers));
            entity.setProperty("InboundEventAcknowledgementPolicy", this.inboundEventAcknowledgementPolicy.name());
            entity.setProperty("SyncInjectedMessages", String.valueOf(this.syncInjectedMessages));
            entity.setProperty("EnableTypeBasedRouting", String.valueOf(this.enableTypeBasedRouting));
            entity.setProperty("StopOnJVMShutdown", String.valueOf(this.stopOnJVMShutdown));
        }
        catch (IOException e) {
            throw new EAepException(e);
        }
        catch (EConfigException e) {
            throw new EAepException(e);
        }
    }

    public final void save() throws EAepException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws EAepException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/aep/engines");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final void delete() throws EAepException {
        this.delete(Config.getRepository());
    }

    public static AepEngineDescriptor create(String name) {
        if (name == null) {
            throw new IllegalArgumentException("engine name cannot be null");
        }
        return new AepEngineDescriptor(name);
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("engine name cannot be null");
        }
        return repo.getSimpleEntity("/aep/engines/" + name) != null;
    }

    public static boolean exists(String name) {
        return AepEngineDescriptor.exists(Config.getRepository(), name);
    }

    public static AepEngineDescriptor load(IConfigRepository repo, String name) throws EAepException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("engine name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/aep/engines/" + name);
        if (entity != null) {
            Properties properties;
            StringReader reader;
            String propertiesStr;
            StringTokenizer tokenizer;
            String channelList;
            StringTokenizer tokenizer2;
            String messageFactories;
            StringTokenizer tokenizer3;
            AepEngineDescriptor engineDescriptor = AepEngineDescriptor.create(name);
            String stateFactories = entity.getProperty("StateFactories", null);
            if (stateFactories != null && (tokenizer3 = new StringTokenizer(stateFactories, ",")).hasMoreTokens()) {
                while (tokenizer3.hasMoreTokens()) {
                    try {
                        engineDescriptor.addStateFactory(tokenizer3.nextToken());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            if ((messageFactories = entity.getProperty("MessageFactories", null)) != null && (tokenizer2 = new StringTokenizer(messageFactories, ",")).hasMoreTokens()) {
                while (tokenizer2.hasMoreTokens()) {
                    try {
                        engineDescriptor.addMessageFactory(tokenizer2.nextToken());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            if ((channelList = entity.getProperty("Channels", null)) != null && (tokenizer = new StringTokenizer(channelList, ",")).hasMoreTokens()) {
                while (tokenizer.hasMoreTokens()) {
                    try {
                        engineDescriptor.addChannel(tokenizer.nextToken());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            try {
                propertiesStr = entity.getProperty("BusConnectionProperties", null);
                if (propertiesStr != null) {
                    reader = new StringReader(propertiesStr);
                    Properties allProperties = new Properties();
                    allProperties.load(reader);
                    for (String busName : allProperties.stringPropertyNames()) {
                        Properties properties2 = new Properties();
                        reader = new StringReader(allProperties.getProperty(busName));
                        properties2.load(reader);
                        engineDescriptor.setBusConnectionProperties(busName, properties2);
                    }
                }
            }
            catch (IOException e) {
                throw new EAepException(e);
            }
            if (entity.getProperty("DisplayName", null) != null) {
                engineDescriptor.setDisplayName(entity.getProperty("DisplayName", null));
            }
            engineDescriptor.setStore(entity.getProperty("Store", null));
            if (entity.getProperty("HAPolicy", null) != null) {
                engineDescriptor.setHAPolicy(AepEngine.HAPolicy.valueOf(entity.getProperty("HAPolicy", null)));
            }
            if (entity.getProperty("ReplicationPolicy", null) != null) {
                engineDescriptor.setReplicationPolicy(AepEngine.ReplicationPolicy.valueOf(entity.getProperty("ReplicationPolicy", null)));
            }
            if (entity.getProperty("MessagingStartFailPolicy", null) != null) {
                engineDescriptor.setMessagingStartFailPolicy(AepEngine.MessagingStartFailPolicy.valueOf(entity.getProperty("MessagingStartFailPolicy", null)));
            }
            if (entity.getProperty("MessageBusBindingFailPolicy", null) != null) {
                engineDescriptor.setMessageBusBindingFailPolicy(AepEngine.MessageBusBindingFailPolicy.valueOf(entity.getProperty("MessageBusBindingFailPolicy", null)));
            }
            if (entity.getProperty("InboundMessageLoggingPolicy", null) != null) {
                engineDescriptor.setInboundMessageLoggingPolicy(AepEngine.InboundMessageLoggingPolicy.valueOf(entity.getProperty("InboundMessageLoggingPolicy", null)));
            }
            if (entity.getProperty("InboundMessageLoggingFailurePolicy", null) != null) {
                engineDescriptor.setInboundMessageLoggingFailurePolicy(AepEngine.InboundMessageLoggingFailurePolicy.valueOf(entity.getProperty("InboundMessageLoggingFailurePolicy", null)));
            }
            try {
                propertiesStr = entity.getProperty("InboundMessageLoggingProperties", null);
                if (propertiesStr == null) {
                    engineDescriptor.setInboundMessageLoggingProperties(new Properties());
                } else {
                    reader = new StringReader(propertiesStr);
                    properties = new Properties();
                    properties.load(reader);
                    engineDescriptor.setInboundMessageLoggingProperties(properties);
                }
            }
            catch (IOException e) {
                throw new EAepException(e);
            }
            if (entity.getProperty("OutboundMessageLoggingPolicy", null) != null) {
                engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.valueOf(entity.getProperty("OutboundMessageLoggingPolicy", null)));
            }
            if (entity.getProperty("OutboundMessageLoggingFailurePolicy", null) != null) {
                engineDescriptor.setOutboundMessageLoggingFailurePolicy(AepEngine.OutboundMessageLoggingFailurePolicy.valueOf(entity.getProperty("OutboundMessageLoggingFailurePolicy", null)));
            }
            try {
                propertiesStr = entity.getProperty("OutboundMessageLoggingProperties", null);
                if (propertiesStr == null) {
                    engineDescriptor.setOutboundMessageLoggingProperties(new Properties());
                } else {
                    reader = new StringReader(propertiesStr);
                    properties = new Properties();
                    properties.load(reader);
                    engineDescriptor.setOutboundMessageLoggingProperties(properties);
                }
            }
            catch (IOException e) {
                throw new EAepException(e);
            }
            if (entity.getProperty("PerTransactionStatsLoggingPolicy", null) != null) {
                engineDescriptor.setPerTransactionStatsLoggingPolicy(AepEngine.PerTransactionStatsLoggingPolicy.valueOf(entity.getProperty("PerTransactionStatsLoggingPolicy", null)));
            }
            if (entity.getProperty("PerTransactionStatsLoggingFailurePolicy", null) != null) {
                engineDescriptor.setPerTransactionStatsLoggingFailurePolicy(AepEngine.PerTransactionStatsLoggingFailurePolicy.valueOf(entity.getProperty("PerTransactionStatsLoggingFailurePolicy", null)));
            }
            try {
                propertiesStr = entity.getProperty("PerTransactionStatsLoggingProperties", null);
                if (propertiesStr == null) {
                    engineDescriptor.setPerTransactionStatsLoggingProperties(new Properties());
                } else {
                    reader = new StringReader(propertiesStr);
                    properties = new Properties();
                    properties.load(reader);
                    engineDescriptor.setPerTransactionStatsLoggingProperties(properties);
                }
            }
            catch (IOException e) {
                throw new EAepException(e);
            }
            if (entity.getProperty("AppExceptionHandlingPolicy", null) != null) {
                engineDescriptor.setAppExceptionHandlingPolicy(AepEngine.AppExceptionHandlingPolicy.valueOf(entity.getProperty("AppExceptionHandlingPolicy", null)));
            }
            if (entity.getProperty("MessageSendExceptionHandlingPolicy", null) != null) {
                engineDescriptor.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.valueOf(entity.getProperty("MessageSendExceptionHandlingPolicy", null)));
            }
            if (entity.getProperty("MessageSendStabilityFailureHandlingPolicy", null) != null) {
                engineDescriptor.setMessageSendStabilityFailureHandlingPolicy(AepEngine.MessageSendStabilityFailureHandlingPolicy.valueOf(entity.getProperty("MessageSendStabilityFailureHandlingPolicy", null)));
            }
            if (entity.getProperty("EventMultiplexerType", null) != null) {
                engineDescriptor.setEventMultiplexerType(AepEngine.EventMultiplexerType.valueOf(entity.getProperty("EventMultiplexerType", null)));
            }
            try {
                propertiesStr = entity.getProperty("EventMultiplexerProperties", null);
                if (propertiesStr == null) {
                    engineDescriptor.setEventMultiplexerProperties(new Properties());
                } else {
                    reader = new StringReader(propertiesStr);
                    properties = new Properties();
                    properties.load(reader);
                    engineDescriptor.setEventMultiplexerProperties(properties);
                }
            }
            catch (IOException e) {
                throw new EAepException(e);
            }
            try {
                String expectedLogEmptiness;
                String expectedStartupRole = entity.getProperty("ExpectedStartupRole", null);
                if (expectedStartupRole != null) {
                    engineDescriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.valueOf((String)expectedStartupRole));
                }
                if ((expectedLogEmptiness = entity.getProperty("ExpectedLogEmptiness", null)) != null) {
                    engineDescriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.valueOf((String)expectedLogEmptiness));
                }
            }
            catch (Throwable e) {
                throw new EAepException(e);
            }
            if (entity.getProperty("AdaptiveCommitBatchCeiling", null) != null) {
                engineDescriptor.setAdaptiveCommitBatchCeiling(Integer.valueOf(entity.getProperty("AdaptiveCommitBatchCeiling", null)));
            }
            if (entity.getProperty("EnableMultipleFlows", null) != null) {
                engineDescriptor.setEnableMultipleFlows(Boolean.valueOf(entity.getProperty("EnableMultipleFlows", null)));
            }
            if (entity.getProperty("EnableReplayOnRollback", null) != null) {
                engineDescriptor.setEnableReplayOnRollback(Boolean.valueOf(entity.getProperty("EnableReplayOnRollback", null)));
            }
            if (entity.getProperty("DispatchTransactionStageEvents", null) != null) {
                engineDescriptor.setDispatchTransactionStageEvents(Boolean.valueOf(entity.getProperty("DispatchTransactionStageEvents", null)));
            }
            if (entity.getProperty("EnableTransactionCommitSuspension", null) != null) {
                engineDescriptor.setEnableTransactionCommitSuspension(Boolean.valueOf(entity.getProperty("EnableTransactionCommitSuspension", null)));
            }
            if (entity.getProperty("EnableTransactionSavepoints", null) != null) {
                engineDescriptor.setEnableTransactionSavepoints(Boolean.valueOf(entity.getProperty("EnableTransactionSavepoints", null)));
            }
            if (entity.getProperty("ReplicateSolicitedSends", null) != null) {
                engineDescriptor.setReplicateSolicitedSends(Boolean.valueOf(entity.getProperty("ReplicateSolicitedSends", null)));
            }
            if (entity.getProperty("ReplicateUnsolicitedSends", null) != null) {
                engineDescriptor.setReplicateUnsolicitedSends(Boolean.valueOf(entity.getProperty("ReplicateUnsolicitedSends", null)));
            }
            if (entity.getProperty("SequenceUnsolicitedSends", null) != null) {
                engineDescriptor.setSequenceUnsolicitedSends(Boolean.valueOf(entity.getProperty("SequenceUnsolicitedSends", null)));
            }
            if (entity.getProperty("SequenceUnsolicitedWithSolicitedSends", null) != null) {
                engineDescriptor.setSequenceUnsolicitedWithSolicitedSends(Boolean.valueOf(entity.getProperty("SequenceUnsolicitedWithSolicitedSends", null)));
            }
            if (entity.getProperty("DispatchSendStabilityEvents", null) != null) {
                engineDescriptor.setDispatchSendStabilityEvents(Boolean.valueOf(entity.getProperty("DispatchSendStabilityEvents", null)));
            }
            if (entity.getProperty("DisposeOnSend", null) != null) {
                engineDescriptor.setDisposeOnSend(Boolean.valueOf(entity.getProperty("DisposeOnSend", null)));
            }
            if (entity.getProperty("ClusterHeartbeatInterval", null) != null) {
                engineDescriptor.setClusterHeartbeatInterval(Integer.valueOf(entity.getProperty("ClusterHeartbeatInterval", null)));
            }
            if (entity.getProperty("Administrative", null) != null) {
                engineDescriptor.setAdministrative(Boolean.valueOf(entity.getProperty("Administrative", null)));
            }
            if (entity.getProperty("StuckAlertEventThreshold", null) != null) {
                engineDescriptor.setStuckAlertEventThreshold(Integer.valueOf(entity.getProperty("StuckAlertEventThreshold", null)));
            }
            if (entity.getProperty("PerformDuplicateChecking", null) != null) {
                engineDescriptor.setPerformDuplicateChecking(Boolean.valueOf(entity.getProperty("PerformDuplicateChecking", null)));
            }
            if (entity.getProperty("PerformMidstreamInitializationValidation", null) != null) {
                engineDescriptor.setPerformMidstreamInitializationValidation(Boolean.valueOf(entity.getProperty("PerformMidstreamInitializationValidation", null)));
            }
            if (entity.getProperty("EnableSequenceNumberTrace", null) != null) {
                engineDescriptor.setEnableSequenceNumberTrace(Boolean.valueOf(entity.getProperty("EnableSequenceNumberTrace", null)));
            }
            if (entity.getProperty("EnableEventTrace", null) != null) {
                engineDescriptor.setEnableEventTrace(Boolean.valueOf(entity.getProperty("EnableEventTrace", null)));
            }
            if (entity.getProperty("EnableTransactionTrace", null) != null) {
                engineDescriptor.setEnableTransactionTrace(Boolean.valueOf(entity.getProperty("EnableTransactionTrace", null)));
            }
            if (entity.getProperty("EnableScheduleTrace", null) != null) {
                engineDescriptor.setEnableScheduleTrace(Boolean.valueOf(entity.getProperty("EnableScheduleTrace", null)));
            }
            if (entity.getProperty("EnableAlertTrace", null) != null) {
                engineDescriptor.setEnableAlertTrace(Boolean.valueOf(entity.getProperty("EnableAlertTrace", null)));
            }
            if (entity.getProperty("EnableMessageTrace", null) != null) {
                engineDescriptor.setEnableMessageTrace(Boolean.valueOf(entity.getProperty("EnableMessageTrace", null)));
            }
            if (entity.getProperty("MessageTraceInJson", null) != null) {
                engineDescriptor.setMessageTraceInJson(Boolean.valueOf(entity.getProperty("MessageTraceInJson", null)));
            }
            if (entity.getProperty("MessageTraceJsonStyle", null) != null) {
                engineDescriptor.setMessageTraceJsonStyle(RogLogUtil.JsonPrettyPrintStyle.valueOf((String)entity.getProperty("MessageTraceJsonStyle", null)));
            }
            if (entity.getProperty("MessageTraceMetadataDisplayPolicy", null) != null) {
                engineDescriptor.setMessageTraceMetadataDisplayPolicy(RogLogUtil.MetadataDisplayPolicy.valueOf((String)entity.getProperty("MessageTraceMetadataDisplayPolicy", null)));
            }
            if (entity.getProperty("MessageTraceFilterUnsetFields", null) != null) {
                engineDescriptor.setMessageTraceFilterUnsetFields(Boolean.valueOf(entity.getProperty("MessageTraceFilterUnsetFields", null)));
            }
            if (entity.getProperty("MaxEnvironmentProviders", null) != null) {
                engineDescriptor.setMaxEnvironmentProviders(Integer.valueOf(entity.getProperty("MaxEnvironmentProviders", null)));
            }
            if (entity.getProperty("EnableSendCommitCompleteSequenceAlerts", null) != null) {
                engineDescriptor.setEnableSendCommitCompleteSequenceAlerts(Boolean.valueOf(entity.getProperty("EnableSendCommitCompleteSequenceAlerts", null)));
            }
            if (entity.getProperty("CaptureMessageTypeStats", null) != null) {
                engineDescriptor.setCaptureMessageTypeStats(Boolean.valueOf(entity.getProperty("CaptureMessageTypeStats", null)));
            }
            if (entity.getProperty("MessageTypeStatsLatenciesToCapture", null) != null) {
                engineDescriptor.setMessageTypeStatsLatenciesToCapture(entity.getProperty("MessageTypeStatsLatenciesToCapture", null));
            }
            if (entity.getProperty("CaptureTransactionLatencyStats", null) != null) {
                engineDescriptor.setCaptureTransactionLatencyStats(Boolean.valueOf(entity.getProperty("CaptureTransactionLatencyStats", null)));
            }
            if (entity.getProperty("CapturePerTransactionStats", null) != null) {
                engineDescriptor.setCapturePerTransactionStats(Boolean.valueOf(entity.getProperty("CapturePerTransactionStats", null)));
            }
            if (entity.getProperty("CaptureEventLatencyStats", null) != null) {
                engineDescriptor.setCaptureEventLatencyStats(Boolean.valueOf(entity.getProperty("CaptureEventLatencyStats", null)));
            }
            if (entity.getProperty("ReplicateInParallel", null) != null) {
                engineDescriptor.setReplicateInParallel(Boolean.valueOf(entity.getProperty("ReplicateInParallel", null)));
            }
            if (entity.getProperty("PreserveChannelJoinsOnStop", null) != null) {
                engineDescriptor.setPreserveChannelJoinsOnStop(Boolean.valueOf(entity.getProperty("PreserveChannelJoinsOnStop", null)));
            }
            if (entity.getProperty("SetSupportMetadata", null) != null) {
                engineDescriptor.setSetSupportMetadata(Boolean.valueOf(entity.getProperty("SetSupportMetadata", null)));
            }
            if (entity.getProperty("SetOutboundSequenceNumbers", null) != null) {
                engineDescriptor.setSetOutboundSequenceNumbers(Boolean.valueOf(entity.getProperty("SetOutboundSequenceNumbers", null)));
            }
            engineDescriptor.setInboundEventAcknowledgementPolicy(AepEngine.InboundEventAcknowledgementPolicy.valueOf(entity.getProperty("InboundEventAcknowledgementPolicy", AepEngine.InboundEventAcknowledgementPolicy.Default.name())));
            if (entity.getProperty("SyncInjectedMessages", null) != null) {
                engineDescriptor.setSyncInjectedMessages(Boolean.valueOf(entity.getProperty("SyncInjectedMessages", null)));
            }
            if (entity.getProperty("EnableTypeBasedRouting", null) != null) {
                engineDescriptor.setEnableTypeBasedRouting(Boolean.valueOf(entity.getProperty("EnableTypeBasedRouting", null)));
            }
            if (entity.getProperty("StopOnJVMShutdown", null) != null) {
                engineDescriptor.setStopOnJVMShutdown(Boolean.valueOf(entity.getProperty("StopOnJVMShutdown", null)));
            }
            return engineDescriptor;
        }
        throw new EAepException("AEP engine '" + name + "' not found in repository");
    }

    public static AepEngineDescriptor load(String name) throws EAepException {
        return AepEngineDescriptor.load(Config.getRepository(), name);
    }

    public static Set<AepEngineDescriptor> loadAll(IConfigRepository repo) throws EAepException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<AepEngineDescriptor> engines = new LinkedHashSet<AepEngineDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/aep/engines");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    engines.add(AepEngineDescriptor.load(repo, entity.getName()));
                }
                catch (EAepException e) {
                    throw new EAepException("Failure in loading descriptor for AEP engine '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return engines;
    }

    public static Set<AepEngineDescriptor> loadAll() throws EAepException {
        return AepEngineDescriptor.loadAll(Config.getRepository());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nEngine '" + this.getName() + "' Configuration {").append("\n");
        sb.append("...state_factories=").append(this.getStateFactories().toString()).append("\n");
        sb.append("...message_factories=").append(this.getMessageFactories().toString()).append("\n");
        sb.append("...channels").append("\n");
        for (String busName : this.getBuses()) {
            Iterator<Map.Entry<String, ChannelConfig>> channelConfigIterator = this.getChannels(busName).entrySet().iterator();
            Object busDescriptor = null;
            try {
                busDescriptor = MessageBusDescriptor.load((String)busName, (String)this.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (channelConfigIterator.hasNext()) {
                Map.Entry<String, ChannelConfig> channelEntry = channelConfigIterator.next();
                sb.append("......").append(channelEntry.getKey()).append("@").append(busName).append("\n");
                if (busDescriptor != null) {
                    MessageChannelDescriptor channelDescriptor = busDescriptor.getChannel(channelEntry.getKey());
                    if (channelDescriptor != null) {
                        channelDescriptor.toString();
                        sb.append(".........Id     : ").append(channelDescriptor.getChannelId()).append("\n");
                        sb.append(".........Key    : ").append(channelDescriptor.getChannelKey()).append("\n");
                        sb.append(".........Qos    : ").append(channelDescriptor.getChannelQos()).append("\n");
                        sb.append(".........Join   : ").append(channelEntry.getValue().getJoin()).append("\n");
                        sb.append(".........Filter : ").append(channelEntry.getValue().getFilter() != null ? channelEntry.getValue().getFilter() : channelDescriptor.getChannelFilter()).append("\n");
                        sb.append(".........PreserveJoin : ").append(channelEntry.getValue().getPreserveJoinsOnClose() != MessageChannel.PreserveJoinPolicy.Default ? channelEntry.getValue().getPreserveJoinsOnClose() : channelDescriptor.getPreserveJoinsOnClose()).append("\n");
                        continue;
                    }
                    sb.append(".........channel configuration not available.\n.");
                    continue;
                }
                sb.append(".........bus configuration not available.\n.");
            }
        }
        sb.append("...bus_connection_properties={").append("\n");
        for (String busName : this.getBusConnectionsWithConfiguration()) {
            sb.append("......" + busName + " {").append("\n");
            Iterator<Object> properties = this.getBusConnectionProperties(busName);
            if (properties != null) {
                for (String name : ((Properties)((Object)properties)).stringPropertyNames()) {
                    sb.append(".........").append(name).append("=").append(((Properties)((Object)properties)).getProperty(name)).append("\n");
                }
            }
            sb.append("......}").append("\n");
        }
        sb.append("...}").append("\n");
        sb.append("...adaptive_commit_batch_ceiling=" + this.getAdaptiveCommitBatchCeiling()).append("\n");
        sb.append("...administrative=" + this.getAdministrative()).append("\n");
        sb.append("...app_exception_handling_policy='" + (Object)((Object)this.getAppExceptionHandlingPolicy())).append("'\n");
        sb.append("...capture_message_type_stats=" + this.getCaptureMessageTypeStats()).append("\n");
        sb.append("...capture_transaction_latency_stats=" + this.getCaptureTransactionLatencyStats()).append("\n");
        sb.append("...capture_per_transaction_stats=" + this.getCapturePerTransactionStats()).append("\n");
        sb.append("...capture_event_latency_stats=" + this.getCaptureEventLatencyStats()).append("\n");
        sb.append("...cluster_heartbeat_interval=" + this.getClusterHeartbeatInterval()).append("\n");
        sb.append("...multiple_flows=" + this.getEnableMultipleFlows()).append("\n");
        sb.append("...replay_on_rollback=" + this.getEnableReplayOnRollback()).append("\n");
        sb.append("...dispatch_transaction_stage_events=" + this.getDispatchTransactionStageEvents()).append("\n");
        sb.append("...dispatch_send_stability_events=" + this.getDispatchSendStabilityEvents()).append("\n");
        if (this.getDisplayName() != null) {
            sb.append("...display_name=" + this.getDisplayName()).append("\n");
        }
        sb.append("...dispose_on_send=" + this.getDisposeOnSend()).append("\n");
        sb.append("...duplicate_checking=" + this.getPerformDuplicateChecking()).append("\n");
        sb.append("...enable_alert_trace=" + this.getEnableAlertTrace()).append("\n");
        sb.append("...enable_event_trace=" + this.getEnableEventTrace()).append("\n");
        sb.append("...enable_schedule_trace=" + this.getEnableScheduleTrace()).append("\n");
        sb.append("...enable_message_trace=" + this.getEnableMessageTrace()).append("\n");
        sb.append("...enable_transaction_commit_suspension=" + this.getEnableTransactionCommitSuspension()).append("\n");
        sb.append("...enable_send_commit_complete_sequence_alerts=" + this.getEnableSendCommitCompleteSequenceAlerts()).append("\n");
        sb.append("...event_multiplexer_type='" + (Object)((Object)this.getEventMultiplexerType())).append("'\n");
        sb.append("...event_multiplexer_properties={").append("\n");
        Properties properties = this.getEventMultiplexerProperties();
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        sb.append("...ha_policy='" + (Object)((Object)this.getHAPolicy())).append("'\n");
        sb.append("...inbound_event_acknowledgement_policy=" + (Object)((Object)this.getInboundEventAcknowledgementPolicy())).append("\n");
        sb.append("...inbound_message_logging_policy='" + (Object)((Object)this.getInboundMessageLoggingPolicy())).append("'\n");
        sb.append("...inbound_message_logging_failure_policy='" + (Object)((Object)this.getInboundMessageLoggingFailurePolicy())).append("'\n");
        sb.append("...inbound_message_logging_properties={").append("\n");
        if (this.getInboundMessageLoggingPolicy() == AepEngine.InboundMessageLoggingPolicy.UseDedicated && (properties = this.getInboundMessageLoggingProperties()) != null) {
            for (String name : properties.stringPropertyNames()) {
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        sb.append("...max_environment_providers=" + this.getMaxEnvironmentProviders()).append("\n");
        sb.append("...message_bus_binding_fail_policy='" + (Object)((Object)this.getMessageBusBindingFailPolicy())).append("'\n");
        sb.append("...message_send_exception_handling_policy='" + (Object)((Object)this.getMessageSendExceptionHandlingPolicy())).append("'\n");
        sb.append("...message_send_stability_failure_handling_policy='" + (Object)((Object)this.getMessageSendStabilityFailureHandlingPolicy())).append("'\n");
        sb.append("...messaging_start_fail_policy='" + (Object)((Object)this.getMessagingStartFailPolicy())).append("'\n");
        sb.append("...message_type_stats_latencies_to_capture='" + this.getMessageTypeStatsLatenciesToCapture()).append("'\n");
        sb.append("...midstream_init_validation=" + this.getPerformMidstreamInitializationValidation()).append("\n");
        sb.append("...outbound_message_logging_policy='" + (Object)((Object)this.getOutboundMessageLoggingPolicy())).append("'\n");
        sb.append("...outbound_message_logging_failure_policy='" + (Object)((Object)this.getOutboundMessageLoggingFailurePolicy())).append("'\n");
        sb.append("...outbound_message_logging_properties={").append("\n");
        if (this.getOutboundMessageLoggingPolicy() == AepEngine.OutboundMessageLoggingPolicy.UseDedicated && (properties = this.getOutboundMessageLoggingProperties()) != null) {
            for (String name : properties.stringPropertyNames()) {
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        sb.append("...per_transaction_stats_logging_policy='" + (Object)((Object)this.getPerTransactionStatsLoggingPolicy())).append("'\n");
        sb.append("...per_transaction_stats_logging_failure_policy='" + (Object)((Object)this.getPerTransactionStatsLoggingFailurePolicy())).append("'\n");
        sb.append("...per_transaction_stats_logging_properties={").append("\n");
        if (this.getPerTransactionStatsLoggingPolicy() == AepEngine.PerTransactionStatsLoggingPolicy.UseDedicated && (properties = this.getPerTransactionStatsLoggingProperties()) != null) {
            for (String name : properties.stringPropertyNames()) {
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        sb.append("...preserve_channel_joins_on_stop=" + this.getPreserveChannelJoinsOnStop()).append("\n");
        sb.append("...replicate_in_parallel=" + this.getReplicateInParallel()).append("\n");
        sb.append("...replicate_solicited_sends=" + this.getReplicateSolicitedSends()).append("\n");
        sb.append("...replicate_unsolicited_sends=" + this.getReplicateUnsolicitedSends()).append("\n");
        sb.append("...replication_policy='" + (Object)((Object)this.getReplicationPolicy())).append("'\n");
        sb.append("...sequence_unsolicited_sends=" + this.getSequenceUnsolicitedSends()).append("\n");
        sb.append("...sequence_unsolicited_with_solicited_sends=" + this.getSequenceUnsolicitedWithSolicitedSends()).append("\n");
        sb.append("...set_inbound_msgs_as_readonly=" + this.getSetInboundMessagesAsReadOnly()).append("\n");
        sb.append("...set_outbound_msgs_as_readonly=" + this.getSetOutboundMessagesAsReadOnly()).append("\n");
        sb.append("...set_outbound_sequence_numbers=" + this.getSetOutboundSequenceNumbers()).append("\n");
        sb.append("...set_support_metadata=" + this.getSetSupportMetadata()).append("\n");
        sb.append("...startup_expectations={").append("\n");
        Map<AepEngine.StartupExpectation, Enum<?>> expectations = this.getStartupExpectations();
        if (expectations != null) {
            for (AepEngine.StartupExpectation expectation : expectations.keySet()) {
                sb.append("......").append(expectation.name()).append("=").append(expectations.get((Object)expectation)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        sb.append("...stuck_event_alert_threshold=" + this.getStuckAlertEventThreshold()).append("\n");
        sb.append("...sync_injected_messages=" + this.getSyncInjectedMessages()).append("\n");
        sb.append("...enable_type_based_routing=" + this.getEnableTypeBasedRouting()).append("\n");
        sb.append("...stop_on_jvm_shutdown=" + this.getStopOnJVMShutdown()).append("\n");
        sb.append("...store='" + this.getStore()).append("'\n");
        sb.append("}").append("\n");
        if (this.getStore() != null) {
            try {
                sb.append(StoreDescriptor.load((String)this.getStore()).toString());
            }
            catch (Exception e) {
                sb.append("...<failed to get store configuration [" + e.toString() + "]>");
            }
        }
        return sb.toString();
    }

    public static final class ChannelConfig {
        private boolean shouldJoin;
        private String filter;
        private MessageChannel.PreserveJoinPolicy preserveJoinsOnClose;

        final String serialize() {
            StringBuilder builder = new StringBuilder();
            builder.append("");
            builder.append("join=").append(this.getShouldJoin());
            if (this.filter != null) {
                builder.append("&filter=" + this.filter);
            }
            if (this.preserveJoinsOnClose != null) {
                builder.append("&preserveJoinsOnClose=" + this.preserveJoinsOnClose);
            }
            return builder.toString();
        }

        public final boolean getShouldJoin() {
            return this.shouldJoin;
        }

        public final void setShouldJoin(boolean shouldJoin) {
            this.shouldJoin = shouldJoin;
        }

        public final boolean getJoin() {
            return this.shouldJoin;
        }

        public final void setJoin(boolean shouldJoin) {
            this.shouldJoin = shouldJoin;
        }

        public final String getFilter() {
            return this.filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final MessageChannel.PreserveJoinPolicy getPreserveJoinsOnClose() {
            return this.preserveJoinsOnClose == null ? MessageChannel.PreserveJoinPolicy.Default : this.preserveJoinsOnClose;
        }

        public final void setPreserveJoinsOnClose(MessageChannel.PreserveJoinPolicy preserveJoinsOnClose) {
            this.preserveJoinsOnClose = preserveJoinsOnClose == null || preserveJoinsOnClose == MessageChannel.PreserveJoinPolicy.Default ? null : preserveJoinsOnClose;
        }

        public static final ChannelConfig from(String str) {
            ChannelConfig channelConfig = new ChannelConfig();
            if (str != null) {
                StringTokenizer tokenizer = new StringTokenizer(str, "&", false);
                while (tokenizer.hasMoreTokens()) {
                    String propVal = tokenizer.nextToken();
                    StringTokenizer propValTokenizer = new StringTokenizer(propVal, "=", false);
                    if (propValTokenizer.countTokens() == 2) {
                        String prop = propValTokenizer.nextToken();
                        String val = propValTokenizer.nextToken();
                        if (prop.equals("join")) {
                            channelConfig.shouldJoin = Boolean.valueOf(val);
                            continue;
                        }
                        if (prop.equals("filter")) {
                            channelConfig.filter = val;
                            if (channelConfig.filter.trim().length() != 0) continue;
                            channelConfig.filter = null;
                            continue;
                        }
                        if (propVal.startsWith("preserveJoinsOnClose=")) {
                            channelConfig.setPreserveJoinsOnClose(MessageChannel.PreserveJoinPolicy.valueOf((String)propVal.substring("preserveJoinsOnClose=".length())));
                            continue;
                        }
                        throw new IllegalArgumentException(str);
                    }
                    if (propVal.startsWith("filter=")) {
                        channelConfig.filter = propVal.substring(7);
                        if (channelConfig.filter.trim().length() != 0) continue;
                        channelConfig.filter = null;
                        continue;
                    }
                    throw new IllegalArgumentException(str);
                }
            }
            return channelConfig;
        }

        public String toString() {
            return this.serialize();
        }
    }
}

