/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.ods;

import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.perf.ods.Common;
import com.neeve.perf.serialization.MessageFactory;
import com.neeve.rog.IRogMessage;
import com.neeve.stats.StatsLatencyWriter;
import com.neeve.util.UtlThread;
import jargs.gnu.CmdLineParser;
import java.util.Properties;

public final class ESMember
extends Common {
    ESMember(Properties persisterProps) throws Exception {
        super(true, persisterProps, false, null, 1);
    }

    private final void registerFactories() throws Exception {
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)new com.neeve.perf.serialization.rumi.protobuf.MessageFactory());
    }

    private final IRogMessage[] createMessages(int count) {
        MessageFactory messageFactory = new MessageFactory("rumi.protobuf");
        IRogMessage[] messages = new IRogMessage[count];
        for (int i = 0; i < count; ++i) {
            messages[i] = (IRogMessage)messageFactory.createCar(true);
        }
        return messages;
    }

    private final void run(int count, int warmupTime, int rate, int numPerCommit, long nanoTimeOverhead, boolean noLatencyWrites, boolean printIntervalStats) throws Exception {
        IRogMessage[] messages = this.createMessages(numPerCommit);
        IStoreCommitCompletionEvent completionEvent = this._store.createCommitCompletionEvent();
        StatsLatencyWriter lw = new StatsLatencyWriter("commit", noLatencyWrites ? null : "latencies.commit.bin", printIntervalStats);
        System.out.println("Running...");
        int i = 1;
        long start = System.nanoTime();
        long nanosPerCommit = rate > 0 ? 1000000000L / (long)rate : 0L;
        long next = start + nanosPerCommit;
        boolean warmupCompleted = false;
        int postWarmupCount = 0;
        long postWarmupStart = 0L;
        lw.start(rate, count);
        while (i < count) {
            long current = System.nanoTime();
            if (current >= next) {
                long t0 = System.nanoTime();
                this._store.commit((long)i, (long)(i - 1), (IStoreObject[])messages, numPerCommit, completionEvent, 0).waitForCompletion();
                int commitTime = (int)(System.nanoTime() - t0 - nanoTimeOverhead);
                lw.write(commitTime);
                next += nanosPerCommit;
                ++i;
                if (warmupCompleted) {
                    ++postWarmupCount;
                }
            }
            if (warmupCompleted || current - start <= (long)warmupTime * 1000000000L) continue;
            System.out.println("Warm up complete.");
            postWarmupStart = current;
            warmupCompleted = true;
        }
        long stop = System.nanoTime();
        lw.close();
        int overallRate = (int)((long)postWarmupCount * 1000000000L / (stop - postWarmupStart));
        System.out.println("Committed " + this._dfmt.format(postWarmupCount) + " transactions (" + this._dfmt.format(postWarmupCount * numPerCommit) + " messages) @ " + this._dfmt.format(overallRate) + " commits/sec (" + this._dfmt.format(overallRate * numPerCommit) + " msgs/sec) post warmup.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(int count, int warmupTime, int rate, int numPerCommit, boolean noLatencyWrites, boolean printIntervalStats) throws Exception {
        try {
            long nanoTimeOverhead = 0L;
            long start = System.nanoTime();
            System.out.println("Calculating nanoTime() overhead...");
            for (int i = 0; i < 100000000; ++i) {
                System.nanoTime();
            }
            nanoTimeOverhead = (System.nanoTime() - start) / 100000000L;
            System.out.println("Registering factories...");
            this.registerFactories();
            this.run(count, warmupTime, rate, numPerCommit, nanoTimeOverhead, noLatencyWrites, printIntervalStats);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._store.close(0);
        }
    }

    private static void printUsage() {
        System.err.println("Usage ESMember");
        System.err.println("--------------------------------------------General Parameters------------------------------------------------------");
        System.err.println(" [{-c, --count} number of commits to perform]");
        System.err.println("   Number of commits to perform (default=10,000,000)");
        System.err.println(" [{-t, --warmupTime} Warmup time]");
        System.err.println("   Warmup time, in seconds, for calculation of throughput stats (default=2 (2 seconds))");
        System.err.println(" [{-r, --rate} commit rate]");
        System.err.println("   Rate at which to perform commits (default=-1 (unlimited))");
        System.err.println(" [{-n, --numPerCommit} number of messages per commit]");
        System.err.println("   Number of messages per commit (default=1)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-a, --noLatencyWrites} don't write latencies to a file");
        System.err.println("   Indicates that latencies should not be written to a file (default=false)");
        System.err.println(" [{-b, --printIntervalStats} print interval latency stats");
        System.err.println("   Indicates that latencies stats should be printed on a periodic basis in addition to at the end (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-j, --affinity} CPU affinity of the write/read thread");
        System.err.println("   Sets the CPU affinity of the thread performing the store operations (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-h, --help} print this help string]");
        System.err.println("");
        System.err.println("--------------------------------------------Persister Parameters----------------------------------------------------");
        System.err.println(" [{-o, --logMode} the transaction log open mode]");
        System.err.println("   Specifies the mode to open the transaction log in, Valid values are 'rw', 'rws' and 'rwd' (default='rw')");
        System.err.println(" [{-i, --initialLogLength} the preallocated length of the transaction log]");
        System.err.println("   Specifies the preallocated length (in gigabytes) of the transaction log (default=1)");
        System.err.println(" [{-z, --zeroOutInitial} zeroes out the preallocated length. only applies if --initialLength is specified and > 0]");
        System.err.println("   Specifies whether to zero out the preallocated length of the transaction log (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-m, --flushUsingMappedMemory} whether to flush using a memory mapped region of the log");
        System.err.println("   Specifies whether to use a memory mapped region of the log to perform flush operations (default=false)");
        System.err.println(" [{-a, --writeBufferSize} specifies the log write buffer size]");
        System.err.println("   Specifies, in bytes, the log's write buffer size (default=8192)");
        System.err.println(" [{-f, --flushOnCommit} whether to flush the transaction log on every commit]");
        System.err.println("   Specifies whether the in memory cached entries of the log are forcibly flushed on every commit (default=false)");
        System.err.println("   <Note: A flush does not imply sync>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-d, --detached} detached]");
        System.err.println("   Switches detached writes (concurrent write in a separate thread) on or off (default=false)");
        System.err.println(" [{-q, --queueDepth} queue depth for detached writes]");
        System.err.println("   Specifies the queue depth for detached writes (default=1024)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-l, --publisherClaimStrategy} disruptor publisher claim strategy for detached writes]");
        System.err.println("   Specifies the disruptor publisher claim strategy. Valid values are SingleThreaded | MultiThreaded | MultiThreadedSufficientCores (default=MultiThreadedSufficientCores)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-w, --writerWaitStrategy} disruptor writer wait strategy for detached writes]");
        System.err.println("   Specifies the disruptor writer claim strategy. Valid values are Sleeping | Yielding | Blocking | BusySpin (default=Yielding)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-x, --writerAffinity} disruptor writer thread affinity for detached writes]");
        System.err.println("   Specifies the disruptor writer thread affinity. (default=[0])");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-b, --readBufferSize} specifies the log read buffer size]");
        System.err.println("   Specifies, in bytes, the log's read buffer size (default=8192)");
        System.err.println(" [{-p, --pageSize} specifies the disk subsystem page size]");
        System.err.println("   Specifies (in bytes) the page size to use when reading/writing from/to disk (default=8192)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
    }

    public static final void main(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option countOption = parser.addIntegerOption('c', "count");
        CmdLineParser.Option warmupTimeOption = parser.addIntegerOption('t', "warmupTime");
        CmdLineParser.Option rateOption = parser.addIntegerOption('r', "rate");
        CmdLineParser.Option numPerCommitOption = parser.addIntegerOption('n', "numPerCommit");
        CmdLineParser.Option noLatencyWritesOption = parser.addBooleanOption('a', "noLatencyWrites");
        CmdLineParser.Option printIntervalStatsOption = parser.addBooleanOption('b', "printIntervalStats");
        CmdLineParser.Option affinityOption = parser.addStringOption('j', "affinity");
        CmdLineParser.Option logModeOption = parser.addStringOption('m', "logMode");
        CmdLineParser.Option initialLogLengthOption = parser.addIntegerOption('i', "initialLogLength");
        CmdLineParser.Option zeroOutInitialOption = parser.addBooleanOption('z', "zeroOutInitial");
        CmdLineParser.Option flushUsingMappedMemoryOption = parser.addBooleanOption('m', "flushUsingMappedMemory");
        CmdLineParser.Option writeBufferSizeOption = parser.addIntegerOption('a', "writeBufferSize");
        CmdLineParser.Option flushOnCommitOption = parser.addBooleanOption('f', "flushOnCommit");
        CmdLineParser.Option detachedOption = parser.addBooleanOption('d', "detached");
        CmdLineParser.Option queueDepthOption = parser.addIntegerOption('q', "queueDepth");
        CmdLineParser.Option publisherClaimStrategyOption = parser.addStringOption('l', "publisherClaimStrategy");
        CmdLineParser.Option writerWaitStrategyOption = parser.addStringOption('w', "writerWaitStrategy");
        CmdLineParser.Option writerAffinityOption = parser.addStringOption('x', "writerAffinity");
        CmdLineParser.Option readBufferSizeOption = parser.addIntegerOption('b', "readBufferSize");
        CmdLineParser.Option pageSizeOption = parser.addIntegerOption('p', "pageSize");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
            if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                String affinityStr = (String)parser.getOptionValue(affinityOption, null);
                if (affinityStr != null) {
                    System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
                    UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)affinityStr));
                }
                Properties persisterProps = new Properties();
                persisterProps.setProperty("logMode", (String)parser.getOptionValue(logModeOption, (Object)"rw"));
                persisterProps.setProperty("initialLogLength", String.valueOf(parser.getOptionValue(initialLogLengthOption, (Object)1)));
                persisterProps.setProperty("zeroOutInitial", (Boolean)parser.getOptionValue(zeroOutInitialOption, (Object)false) != false ? "true" : "false");
                persisterProps.setProperty("flushUsingMappedMemory", (Boolean)parser.getOptionValue(flushUsingMappedMemoryOption, (Object)false) != false ? "true" : "false");
                persisterProps.setProperty("writeBufferSize", String.valueOf(parser.getOptionValue(writeBufferSizeOption, (Object)8192)));
                persisterProps.setProperty("flushOnCommit", (Boolean)parser.getOptionValue(flushOnCommitOption, (Object)false) != false ? "true" : "false");
                persisterProps.setProperty("detachedPersist", (Boolean)parser.getOptionValue(detachedOption, (Object)false) != false ? "true" : "false");
                persisterProps.setProperty("queueDepth", String.valueOf(parser.getOptionValue(queueDepthOption, (Object)1024)));
                persisterProps.setProperty("queueOfferStrategy", (String)parser.getOptionValue(publisherClaimStrategyOption, (Object)"SingleThreaded"));
                persisterProps.setProperty("queueWaitStrategy", (String)parser.getOptionValue(writerWaitStrategyOption, (Object)"Yielding"));
                persisterProps.setProperty("queueDrainerCpuAffinityMask", (String)parser.getOptionValue(writerAffinityOption, (Object)"[0]"));
                persisterProps.setProperty("readBufferSize", String.valueOf(parser.getOptionValue(readBufferSizeOption, (Object)8192)));
                persisterProps.setProperty("pageSize", String.valueOf(parser.getOptionValue(pageSizeOption, (Object)4096)));
                System.out.println("");
                System.out.println("***** Parameters");
                System.out.println("***** ...Runner ");
                int count = (Integer)parser.getOptionValue(countOption, (Object)10000000);
                System.out.println("***** ......count=" + count);
                int warmupTime = (Integer)parser.getOptionValue(warmupTimeOption, (Object)2);
                System.out.println("***** ......warmupTime=" + warmupTime);
                int rate = (Integer)parser.getOptionValue(rateOption, (Object)-1);
                System.out.println("***** ......rate=" + rate);
                int numPerCommit = (Integer)parser.getOptionValue(numPerCommitOption, (Object)1);
                System.out.println("***** ......numPerCommit=" + numPerCommit);
                boolean noLatencyWrites = (Boolean)parser.getOptionValue(noLatencyWritesOption, (Object)false);
                System.out.println("***** ......noLatencyWrites=" + noLatencyWrites);
                boolean printIntervalStats = (Boolean)parser.getOptionValue(printIntervalStatsOption, (Object)false);
                System.out.println("***** ......printIntervalStats=" + printIntervalStats);
                System.out.println("***** ......affinity=" + affinityStr);
                System.out.println("***** ...}");
                System.out.println("***** ...Store Persister {");
                System.out.println("***** ......logMode=" + persisterProps.getProperty("logMode"));
                System.out.println("***** ......initialLogLength=" + persisterProps.getProperty("initialLogLength"));
                System.out.println("***** ......zeroOutInitial=" + persisterProps.getProperty("zeroOutInitial"));
                System.out.println("***** ......flushUsingMappedMemory=" + persisterProps.getProperty("flushUsingMappedMemory"));
                System.out.println("***** ......writeBufferSize=" + persisterProps.getProperty("writeBufferSize"));
                System.out.println("***** ......flushOnCommit=" + persisterProps.getProperty("flushOnCommit"));
                System.out.println("***** ......detached=" + persisterProps.getProperty("detachedPersist"));
                System.out.println("***** .........queueDepth=" + persisterProps.getProperty("queueDepth"));
                System.out.println("***** .........publisherClaimStrategy=" + persisterProps.getProperty("queueOfferStrategy"));
                System.out.println("***** .........writerWaitStrategy=" + persisterProps.getProperty("queueWaitStrategy"));
                System.out.println("***** .........writerAffinity=" + persisterProps.getProperty("queueDrainerCpuAffinityMask"));
                System.out.println("***** ......readBufferSize=" + persisterProps.getProperty("readBufferSize"));
                System.out.println("***** ......pageSize=" + persisterProps.getProperty("pageSize"));
                System.out.println("***** ...}");
                System.out.println("");
                new ESMember(persisterProps).run(count, warmupTime, rate, numPerCommit, noLatencyWrites, printIntervalStats);
            } else {
                ESMember.printUsage();
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            ESMember.printUsage();
        }
    }
}

