/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.quark;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.perf.serialization.rumi.quark.Acceleration;
import com.neeve.perf.serialization.rumi.quark.IPerformanceFigure;
import com.neeve.perf.serialization.rumi.quark.MessageFactory;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.quark.IQuarkChildSerializationCompletionCallback;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.rog.IRogFieldReflector;
import com.neeve.rog.impl.RogNonTransactionalField;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReflection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="quark", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 595)", date="11/16/25 4:23 AM", buildInfo="nvx-rumi-perf-models-4.0.4 (Rumi ADM Maven Plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=103)
@JsonPropertyOrder(value={"octaneRating", "acceleration"})
public final class PerformanceFigure
implements IPerformanceFigure,
MessageReflector,
IdxMappable,
UtlPool.Item<PerformanceFigure>,
AdmRuntime.BufferSizer {
    private static final RogNonTransactionalField<PerformanceFigure, Byte> _octaneRatingReflector = new RogNonTransactionalField<PerformanceFigure, Byte>("octaneRating", PerformanceFigure.class, "octaneRating", Byte.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<OctaneRatingDeserializer> _fieldDeserializer = new ThreadLocal();

        private final OctaneRatingDeserializer getFieldDeserializer() {
            OctaneRatingDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new OctaneRatingDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(PerformanceFigure node) {
            if (node.hasPojo()) {
                return node.hasOctaneRating();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                OctaneRatingDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final byte getResolvedFieldValue(PerformanceFigure node) {
            if (node.hasPojo()) {
                return node.getOctaneRating();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(PerformanceFigure node, Byte value) {
            if (value == null) {
                node.clearOctaneRating();
            } else {
                node.setOctaneRating(value);
            }
        }

        public final boolean hasValue(PerformanceFigure node) {
            return this.resolveFieldValue(node);
        }

        public final Byte getValue(PerformanceFigure node) {
            return this.resolveFieldValue(node) ? Byte.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(PerformanceFigure node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((long)this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final HashMap<String, IRogFieldReflector<PerformanceFigure, ?>> _fieldReflectors = new HashMap(1);
    private static final boolean _conserveMemory;
    private static final boolean _freeBackingStorageOnClear;
    private static final MemoryStats _memstats;
    private static final PerformanceFigurePoolFactory _performanceFigureFactory;
    private static final PerformanceFigurePojoPoolFactory _performanceFigurePojoFactory;
    private static final PerformanceFigureSerializerPoolFactory _performanceFigureSerializerFactory;
    private static final PerformanceFigureDeserializerPoolFactory _performanceFigureDeserializerFactory;
    static final UtlPool<PerformanceFigure> _entityPool;
    static final UtlPool<Pojo> _entityPojoPool;
    static final UtlPool<Serializer> _entitySerializerPool;
    static final UtlPool<Deserializer> _entityDeserializerPool;
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<PerformanceFigure> _pool;
    private long _serializedBuffer;
    private int _serializedBufferLength;
    private int _serializedBufferCapacity;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final PerformanceFigure[] EMPTY_ARRAY;

    PerformanceFigure() {
    }

    public static PerformanceFigure create() {
        PerformanceFigure entity = (PerformanceFigure)_entityPool.get(null);
        _memstats.onEntityAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final long serializedBuffer(int len) {
        long oldBuffer = this._serializedBuffer;
        int oldCapacity = this._serializedBufferCapacity;
        int newCapacity = Math.max(len, 3);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newCapacity, (boolean)false);
        if (newCapacity > oldCapacity) {
            if (oldBuffer != 0L) {
                _memstats.onEntityDataDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memstats.onEntityDataAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
            this._serializedBufferCapacity = newCapacity;
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != 0L;
    }

    @JsonIgnore
    public final long getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @JsonIgnore
    public final int getSerializedBufferCapacity() {
        return this._serializedBufferCapacity;
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferCapacity) {
            return addr;
        }
        int newLength = capacity <= this._serializedBufferCapacity ? capacity : Math.max(capacity, this._serializedBufferCapacity * 2);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newLength, (boolean)false);
        this._serializedBufferCapacity = newLength;
        return this._serializedBuffer;
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo(boolean onlyPojos) {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (onlyPojos) {
            this._pojo.setOnlyPojos();
        } else {
            this._pojo.clearOnlyPojos();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        if (onlyPojos) {
            this.conserveMemory(AdmRuntime.DataStoragePolicy.OnlyPojo);
        }
        return this._pojo;
    }

    public final Pojo pojo() {
        return this.pojo(false);
    }

    public final void disposeSerializedBuffer(boolean gcDisposed) {
        if (this.hasSerializedBuffer()) {
            IOBuffer.freeMemoryBlock((long)this._serializedBuffer, (int)this._serializedBufferCapacity);
            _memstats.onEntityDataDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, this._serializedBufferCapacity, !gcDisposed);
            this._serializedBuffer = 0L;
            this._serializedBufferLength = 0;
            this._serializedBufferCapacity = 0;
        }
    }

    public final void disposeSerializedBuffer() {
        this.disposeSerializedBuffer(false);
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory(AdmRuntime.DataStoragePolicy policy) {
        switch (policy) {
            case OnlySerialized: {
                this.sync();
                this.disposeSerializer();
                this.disposeDeserializer();
                this.disposePojo(false);
                break;
            }
            case OnlyPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) {
                    this.pojo(false);
                }
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
            case SerializedOrPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) break;
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
        }
    }

    public final void clear(boolean disposeMembers, boolean freeBackingStorage) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this._pojo.clear(freeBackingStorage);
                this.disposePojo(false);
            } else {
                this._pojo.reset(freeBackingStorage);
            }
        }
        if (freeBackingStorage || disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear(boolean disposeMembers) {
        this.clear(disposeMembers, _freeBackingStorageOnClear);
    }

    public final void clear() {
        this.clear(_conserveMemory, _freeBackingStorageOnClear);
    }

    public final void reset(boolean disposeMembers, boolean freeBackingStorage) {
        this.clear(disposeMembers, freeBackingStorage);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset(boolean disposeMembers) {
        this.reset(disposeMembers, _conserveMemory);
    }

    public final void reset() {
        this.reset(_conserveMemory, _conserveMemory);
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (this.hasDirtyPojo()) {
            this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
            this._pojo.clearDirty();
        } else if (!this.hasSerializedBuffer()) {
            this.serializedBuffer(0);
        }
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (byte[])array, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (ByteBuffer)buffer, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)buffer.getNativeAddress(), (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)addr, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final PerformanceFigure deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final PerformanceFigure deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final PerformanceFigure deserializeFrom(PerformanceFigure val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final PerformanceFigure wrap(IOBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer.getNativeAddress();
        this._serializedBufferLength = len;
        return this;
    }

    public final PerformanceFigure deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final PerformanceFigure deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(len), (int)0, (byte[])array, (int)offset, (int)len);
        }
        return this;
    }

    public final PerformanceFigure deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final PerformanceFigure deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(this._serializedBufferLength), (int)0, (ByteBuffer)buffer, (int)buffer.position(), (int)this._serializedBufferLength);
        }
        return this;
    }

    public final PerformanceFigure deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            IOBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        }
        return this;
    }

    public final PerformanceFigure deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final PerformanceFigure deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final PerformanceFigure deserializeFrom(PktPacket packet) {
        try {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            PerformanceFigure performanceFigure = this.deserializeFrom(buffer, 0, buffer.getLength());
            return performanceFigure;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final PerformanceFigure deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        IOBuffer.copy((long)addr, (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        return this;
    }

    public final PerformanceFigure deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(PerformanceFigure copy) {
        copy.clear();
        this.sync();
        if (this.hasSerializedBuffer()) {
            copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
    }

    public final PerformanceFigure copy() {
        PerformanceFigure copy = PerformanceFigure.create();
        this.copyInto(copy);
        return copy;
    }

    public boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return _fieldReflectors.containsKey(name) || UtlReflection.hasPath((Object)message, (String)name);
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (_fieldReflectors.containsKey(name)) {
            return true;
        }
        Class c = UtlReflection.getUnwrappedReturnType(message.getClass(), (String)name);
        if (c == null || c.isArray()) {
            return false;
        }
        if (c.isEnum() || c.isPrimitive()) {
            return true;
        }
        return c == Date.class || c == Currency.class || c == String.class || XString.class.isAssignableFrom(c);
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsString(message, name.split("\\."));
    }

    public final String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : String.valueOf(object);
        }
        IRogFieldReflector<PerformanceFigure, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public final XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsRawString(message, name.split("\\."));
    }

    public final XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : XString.create((String)object.toString());
        }
        IRogFieldReflector<PerformanceFigure, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return XString.create((String)val.toString());
            }
            return null;
        }
        return null;
    }

    public final boolean appendFieldValueTo(Object message, String name, XString target) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.appendFieldValueTo(message, name.split("\\."), target);
    }

    public final boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            if (object == null) {
                return false;
            }
            target.append((CharSequence)object.toString());
            return true;
        }
        IRogFieldReflector<PerformanceFigure, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            return reflector.appendValueTo((Object)this, target);
        }
        return false;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getOctaneRatingFieldId() {
        return 1;
    }

    @Override
    @JsonProperty(value="octaneRating")
    public final void setOctaneRating(byte val) {
        this.pojo().setOctaneRating(val);
    }

    @Override
    @JsonIgnore
    public final byte getOctaneRating() {
        return this.pojo().getOctaneRating();
    }

    @Override
    @JsonProperty(value="octaneRating")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Byte getOctaneRatingAsObject() {
        if (!this.hasOctaneRating()) {
            return null;
        }
        return this.getOctaneRating();
    }

    @Override
    public final boolean hasOctaneRating() {
        return this.pojo().hasOctaneRating();
    }

    @Override
    public final void clearOctaneRating() {
        this.pojo().clearOctaneRating();
    }

    public static final int getAccelerationFieldId() {
        return 2;
    }

    @Override
    @JsonProperty(value="acceleration")
    public final void setAcceleration(Acceleration[] val) {
        this.pojo().clearAcceleration();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToAcceleration(val[i]);
            }
        }
    }

    @Override
    public final void lendAcceleration(Acceleration[] val) {
        this.pojo().clearAcceleration();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToAcceleration(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setAccelerationFrom(XIterator<Acceleration> val) {
        this.pojo().clearAcceleration();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                Acceleration v = (Acceleration)val.next();
                if (v == null) continue;
                this.pojo().addToAcceleration(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendAccelerationFrom(XIterator<Acceleration> val) {
        this.pojo().clearAcceleration();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                Acceleration v = (Acceleration)val.next();
                if (v == null) continue;
                this.pojo().lendToAcceleration(v);
            }
        }
    }

    @Override
    @JsonProperty(value="acceleration")
    public final void addAcceleration(Acceleration val) {
        this.pojo().addToAcceleration(val);
    }

    @Override
    @JsonProperty(value="acceleration")
    public final void lendAcceleration(Acceleration val) {
        this.pojo().lendToAcceleration(val);
    }

    @Override
    @JsonProperty(value="acceleration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Acceleration[] getAcceleration() {
        int count = this.pojo().getAccelerationCount();
        if (count > 0) {
            Acceleration[] val = new Acceleration[count];
            XIterator<Acceleration> iterator = this.pojo().getAccelerationIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (Acceleration)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final Acceleration[] getAccelerationEmptyIfNull() {
        Acceleration[] val = this.getAcceleration();
        return val != null ? val : Acceleration.EMPTY_ARRAY;
    }

    @Override
    public final int getAccelerationCount() {
        return this.pojo().getAccelerationCount();
    }

    @Override
    public final Acceleration getAccelerationAt(int index) {
        return this.pojo().getAccelerationAt(index);
    }

    @Override
    public final XIterator<Acceleration> getAccelerationIterator() {
        return this.pojo().getAccelerationIterator();
    }

    @Override
    public final Acceleration[] takeAcceleration() {
        int count = this.pojo().getAccelerationCount();
        if (count > 0) {
            Acceleration[] val = new Acceleration[count];
            XIterator<Acceleration> iterator = this.pojo().getAccelerationIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (Acceleration)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearAcceleration() {
        this.pojo().clearAcceleration();
    }

    public static final <T> IRogFieldReflector<PerformanceFigure, T> getFieldReflector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return PerformanceFigure.getFieldReflector(name.split("\\."));
    }

    public static final <T> IRogFieldReflector<PerformanceFigure, T> getFieldReflector(String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            throw new IllegalArgumentException("fetching of reflectable field accessors for nested fields is currently not supported");
        }
        return _fieldReflectors.get(pathComponents[0]);
    }

    public final Object getQueryFieldValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IRogFieldReflector<PerformanceFigure, ?> reflector = _fieldReflectors.get(name);
        if (reflector != null) {
            return reflector.getValue((Object)this);
        }
        return null;
    }

    public final PerformanceFigure init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final PerformanceFigure setPool(UtlPool<PerformanceFigure> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<PerformanceFigure> getPool() {
        return this._pool;
    }

    public final PerformanceFigure acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose(boolean freeBackingStorage) {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            if (freeBackingStorage) {
                this.clear(true);
            }
            this._pool.put((UtlPool.Item)this);
            _memstats.onEntityDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final void dispose() {
        this.dispose(false);
    }

    public final Object clone() {
        Acceleration[] cloner_acceleration;
        PerformanceFigure clonee = PerformanceFigure.create();
        if (this.hasOctaneRating()) {
            clonee.setOctaneRating(this.getOctaneRating());
        }
        if ((cloner_acceleration = this.getAcceleration()) != null) {
            Acceleration[] clonee_acceleration = new Acceleration[cloner_acceleration.length];
            for (int i = 0; i < cloner_acceleration.length; ++i) {
                clonee_acceleration[i] = (Acceleration)cloner_acceleration[i].clone();
            }
            clonee.setAcceleration(clonee_acceleration);
        } else {
            clonee.setAcceleration(null);
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasOctaneRating()) {
            builder.append(0 == c++ ? "" : ",").append("OctaneRating=").append(this.getOctaneRating());
        }
        builder.append(0 == c++ ? "" : ",").append("Acceleration=").append(Arrays.toString(this.getAcceleration()));
        builder.append("}");
        return builder.toString();
    }

    static {
        _fieldReflectors.put("OctaneRating", (IRogFieldReflector<PerformanceFigure, ?>)_octaneRatingReflector);
        _fieldReflectors.put("octaneRating", (IRogFieldReflector<PerformanceFigure, ?>)_octaneRatingReflector);
        _conserveMemory = Config.conserveMemory();
        _freeBackingStorageOnClear = Config.getValue((String)("nv.tuning.memory." + PerformanceFigure.class.getName() + ".freeBackingStorageOnClear"), (boolean)Config.getValue((String)"nv.tuning.memory.freeBackingStorageOnClear", (boolean)_conserveMemory));
        _memstats = MemoryStats.getInstance();
        _performanceFigureFactory = new PerformanceFigurePoolFactory();
        _performanceFigurePojoFactory = new PerformanceFigurePojoPoolFactory();
        _performanceFigureSerializerFactory = new PerformanceFigureSerializerPoolFactory();
        _performanceFigureDeserializerFactory = new PerformanceFigureDeserializerPoolFactory();
        _entityPool = UtlPool.create((String)"quark.entity", (String)"PerformanceFigureQuarkEntity.1.103", (UtlPool.Factory)_performanceFigureFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(PerformanceFigure.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigurePoolEvictedItemReceiver());
        _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"PerformanceFigureQuarkEntityPojo.1.103", (UtlPool.Factory)_performanceFigurePojoFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigurePojoPoolEvictedItemReceiver());
        _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"PerformanceFigureQuarkEntitySerializer.1.103", (UtlPool.Factory)_performanceFigureSerializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigureSerializerPoolEvictedItemReceiver());
        _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"PerformanceFigureQuarkEntityDeserializer.1.103", (UtlPool.Factory)_performanceFigureDeserializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigureDeserializerPoolEvictedItemReceiver());
        EMPTY_ARRAY = new PerformanceFigure[0];
    }

    private static final class OctaneRatingDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private byte _value;
        private Deserializer _deserializer;
        private byte _flags;

        private OctaneRatingDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleOctaneRating(byte val) {
            this._value = val;
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final byte FLG_ONLY_POJOS = 8;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private int _serializedLength;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private byte _usrOctaneRating;
        private final XIndexedList<Acceleration> _usrAcceleration = new XIndexedList(256);

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memstats.onEntityPojoAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasOctaneRating() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final byte getOctaneRating() {
            return this._usrOctaneRating;
        }

        public final void setOctaneRating(byte val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasOctaneRating()) {
                this._serializedLength += 3;
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrOctaneRating = val;
            this._dirty = true;
        }

        public final void clearOctaneRating() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasOctaneRating()) {
                return;
            }
            this._usrOctaneRating = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
            this._serializedLength -= 3;
        }

        public final int getAccelerationCount() {
            return this._usrAcceleration.size();
        }

        public final Acceleration getAccelerationAt(int index) {
            if (index < 0 || index >= this.getAccelerationCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (Acceleration)this._usrAcceleration.get(index);
        }

        public final XIterator<Acceleration> getAccelerationIterator() {
            return this._usrAcceleration.reusableIterator();
        }

        public final void addToAcceleration(Acceleration val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrAcceleration.add((Object)val);
            this._dirty = true;
        }

        public final void addToAccelerationFrom(Acceleration.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            Acceleration val = Acceleration.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrAcceleration.add((Object)val);
            this._dirty = true;
        }

        public final void lendToAcceleration(Acceleration val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrAcceleration.add((Object)val);
            this._dirty = true;
        }

        public final void clearAcceleration(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrAcceleration.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((Acceleration)this._usrAcceleration.get(i)).dispose(freeBackingStorage);
            }
            this._usrAcceleration.clear();
            this._dirty = true;
        }

        public final void clearAcceleration() {
            this.clearAcceleration(false);
        }

        public final void clear(boolean freeBackingStorage) {
            this._readonly = false;
            this._usrOctaneRating = 0;
            this.clearAcceleration(freeBackingStorage);
            this._fieldBitmask[0] = 0L;
            this._serializedLength = 0;
            this._dirty = true;
        }

        public final void clear() {
            this.clear(_freeBackingStorageOnClear);
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final Pojo setOnlyPojos() {
            this._flags = (byte)(this._flags | 8);
            return this;
        }

        private final boolean isOnlyPojos() {
            return (this._flags & 8) != 0;
        }

        private final Pojo clearOnlyPojos() {
            this._flags = (byte)(this._flags & 0xFFFFFFF7);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = this._serializedLength;
            XIterator<Acceleration> accelerationIterator = this.getAccelerationIterator();
            while (accelerationIterator.hasNext()) {
                Acceleration val = (Acceleration)accelerationIterator.next();
                len += val.hasDirtyPojo() ? 6 + val.pojo().getSerializedLength() : 6 + val.getSerializedBufferLength();
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasOctaneRating()) {
                serializer.octaneRating(this._usrOctaneRating);
            }
            XIterator<Acceleration> accelerationIterator = this.getAccelerationIterator();
            while (accelerationIterator.hasNext()) {
                Acceleration val = (Acceleration)accelerationIterator.next();
                if (val.hasDirtyPojo()) {
                    val.pojo().serialize(serializer.acceleration());
                    continue;
                }
                serializer.acceleration(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset(boolean freeBackingStorage) {
            this.clear(freeBackingStorage);
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo reset() {
            return this.reset(_conserveMemory);
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityPojoDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleOctaneRating(byte val) {
                Pojo.this.setOctaneRating(val);
            }

            @Override
            public final void handleAcceleration(Acceleration.Deserializer val) {
                Pojo.this.addToAccelerationFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final Acceleration.Deserializer _accelerationDeserializer = Acceleration.Deserializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private long _addr;
        private int _offset;
        private int _len;
        private boolean _stopped;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memstats.onEntityDeserializerAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(IOBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            this._stopped = false;
            block11: for (int pos = this._offset; !this._stopped && pos < lim; pos += 2 + flen) {
                switch ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3) {
                    case 1: {
                        flen = 1;
                        cb.handleOctaneRating(IOBuffer.getByte((long)addr, (int)(pos + 2)));
                        continue block11;
                    }
                    case 2: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleAcceleration(this._accelerationDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block11;
                    }
                    default: {
                        switch (IOBuffer.getShort((long)addr, (int)pos) & 3) {
                            case 0: {
                                flen = 4 + IOBuffer.getInt((long)addr, (int)(pos + 2));
                                continue block11;
                            }
                            case 1: {
                                flen = 1;
                                continue block11;
                            }
                            case 2: {
                                flen = 2;
                                continue block11;
                            }
                            case 3: {
                                flen = 4;
                                continue block11;
                            }
                            case 4: {
                                flen = 8;
                                continue block11;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3));
                    }
                }
            }
        }

        public final void stop() {
            this._stopped = true;
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityDeserializerDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static abstract class AbstractCallbackImpl
        implements Callback {
            @Override
            public void handleOctaneRating(byte val) {
            }

            @Override
            public void handleAcceleration(Acceleration.Deserializer val) {
            }
        }

        public static interface Callback {
            public void handleOctaneRating(byte var1);

            public void handleAcceleration(Acceleration.Deserializer var1);
        }
    }

    public static final class Serializer
    implements IQuarkChildSerializationCompletionCallback,
    UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private final Acceleration.Serializer _accelerationSerializer = Acceleration.Serializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private PerformanceFigure _entity;
        private IQuarkChildSerializationCompletionCallback _parent;
        private int _mark;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memstats.onEntitySerializerAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        public final Serializer init(long addr, int len, IQuarkChildSerializationCompletionCallback parent) {
            this._entity = null;
            this._parent = parent;
            this._mark = -1;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(IOBuffer buffer, int len, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), len, parent);
        }

        public final Serializer init(IOBuffer buffer, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), 0, parent);
        }

        final Serializer init(PerformanceFigure entity) {
            this.init(entity.getSerializedBuffer(), 0, null);
            this._entity = entity;
            return this;
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(IOBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer octaneRating(byte val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 3);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)9);
            this._len += 2;
            IOBuffer.putByte((long)this._addr, (int)this._len, (byte)val);
            ++this._len;
            return this;
        }

        public final Acceleration.Serializer acceleration() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            this._mark = this._len;
            this._len += 4;
            if (this.hasSizer()) {
                this._accelerationSerializer.setSizer(this);
            }
            return this._accelerationSerializer.init(this._addr, this._len, (IQuarkChildSerializationCompletionCallback)this);
        }

        public final Serializer acceleration(Acceleration.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.getSerializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer acceleration(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer acceleration(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            if (this._parent != null) {
                this._parent.childSerializeComplete(this._len);
                this._parent = null;
            }
            this._mark = -1;
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntitySerializerDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final void childSerializeComplete(int len) {
            if (this._mark < 0) {
                throw new IllegalStateException("child object serialization in not in progress");
            }
            IOBuffer.putInt((long)this._addr, (int)this._mark, (int)(len - this._len));
            this._len = len;
            this._mark = -1;
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class PerformanceFigureDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private PerformanceFigureDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memstats.onEntityDeserializerLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigureDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private PerformanceFigureDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class PerformanceFigureSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private PerformanceFigureSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memstats.onEntitySerializerLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigureSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private PerformanceFigureSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class PerformanceFigurePojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private PerformanceFigurePojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            evictedItem.clear(true);
            _memstats.onEntityPojoLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigurePojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private PerformanceFigurePojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class PerformanceFigurePoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<PerformanceFigure> {
        private PerformanceFigurePoolEvictedItemReceiver() {
        }

        public final void process(PerformanceFigure evictedItem) {
            evictedItem.clear(false, true);
            _memstats.onEntityLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigurePoolFactory
    implements UtlPool.Factory<PerformanceFigure> {
        private PerformanceFigurePoolFactory() {
        }

        public final PerformanceFigure createItem(Object object) {
            return new PerformanceFigure();
        }

        public final PerformanceFigure[] createItemArray(int size) {
            return new PerformanceFigure[size];
        }
    }

    static final class PerformanceFigurePoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        PerformanceFigurePoolFactoryItemCreateArgument() {
        }

        PerformanceFigurePoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }
}

