/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class MessageEncodingTypeDescriptor
extends SmaObject {
    private final String name;
    private final int id;
    private final String serializerClassName;
    private final String reflectorClassName;

    private MessageEncodingTypeDescriptor(String name, int id, String serializerClassName, String reflectorClassName) {
        super(null);
        this.name = name;
        this.id = id;
        this.serializerClassName = serializerClassName;
        this.reflectorClassName = reflectorClassName;
    }

    public final String getName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    public final String getSerializerClassName() {
        return this.serializerClassName;
    }

    public final String getReflectorClassName() {
        return this.reflectorClassName;
    }

    public final void save(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/encodings");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/sma/encodings");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperty("Id", String.valueOf(this.getId()));
            entity.setProperty("Name", this.getName());
            entity.setProperty("SerializerClass", this.getSerializerClassName());
            entity.setProperty("RefelectorClass", this.getReflectorClassName());
        }
        catch (EConfigException e) {
            throw new SmaException(e);
        }
    }

    public final void delete(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/encodings");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", " + this.id + ", '" + this.serializerClassName + ", '" + this.reflectorClassName + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("encoding type name cannot be null");
        }
        return repo.getSimpleEntity("/sma/encodings/" + name) != null;
    }

    public static boolean exists(String name) {
        return MessageEncodingTypeDescriptor.exists(Config.getRepository(), name);
    }

    public static MessageEncodingTypeDescriptor create(String name, int id, String serializerClassName, String reflectorClassName) {
        if (name == null) {
            throw new IllegalArgumentException("encoding name cannot be null");
        }
        return new MessageEncodingTypeDescriptor(name, id, serializerClassName, reflectorClassName);
    }

    public static MessageEncodingTypeDescriptor load(IConfigRepository repo, String name) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("encoding name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/sma/encodings/" + name);
        if (entity != null) {
            int id = UtlProps.getValue((Properties)entity.getProperties(), (String)"Id", (int)0);
            if (id <= 0) {
                throw new SmaException("Invalid encoding type configuration [Missing or invalid value for 'Id']");
            }
            String serializerClassName = entity.getProperty("SerializerClass", null);
            String reflectorClassName = entity.getProperty("ReflectorClass", null);
            return MessageEncodingTypeDescriptor.create(name, id, serializerClassName, reflectorClassName);
        }
        throw new SmaException("Encoding type '" + name + "' not found in repository");
    }

    public static MessageEncodingTypeDescriptor load(String name) throws SmaException {
        return MessageEncodingTypeDescriptor.load(Config.getRepository(), name);
    }

    public static Map<Integer, MessageEncodingTypeDescriptor> loadAll(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashMap<Integer, MessageEncodingTypeDescriptor> encodings = new LinkedHashMap<Integer, MessageEncodingTypeDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/encodings");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    MessageEncodingTypeDescriptor descriptor = MessageEncodingTypeDescriptor.load(repo, entity.getName());
                    MessageEncodingTypeDescriptor existingDescriptor = encodings.put(descriptor.getId(), descriptor);
                    if (existingDescriptor == null) continue;
                    descriptor.getTracer().log("SMA message encoding type '" + descriptor.getName() + "' uses the same id as encoding type '" + existingDescriptor.getName() + "' [id=" + descriptor.getId() + "]. Using encoding type '" + descriptor.getName() + "'...", Tracer.Level.WARNING);
                }
                catch (SmaException e) {
                    throw new SmaException("Failure in loading descriptor for encoding type '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return encodings;
    }

    public static Map<Integer, MessageEncodingTypeDescriptor> loadAll() throws SmaException {
        return MessageEncodingTypeDescriptor.loadAll(Config.getRepository());
    }
}

