/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

public abstract class UtlListElement {
    public UtlListElement head;
    public UtlListElement next;
    public UtlListElement prev;
    public int count;

    protected UtlListElement() {
        this.wipe();
    }

    public final void wipe() {
        this.prev = null;
        this.next = null;
        this.head = null;
        this.count = -1;
    }

    public final void insertBefore(UtlListElement element) {
        element.prev = this.prev;
        element.next = this;
        element.prev.next = element;
        this.prev = element;
        element.head = this.head;
        ++this.head.count;
    }

    public final void insertAfter(UtlListElement element) {
        element.next = this.next;
        element.prev = this;
        element.next.prev = element;
        this.next = element;
        element.head = this.head;
        ++this.head.count;
    }

    public final boolean isLinked() {
        return this.head != null;
    }

    public final void unlink() {
        if (this.head != null) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            --this.head.count;
            this.prev = null;
            this.next = null;
            this.head = null;
        }
    }

    public final UtlListElement next() {
        return this.next == this.head ? null : this.next;
    }

    public final UtlListElement previous() {
        return this.prev == this.head ? null : this.prev;
    }

    public final int count() {
        return this.head.count;
    }

    protected Object clone() throws CloneNotSupportedException {
        UtlListElement clonee = (UtlListElement)super.clone();
        clonee.wipe();
        return clonee;
    }
}

