/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.engine;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepMessageSender;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.config.Config;
import com.neeve.config.VMConfigurer;
import com.neeve.perf.aep.engine.Processor;
import com.neeve.perf.serialization.Driver;
import com.neeve.perf.serialization.Provider;
import com.neeve.perf.serialization.rumi.quark.Car;
import com.neeve.rog.IRogMessage;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlTailoring;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;

@AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
public final class ESProcessor
extends Processor {
    private static final Object mainThreadShutdownSynchronizer = new Object();
    private final Provider<com.neeve.perf.serialization.rumi.protobuf.Car> _protobufProvider;
    private final Provider<Car> _quarkProvider;
    private final int _count;
    private final boolean _emptyMessage;
    private static boolean _engineStopped;

    private ESProcessor() throws Exception {
        String encoding = System.getProperty("DRIVER_TEST_ENCODING");
        if (encoding.contains("quark")) {
            this._protobufProvider = null;
            this._quarkProvider = Driver.getProvider((String)System.getProperty("DRIVER_TEST_ENCODING"));
        } else {
            this._quarkProvider = null;
            this._protobufProvider = Driver.getProvider((String)System.getProperty("DRIVER_TEST_ENCODING"));
        }
        this._count = Integer.valueOf(System.getProperty("DRIVER_TEST_COUNT"));
        this._emptyMessage = Boolean.valueOf(System.getProperty("DRIVER_TEST_EMPTY_MESSAGE"));
    }

    @EventHandler
    public final void onMessage(Car inMessage) throws Exception {
        this._quarkProvider.decode((MessageView)inMessage);
        IRogMessage outMessage = (IRogMessage)this._quarkProvider.create(!this._emptyMessage);
        outMessage.setPostWireTs(inMessage.getPostWireTs());
        this._messageSender.sendMessage(1, outMessage);
    }

    @EventHandler
    public final void onMessage(com.neeve.perf.serialization.rumi.protobuf.Car inMessage) throws Exception {
        this._protobufProvider.decode((MessageView)inMessage);
        IRogMessage outMessage = (IRogMessage)this._protobufProvider.create(!this._emptyMessage);
        outMessage.setPostWireTs(inMessage.getPostWireTs());
        this._messageSender.sendMessage(1, outMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public final void onEngineStopped(AepEngineStoppedEvent event) {
        Object object = mainThreadShutdownSynchronizer;
        synchronized (object) {
            _engineStopped = true;
            mainThreadShutdownSynchronizer.notifyAll();
        }
    }

    private static void printUsage() {
        System.err.println("Usage ESProcessor");
        System.err.println("--------------------------------------------General Parameters------------------------------------------------------");
        System.err.println(" [{-l, --encoding} encoding type of messages to inject]");
        System.err.println("   The encoding type of messages to inject [quark.serial | quark.random | protobuf.serial | protobuf.random] (default=protobuf.serial)");
        System.err.println(" [{-c, --count} number of messages to inject]");
        System.err.println("   Number of messages to inject (default=10,000,000)");
        System.err.println(" [{-t, --warmupTime} Warmup time]");
        System.err.println("   Warmup time, in seconds, for calculation of throughput stats (default=2 (2 seconds))");
        System.err.println(" [{-r, --rate} commit rate]");
        System.err.println("   Rate at which to send messages (default=100,000 (unlimited))");
        System.err.println(" [{-E, --emptyMessage} do not populate the inbound and outbound messages]");
        System.err.println("   Specifies that inbound and outbound message should not be populated (false))");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-a, --noLatencyWrites} don't write latencies to a file");
        System.err.println("   Indicates that latencies should not be written to a file (default=false)");
        System.err.println(" [{-b, --printIntervalStats} print interval latency stats");
        System.err.println("   Indicates that latencies stats should be printed on a periodic basis in addition to at the end (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-O, --outputFile} the file to write the result to");
        System.err.println("   The excel file to write the results to (default=null)");
        System.err.println(" [{-C, --outputCell} the cell in the output file to write the result to");
        System.err.println("   Specifies the cell, in <ROW>-<COL> format, in the result excel file where the result should be written (default=null)");
        System.err.println(" [{-T, --outputThroughput} write throughput result instead of latencies");
        System.err.println("   Specifies that the throughput result of the test should be written instead of latencies (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-j, --injectorCPUAffinityMask} CPU affinity mask of the injecting thread");
        System.err.println("   Sets the CPU affinity mask of the injecting thread (default=null)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-s, --server} Launch in a Rumi server]");
        System.err.println("   If specified, then the processor launches an embedded Rumi server to launch and manage the service. (default=false)");
        System.err.println("");
        System.err.println("---------------------------------------Engine Multiplexer Parameters------------------------------------------------");
        System.err.println(" [{-u, --muxType} Type of the engine event multiplexer queue");
        System.err.println("   Sets the type of the engine event multiplexer queue [DedicatedThreaded | FreeThreadedSerialized] (default=DedicatedThreaded)");
        System.err.println(" [{-g, --muxQueueDepth} Depth of the engine event multiplexer queue");
        System.err.println("   Sets the depth of the engine event multiplexer queue (default=1024)");
        System.err.println(" [{-y, --muxCPUAffinityMask} CPU affinity mask of the engine event multiplexer thread");
        System.err.println("   Sets the CPU affinity mask of the engine event multiplexer thread (default=null)");
        System.err.println("");
        System.err.println("-------------------------------------------Message Bus Parameters---------------------------------------------------");
        System.err.println(" [{-u, --busDetachedSend} sends outbound messages in a separate thread]");
        System.err.println("   Switches on detached sender in the bus connection manager (concurrent write in a separate thread) on or off (default=false)");
        System.err.println(" [{-n, --busDetachedSendQueueDepth} Depth of the messaging bus detached send queue");
        System.err.println("   Sets the depth of the messaging bus detached send queue (default=1024)");
        System.err.println(" [{-o, --busDetachedSendCPUAffinityMask} CPU affinity mask of the bus detached sender thread");
        System.err.println("   Sets the CPU affinity mask of the bus detached sender thread (default=null)");
        System.err.println("");
        System.err.println("-----------------------------------------Store Persister Parameters-------------------------------------------------");
        System.err.println(" [{-e, --enablePersistence} whether to disable store persistence]");
        System.err.println("   Specifies whether persistence is disabled (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-k, --persisterLogLocation} the directory where to create the store log]");
        System.err.println("   Specifies the directory where the store log should be created (default=\".\")");
        System.err.println(" [{-i, --persisterInitialLogLength} the preallocated length of the store log]");
        System.err.println("   Specifies the preallocated length (in gigabytes) of the store log (default=20)");
        System.err.println(" [{-z, --persisterZeroOutInitial} zeroes out the store log. only applies if --initialLength is specified and > 0]");
        System.err.println("   Specifies whether to zero out the preallocated length of the store log (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-w, --persisterWriteBufferSize} specifies the store log write buffer size]");
        System.err.println("   Specifies, in bytes, the store log's write buffer size (default=8192)");
        System.err.println(" [{-m, --persisterFlushUsingMappedMemory} whether to flush using a memory mapped region of the store log");
        System.err.println("   Specifies whether to use a memory mapped region of the store log to perform flush operations (default=false)");
        System.err.println(" [{-f, --persisterFlushOnCommit} whether to flush the store log on every commit]");
        System.err.println("   Specifies whether the in memory cached entries of the log are forcibly flushed on every commit (default=false)");
        System.err.println("   <Note: A flush does not imply sync>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-d, --persisterDetached} run store persister in detached mode]");
        System.err.println("   Switches on detached writes to the store log (concurrent write in a separate thread) on or off (default=false)");
        System.err.println(" [{-q, --persisterQueueDepth} queue depth for detached writes]");
        System.err.println("   Specifies the queue depth for detached writes (default=1024)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println(" [{-x, --persisterWriterCPUAffinityMask} writer thread CPU affinity mask for detached writes]");
        System.err.println("   Specifies the writer thread CPU affinity mask for detached thread. (default=null)");
        System.err.println("   <This option only applies to detached writes>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-t, --persisterReadBufferSize} specifies the log read buffer size]");
        System.err.println("   Specifies, in bytes, the log's read buffer size (default=8192)");
        System.err.println(" [{-p, --persisterPageSize} specifies the disk subsystem page size]");
        System.err.println("   Specifies (in bytes) the page size to use when reading/writing from/to disk (default=8192)");
        System.err.println("");
        System.err.println("-----------------------------------------Store Clustering Parameters------------------------------------------------");
        System.err.println(" [{-v, --enableClustering} whether to disable store clustering]");
        System.err.println("   Specifies whether clustering is disabled (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-U, --clusteringDiscoveryLocalIfAddr} specifies the local interface to use for cluster discovery]");
        System.err.println("   Specifies the local interface to use for cluster discovery (default=0.0.0.0)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-I, --clusteringLocalIfAddr} specifies the local interface to use for cluster replication]");
        System.err.println("   Specifies the local interface to use for cluster replication (default=0.0.0.0)");
        System.err.println(" [{-P, --clusteringLocalPort} specifies the local port to use for cluster replication]");
        System.err.println("   Specifies the local port to use for cluster replication (default=0)");
        System.err.println(" [{-V, --clusteringLinkReaderCPUAffinityMask} cluster replication link reader thread CPU affinity mask]");
        System.err.println("   Specifies the cluster replication link reader thread CPU affinity mask. (default=null)");
        System.err.println(" [{-W, --clusteringLinkSpinRead} whether the cluster replication link should perform spinning reads]");
        System.err.println("   Specifies whether the network reads performed by the cluster replication link should spin instead of block. (default=false)");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-S, --clusteringDetachedSend} run store replicator in detached send mode]");
        System.err.println("   Switches on detached send for cluster replication (concurrent send in a separate thread) on or off (default=false)");
        System.err.println(" [{-Q, --clusteringDetachedSendQueueDepth} queue depth for detached cluster replication send]");
        System.err.println("   Specifies the queue depth for detached cluster replication send (default=1024)");
        System.err.println("   <This option only applies to detached cluster replication send>");
        System.err.println(" [{-A, --clusteringDetachedSenderCPUAffinityMask} writer thread CPU affinity mask for the cluster replication detached sender]");
        System.err.println("   Specifies the cluster replication detached sender thread CPU affinity mask. (default=null)");
        System.err.println("   <This option only applies to detached cluster replication send>");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
        System.err.println(" [{-D, --clusteringDetachedDispatch} run store replicator in detached dispatch mode]");
        System.err.println("   Switches on detached dispatch for cluster replication (concurrent dispatch in a separate thread) on or off (default=false)");
        System.err.println(" [{-R, --clusteringDetachedDispatchQueueDepth} queue depth for detached cluster replication dispatch]");
        System.err.println("   Specifies the queue depth for detached cluster replication dispatch (default=1024)");
        System.err.println("   <This option only applies to detached cluster replication dispatch>");
        System.err.println(" [{-B, --clusteringDetachedDispatcherCPUAffinityMask} writer thread CPU affinity mask for the cluster replication detached dispatcher]");
        System.err.println("   Specifies the cluster replication detached dispatcher thread CPU affinity mask. (default=null)");
        System.err.println("   <This option only applies to detached cluster replication dispatch>");
        System.err.println("");
        System.err.println("----------------------------------------------------Help------------------------------------------------------------");
        System.err.println(" [{-h, --help} print this help string]");
        System.err.println("--------------------------------------------------------------------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        block27: {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option encodingOption = parser.addStringOption('l', "encoding");
            CmdLineParser.Option countOption = parser.addIntegerOption('c', "count");
            CmdLineParser.Option warmupTimeOption = parser.addIntegerOption('t', "warmupTime");
            CmdLineParser.Option rateOption = parser.addIntegerOption('r', "rate");
            CmdLineParser.Option emptyMessageOption = parser.addBooleanOption('E', "emptyMessage");
            CmdLineParser.Option noLatencyWritesOption = parser.addBooleanOption('a', "noLatencyWrites");
            CmdLineParser.Option printIntervalStatsOption = parser.addBooleanOption('b', "printIntervalStats");
            CmdLineParser.Option injectorCPUAffinityMaskOption = parser.addStringOption('j', "injectorCPUAffinityMask");
            CmdLineParser.Option outputFileOption = parser.addStringOption('O', "outputFile");
            CmdLineParser.Option outputCellOption = parser.addStringOption('C', "outputCell");
            CmdLineParser.Option outputThroughputOption = parser.addBooleanOption('T', "outputThroughput");
            CmdLineParser.Option serverOption = parser.addBooleanOption('s', "server");
            CmdLineParser.Option muxTypeOption = parser.addStringOption('u', "muxType");
            CmdLineParser.Option muxQueueDepthOption = parser.addIntegerOption('g', "muxQueueDepth");
            CmdLineParser.Option muxCPUAffinityMaskOption = parser.addStringOption('y', "muxCPUAffinityMask");
            CmdLineParser.Option busDetachedSendOption = parser.addStringOption('u', "busDetachedSend");
            CmdLineParser.Option busDetachedSendQueueDepthOption = parser.addIntegerOption('n', "busDetachedSendQueueDepth");
            CmdLineParser.Option busDetachedSendCPUAffinityMaskOption = parser.addStringOption('o', "busDetachedSendCPUAffinityMask");
            CmdLineParser.Option enablePersistenceOption = parser.addBooleanOption('e', "enablePersistence");
            CmdLineParser.Option persisterLogLocationOption = parser.addStringOption('k', "persisterLogLocation");
            CmdLineParser.Option persisterInitialLogLengthOption = parser.addIntegerOption('i', "persisterInitialLogLength");
            CmdLineParser.Option persisterZeroOutInitialOption = parser.addBooleanOption('z', "persisterZeroOutInitial");
            CmdLineParser.Option persisterWriteBufferSizeOption = parser.addIntegerOption('w', "persisterWriteBufferSize");
            CmdLineParser.Option persisterFlushUsingMappedMemoryOption = parser.addBooleanOption('m', "persisterFlushUsingMappedMemory");
            CmdLineParser.Option persisterFlushOnCommitOption = parser.addBooleanOption('f', "persisterFlushOnCommit");
            CmdLineParser.Option persisterDetachedOption = parser.addStringOption('d', "persisterDetached");
            CmdLineParser.Option persisterQueueDepthOption = parser.addIntegerOption('q', "persisterQueueDepth");
            CmdLineParser.Option persisterWriterCPUAffinityMaskOption = parser.addStringOption('x', "persisterWriterCPUAffinityMask");
            CmdLineParser.Option persisterReadBufferSizeOption = parser.addIntegerOption('t', "persisterReadBufferSize");
            CmdLineParser.Option persisterPageSizeOption = parser.addIntegerOption('p', "persisterPageSize");
            CmdLineParser.Option enableClusteringOption = parser.addBooleanOption('v', "enableClustering");
            CmdLineParser.Option clusteringDiscoveryLocalIfAddrOption = parser.addStringOption('U', "clusteringDiscoveryLocalIfAddr");
            CmdLineParser.Option clusteringLocalIfAddrOption = parser.addStringOption('I', "clusteringLocalIfAddr");
            CmdLineParser.Option clusteringLocalPortOption = parser.addStringOption('P', "clusteringLocalPort");
            CmdLineParser.Option clusteringLinkReaderCPUAffinityMaskOption = parser.addStringOption('V', "clusteringLinkReaderCPUAffinityMask");
            CmdLineParser.Option clusteringLinkSpinReadOption = parser.addStringOption('W', "clusteringLinkSpinRead");
            CmdLineParser.Option clusteringDetachedSendOption = parser.addBooleanOption('S', "clusteringDetachedSend");
            CmdLineParser.Option clusteringDetachedSendQueueDepthOption = parser.addIntegerOption('Q', "clusteringDetachedSendQueueDepth");
            CmdLineParser.Option clusteringDetachedSenderCPUAffinityMaskOption = parser.addStringOption('A', "clusteringDetachedSenderCPUAffinityMask");
            CmdLineParser.Option clusteringDetachedDispatchOption = parser.addBooleanOption('S', "clusteringDetachedDispatch");
            CmdLineParser.Option clusteringDetachedDispatchQueueDepthOption = parser.addIntegerOption('Q', "clusteringDetachedDispatchQueueDepth");
            CmdLineParser.Option clusteringDetachedDispatcherCPUAffinityMaskOption = parser.addStringOption('A', "clusteringDetachedDispatcherCPUAffinityMask");
            CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
            try {
                parser.parse(args);
                if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                    boolean clusteringDetachedDispatch;
                    boolean clusteringDetachedSend;
                    String clusteringLinkSpinRead;
                    boolean enablePersistence;
                    String busDetachedSend;
                    String val;
                    System.setProperty("DRIVER_TEST_ENCODING", (String)parser.getOptionValue(encodingOption, (Object)"protobuf.serial"));
                    System.setProperty("DRIVER_TEST_COUNT", String.valueOf((Integer)parser.getOptionValue(countOption, (Object)10000000)));
                    System.setProperty("DRIVER_TEST_WARMUP_TIME", String.valueOf((Integer)parser.getOptionValue(warmupTimeOption, (Object)2)));
                    System.setProperty("DRIVER_TEST_RATE", String.valueOf((Integer)parser.getOptionValue(rateOption, (Object)100000)));
                    System.setProperty("DRIVER_TEST_EMPTY_MESSAGE", (Boolean)parser.getOptionValue(emptyMessageOption, (Object)false) != false ? "true" : "false");
                    System.setProperty("DRIVER_LW_NOWRITE", (Boolean)parser.getOptionValue(noLatencyWritesOption, (Object)false) != false ? "true" : "false");
                    System.setProperty("DRIVER_LW_PRINT_INTERVAL_STATS", (Boolean)parser.getOptionValue(printIntervalStatsOption, (Object)false) != false ? "true" : "false");
                    String injectorCPUAffinityMask = (String)parser.getOptionValue(injectorCPUAffinityMaskOption, null);
                    if (injectorCPUAffinityMask != null) {
                        System.setProperty("DRIVER_INJECTOR_CPU_AFFINITY_MASK", injectorCPUAffinityMask);
                    }
                    if ((val = (String)parser.getOptionValue(outputFileOption, null)) != null) {
                        System.setProperty("OUTPUT_FILE", val);
                    }
                    if ((val = (String)parser.getOptionValue(outputCellOption, null)) != null) {
                        System.setProperty("OUTPUT_CELL", val);
                    }
                    System.setProperty("OUTPUT_THROUGHPUT", (Boolean)parser.getOptionValue(outputThroughputOption, (Object)false) != false ? "true" : "false");
                    System.setProperty("MUX_TYPE", (String)parser.getOptionValue(muxTypeOption, (Object)"DedicatedThreaded"));
                    System.setProperty("MUX_QUEUE_DEPTH", String.valueOf((Integer)parser.getOptionValue(muxQueueDepthOption, (Object)1024)));
                    String muxCPUAffinityMask = (String)parser.getOptionValue(muxCPUAffinityMaskOption, null);
                    if (muxCPUAffinityMask != null) {
                        System.setProperty("MUX_CPU_AFFINITY_MASK", muxCPUAffinityMask);
                    }
                    if ((busDetachedSend = (String)parser.getOptionValue(busDetachedSendOption, null)) != null) {
                        System.setProperty("x.apps.processor.messaging.buses.processor.detachedSend.enabled", busDetachedSend.equalsIgnoreCase("true") ? "true" : "false");
                    }
                    System.setProperty("BUS_DETACHED_SEND_QUEUE_DEPTH", String.valueOf((Integer)parser.getOptionValue(busDetachedSendQueueDepthOption, (Object)1024)));
                    String busDetachedSendCPUAffinityMask = (String)parser.getOptionValue(busDetachedSendCPUAffinityMaskOption, null);
                    if (busDetachedSendCPUAffinityMask != null) {
                        System.setProperty("BUS_DETACHED_SEND_QUEUE_DRAINER_CPU_AFFINITY_MASK", busDetachedSendCPUAffinityMask);
                    }
                    System.setProperty("PERSISTENCE_ENABLED", (enablePersistence = ((Boolean)parser.getOptionValue(enablePersistenceOption, (Object)false)).booleanValue()) ? "true" : "false");
                    System.setProperty("PERSISTENCE_LOG_LOCATION", (String)parser.getOptionValue(persisterLogLocationOption, (Object)"."));
                    System.setProperty("PERSISTENCE_INITIAL_LOG_LENGTH", String.valueOf(parser.getOptionValue(persisterInitialLogLengthOption, (Object)20)));
                    System.setProperty("PERSISTENCE_ZERO_OUT_INITIAL", (Boolean)parser.getOptionValue(persisterZeroOutInitialOption, (Object)false) != false ? "true" : "false");
                    System.setProperty("PERSISTENCE_WRITE_BUFFER_SIZE", String.valueOf(parser.getOptionValue(persisterWriteBufferSizeOption, (Object)8192)));
                    System.setProperty("PERSISTENCE_FLUSH_USING_MAPPED_MEMORY", (Boolean)parser.getOptionValue(persisterFlushUsingMappedMemoryOption, (Object)false) != false ? "true" : "false");
                    System.setProperty("PERSISTENCE_FLUSH_ON_COMMIT", (Boolean)parser.getOptionValue(persisterFlushOnCommitOption, (Object)false) != false ? "true" : "false");
                    String persisterDetached = (String)parser.getOptionValue(persisterDetachedOption, null);
                    if (persisterDetached != null) {
                        System.setProperty("x.apps.processor.storage.persistence.detachedPersist.enabled", persisterDetached.equalsIgnoreCase("true") ? "true" : "false");
                    }
                    System.setProperty("PERSISTENCE_DETACHED_QUEUE_DEPTH", String.valueOf(parser.getOptionValue(persisterQueueDepthOption, (Object)1024)));
                    String persisterWriterCPUAffinityMask = (String)parser.getOptionValue(persisterWriterCPUAffinityMaskOption, null);
                    if (persisterWriterCPUAffinityMask != null) {
                        System.setProperty("PERSISTENCE_DETACHED_QUEUE_DRAINER_CPU_AFFINITY_MASK", persisterWriterCPUAffinityMask);
                    }
                    System.setProperty("PERSISTENCE_READ_BUFFER_SIZE", String.valueOf(parser.getOptionValue(persisterReadBufferSizeOption, (Object)8192)));
                    System.setProperty("PERSISTENCE_PAGE_SIZE", String.valueOf(parser.getOptionValue(persisterPageSizeOption, (Object)4096)));
                    boolean enableClustering = (Boolean)parser.getOptionValue(enableClusteringOption, (Object)false);
                    System.setProperty("CLUSTERING_ENABLED", enableClustering ? "true" : "false");
                    System.setProperty("CLUSTER_DISCOVERY_LOCALIFADDR", (String)parser.getOptionValue(clusteringDiscoveryLocalIfAddrOption, (Object)"0.0.0.0"));
                    System.setProperty("CLUSTER_REPLICATOR_LOCALIFADDR", (String)parser.getOptionValue(clusteringLocalIfAddrOption, (Object)"0.0.0.0"));
                    System.setProperty("CLUSTER_REPLICATOR_LOCALPORT", (String)parser.getOptionValue(clusteringLocalPortOption, (Object)"0"));
                    String clusteringLinkReaderCPUAffinityMask = (String)parser.getOptionValue(clusteringLinkReaderCPUAffinityMaskOption, null);
                    if (clusteringLinkReaderCPUAffinityMask != null) {
                        System.setProperty("CLUSTERING_LINK_READER_CPU_AFFINITY_MASK", clusteringLinkReaderCPUAffinityMask);
                    }
                    if ((clusteringLinkSpinRead = (String)parser.getOptionValue(clusteringLinkSpinReadOption, null)) != null) {
                        System.setProperty("CLUSTER_LINK_PARAMS", "spinread=" + (clusteringLinkSpinRead.equalsIgnoreCase("true") ? "true" : "false"));
                    }
                    System.setProperty("CLUSTERING_DETACHED_SEND", (clusteringDetachedSend = ((Boolean)parser.getOptionValue(clusteringDetachedSendOption, (Object)false)).booleanValue()) ? "true" : "false");
                    System.setProperty("CLUSTERING_DETACHED_SEND_QUEUE_DEPTH", String.valueOf(parser.getOptionValue(clusteringDetachedSendQueueDepthOption, (Object)1024)));
                    String clusteringDetachedSenderCPUAffinityMask = (String)parser.getOptionValue(clusteringDetachedSenderCPUAffinityMaskOption, null);
                    if (clusteringDetachedSenderCPUAffinityMask != null) {
                        System.setProperty("CLUSTERING_DETACHED_SEND_QUEUE_DRAINER_CPU_AFFINITY_MASK", clusteringDetachedSenderCPUAffinityMask);
                    }
                    System.setProperty("CLUSTERING_DETACHED_DISPATCH", (clusteringDetachedDispatch = ((Boolean)parser.getOptionValue(clusteringDetachedDispatchOption, (Object)false)).booleanValue()) ? "true" : "false");
                    System.setProperty("CLUSTERING_DETACHED_DISPATCH_QUEUE_DEPTH", String.valueOf(parser.getOptionValue(clusteringDetachedDispatchQueueDepthOption, (Object)1024)));
                    String clusteringDetachedDispatcherCPUAffinityMask = (String)parser.getOptionValue(clusteringDetachedDispatcherCPUAffinityMaskOption, null);
                    if (clusteringDetachedDispatcherCPUAffinityMask != null) {
                        System.setProperty("CLUSTERING_DETACHED_DISPATCH_QUEUE_DRAINER_CPU_AFFINITY_MASK", clusteringDetachedDispatcherCPUAffinityMask);
                    }
                    if (enablePersistence || enableClustering) {
                        System.setProperty("STORAGE_ENABLED", "true");
                    }
                    if (enableClustering) {
                        System.setProperty("DRIVER_PROMPT_TO_START", "true");
                    }
                    System.out.println("");
                    System.out.println("Parameters");
                    System.out.println("...Driver {");
                    System.out.println("......encoding=" + System.getProperty("DRIVER_TEST_ENCODING"));
                    System.out.println("......count=" + System.getProperty("DRIVER_TEST_COUNT"));
                    System.out.println("......warmupTime=" + System.getProperty("DRIVER_TEST_WARMUP_TIME"));
                    System.out.println("......rate=" + System.getProperty("DRIVER_TEST_RATE"));
                    System.out.println("......emptyMessage=" + System.getProperty("DRIVER_TEST_EMPTY_MESSAGE"));
                    System.out.println("......noLatencyWrites=" + System.getProperty("DRIVER_LW_NOWRITE"));
                    System.out.println("......printIntervalStats=" + System.getProperty("DRIVER_LW_PRINT_INTERVAL_STATS"));
                    System.out.println("......injectorCPUAffinityMask=" + System.getProperty("DRIVER_INJECTOR_CPU_AFFINITY_MASK"));
                    System.out.println("...}");
                    System.out.println("...Output {");
                    System.out.println("......file=" + System.getProperty("OUTPUT_FILE"));
                    System.out.println("......cell=" + System.getProperty("OUTPUT_CELL"));
                    System.out.println("......throughput=" + System.getProperty("OUTPUT_THROUGHPUT"));
                    System.out.println("...}");
                    System.out.println("...Containerization {");
                    boolean launchInServer = (Boolean)parser.getOptionValue(serverOption, (Object)false);
                    System.out.println("......launchInServer=" + launchInServer);
                    System.out.println("...}");
                    System.out.println("...Engine Event Mux {");
                    System.out.println("......muxType=" + System.getProperty("MUX_TYPE"));
                    System.out.println("......queueDepth=" + System.getProperty("MUX_QUEUE_DEPTH"));
                    System.out.println("......muxCPUAffinityMask=" + System.getProperty("MUX_CPU_AFFINITY_MASK"));
                    System.out.println("...}");
                    System.out.println("...Message Bus {");
                    System.out.println("......detached = " + (busDetachedSend != null ? busDetachedSend : "<system>"));
                    System.out.println(".........queueDepth=" + System.getProperty("BUS_DETACHED_SEND_QUEUE_DEPTH"));
                    System.out.println(".........senderCPUAffinityMask=" + System.getProperty("BUS_DETACHED_SEND_QUEUE_DRAINER_CPU_AFFINITY_MASK"));
                    System.out.println("...}");
                    System.out.println("...Store Persister {");
                    System.out.println("......enabled=" + enablePersistence);
                    if (enablePersistence) {
                        System.out.println("......initialLogLength=" + System.getProperty("PERSISTENCE_INITIAL_LOG_LENGTH"));
                        System.out.println("......zeroOutInitial=" + System.getProperty("PERSISTENCE_ZERO_OUT_INITIAL"));
                        System.out.println("......flushUsingMappedMemory=" + System.getProperty("PERSISTENCE_FLUSH_USING_MAPPED_MEMORY"));
                        System.out.println("......writeBufferSize=" + System.getProperty("PERSISTENCE_WRITE_BUFFER_SIZE"));
                        System.out.println("......flushOnCommit=" + System.getProperty("PERSISTENCE_FLUSH_ON_COMMIT"));
                        System.out.println("......detached = " + (persisterDetached != null ? persisterDetached : "<system>"));
                        System.out.println(".........queueDepth=" + System.getProperty("PERSISTENCE_DETACHED_QUEUE_DEPTH"));
                        System.out.println(".........writerCPUAffinityMask=" + System.getProperty("PERSISTENCE_DETACHED_QUEUE_DRAINER_CPU_AFFINITY_MASK"));
                        System.out.println("......readBufferSize=" + System.getProperty("PERSISTENCE_READ_BUFFER_SIZE"));
                        System.out.println("......pageSize=" + System.getProperty("PERSISTENCE_PAGE_SIZE"));
                    }
                    System.out.println("...}");
                    System.out.println("...Store Replicator {");
                    System.out.println("......enabled=" + enableClustering);
                    if (enableClustering) {
                        System.out.println("......discoveryLocalIfAddr=" + System.getProperty("CLUSTER_DISCOVERY_LOCALIFADDR"));
                        System.out.println("......link");
                        System.out.println(".........localIfAddr=" + System.getProperty("CLUSTER_REPLICATOR_LOCALIFADDR"));
                        System.out.println(".........localPort=" + System.getProperty("CLUSTER_REPLICATOR_LOCALPORT"));
                        System.out.println(".........readerCPUAffinityMask=" + System.getProperty("CLUSTERING_LINK_READER_CPU_AFFINITY_MASK"));
                        System.out.println(".........linkParams=" + System.getProperty("CLUSTER_LINK_PARAMS"));
                        System.out.println("......detachedSend= " + System.getProperty("CLUSTERING_DETACHED_SEND"));
                        System.out.println(".........queueDepth=" + System.getProperty("CLUSTERING_DETACHED_SEND_QUEUE_DEPTH"));
                        System.out.println(".........senderCPUAffinityMask=" + System.getProperty("CLUSTERING_DETACHED_SEND_QUEUE_DRAINER_CPU_AFFINITY_MASK"));
                        System.out.println("......detachedDispatch= " + System.getProperty("CLUSTERING_DETACHED_DISPATCH"));
                        System.out.println(".........queueDepth=" + System.getProperty("CLUSTERING_DETACHED_DISPATCH_QUEUE_DEPTH"));
                        System.out.println(".........dispatcherCPUAffinityMask=" + System.getProperty("CLUSTERING_DETACHED_DISPATCH_QUEUE_DRAINER_CPU_AFFINITY_MASK"));
                    }
                    System.out.println("...}");
                    System.out.println("");
                    if (injectorCPUAffinityMask != null || muxCPUAffinityMask != null || busDetachedSend != null && busDetachedSend.equalsIgnoreCase("true") && busDetachedSendCPUAffinityMask != null || enablePersistence && persisterDetached != null && persisterDetached.equalsIgnoreCase("true") && persisterWriterCPUAffinityMask != null || enableClustering && clusteringLinkSpinRead != null && clusteringLinkSpinRead.equalsIgnoreCase("true") && clusteringLinkReaderCPUAffinityMask != null || enableClustering && clusteringDetachedSend && clusteringDetachedSenderCPUAffinityMask != null || enableClustering && clusteringDetachedDispatch && clusteringDetachedDispatcherCPUAffinityMask != null) {
                        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
                        if (injectorCPUAffinityMask == null || muxCPUAffinityMask == null || busDetachedSend != null && busDetachedSend.equalsIgnoreCase("true") && busDetachedSendCPUAffinityMask == null || enablePersistence && persisterDetached != null && persisterDetached.equalsIgnoreCase("true") && persisterWriterCPUAffinityMask == null || enableClustering && clusteringLinkSpinRead != null && clusteringLinkSpinRead.equalsIgnoreCase("true") && clusteringLinkReaderCPUAffinityMask == null || enableClustering && clusteringDetachedSend && clusteringDetachedSenderCPUAffinityMask == null || enableClustering && clusteringDetachedDispatch && clusteringDetachedDispatcherCPUAffinityMask == null) {
                            System.out.println("");
                            System.out.println("*****************************************************************************");
                            System.out.println("                               WARNING!!!                                    ");
                            System.out.println("  At least one CPU affinity mask is set due to which CPU affinitization has  ");
                            System.out.println("  been implicitly enabled. However, one or more CPU affinity masks have not  ");
                            System.out.println("  been configured. This can result in significantly degraded performance.    ");
                            System.out.println("  Please ensure either none or CPU affinity masks for all threads that are   ");
                            System.out.println("  affinitizable have been set.                                               ");
                            System.out.println("****************************************************************************");
                            System.out.println("");
                        }
                    }
                    VMConfigurer.configure((File)new File(Paths.get(Config.getRootDirectory().toString(), "conf", "config.xml").toString()), (UtlTailoring.PropertySource)UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
                    if (launchInServer) {
                        SrvConfigDescriptor serverDescriptor = SrvConfigDescriptor.load((String)"processor-1a");
                        EmbeddedXVM server = EmbeddedXVM.create((SrvConfigDescriptor)serverDescriptor);
                        server.start();
                    } else {
                        Config.initializeEnvironment();
                        ESProcessor processor = new ESProcessor();
                        AepMessageSender sender = AepMessageSender.create();
                        AepEngineDescriptor engineDescriptor = AepEngineDescriptor.load((String)"processor");
                        engineDescriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing);
                        AepEngine engine = AepEngine.create((AepEngineDescriptor)engineDescriptor, null, new HashSet<Object>(Arrays.asList(processor)), null, new HashSet<AepMessageSender>(Arrays.asList(sender)), null);
                        processor.setMessageSender(sender);
                        processor.setEngine(engine);
                        engine.start();
                    }
                    Object object = mainThreadShutdownSynchronizer;
                    synchronized (object) {
                        while (!_engineStopped) {
                            mainThreadShutdownSynchronizer.wait();
                        }
                        break block27;
                    }
                }
                ESProcessor.printUsage();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

