/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util.collect;

import com.google.common.base.Objects;
import com.neeve.query.index.IdxRange;

public class UtlRangeBase<T extends Comparable<T>>
implements IdxRange<T> {
    private final T start;
    private final T end;
    private boolean includeStart = true;
    private boolean includeEnd = true;
    private boolean boundBelow = true;
    private boolean boundAbove = true;

    public UtlRangeBase(T start, T end) {
        if (start == null) {
            this.boundBelow = false;
            this.includeStart = false;
        }
        if (end == null) {
            this.boundAbove = false;
            this.includeEnd = false;
        }
        if (this.boundBelow && this.boundAbove && start.compareTo(end) > 0) {
            throw new IllegalArgumentException("start may not be after end");
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public T getStart() {
        return this.start;
    }

    @Override
    public T getEnd() {
        return this.end;
    }

    @Override
    public void setIncludeStart(boolean include) {
        if (include && !this.boundBelow) {
            throw new IllegalStateException("cannot close an unbound range");
        }
        this.includeStart = include;
    }

    @Override
    public boolean includeStart() {
        return this.includeStart;
    }

    @Override
    public void setIncludeEnd(boolean include) {
        if (include && !this.boundAbove) {
            throw new IllegalStateException("cannot close an unbound range");
        }
        this.includeEnd = include;
    }

    @Override
    public boolean includeEnd() {
        return this.includeEnd;
    }

    @Override
    public boolean isBoundBelow() {
        return this.boundBelow;
    }

    @Override
    public boolean isBoundAbove() {
        return this.boundAbove;
    }

    @Override
    public void makeOpen() {
        this.setIncludeStart(false);
        this.setIncludeEnd(false);
    }

    @Override
    public void makeClosed() {
        this.setIncludeStart(true);
        this.setIncludeEnd(true);
    }

    @Override
    public void makeSlice() {
        this.setIncludeStart(true);
        this.setIncludeEnd(false);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UtlRangeBase)) {
            return false;
        }
        UtlRangeBase other = (UtlRangeBase)obj;
        return Objects.equal(this.start, other.start) && Objects.equal(this.end, other.end);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    @Override
    public String toString() {
        String open = this.includeStart ? "[" : "(";
        String close = this.includeEnd ? "]" : ")";
        return open + this.start + "," + this.end + close;
    }

    private boolean isWithinStart(T value) {
        if (!this.boundBelow) {
            return true;
        }
        if (value == null) {
            return false;
        }
        int comparison = this.start.compareTo(value);
        return this.includeStart ? comparison <= 0 : comparison < 0;
    }

    private boolean isWithinEnd(T value) {
        if (!this.boundAbove) {
            return true;
        }
        if (value == null) {
            return false;
        }
        int comparison = this.end.compareTo(value);
        return this.includeEnd ? comparison >= 0 : comparison > 0;
    }

    @Override
    public boolean contains(T value) {
        return this.isWithinStart(value) && this.isWithinEnd(value);
    }

    @Override
    public boolean contains(IdxRange<T> other) {
        return this.isWithinStart(other.getStart()) && this.isWithinEnd(other.getEnd());
    }

    @Override
    public int compare(T value) {
        if (!this.isWithinStart(value)) {
            return -1;
        }
        if (!this.isWithinEnd(value)) {
            return 1;
        }
        return 0;
    }
}

