/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization;

import com.neeve.perf.serialization.Provider;
import com.neeve.perf.serialization.rumi.quark.serial.CarBenchmark;
import com.neeve.stats.Stats;
import com.neeve.tools.interactive.commands.AnnotatedCommand;

@AnnotatedCommand.Command(keywords={"SerializationDriver"}, description="A driver to benchmark serialization deserialization times")
public class Driver
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=112, longForm="provider", defaultValue="quark", description="The serialization provider to use")
    private String providerStr;

    private void perfTestEncode(Provider provider, int runNumber, Stats.LatencyManager latencyManager, int reps, long nanoTimeOverhead) {
        latencyManager.reset();
        for (int i = 0; i < reps; ++i) {
            provider.prepareToEncode();
            long encodeStart = System.nanoTime();
            provider.encode();
            long encodeTime = System.nanoTime() - encodeStart - nanoTimeOverhead;
            provider.postEncode();
            latencyManager.add((double)encodeTime);
        }
        latencyManager.compute();
        System.out.printf("%-25s %-3d %-6s %-5d %-5.0f %-5.0f%n", provider.name(), runNumber, "ENC", provider.encodedLength(), latencyManager.median(), latencyManager.mean());
    }

    private void perfTestDecode(Provider provider, int runNumber, Stats.LatencyManager latencyManager, int reps, long nanoTimeOverhead) {
        latencyManager.reset();
        for (int i = 0; i < reps; ++i) {
            provider.prepareToDecode();
            long decodeStart = System.nanoTime();
            provider.decode();
            long decodeTime = System.nanoTime() - decodeStart - nanoTimeOverhead;
            provider.postDecode();
            latencyManager.add((double)decodeTime);
        }
        latencyManager.compute();
        System.out.printf("%-25s %-3d %-6s %-5d %-5.0f %-5.0f%n", provider.name(), runNumber, "DEC", provider.decodedLength(), latencyManager.median(), latencyManager.mean());
    }

    public static final Provider<?> getProvider(String providerStr) {
        if (providerStr.equalsIgnoreCase("quark") || providerStr.equalsIgnoreCase("quark.serial") || providerStr.equalsIgnoreCase("rumi.quark") || providerStr.equalsIgnoreCase("rumi.quark.serial")) {
            return new CarBenchmark();
        }
        if (providerStr.equalsIgnoreCase("quark.random") || providerStr.equalsIgnoreCase("rumi.quark.random")) {
            return new com.neeve.perf.serialization.rumi.quark.random.CarBenchmark();
        }
        if (providerStr.equalsIgnoreCase("protobuf") || providerStr.equalsIgnoreCase("protobuf.serial") || providerStr.equalsIgnoreCase("rumi.protobuf") || providerStr.equalsIgnoreCase("rumi.protobuf.serial")) {
            return new com.neeve.perf.serialization.rumi.protobuf.serial.CarBenchmark();
        }
        if (providerStr.equalsIgnoreCase("protobuf.random") || providerStr.equalsIgnoreCase("rumi.protobuf.random")) {
            return new com.neeve.perf.serialization.rumi.protobuf.random.CarBenchmark();
        }
        throw new IllegalArgumentException("invalid serialization provider '" + providerStr + "'");
    }

    public void execute() {
        int i;
        Provider<?> provider = Driver.getProvider(this.providerStr);
        int reps = 10000000;
        Stats.LatencyManager latencyManager = new Stats.LatencyManager("encdec", 10000000);
        long nanoTimeOverhead = 0L;
        long start = System.nanoTime();
        System.out.println("Calculating nanoTime() overhead...");
        for (i = 0; i < 100000000; ++i) {
            System.nanoTime();
        }
        nanoTimeOverhead = (System.nanoTime() - start) / 100000000L;
        System.out.println("..." + nanoTimeOverhead + " nanos");
        System.out.printf("%-25s %-3s %-6s %-5s %-5s %-5s%n", "PROV", "RUN", "ENCDEC", "LEN", "MED", "AVG");
        for (i = 0; i < 10; ++i) {
            this.perfTestEncode(provider, i, latencyManager, 10000000, nanoTimeOverhead);
            this.perfTestDecode(provider, i, latencyManager, 10000000, nanoTimeOverhead);
        }
    }

    public static void main(String[] args) {
        System.getProperties().setProperty("nv.optimizefor", "latency");
        try {
            new Driver().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

