/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.daemon.er.DmnErAgent;
import com.neeve.link.LnkLTPAuthority;
import com.neeve.server.link.SrvLink;
import com.neeve.server.link.SrvLinkConfig;

final class SrvLinkClient
extends DmnErAgent {
    private final short srvLtp;
    private final short clientLtp;
    private final AppInfo appInfo;

    SrvLinkClient(String name, int addr, SrvLink link, short srvLtp, short clientLtp, AppInfo appInfo) {
        super(SrvLinkConfig.getConfig(), name, addr, link);
        this.srvLtp = srvLtp;
        this.clientLtp = clientLtp;
        this.appInfo = appInfo;
    }

    final short getSrvLtp() {
        return this.srvLtp;
    }

    final short getClientLtp() {
        return this.clientLtp;
    }

    final AppInfo getAppInfo() {
        return this.appInfo;
    }

    final void close() {
        LnkLTPAuthority.getInstance().release(this.srvLtp);
    }

    @Override
    public final String toString() {
        return "[" + super.toString() + " (ltpc=" + this.getClientLtp() + "->ltps=" + this.getSrvLtp() + ")]";
    }

    public static final class AppInfo {
        private final String name;
        private final short version;

        public AppInfo(String name, short version) {
            this.name = name;
            this.version = version;
        }

        public final String getName() {
            return this.name;
        }

        public final short getVersion() {
            return this.version;
        }

        public String toString() {
            return "[" + this.getName() + " <v" + this.getVersion() + ">]";
        }
    }
}

