/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jcsmp;

import com.neeve.lang.XString;
import com.neeve.sma.SmaException;
import com.neeve.solxf.ESolException;
import com.neeve.solxf.ISolFlowReceiver;
import com.neeve.solxf.ISolMessageConsumer;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.solxf.ISolMessageProducer;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.ISolSession;
import com.neeve.solxf.impl.jcsmp.SolJcsmpBestEffortMessageListener;
import com.neeve.solxf.impl.jcsmp.SolJcsmpFlowReceiver;
import com.neeve.solxf.impl.jcsmp.SolJcsmpGuaranteedMessageListener;
import com.neeve.solxf.impl.jcsmp.SolJcsmpMessageConsumer;
import com.neeve.solxf.impl.jcsmp.SolJcsmpMessageProducer;
import com.neeve.solxf.impl.jcsmp.SolJcsmpQueue;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPVersion;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.Enumeration;
import java.util.Properties;

public final class SolJcsmpSession
implements ISolSession {
    private final JCSMPSession _session;
    private final Context _context;
    private final Properties _solxfProperties;

    SolJcsmpSession(String host, String userName, Properties props, Properties solxfProperties) throws SmaException {
        this._solxfProperties = solxfProperties;
        this._context = JCSMPFactory.onlyInstance().createContext(null);
        try {
            this._session = JCSMPFactory.onlyInstance().createSession(JCSMPProperties.fromProperties((Properties)props), this._context);
        }
        catch (Exception e) {
            this.close();
            if (e instanceof SmaException) {
                throw (SmaException)e;
            }
            throw new SmaException((Throwable)e);
        }
    }

    final JCSMPSession getSession() {
        return this._session;
    }

    @Override
    public final void connect() throws SmaException {
        try {
            this._session.connect();
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public String getRouterName() throws SmaException {
        try {
            return (String)this._session.getCapability(CapabilityType.PEER_ROUTER_NAME);
        }
        catch (JCSMPException e) {
            throw new SmaException("Unabled to get peer router name: " + (Object)((Object)e), (Throwable)e);
        }
    }

    @Override
    public final boolean isCapable(ISolSession.CapabilityType capability) {
        try {
            switch (capability) {
                case ENDPOINT_MANAGEMENT: {
                    return (Boolean)this._session.getCapability(CapabilityType.ENDPOINT_MANAGEMENT);
                }
                case QUEUE_SUBSCRIPTIONS: {
                    return (Boolean)this._session.getCapability(CapabilityType.QUEUE_SUBSCRIPTIONS);
                }
            }
            throw new IllegalArgumentException("unknown capability '" + (Object)((Object)capability) + "'");
        }
        catch (JCSMPException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void provision(ISolQueue queue, ISolSession.EndpointProperties properties) throws SmaException {
        EndpointProperties ep = new EndpointProperties();
        ep.setPermission(Integer.valueOf(ISolSession.EndpointProperties.PERMISSION_CONSUME));
        ep.setPermission(Integer.valueOf(ISolSession.EndpointProperties.PERMISSION_DELETE));
        ep.setAccessType(Integer.valueOf(properties.getAccessType()));
        ep.setQuota(Integer.valueOf(properties.getQuota()));
        ep.setRespectsMsgTTL(Boolean.valueOf(properties.getRespectsMsgTTL()));
        try {
            this._session.provision((Endpoint)((SolJcsmpQueue)queue).getQueue(), ep, 1L);
        }
        catch (JCSMPErrorResponseException e) {
            if (e.getSubcodeEx() != 33) {
                throw new SmaException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final ISolFlowReceiver createFlow(ISolQueue queue, ISolMessageListener listener, Properties props) throws SmaException {
        return new SolJcsmpFlowReceiver(this._session, queue, new SolJcsmpGuaranteedMessageListener(this._session, listener, this._solxfProperties), props);
    }

    @Override
    public final ISolMessageProducer createMessageProducer(ISolPublishEventHandler handler) throws SmaException {
        return new SolJcsmpMessageProducer(this._session, handler, this._solxfProperties);
    }

    @Override
    public final ISolMessageConsumer createMessageConsumer(ISolMessageListener listener) throws SmaException {
        return new SolJcsmpMessageConsumer(this._session, new SolJcsmpBestEffortMessageListener(this._session, listener, this._solxfProperties));
    }

    @Override
    public final void addSubscription(XString topic) throws SmaException {
        try {
            this._session.addSubscription((Subscription)JCSMPFactory.onlyInstance().createTopic(topic.getValue()));
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void addSubscription(ISolQueue queue, XString topic) throws SmaException {
        try {
            this._session.addSubscription((Endpoint)((SolJcsmpQueue)queue).getQueue(), (Subscription)JCSMPFactory.onlyInstance().createTopic(topic.getValue()), 4);
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void removeSubscription(XString topic) throws SmaException {
        try {
            this._session.removeSubscription((Subscription)JCSMPFactory.onlyInstance().createTopic(topic.getValue()));
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void removeSubscription(ISolQueue queue, XString topic) throws SmaException {
        try {
            this._session.removeSubscription((Endpoint)((SolJcsmpQueue)queue).getQueue(), (Subscription)JCSMPFactory.onlyInstance().createTopic(topic.getValue()), 4);
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void close() {
        if (this._context != null) {
            this._context.destroy();
        }
    }

    @Override
    public final void getStats(String userName, boolean isProducer, StringBuilder builder) {
        JCSMPSessionStats stats = this._session.getSessionStats();
        Enumeration elements = StatType.elements();
        while (elements.hasMoreElements()) {
            StatType t = (StatType)elements.nextElement();
            builder.append(userName);
            builder.append("[");
            builder.append(isProducer ? "P" : "C");
            builder.append("]");
            builder.append(t.getLabel());
            builder.append("=");
            builder.append(stats.getStat(t));
            builder.append(",");
            builder.append(String.format("%s[%s]%s=%s,", userName, isProducer ? "P" : "C", t.getLabel(), stats.getStat(t)));
        }
    }

    @Override
    public final String getVersion() {
        return new JCSMPVersion().getSwVersion();
    }
}

