/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.emx.EmxNwLnkBlockingReader;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.io.IOBuffer;
import com.neeve.perf.common.SystemProperties;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;

@AnnotatedCommand.Command(keywords={"BlockingStreamingReceiver"}, description="A blocking receiver to test streaming performance using EMX links")
public class BlockingStreamingReceiver
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=109, longForm="messageSize", defaultValue="256", required=true, description="The size of the messge being streamed")
    private int _messageSize;
    @AnnotatedCommand.Option(shortForm=99, longForm="cpuAffinityMask", description="the CPU() to affinitize the reading thread to")
    private String _cpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=115, longForm="stats", defaultValue="false", required=true, description="Whether to output incremental throughput stats")
    private boolean _stats;

    public void execute() throws Exception {
        SystemProperties.dump();
        EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create((String)this._descriptor, (EmxNwLnkAcceptor.Callback)new AcceptCallback());
        EmxNwLnk link = acceptor.accept();
        new ReaderThread(link).start();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
        new BlockingStreamingReceiver().run(args);
    }

    private final class ReaderThread
    extends Thread {
        ReaderThread(EmxNwLnk link) throws Exception {
            super((Runnable)EmxNwLnkBlockingReader.create((EmxNwLnk)link, (EmxNwLnkReader.Callback)new ReadCallback()));
        }

        @Override
        public final void run() {
            if (BlockingStreamingReceiver.this._cpuAffinityMask != null) {
                System.out.println("[BlockingStreamingReceiver] Affinitizing thread to CPU " + BlockingStreamingReceiver.this._cpuAffinityMask);
                UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)BlockingStreamingReceiver.this._cpuAffinityMask));
            }
            super.run();
        }
    }

    private final class ReadCallback
    implements EmxNwLnkReader.Callback {
        private long start;
        private long deltaStart;
        private int numRcvd;
        private int deltaNumRcvd;

        private ReadCallback() {
        }

        public final int handleReadData(EmxNwLnk lnk, IOBuffer iobuf, int length) {
            int count = length / BlockingStreamingReceiver.this._messageSize;
            if (BlockingStreamingReceiver.this._stats) {
                long now = System.currentTimeMillis();
                if (this.start == 0L) {
                    this.start = this.deltaStart = now;
                }
                this.numRcvd += count;
                this.deltaNumRcvd += count;
                if (now - this.deltaStart >= 1000L) {
                    long deltaRate = (long)this.deltaNumRcvd * 1000L / (now - this.deltaStart);
                    long overallRate = (long)this.numRcvd * 1000L / (now - this.start);
                    System.out.println("[BlockingStreamingReceiver] RATE [" + deltaRate + "," + overallRate + "]");
                    this.deltaStart = now;
                    this.deltaNumRcvd = 0;
                }
            }
            return BlockingStreamingReceiver.this._messageSize * count;
        }

        public final void handleLinkClosure(EmxNwLnk lnk) {
            System.out.println("[BlockingStreamingReceiver] Link closed by peer");
        }

        public final void handleLinkFailure(EmxNwLnk lnk, Throwable cause) {
            cause.printStackTrace();
        }
    }

    private final class AcceptCallback
    implements EmxNwLnkAcceptor.Callback {
        private AcceptCallback() {
        }

        public final void handleAcceptedLink(EmxNwLnk link) {
        }

        public final void handleAcceptorFailure(Throwable cause) {
        }
    }
}

