/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.jms;

import com.neeve.jms.JmsBindingProperties;
import com.neeve.jms.JmsMessageBusBinding;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

public class JmsMessageChannel
extends MessageChannelBase
implements MessageListener {
    private final JmsMessageBusBinding binding;
    private String[] filters;
    private int ackQueueIndex = 0;
    private final ArrayList<Message>[] ackQueue;

    protected JmsMessageChannel(MessageChannelDescriptor descriptor, JmsMessageBusBinding binding) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
        if (descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            this.ackQueue = new ArrayList[2];
            this.ackQueue[0] = new ArrayList();
            this.ackQueue[1] = new ArrayList();
        } else {
            this.ackQueue = null;
        }
    }

    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String destination = this.normalizeDestination(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Subscribing to (guaranteed) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.subscribeGuaranteed(this, destination);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Subscribing to (best effort) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.subscribe(this, destination);
        }
    }

    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String destination = this.normalizeDestination(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Unsubscribing from (guaranteed) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.unsubscribeGuaranteed(this, destination);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Unsubscribing from (best effort) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.unsubscribe(this, destination);
        }
    }

    private final MessageTransportHeaders prepareTransportHeadersForInboundMessage(Message message, MessageMetadata metadata) throws JMSException {
        MessageTransportHeaders transportHeaders;
        if (this.binding.isEnableInboundTransportHeaders()) {
            transportHeaders = MessageTransportHeaders.create();
            transportHeaders.addHeader(JmsBindingProperties.TRANSPORT_HEADER_JMS_MESSAGE_ID, message.getJMSMessageID());
            if (this.getId() == Short.MAX_VALUE && metadata != null) {
                XString receivedMessageChannel = metadata.getMessageChannelNameAsRaw();
                if (receivedMessageChannel == null || receivedMessageChannel.isNull() || receivedMessageChannel.length() == 0) {
                    transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, metadata.getMessageChannelId());
                } else {
                    transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, receivedMessageChannel);
                }
            }
        } else {
            transportHeaders = null;
        }
        return transportHeaders;
    }

    private final XString prepareMessageKeyForInboundMessage(Message message) {
        String destinationName;
        XString messageKey = this.binding.isSetKeyOnReceipt() ? ((destinationName = this.binding.extractDestinationName(message)) != null ? XString.create((String)destinationName) : null) : null;
        return messageKey;
    }

    private final String prepareDestinationForOutboundMessage(MessageView view) throws SmaException {
        String key = view.getMessageKey();
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (key == null && !topicStartsWithChannel) {
            throw new SmaException("send performed with null key but binding configured to not prepend topic with channel");
        }
        return this.normalizeDestination(key == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + key : key));
    }

    final void onMessage(Message message, JmsMessageChannel ackChannel, MessageMetadata metadata, long originTs, long preWireTs, long postWireTs) {
        long preDeserializeTs;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received message (metadata=" + metadata + ")", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.d1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
        long l = preDeserializeTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        if (metadata != null && metadata.getVersion() == 1) {
            throw new RuntimeException("JMS binding only supports the V1 header with TextMessage payload");
        }
        try {
            Object smaMessage = null;
            if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                int len = (int)bytesMessage.getBodyLength();
                smaMessage = new byte[len];
                if (len > 0) {
                    bytesMessage.readBytes((byte[])smaMessage);
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap((byte[])smaMessage)), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                }
            } else if (message instanceof TextMessage) {
                smaMessage = ((TextMessage)message).getText();
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + smaMessage, Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                }
            } else {
                throw new RuntimeException("Unable to handle JMS message type '" + message.getClass().getSimpleName() + "' [unsupported message type]");
            }
            XString messageKey = this.prepareMessageKeyForInboundMessage(message);
            MessageTransportHeaders transportHeaders = this.prepareTransportHeadersForInboundMessage(message, metadata);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Dispatching...", Tracer.Level.DEBUG);
            }
            this.onMessage(smaMessage, transportHeaders, metadata != null ? (short)metadata.getMessageViewFactory() : (short)39, metadata != null ? metadata.getMessageViewType() : (short)1, metadata != null ? (int)metadata.getMessageEncodingType() : 6, metadata != null ? metadata.getMessageSender() : 0, metadata != null ? metadata.getMessageFlow() : 0, metadata != null ? metadata.getMessageSno() : 0L, metadata != null ? metadata.getRequestId() : 0L, metadata != null ? metadata.getRequestorIdAsRaw() : null, messageKey, ackChannel != null && ackChannel.getQos() == MessageChannel.Qos.Guaranteed ? this.binding.createAcknowledger(ackChannel, message) : null, originTs, preWireTs, postWireTs, preDeserializeTs);
            this.flushReceivedAcks();
        }
        catch (JMSException e) {
            throw new RuntimeException(this.tracePrefix + "JMS Error processing received message: " + e.getMessage(), e);
        }
        finally {
            if (metadata != null) {
                metadata.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushReceivedAcks() throws JMSException {
        if (this.getQos() == MessageChannel.Qos.Guaranteed) {
            ArrayList<Message> toAck = null;
            ArrayList<Message>[] arrayListArray = this.ackQueue;
            synchronized (this.ackQueue) {
                if (!this.ackQueue[this.ackQueueIndex].isEmpty()) {
                    toAck = this.ackQueue[this.ackQueueIndex];
                    this.ackQueueIndex = this.ackQueueIndex == 0 ? 1 : 0;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (toAck != null) {
                    boolean acked = false;
                    for (int i = 0; i < toAck.size(); ++i) {
                        if (this.tracer.debug) {
                            this.tracer.log("Acking message " + toAck.get(i).getJMSMessageID(), Tracer.Level.DEBUG);
                        }
                        toAck.get(i).acknowledge();
                        acked = true;
                    }
                    toAck.clear();
                    return acked;
                }
                return false;
            }
        }
        return false;
    }

    final void onAckNack(MessageView view, Exception status) {
        this.onMessageStability(view, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doSend(MessageView view, int flags) throws SmaException {
        boolean bl;
        block15: {
            MessageMetadata metadata;
            block17: {
                block16: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
                    }
                    MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
                    if (MessageLatencyManager.captureMsgLatencyStats) {
                        view.setPreSerializeTs(UtlTime.now());
                    }
                    if (this.binding.rawMode()) break block16;
                    metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
                    switch (this.binding.getMetadataVersion()) {
                        case 2: {
                            metadata.serializeV2((byte)view.getMessageEncodingType(), view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
                            break block17;
                        }
                        case 3: {
                            metadata.serializeV3((byte)view.getMessageEncodingType(), view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw(), view.getRequestId(), view.getRequestorIdAsRaw());
                            break block17;
                        }
                        default: {
                            throw new IllegalArgumentException("unsupported metadata version [" + this.binding.getMetadataVersion() + "]");
                        }
                    }
                }
                metadata = null;
            }
            try {
                byte[] serializedMessage = view.serializeToByteArray();
                BytesMessage message = this.binding.createBytesMessage();
                message.writeBytes(serializedMessage);
                String destination = this.prepareDestinationForOutboundMessage(view);
                if (MessageLatencyManager.captureMsgLatencyStats) {
                    view.setPostSerializeTs(UtlTime.now());
                }
                MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)message);
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Publishing message. Message is " + serializedMessage.length + " bytes, metadata is " + metadata + ", topic is '" + destination + "'", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedMessage)).toString(), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                }
                this.binding.send(this, view, (Message)message, metadata, destination, this.descriptor.getChannelQos(), view.getOriginTs(), flags);
                if (this.getQos() == MessageChannel.Qos.Guaranteed) {
                    this.onMessageStability(view);
                }
                bl = true;
                if (metadata == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (metadata != null) {
                        metadata.dispose();
                    }
                    throw throwable;
                }
                catch (JMSException e) {
                    throw new SmaException((Throwable)e);
                }
            }
            metadata.dispose();
        }
        return bl;
    }

    protected String normalizeDestination(String destination) {
        return destination;
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
        this.binding.onChannelClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void acknowledgeMessage(Message message) {
        ArrayList<Message>[] arrayListArray = this.ackQueue;
        synchronized (this.ackQueue) {
            this.ackQueue[this.ackQueueIndex].add(message);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final void onMessage(Message message) {
        this.binding.onMessage(this, message);
    }

    public final String getType() {
        return "Jms";
    }
}

