/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ColumnReference;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import com.akiban.sql.types.DataTypeDescriptor;

public class ResultColumn
extends ValueNode {
    private String name;
    private String exposedName;
    private String tableName;
    private ValueNode expression;
    private boolean defaultColumn;
    private boolean autoincrement;
    private ColumnReference reference;
    private int virtualColumnId;
    private boolean isNameGenerated;

    @Override
    public void init(Object arg1, Object arg2) throws StandardException {
        if (arg1 instanceof String || arg1 == null) {
            this.exposedName = this.name = (String)arg1;
            this.setExpression((ValueNode)arg2);
        } else if (arg1 instanceof ColumnReference) {
            ColumnReference ref = (ColumnReference)arg1;
            this.name = ref.getColumnName();
            this.exposedName = ref.getColumnName();
            this.reference = ref;
            this.setExpression((ValueNode)arg2);
        } else {
            this.setType((DataTypeDescriptor)arg1);
            this.setExpression((ValueNode)arg2);
            if (arg2 instanceof ColumnReference) {
                this.reference = (ColumnReference)arg2;
            }
        }
        if (this.expression != null && this.expression.isInstanceOf(100)) {
            this.defaultColumn = true;
        }
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        ResultColumn other = (ResultColumn)node;
        this.name = other.name;
        this.exposedName = other.exposedName;
        this.tableName = other.tableName;
        this.expression = (ValueNode)this.getNodeFactory().copyNode(other.expression, this.getParserContext());
        this.defaultColumn = other.defaultColumn;
        this.autoincrement = other.autoincrement;
        this.reference = (ColumnReference)this.getNodeFactory().copyNode(other.reference, this.getParserContext());
        this.virtualColumnId = other.virtualColumnId;
        this.isNameGenerated = other.isNameGenerated;
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(boolean value) {
        this.defaultColumn = value;
    }

    boolean columnNameMatches(String columnName) {
        return columnName.equals(this.exposedName) || columnName.equals(this.name) || columnName.equals(this.getSourceColumnName());
    }

    String getSourceColumnName() {
        if (this.expression instanceof ColumnReference) {
            return ((ColumnReference)this.expression).getColumnName();
        }
        return null;
    }

    public String getName() {
        return this.exposedName;
    }

    @Override
    public String getSchemaName() throws StandardException {
        if (this.expression != null) {
            return this.expression.getSchemaName();
        }
        return null;
    }

    @Override
    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.expression != null) {
            return this.expression.getTableName();
        }
        return null;
    }

    public int getColumnPosition() {
        return this.virtualColumnId;
    }

    public void setExpression(ValueNode expression) {
        this.expression = expression;
    }

    public ValueNode getExpression() {
        return this.expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.setExpression(this.getNullNode(this.getType()));
    }

    public void setName(String name) {
        if (this.name == null) {
            this.name = name;
        } else assert (this.reference == null || name.equals(this.reference.getColumnName())) : "don't change name from reference name";
        this.exposedName = name;
    }

    public boolean isNameGenerated() {
        return this.isNameGenerated;
    }

    public void setNameGenerated(boolean value) {
        this.isNameGenerated = value;
    }

    public void adjustVirtualColumnId(int adjust) {
        this.virtualColumnId += adjust;
    }

    public void setVirtualColumnId(int id) {
        this.virtualColumnId = id;
    }

    public int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    @Override
    public String toString() {
        return "exposedName: " + this.exposedName + "\n" + "name: " + this.name + "\n" + "tableName: " + this.tableName + "\n" + "isDefaultColumn: " + this.defaultColumn + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.expression != null) {
            this.printLabel(depth, "expression: ");
            this.expression.treePrint(depth + 1);
        }
        if (this.reference != null) {
            this.printLabel(depth, "reference: ");
            this.reference.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.expression != null) {
            this.setExpression((ValueNode)this.expression.accept(v));
        }
        if (this.reference != null) {
            this.reference = (ColumnReference)this.reference.accept(v);
        }
    }

    public TableName getTableNameObject() {
        return null;
    }

    public ColumnReference getReference() {
        return this.reference;
    }

    @Override
    public boolean isEquivalent(ValueNode o) throws StandardException {
        if (o.getNodeType() == this.getNodeType()) {
            ResultColumn other = (ResultColumn)o;
            if (this.expression != null) {
                return this.expression.isEquivalent(other.expression);
            }
        }
        return false;
    }
}

